/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.kits;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appboy.AppboyFirebaseMessagingService;
import com.appboy.IBrazeEndpointProvider;
import com.appboy.enums.Gender;
import com.appboy.enums.Month;
import com.appboy.enums.SdkFlavor;
import com.braze.Braze;
import com.braze.BrazeActivityLifecycleCallbackListener;
import com.braze.BrazeUser;
import com.braze.configuration.BrazeConfig;
import com.braze.enums.BrazeSdkMetadata;
import com.braze.models.outgoing.BrazeProperties;
import com.braze.push.BrazeNotificationUtils;
import com.google.firebase.messaging.RemoteMessage;
import com.mparticle.BaseEvent;
import com.mparticle.MPEvent;
import com.mparticle.MParticle;
import com.mparticle.commerce.CommerceEvent;
import com.mparticle.commerce.Product;
import com.mparticle.identity.MParticleUser;
import com.mparticle.internal.Logger;
import com.mparticle.kits.CommerceEventUtils;
import com.mparticle.kits.FilteredIdentityApiRequest;
import com.mparticle.kits.KitIntegration;
import com.mparticle.kits.KitUtils;
import com.mparticle.kits.ReportingMessage;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AppboyKit
extends KitIntegration
implements KitIntegration.AttributeListener,
KitIntegration.CommerceListener,
KitIntegration.EventListener,
KitIntegration.PushListener,
KitIntegration.IdentityListener {
    static final String APPBOY_KEY = "apiKey";
    static final String FORWARD_SCREEN_VIEWS = "forwardScreenViews";
    static final String USER_IDENTIFICATION_TYPE = "userIdentificationType";
    static final String ENABLE_TYPE_DETECTION = "enableTypeDetection";
    static final String HOST = "host";
    boolean isMpidIdentityType = false;
    MParticle.IdentityType identityType;
    public static final String PUSH_ENABLED = "push_enabled";
    private static final String PREF_KEY_HAS_SYNCED_ATTRIBUTES = "appboy::has_synced_attributes";
    private static final String PREF_KEY_CURRENT_EMAIL = "appboy::current_email";
    final Handler dataFlushHandler = new Handler();
    private Runnable dataFlushRunnable;
    private static final int FLUSH_DELAY = 5000;
    private boolean forwardScreenViews = false;
    boolean enableTypeDetection = false;
    public static boolean setDefaultAppboyLifecycleCallbackListener = true;

    public String getName() {
        return "Appboy";
    }

    protected List<ReportingMessage> onKitCreate(Map<String, String> settings, Context context) {
        String enableDetectionType;
        String key = settings.get(APPBOY_KEY);
        if (KitUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Appboy key is empty.");
        }
        String authority = settings.get(HOST);
        if (!KitUtils.isEmpty((CharSequence)authority)) {
            this.setAuthority(authority);
        }
        if (!KitUtils.isEmpty((CharSequence)(enableDetectionType = settings.get(ENABLE_TYPE_DETECTION)))) {
            try {
                this.enableTypeDetection = Boolean.parseBoolean(enableDetectionType);
            }
            catch (Exception e) {
                Logger.warning((String[])new String[]{"Appboy, unable to parse \"enableDetectionType\""});
            }
        }
        this.forwardScreenViews = Boolean.parseBoolean(settings.get(FORWARD_SCREEN_VIEWS));
        BrazeConfig config = new BrazeConfig.Builder().setApiKey(key).setSdkFlavor(SdkFlavor.MPARTICLE).setSdkMetadata(EnumSet.of(BrazeSdkMetadata.MPARTICLE)).build();
        Braze.configure((Context)context, (BrazeConfig)config);
        this.dataFlushRunnable = new Runnable(){

            @Override
            public void run() {
                if (AppboyKit.this.getKitManager().isBackgrounded()) {
                    Braze.getInstance((Context)AppboyKit.this.getContext()).requestImmediateDataFlush();
                }
            }
        };
        this.queueDataFlush();
        if (setDefaultAppboyLifecycleCallbackListener) {
            ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new BrazeActivityLifecycleCallbackListener());
        }
        this.setIdentityType(settings);
        return null;
    }

    void setIdentityType(Map<String, String> settings) {
        String userIdentificationType = settings.get(USER_IDENTIFICATION_TYPE);
        if (!KitUtils.isEmpty((CharSequence)userIdentificationType)) {
            if (userIdentificationType.equals("MPID")) {
                this.isMpidIdentityType = true;
            } else {
                this.identityType = MParticle.IdentityType.valueOf((String)userIdentificationType);
            }
        }
    }

    public List<ReportingMessage> setOptOut(boolean optedOut) {
        return null;
    }

    public List<ReportingMessage> leaveBreadcrumb(String breadcrumb) {
        return null;
    }

    public List<ReportingMessage> logError(String message, Map<String, String> errorAttributes) {
        return null;
    }

    public List<ReportingMessage> logException(Exception exception, Map<String, String> exceptionAttributes, String message) {
        return null;
    }

    public List<ReportingMessage> logEvent(MPEvent event) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        if (event.getCustomAttributes() == null) {
            Braze.getInstance((Context)this.getContext()).logCustomEvent(event.getEventName());
        } else {
            BrazeProperties properties = new BrazeProperties();
            BrazeUser user = Braze.getInstance((Context)this.getContext()).getCurrentUser();
            BrazePropertiesSetter brazePropertiesSetter = new BrazePropertiesSetter(properties, this.enableTypeDetection);
            UserAttributeSetter userAttributeSetter = new UserAttributeSetter(user, this.enableTypeDetection);
            for (Map.Entry entry : event.getCustomAttributeStrings().entrySet()) {
                newAttributes.put((String)entry.getKey(), brazePropertiesSetter.parseValue((String)entry.getKey(), (String)entry.getValue()));
                Integer hashedKey = KitUtils.hashForFiltering((String)(event.getEventType().toString() + event.getEventName() + (String)entry.getKey()));
                Map attributeMap = this.getConfiguration().getEventAttributesAddToUser();
                if (attributeMap.containsKey(hashedKey)) {
                    user.addToCustomAttributeArray((String)attributeMap.get(hashedKey), (String)entry.getValue());
                }
                if ((attributeMap = this.getConfiguration().getEventAttributesRemoveFromUser()).containsKey(hashedKey)) {
                    user.removeFromCustomAttributeArray((String)attributeMap.get(hashedKey), (String)entry.getValue());
                }
                if (!(attributeMap = this.getConfiguration().getEventAttributesSingleItemUser()).containsKey(hashedKey)) continue;
                userAttributeSetter.parseValue((String)attributeMap.get(hashedKey), (String)entry.getValue());
            }
            Braze.getInstance((Context)this.getContext()).logCustomEvent(event.getEventName(), properties);
        }
        this.queueDataFlush();
        return Collections.singletonList(ReportingMessage.fromEvent((KitIntegration)this, (BaseEvent)event).setAttributes(newAttributes));
    }

    public List<ReportingMessage> logScreen(String screenName, Map<String, String> screenAttributes) {
        if (this.forwardScreenViews) {
            if (screenAttributes == null) {
                Braze.getInstance((Context)this.getContext()).logCustomEvent(screenName);
            } else {
                BrazeProperties properties = new BrazeProperties();
                BrazePropertiesSetter propertyParser = new BrazePropertiesSetter(properties, this.enableTypeDetection);
                for (Map.Entry<String, String> entry : screenAttributes.entrySet()) {
                    propertyParser.parseValue(entry.getKey(), entry.getValue());
                }
                Braze.getInstance((Context)this.getContext()).logCustomEvent(screenName, properties);
            }
            this.queueDataFlush();
            LinkedList<ReportingMessage> messages = new LinkedList<ReportingMessage>();
            messages.add(new ReportingMessage((KitIntegration)this, "v", System.currentTimeMillis(), screenAttributes));
            return messages;
        }
        return null;
    }

    public List<ReportingMessage> logLtvIncrease(BigDecimal valueIncreased, BigDecimal valueTotal, String eventName, Map<String, String> contextInfo) {
        return null;
    }

    public List<ReportingMessage> logEvent(CommerceEvent event) {
        LinkedList<ReportingMessage> messages = new LinkedList<ReportingMessage>();
        if (!KitUtils.isEmpty((CharSequence)event.getProductAction()) && event.getProductAction().equalsIgnoreCase("purchase") && event.getProducts().size() > 0) {
            List productList = event.getProducts();
            for (Product product : productList) {
                this.logTransaction(event, product);
            }
            messages.add(ReportingMessage.fromEvent((KitIntegration)this, (BaseEvent)event));
            this.queueDataFlush();
            return messages;
        }
        List eventList = CommerceEventUtils.expand((CommerceEvent)event);
        if (eventList != null) {
            for (int i = 0; i < eventList.size(); ++i) {
                try {
                    this.logEvent((MPEvent)eventList.get(i));
                    messages.add(ReportingMessage.fromEvent((KitIntegration)this, (BaseEvent)event));
                    continue;
                }
                catch (Exception e) {
                    Logger.warning((String[])new String[]{"Failed to call logCustomEvent to Appboy kit: " + e.toString()});
                }
            }
            this.queueDataFlush();
        }
        return messages;
    }

    public void setUserAttribute(String key, String value) {
        BrazeUser user = Braze.getInstance((Context)this.getContext()).getCurrentUser();
        UserAttributeSetter userAttributeSetter = new UserAttributeSetter(user, this.enableTypeDetection);
        if ("$City".equals(key)) {
            user.setHomeCity(value);
        } else if ("$Country".equals(key)) {
            user.setCountry(value);
        } else if ("$FirstName".equals(key)) {
            user.setFirstName(value);
        } else if ("$Gender".equals(key)) {
            if (value.contains("fe")) {
                user.setGender(Gender.FEMALE);
            } else {
                user.setGender(Gender.MALE);
            }
        } else if ("$LastName".equals(key)) {
            user.setLastName(value);
        } else if ("$Mobile".equals(key)) {
            user.setPhoneNumber(value);
        } else if ("$Age".equals(key)) {
            Calendar calendar = this.getCalendarMinusYears(value);
            if (calendar != null) {
                user.setDateOfBirth(calendar.get(1), Month.JANUARY, 1);
            } else {
                Logger.error((String[])new String[]{"unable to set DateOfBirth for $Age = " + value});
            }
        } else if ("dob".equals(key)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateFormat.parse(value));
                int year = calendar.get(1);
                int month = calendar.get(2);
                Month monthEnumValue = Month.getMonth((int)month);
                int day = calendar.get(5);
                user.setDateOfBirth(year, monthEnumValue, day);
            }
            catch (Exception e) {
                Logger.error((String[])new String[]{"unable to set DateOfBirth for \"dob\" = " + value + ". Exception: " + e.getMessage()});
            }
        } else if ("$Zip".equals(key)) {
            user.setCustomUserAttribute("Zip", value);
        } else {
            if (key.startsWith("$")) {
                key = key.substring(1);
            }
            userAttributeSetter.parseValue(key, value);
        }
        this.queueDataFlush();
    }

    public void setUserAttributeList(String key, List<String> list) {
        BrazeUser user = Braze.getInstance((Context)this.getContext()).getCurrentUser();
        String[] array = list.toArray(new String[list.size()]);
        user.setCustomAttributeArray(key, array);
        this.queueDataFlush();
    }

    public boolean supportsAttributeLists() {
        return true;
    }

    protected void queueDataFlush() {
        this.dataFlushHandler.removeCallbacks(this.dataFlushRunnable);
        this.dataFlushHandler.postDelayed(this.dataFlushRunnable, 5000L);
    }

    public void setAllUserAttributes(Map<String, String> attributes, Map<String, List<String>> attributeLists) {
        if (!this.getKitPreferences().getBoolean(PREF_KEY_HAS_SYNCED_ATTRIBUTES, false)) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.setUserAttribute(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : attributeLists.entrySet()) {
                this.setUserAttributeList(entry.getKey(), (List)entry.getValue());
            }
            this.getKitPreferences().edit().putBoolean(PREF_KEY_HAS_SYNCED_ATTRIBUTES, true).apply();
        }
    }

    public void removeUserAttribute(String key) {
        BrazeUser user = Braze.getInstance((Context)this.getContext()).getCurrentUser();
        if ("$City".equals(key)) {
            user.setHomeCity(null);
        } else if ("$Country".equals(key)) {
            user.setCountry(null);
        } else if ("$FirstName".equals(key)) {
            user.setFirstName(null);
        } else if ("$Gender".equals(key)) {
            user.setGender(null);
        } else if ("$LastName".equals(key)) {
            user.setLastName(null);
        } else if ("$Mobile".equals(key)) {
            user.setPhoneNumber(null);
        } else {
            if (key.startsWith("$")) {
                key = key.substring(1);
            }
            user.unsetCustomUserAttribute(key);
        }
        this.queueDataFlush();
    }

    public void setUserIdentity(MParticle.IdentityType identityType, String identity) {
    }

    public void removeUserIdentity(MParticle.IdentityType identityType) {
    }

    public List<ReportingMessage> logout() {
        return null;
    }

    void logTransaction(CommerceEvent event, Product product) {
        final BrazeProperties purchaseProperties = new BrazeProperties();
        final String[] currency = new String[1];
        final BrazePropertiesSetter commerceTypeParser = new BrazePropertiesSetter(purchaseProperties, this.enableTypeDetection);
        CommerceEventUtils.OnAttributeExtracted onAttributeExtracted = new CommerceEventUtils.OnAttributeExtracted(){

            public void onAttributeExtracted(String key, String value) {
                if (!this.checkCurrency(key, value)) {
                    commerceTypeParser.parseValue(key, value);
                }
            }

            public void onAttributeExtracted(String key, double value) {
                if (!this.checkCurrency(key, value)) {
                    purchaseProperties.addProperty(key, (Object)value);
                }
            }

            public void onAttributeExtracted(String key, int value) {
                purchaseProperties.addProperty(key, (Object)value);
            }

            public void onAttributeExtracted(Map<String, String> attributes) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    if (this.checkCurrency(entry.getKey(), entry.getValue())) continue;
                    commerceTypeParser.parseValue(entry.getKey(), entry.getValue());
                }
            }

            private boolean checkCurrency(String key, Object value) {
                if ("Currency Code".equals(key)) {
                    currency[0] = value != null ? value.toString() : null;
                    return true;
                }
                return false;
            }
        };
        CommerceEventUtils.extractActionAttributes((CommerceEvent)event, (CommerceEventUtils.OnAttributeExtracted)onAttributeExtracted);
        String currencyValue = currency[0];
        if (KitUtils.isEmpty((CharSequence)currencyValue)) {
            currencyValue = "USD";
        }
        Braze.getInstance((Context)this.getContext()).logPurchase(product.getSku(), currencyValue, new BigDecimal(product.getUnitPrice()), (int)product.getQuantity(), purchaseProperties);
    }

    public boolean willHandlePushMessage(Intent intent) {
        if (!Boolean.parseBoolean((String)this.getSettings().get(PUSH_ENABLED))) {
            return false;
        }
        return BrazeNotificationUtils.isAppboyPushMessage((Intent)intent);
    }

    public void onPushMessageReceived(Context context, Intent pushIntent) {
        if (Boolean.parseBoolean((String)this.getSettings().get(PUSH_ENABLED))) {
            AppboyFirebaseMessagingService.handleBrazeRemoteMessage((Context)context, (RemoteMessage)new RemoteMessage(pushIntent.getExtras()));
        }
    }

    public boolean onPushRegistration(String instanceId, String senderId) {
        if (Boolean.parseBoolean((String)this.getSettings().get(PUSH_ENABLED))) {
            Braze.getInstance((Context)this.getContext()).registerAppboyPushMessages(instanceId);
            this.queueDataFlush();
            return true;
        }
        return false;
    }

    protected void setAuthority(final String authority) {
        Braze.setEndpointProvider((IBrazeEndpointProvider)new IBrazeEndpointProvider(){

            public Uri getApiEndpoint(Uri appboyEndpoint) {
                return appboyEndpoint.buildUpon().authority(authority).build();
            }
        });
    }

    public void onIdentifyCompleted(MParticleUser mParticleUser, FilteredIdentityApiRequest filteredIdentityApiRequest) {
        this.updateUser(mParticleUser);
    }

    public void onLoginCompleted(MParticleUser mParticleUser, FilteredIdentityApiRequest filteredIdentityApiRequest) {
        this.updateUser(mParticleUser);
    }

    public void onLogoutCompleted(MParticleUser mParticleUser, FilteredIdentityApiRequest filteredIdentityApiRequest) {
        this.updateUser(mParticleUser);
    }

    public void onModifyCompleted(MParticleUser mParticleUser, FilteredIdentityApiRequest filteredIdentityApiRequest) {
        this.updateUser(mParticleUser);
    }

    private void updateUser(@NonNull MParticleUser mParticleUser) {
        String identity = this.getIdentity(this.isMpidIdentityType, this.identityType, mParticleUser);
        String email = (String)mParticleUser.getUserIdentities().get(MParticle.IdentityType.Email);
        if (identity != null) {
            this.setId(identity);
        }
        if (email != null) {
            this.setEmail(email);
        }
    }

    String getIdentity(boolean isMpidIdentityType, @Nullable MParticle.IdentityType identityType, @NonNull MParticleUser mParticleUser) {
        String identity = null;
        if (isMpidIdentityType) {
            identity = String.valueOf(mParticleUser.getId());
        } else if (identityType != null) {
            identity = (String)mParticleUser.getUserIdentities().get(identityType);
        }
        return identity;
    }

    protected void setId(String customerId) {
        BrazeUser user = Braze.getInstance((Context)this.getContext()).getCurrentUser();
        if (user == null || user.getUserId() != null && !user.getUserId().equals(customerId)) {
            Braze.getInstance((Context)this.getContext()).changeUser(customerId);
            this.queueDataFlush();
        }
    }

    protected void setEmail(String email) {
        if (!email.equals(this.getKitPreferences().getString(PREF_KEY_CURRENT_EMAIL, null))) {
            BrazeUser user = Braze.getInstance((Context)this.getContext()).getCurrentUser();
            user.setEmail(email);
            this.queueDataFlush();
            this.getKitPreferences().edit().putString(PREF_KEY_CURRENT_EMAIL, email).apply();
        }
    }

    public void onUserIdentified(MParticleUser mParticleUser) {
    }

    void addToProperties(BrazeProperties properties, String key, String value) {
        try {
            if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                properties.addProperty(key, (Object)Boolean.parseBoolean(value));
            } else {
                double doubleValue = Double.parseDouble(value);
                if (doubleValue % 1.0 == 0.0) {
                    properties.addProperty(key, (Object)Integer.parseInt(value));
                } else {
                    properties.addProperty(key, (Object)doubleValue);
                }
            }
        }
        catch (Exception e) {
            properties.addProperty(key, (Object)value);
        }
    }

    @Nullable
    Calendar getCalendarMinusYears(String yearsString) {
        try {
            int years = Integer.parseInt(yearsString);
            return this.getCalendarMinusYears(years);
        }
        catch (NumberFormatException ignored) {
            try {
                double years = Double.parseDouble(yearsString);
                return this.getCalendarMinusYears((int)years);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    @Nullable
    Calendar getCalendarMinusYears(int years) {
        if (years >= 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, calendar.get(1) - years);
            return calendar;
        }
        return null;
    }

    class UserAttributeSetter
    extends StringTypeParser {
        BrazeUser brazeUser;

        UserAttributeSetter(BrazeUser brazeUser, boolean enableTypeDetection) {
            super(enableTypeDetection);
            this.brazeUser = brazeUser;
        }

        @Override
        void toInt(String key, int value) {
            this.brazeUser.setCustomUserAttribute(key, value);
        }

        @Override
        void toLong(String key, long value) {
            this.brazeUser.setCustomUserAttribute(key, value);
        }

        @Override
        void toDouble(String key, double value) {
            this.brazeUser.setCustomUserAttribute(key, value);
        }

        @Override
        void toBoolean(String key, boolean value) {
            this.brazeUser.setCustomUserAttribute(key, value);
        }

        @Override
        void toString(String key, String value) {
            this.brazeUser.setCustomUserAttribute(key, value);
        }
    }

    class BrazePropertiesSetter
    extends StringTypeParser {
        BrazeProperties properties;

        BrazePropertiesSetter(BrazeProperties properties, boolean enableTypeDetection) {
            super(enableTypeDetection);
            this.properties = properties;
        }

        @Override
        void toInt(String key, int value) {
            this.properties.addProperty(key, (Object)value);
        }

        @Override
        void toLong(String key, long value) {
            this.properties.addProperty(key, (Object)value);
        }

        @Override
        void toDouble(String key, double value) {
            this.properties.addProperty(key, (Object)value);
        }

        @Override
        void toBoolean(String key, boolean value) {
            this.properties.addProperty(key, (Object)value);
        }

        @Override
        void toString(String key, String value) {
            this.properties.addProperty(key, (Object)value);
        }
    }

    static abstract class StringTypeParser {
        boolean enableTypeDetection;

        StringTypeParser(boolean enableTypeDetection) {
            this.enableTypeDetection = enableTypeDetection;
        }

        Object parseValue(String key, String value) {
            if (!this.enableTypeDetection) {
                this.toString(key, value);
                return value;
            }
            if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                boolean newBool = Boolean.parseBoolean(value);
                this.toBoolean(key, newBool);
                return newBool;
            }
            try {
                if (value.contains(".")) {
                    double doubleValue = Double.parseDouble(value);
                    this.toDouble(key, doubleValue);
                    return doubleValue;
                }
                long newLong = Long.parseLong(value);
                if (newLong <= Integer.MAX_VALUE && newLong >= Integer.MIN_VALUE) {
                    int newInt = (int)newLong;
                    this.toInt(key, newInt);
                    return newInt;
                }
                this.toLong(key, newLong);
                return newLong;
            }
            catch (NumberFormatException nfe) {
                this.toString(key, value);
                return value;
            }
        }

        abstract void toInt(String var1, int var2);

        abstract void toLong(String var1, long var2);

        abstract void toDouble(String var1, double var2);

        abstract void toBoolean(String var1, boolean var2);

        abstract void toString(String var1, String var2);
    }
}

