/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.kits;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.Nullable;
import com.appboy.Appboy;
import com.appboy.AppboyFcmReceiver;
import com.appboy.AppboyLifecycleCallbackListener;
import com.appboy.AppboyUser;
import com.appboy.IAppboyEndpointProvider;
import com.appboy.configuration.AppboyConfig;
import com.appboy.enums.Gender;
import com.appboy.enums.Month;
import com.appboy.enums.SdkFlavor;
import com.appboy.models.outgoing.AppboyProperties;
import com.appboy.push.AppboyNotificationUtils;
import com.mparticle.MPEvent;
import com.mparticle.MParticle;
import com.mparticle.commerce.CommerceEvent;
import com.mparticle.commerce.Product;
import com.mparticle.identity.MParticleUser;
import com.mparticle.internal.Logger;
import com.mparticle.kits.CommerceEventUtils;
import com.mparticle.kits.FilteredIdentityApiRequest;
import com.mparticle.kits.KitIntegration;
import com.mparticle.kits.KitUtils;
import com.mparticle.kits.ReportingMessage;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AppboyKit
extends KitIntegration
implements KitIntegration.AttributeListener,
KitIntegration.CommerceListener,
KitIntegration.EventListener,
KitIntegration.PushListener,
KitIntegration.IdentityListener {
    static final String APPBOY_KEY = "apiKey";
    static final String FORWARD_SCREEN_VIEWS = "forwardScreenViews";
    static final String HOST = "host";
    public static final String PUSH_ENABLED = "push_enabled";
    private static final String PREF_KEY_HAS_SYNCED_ATTRIBUTES = "appboy::has_synced_attributes";
    private static final String PREF_KEY_CURRENT_EMAIL = "appboy::current_email";
    final Handler dataFlushHandler = new Handler();
    private Runnable dataFlushRunnable;
    private static final int FLUSH_DELAY = 5000;
    private boolean forwardScreenViews = false;

    public String getName() {
        return "Appboy";
    }

    protected List<ReportingMessage> onKitCreate(Map<String, String> settings, Context context) {
        String key = settings.get(APPBOY_KEY);
        if (KitUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Appboy key is empty.");
        }
        String authority = settings.get(HOST);
        if (!KitUtils.isEmpty((CharSequence)authority)) {
            this.setAuthority(authority);
        }
        this.forwardScreenViews = Boolean.parseBoolean(settings.get(FORWARD_SCREEN_VIEWS));
        AppboyConfig config = new AppboyConfig.Builder().setApiKey(key).setSdkFlavor(SdkFlavor.MPARTICLE).build();
        Appboy.configure((Context)context, (AppboyConfig)config);
        this.dataFlushRunnable = new Runnable(){

            @Override
            public void run() {
                if (AppboyKit.this.getKitManager().isBackgrounded()) {
                    Appboy.getInstance((Context)AppboyKit.this.getContext()).requestImmediateDataFlush();
                }
            }
        };
        this.queueDataFlush();
        ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new AppboyLifecycleCallbackListener());
        return null;
    }

    public List<ReportingMessage> setOptOut(boolean optedOut) {
        return null;
    }

    public List<ReportingMessage> leaveBreadcrumb(String breadcrumb) {
        return null;
    }

    public List<ReportingMessage> logError(String message, Map<String, String> errorAttributes) {
        return null;
    }

    public List<ReportingMessage> logException(Exception exception, Map<String, String> exceptionAttributes, String message) {
        return null;
    }

    public List<ReportingMessage> logEvent(MPEvent event) {
        if (event.getInfo() == null) {
            Appboy.getInstance((Context)this.getContext()).logCustomEvent(event.getEventName());
        } else {
            AppboyProperties properties = new AppboyProperties();
            for (Map.Entry entry : event.getInfo().entrySet()) {
                properties.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            Appboy.getInstance((Context)this.getContext()).logCustomEvent(event.getEventName(), properties);
        }
        this.queueDataFlush();
        LinkedList<ReportingMessage> messages = new LinkedList<ReportingMessage>();
        messages.add(ReportingMessage.fromEvent((KitIntegration)this, (MPEvent)event));
        return messages;
    }

    public List<ReportingMessage> logScreen(String screenName, Map<String, String> screenAttributes) {
        if (this.forwardScreenViews) {
            if (screenAttributes == null) {
                Appboy.getInstance((Context)this.getContext()).logCustomEvent(screenName);
            } else {
                AppboyProperties properties = new AppboyProperties();
                for (Map.Entry<String, String> entry : screenAttributes.entrySet()) {
                    properties.addProperty(entry.getKey(), entry.getValue());
                }
                Appboy.getInstance((Context)this.getContext()).logCustomEvent(screenName, properties);
            }
            this.queueDataFlush();
            LinkedList<ReportingMessage> messages = new LinkedList<ReportingMessage>();
            messages.add(new ReportingMessage((KitIntegration)this, "v", System.currentTimeMillis(), screenAttributes));
            return messages;
        }
        return null;
    }

    public List<ReportingMessage> logLtvIncrease(BigDecimal valueIncreased, BigDecimal valueTotal, String eventName, Map<String, String> contextInfo) {
        return null;
    }

    public List<ReportingMessage> logEvent(CommerceEvent event) {
        LinkedList<ReportingMessage> messages = new LinkedList<ReportingMessage>();
        if (!KitUtils.isEmpty((CharSequence)event.getProductAction()) && event.getProductAction().equalsIgnoreCase("purchase") && event.getProducts().size() > 0) {
            List productList = event.getProducts();
            for (Product product : productList) {
                this.logTransaction(event, product);
            }
            messages.add(ReportingMessage.fromEvent((KitIntegration)this, (CommerceEvent)event));
            this.queueDataFlush();
            return messages;
        }
        List eventList = CommerceEventUtils.expand((CommerceEvent)event);
        if (eventList != null) {
            for (int i = 0; i < eventList.size(); ++i) {
                try {
                    this.logEvent((MPEvent)eventList.get(i));
                    messages.add(ReportingMessage.fromEvent((KitIntegration)this, (CommerceEvent)event));
                    continue;
                }
                catch (Exception e) {
                    Logger.warning((String[])new String[]{"Failed to call logCustomEvent to Appboy kit: " + e.toString()});
                }
            }
            this.queueDataFlush();
        }
        return messages;
    }

    public void setUserAttribute(String key, String value) {
        AppboyUser user = Appboy.getInstance((Context)this.getContext()).getCurrentUser();
        if ("$City".equals(key)) {
            user.setHomeCity(value);
        } else if ("$Country".equals(key)) {
            user.setCountry(value);
        } else if ("$FirstName".equals(key)) {
            user.setFirstName(value);
        } else if ("$Gender".equals(key)) {
            if (value.contains("fe")) {
                user.setGender(Gender.FEMALE);
            } else {
                user.setGender(Gender.MALE);
            }
        } else if ("$LastName".equals(key)) {
            user.setLastName(value);
        } else if ("$Mobile".equals(key)) {
            user.setPhoneNumber(value);
        } else if ("$Age".equals(key)) {
            Calendar calendar = this.getCalendarMinusYears(value);
            if (calendar != null) {
                user.setDateOfBirth(calendar.get(1), Month.JANUARY, 1);
            } else {
                Logger.error((String[])new String[]{"unable to set DateOfBirth for $Age = " + value});
            }
        } else {
            if (key.startsWith("$")) {
                key = key.substring(1);
            }
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                user.setCustomUserAttribute(key, Boolean.parseBoolean(value));
            } else {
                try {
                    double doubleValue = Double.parseDouble(value);
                    if (doubleValue % 1.0 == 0.0) {
                        user.setCustomUserAttribute(key, Integer.parseInt(value));
                    } else {
                        user.setCustomUserAttribute(key, doubleValue);
                    }
                }
                catch (NumberFormatException nfe) {
                    user.setCustomUserAttribute(key, value);
                }
            }
        }
        this.queueDataFlush();
    }

    public void setUserAttributeList(String key, List<String> list) {
        AppboyUser user = Appboy.getInstance((Context)this.getContext()).getCurrentUser();
        String[] array = list.toArray(new String[list.size()]);
        user.setCustomAttributeArray(key, array);
        this.queueDataFlush();
    }

    public boolean supportsAttributeLists() {
        return true;
    }

    void queueDataFlush() {
        this.dataFlushHandler.removeCallbacks(this.dataFlushRunnable);
        this.dataFlushHandler.postDelayed(this.dataFlushRunnable, 5000L);
    }

    public void setAllUserAttributes(Map<String, String> attributes, Map<String, List<String>> attributeLists) {
        if (!this.getKitPreferences().getBoolean(PREF_KEY_HAS_SYNCED_ATTRIBUTES, false)) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.setUserAttribute(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : attributeLists.entrySet()) {
                this.setUserAttributeList(entry.getKey(), (List)entry.getValue());
            }
            this.getKitPreferences().edit().putBoolean(PREF_KEY_HAS_SYNCED_ATTRIBUTES, true).apply();
        }
    }

    public void removeUserAttribute(String key) {
        AppboyUser user = Appboy.getInstance((Context)this.getContext()).getCurrentUser();
        if ("$City".equals(key)) {
            user.setHomeCity(null);
        } else if ("$Country".equals(key)) {
            user.setCountry(null);
        } else if ("$FirstName".equals(key)) {
            user.setFirstName(null);
        } else if ("$Gender".equals(key)) {
            user.setGender(null);
        } else if ("$LastName".equals(key)) {
            user.setLastName(null);
        } else if ("$Mobile".equals(key)) {
            user.setPhoneNumber(null);
        } else {
            if (key.startsWith("$")) {
                key = key.substring(1);
            }
            user.unsetCustomUserAttribute(key);
        }
        this.queueDataFlush();
    }

    public void setUserIdentity(MParticle.IdentityType identityType, String identity) {
    }

    public void removeUserIdentity(MParticle.IdentityType identityType) {
    }

    public List<ReportingMessage> logout() {
        return null;
    }

    private void logTransaction(CommerceEvent event, Product product) {
        AppboyProperties purchaseProperties = new AppboyProperties();
        HashMap eventAttributes = new HashMap();
        CommerceEventUtils.extractActionAttributes((CommerceEvent)event, eventAttributes);
        String currency = (String)eventAttributes.get("Currency Code");
        if (KitUtils.isEmpty((CharSequence)currency)) {
            currency = "USD";
        }
        eventAttributes.remove("Currency Code");
        for (Map.Entry entry : eventAttributes.entrySet()) {
            purchaseProperties.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        Appboy.getInstance((Context)this.getContext()).logPurchase(product.getSku(), currency, new BigDecimal(product.getUnitPrice()), (int)product.getQuantity(), purchaseProperties);
    }

    public boolean willHandlePushMessage(Intent intent) {
        if (!Boolean.parseBoolean((String)this.getSettings().get(PUSH_ENABLED))) {
            return false;
        }
        return AppboyNotificationUtils.isAppboyPushMessage((Intent)intent);
    }

    public void onPushMessageReceived(Context context, Intent pushIntent) {
        if (Boolean.parseBoolean((String)this.getSettings().get(PUSH_ENABLED))) {
            new AppboyFcmReceiver().onReceive(context, pushIntent);
        }
    }

    public boolean onPushRegistration(String instanceId, String senderId) {
        if (Boolean.parseBoolean((String)this.getSettings().get(PUSH_ENABLED))) {
            Appboy.getInstance((Context)this.getContext()).registerAppboyPushMessages(instanceId);
            this.queueDataFlush();
            return true;
        }
        return false;
    }

    protected void setAuthority(final String authority) {
        Appboy.setAppboyEndpointProvider((IAppboyEndpointProvider)new IAppboyEndpointProvider(){

            public Uri getApiEndpoint(Uri appboyEndpoint) {
                return appboyEndpoint.buildUpon().authority(authority).build();
            }
        });
    }

    public void onIdentifyCompleted(MParticleUser mParticleUser, FilteredIdentityApiRequest filteredIdentityApiRequest) {
        this.updateUser(mParticleUser);
    }

    public void onLoginCompleted(MParticleUser mParticleUser, FilteredIdentityApiRequest filteredIdentityApiRequest) {
        this.updateUser(mParticleUser);
    }

    public void onLogoutCompleted(MParticleUser mParticleUser, FilteredIdentityApiRequest filteredIdentityApiRequest) {
        this.updateUser(mParticleUser);
    }

    public void onModifyCompleted(MParticleUser mParticleUser, FilteredIdentityApiRequest filteredIdentityApiRequest) {
        this.updateUser(mParticleUser);
    }

    private void updateUser(MParticleUser mParticleUser) {
        String customerId = (String)mParticleUser.getUserIdentities().get(MParticle.IdentityType.CustomerId);
        String email = (String)mParticleUser.getUserIdentities().get(MParticle.IdentityType.Email);
        if (customerId != null) {
            this.setCustomerId(customerId);
        }
        if (email != null) {
            this.setEmail(email);
        }
    }

    protected void setCustomerId(String customerId) {
        AppboyUser user = Appboy.getInstance((Context)this.getContext()).getCurrentUser();
        if (user == null || user.getUserId() != null && !user.getUserId().equals(customerId)) {
            Appboy.getInstance((Context)this.getContext()).changeUser(customerId);
            this.queueDataFlush();
        }
    }

    protected void setEmail(String email) {
        if (!email.equals(this.getKitPreferences().getString(PREF_KEY_CURRENT_EMAIL, null))) {
            AppboyUser user = Appboy.getInstance((Context)this.getContext()).getCurrentUser();
            user.setEmail(email);
            this.queueDataFlush();
            this.getKitPreferences().edit().putString(PREF_KEY_CURRENT_EMAIL, email).apply();
        }
    }

    public void onUserIdentified(MParticleUser mParticleUser) {
    }

    @Nullable
    Calendar getCalendarMinusYears(String yearsString) {
        try {
            int years = Integer.parseInt(yearsString);
            return this.getCalendarMinusYears(years);
        }
        catch (NumberFormatException ignored) {
            try {
                double years = Double.parseDouble(yearsString);
                return this.getCalendarMinusYears((int)years);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    @Nullable
    Calendar getCalendarMinusYears(int years) {
        if (years >= 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, calendar.get(1) - years);
            return calendar;
        }
        return null;
    }
}

