/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.BaseEvent;
import com.mparticle.MParticle;
import com.mparticle.internal.Logger;
import com.mparticle.internal.MPUtility;
import com.mparticle.internal.c0.b;
import com.mparticle.internal.c0.e;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MPEvent
extends BaseEvent {
    private MParticle.EventType eventType;
    private String eventName;
    private String category;
    private Double duration = null;
    private Double startTime = null;
    private Double endTime = null;
    private int eventHash;
    private boolean entering = true;
    private boolean screenEvent;

    private MPEvent() {
        super(BaseEvent.Type.EVENT);
    }

    /*
     * WARNING - void declaration
     */
    private MPEvent(Builder builder) {
        super(BaseEvent.Type.EVENT);
        void var1_1;
        if (builder.eventType == null) {
            Logger.error("MPEvent created with no event type!");
        } else {
            this.eventType = ((Builder)var1_1).eventType;
        }
        if (((Builder)var1_1).eventName == null) {
            Logger.error("MPEvent created with no event name!");
        } else if (((Builder)var1_1).eventName.length() > 256) {
            Logger.error("MPEvent created with too long of a name and will be truncated, the limit is: 256");
            this.eventName = ((Builder)var1_1).eventName.substring(0, 256);
        } else {
            this.eventName = ((Builder)var1_1).eventName;
        }
        this.entering = ((Builder)var1_1).entering;
        this.setCustomAttributes(((Builder)var1_1).customAttributes);
        if (((Builder)var1_1).category != null) {
            this.category = ((Builder)var1_1).category;
            if (this.getCustomAttributes() == null) {
                HashMap<String, String> hashMap;
                HashMap<String, String> hashMap2 = hashMap;
                hashMap = new HashMap<String, String>();
                this.setCustomAttributes(hashMap2);
            }
            this.getCustomAttributes().put("$Category", ((Builder)var1_1).category);
        }
        if (((Builder)var1_1).duration != null) {
            this.duration = ((Builder)var1_1).duration;
        }
        if (((Builder)var1_1).endTime != null) {
            this.endTime = ((Builder)var1_1).endTime;
        }
        if (((Builder)var1_1).startTime != null) {
            this.startTime = ((Builder)var1_1).startTime;
        }
        if (((Builder)var1_1).customFlags != null) {
            this.setCustomFlags(((Builder)var1_1).customFlags);
        }
        this.screenEvent = ((Builder)var1_1).screenEvent;
    }

    /*
     * WARNING - void declaration
     */
    public MPEvent(@NonNull MPEvent mpEvent) {
        super(BaseEvent.Type.EVENT);
        void var1_1;
        this.eventType = var1_1.eventType;
        this.eventName = var1_1.eventName;
        if (mpEvent.getCustomAttributes() != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.putAll(var1_1.getCustomAttributes());
            this.setCustomAttributes(hashMap);
        } else {
            this.setCustomAttributes(null);
        }
        this.category = var1_1.category;
        this.duration = var1_1.duration;
        this.endTime = var1_1.endTime;
        this.startTime = var1_1.startTime;
        this.setCustomFlags(var1_1.getCustomFlags());
        this.entering = var1_1.entering;
        this.screenEvent = var1_1.screenEvent;
        com.mparticle.internal.listeners.b.a().onCompositeObjects(var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object o2) {
        void var1_1;
        return super.equals(var1_1) || var1_1 != null && this.toString().equals(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setInfo(@Nullable Map<String, String> info) {
        void var1_1;
        this.setCustomAttributes((Map<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCustomAttributes(@Nullable Map<String, String> customAttributes) {
        void var1_1;
        super.setCustomAttributes((Map<String, String>)var1_1);
    }

    @NonNull
    public String toString() {
        Object object;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (this.eventName != null) {
            stringBuilder2.append("Event name: ").append(this.eventName).append("\n");
        }
        if (this.eventType != null) {
            stringBuilder2.append("type: ").append(this.eventType.name()).append("\n");
        }
        if ((object = this.getLength()) != null && (Double)object > 0.0) {
            stringBuilder2.append("length: ").append(object).append("ms").append("\n");
        }
        if (this.getCustomAttributes() != null) {
            stringBuilder2.append("customAttributes:\n");
            ArrayList<String> arrayList = new ArrayList<String>(this.getCustomAttributes().keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                stringBuilder2.append(string).append(":").append(this.getCustomAttributes().get(string)).append("\n");
            }
        }
        if (this.getCustomFlags() != null) {
            stringBuilder2.append("custom flags:\n");
            stringBuilder2.append(this.getCustomFlags().toString());
        }
        return stringBuilder2.toString();
    }

    @NonNull
    public String getEventName() {
        return this.eventName;
    }

    public boolean isScreenEvent() {
        return this.screenEvent;
    }

    /*
     * WARNING - void declaration
     */
    protected MPEvent setScreenEvent(boolean screenEvent) {
        void var1_1;
        this.screenEvent = var1_1;
        BaseEvent.Type type = screenEvent ? BaseEvent.Type.SCREEN_VIEW : BaseEvent.Type.EVENT;
        MPEvent mPEvent = this;
        mPEvent.setType(type);
        return mPEvent;
    }

    public int getEventHash() {
        if (this.eventHash == 0) {
            this.eventHash = MPUtility.mpHash(this.eventType.ordinal() + this.eventName);
        }
        return this.eventHash;
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    @Deprecated
    @Nullable
    public Map<String, String> getInfo() {
        return this.getCustomAttributes();
    }

    @NonNull
    public MParticle.EventType getEventType() {
        return this.eventType;
    }

    @Nullable
    public Double getLength() {
        Double d2 = this.duration;
        if (d2 != null) {
            return d2;
        }
        d2 = this.endTime;
        if (d2 != null && this.startTime != null) {
            double d3;
            double d4 = d2 - this.startTime;
            if (!(d3 > 0.0)) {
                d4 = 0.0;
            }
            return d4;
        }
        return null;
    }

    boolean getNavigationDirection() {
        return this.entering;
    }

    @Override
    @NonNull
    public b getMessage() {
        return new e.a("e").a(this.getEventType()).b(this.getEventName()).b(this.getLength()).a(this.getCustomFlags()).a(MPUtility.enforceAttributeConstraints(this.getCustomAttributes()));
    }

    public static class Builder {
        private static final String EVENT_TYPE = "eventType";
        private static final String EVENT_CUSTOM_FLAGS = "customFlags";
        private static final String EVENT_NAME = "eventName";
        private static final String EVENT_CATEGORY = "category";
        private static final String EVENT_DURATION = "duration";
        private static final String EVENT_INFO = "customAttributes";
        private static final String EVENT_START_TIME = "startTime";
        private static final String EVENT_END_TIME = "endTime";
        private boolean screenEvent;
        private MParticle.EventType eventType;
        private String eventName;
        private String category;
        private Map<String, String> customAttributes;
        private Double duration;
        private Double startTime;
        private Double endTime;
        private Map<String, List<String>> customFlags;
        private boolean entering;

        private Builder() {
            this.duration = null;
            this.startTime = null;
            this.endTime = null;
            this.customFlags = null;
            this.entering = true;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String eventName, @NonNull MParticle.EventType eventType) {
            void var2_2;
            void var1_1;
            this.duration = null;
            this.startTime = null;
            this.endTime = null;
            this.customFlags = null;
            this.entering = true;
            this.eventName = var1_1;
            this.eventType = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String eventName) {
            void var1_1;
            Builder builder = this;
            this.duration = null;
            this.startTime = null;
            this.endTime = null;
            this.customFlags = null;
            this.entering = true;
            builder.eventName = var1_1;
            builder.eventType = MParticle.EventType.Other;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull MPEvent event) {
            void var1_1;
            this.duration = null;
            this.startTime = null;
            this.endTime = null;
            this.customFlags = null;
            this.entering = true;
            this.eventName = var1_1.getEventName();
            this.eventType = var1_1.getEventType();
            this.category = var1_1.getCategory();
            this.customAttributes = var1_1.getCustomAttributes();
            this.duration = ((MPEvent)var1_1).duration;
            this.startTime = ((MPEvent)var1_1).startTime;
            this.endTime = ((MPEvent)var1_1).endTime;
            this.customFlags = var1_1.getCustomFlags();
            this.entering = ((MPEvent)var1_1).entering;
            this.screenEvent = ((MPEvent)var1_1).screenEvent;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        private Builder startTime(double startTimeMillis) {
            void var1_1;
            this.startTime = (double)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private Builder endTime(double endTimeMillis) {
            void var1_1;
            this.endTime = (double)var1_1;
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public static Builder parseString(@NonNull String builderString) {
            block31: {
                block30: {
                    var1_2 = null;
                    var2_4 = v0;
                    v0 = new JSONObject((String)var0);
                    var0 = v1;
                    v2 = var2_4;
                    v3 = var0;
                    v4 = var2_4;
                    v5 = v4;
                    var3_5 = v4.getString("eventName");
                    v3((String)var3_5, MParticle.EventType.valueOf(v5.getString("eventType")));
                    v1.category = v2.optString("category");
                    if (!v0.has("duration")) ** GOTO lbl19
                    var0.duration = var2_4.getDouble("duration");
lbl19:
                    // 2 sources

                    if (!var2_4.has("startTime")) ** GOTO lbl22
                    var0.startTime = var2_4.getDouble("startTime");
lbl22:
                    // 2 sources

                    if (!var2_4.has("endTime")) ** GOTO lbl25
                    var0.endTime = var2_4.getDouble("endTime");
lbl25:
                    // 2 sources

                    if (!var2_4.has("customAttributes")) ** GOTO lbl45
                    var1_2 = var2_4.getJSONObject("customAttributes");
                    var3_5 = v6;
                    v6 = new HashMap<K, V>();
                    var4_6 = var1_2.keys();
                    while (true) {
                        if (!var4_6.hasNext()) break;
                        v7 = var3_5;
                        v8 = var1_2;
                        var5_7 = (String)var4_6.next();
                        v7.put(var5_7, v8.getString(var5_7));
                    }
                    var0.customAttributes = var3_5;
lbl45:
                    // 2 sources

                    if (!var2_4.has("customFlags")) break block30;
                    var1_2 = var2_4.getJSONObject("customFlags");
                    var2_4 = v9;
                    v9 = new HashMap<K, V>();
                    var3_5 = var1_2.keys();
                    block28: while (true) {
                        if (!var3_5.hasNext()) break;
                        v10 = var2_4;
                        v11 = var1_2;
                        var4_6 = (String)var3_5.next();
                        var5_7 = v11.getJSONArray((String)var4_6);
                        v10.put(var4_6, new LinkedList<E>());
                        var6_8 = 0;
                        while (true) {
                            if (var6_8 >= var5_7.length()) continue block28;
                            ((List)var2_4.get(var4_6)).add(var5_7.getString(var6_8));
                            ++var6_8;
                        }
                        break;
                    }
                    try {
                        var0.customFlags = var2_4;
                    }
                    catch (Exception var1_3) {
                        var1_2 = var0;
                        var0 = var1_3;
                    }
                }
                return var0;
                break block31;
                catch (Exception var0_1) {
                    // empty catch block
                }
            }
            Logger.warning(new String[]{"Failed to deserialize MPEvent.Builder: " + var0.toString()});
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder eventName(@NonNull String eventName) {
            if (eventName != null) {
                void var1_1;
                this.eventName = var1_1;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder eventType(@NonNull MParticle.EventType eventType) {
            if (eventType != null) {
                void var1_1;
                this.eventType = var1_1;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addCustomFlag(@Nullable String key, @Nullable String value) {
            void var2_2;
            void var1_1;
            Cloneable cloneable;
            if (this.customFlags == null) {
                HashMap<String, List<String>> hashMap;
                cloneable = hashMap;
                hashMap = new HashMap<String, List<String>>();
                this.customFlags = cloneable;
            }
            if (!this.customFlags.containsKey(var1_1)) {
                LinkedList linkedList;
                cloneable = linkedList;
                linkedList = new LinkedList();
                this.customFlags.put((String)var1_1, (List<String>)((Object)cloneable));
            }
            Builder builder = this;
            builder.customFlags.get(var1_1).add((String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder category(@Nullable String category) {
            void var1_1;
            this.category = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder duration(double durationMillis) {
            void var1_1;
            this.duration = (double)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder info(@Nullable Map<String, String> info) {
            void var1_1;
            this.customAttributes = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder customAttributes(@Nullable Map<String, String> customAttributes) {
            void var1_1;
            this.customAttributes = var1_1;
            return this;
        }

        @NonNull
        public Builder startTime() {
            return this.startTime(System.currentTimeMillis());
        }

        @NonNull
        public Builder endTime() {
            return this.endTime(System.currentTimeMillis());
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder internalNavigationDirection(boolean entering) {
            void var1_1;
            this.entering = var1_1;
            return this;
        }

        @NonNull
        public MPEvent build() {
            return new MPEvent(this);
        }

        @NonNull
        public String toString() {
            JSONObject jSONObject;
            block36: {
                JSONObject jSONObject2;
                Object object;
                Iterator<Map.Entry<String, Object>> iterator;
                String string;
                block35: {
                    block34: {
                        block33: {
                            JSONObject jSONObject3;
                            block32: {
                                block31: {
                                    JSONObject jSONObject4;
                                    Builder builder = this;
                                    jSONObject = jSONObject4;
                                    Builder builder2 = this;
                                    JSONObject jSONObject5 = jSONObject;
                                    JSONObject jSONObject6 = jSONObject5;
                                    jSONObject5();
                                    jSONObject6.put(EVENT_TYPE, (Object)this.eventType.toString());
                                    string = EVENT_NAME;
                                    jSONObject4.put(string, (Object)builder2.eventName);
                                    if (builder.category == null) break block31;
                                    string = EVENT_CATEGORY;
                                    jSONObject.put(string, (Object)this.category);
                                }
                                if (this.duration == null) break block32;
                                string = EVENT_DURATION;
                                jSONObject.put(string, (Object)this.duration);
                            }
                            if (this.customAttributes == null) break block33;
                            Builder builder = this;
                            string = jSONObject3;
                            jSONObject3 = new JSONObject();
                            iterator = builder.customAttributes.entrySet().iterator();
                            while (true) {
                                if (!iterator.hasNext()) break;
                                String string2 = string;
                                Map.Entry<String, String> entry = iterator.next();
                                Map.Entry<String, String> entry2 = entry;
                                object = entry.getKey();
                                string2.put((String)object, (Object)entry2.getValue());
                            }
                            jSONObject.put(EVENT_INFO, (Object)string);
                        }
                        if (this.startTime == null) break block34;
                        string = EVENT_START_TIME;
                        jSONObject.put(string, (Object)this.startTime);
                    }
                    if (this.endTime == null) break block35;
                    string = EVENT_END_TIME;
                    jSONObject.put(string, (Object)this.endTime);
                }
                if (this.customFlags == null) break block36;
                Builder builder = this;
                string = jSONObject2;
                jSONObject2 = new JSONObject();
                iterator = builder.customFlags.entrySet().iterator();
                while (true) {
                    JSONArray jSONArray;
                    if (!iterator.hasNext()) break;
                    String string3 = string;
                    Map.Entry<String, Object> entry = iterator.next();
                    Map.Entry<String, Object> entry3 = entry;
                    object = (List)entry.getValue();
                    JSONArray jSONArray2 = jSONArray;
                    jSONArray = new JSONArray((Collection)object);
                    string3.put(entry3.getKey(), (Object)jSONArray2);
                }
                try {
                    jSONObject.put(EVENT_CUSTOM_FLAGS, (Object)string);
                }
                catch (JSONException jSONException) {
                    Logger.warning("Failed to serialize MPEvent.Builder: " + jSONException.toString());
                    return super.toString();
                }
            }
            return jSONObject.toString();
        }
    }
}

