/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.commerce;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.BaseEvent;
import com.mparticle.commerce.Impression;
import com.mparticle.commerce.Product;
import com.mparticle.commerce.Promotion;
import com.mparticle.commerce.TransactionAttributes;
import com.mparticle.internal.Logger;
import com.mparticle.internal.MPUtility;
import com.mparticle.internal.c0.b;
import com.mparticle.internal.c0.d;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class CommerceEvent
extends BaseEvent {
    private String mEventName;
    private List<Impression> mImpressions;
    private String mProductAction;
    private String mPromotionAction;
    private List<Promotion> promotionList;
    private List<Product> productList;
    private Integer mCheckoutStep;
    private String mCheckoutOptions;
    private String mProductListName;
    private String mProductListSource;
    private String mCurrency;
    private TransactionAttributes mTransactionAttributes;
    private String mScreen;
    private Boolean mNonIteraction;

    private CommerceEvent(Builder builder) {
        super(BaseEvent.Type.COMMERCE_EVENT);
        Object object;
        this.mProductAction = ((Builder)object).mProductAction;
        this.mPromotionAction = ((Builder)object).mPromotionAction;
        this.setCustomAttributes(((Builder)object).customAttributes);
        if (!MPUtility.isEmpty(builder.promotionList)) {
            ((Builder)object).promotionList.removeAll(Collections.singleton(null));
        }
        this.promotionList = ((Builder)object).promotionList;
        if (!MPUtility.isEmpty(((Builder)object).productList)) {
            this.productList = new LinkedList<Product>(((Builder)object).productList);
            this.productList.removeAll(Collections.singleton(null));
        }
        this.mCheckoutStep = ((Builder)object).mCheckoutStep;
        this.mCheckoutOptions = ((Builder)object).mCheckoutOptions;
        this.mProductListName = ((Builder)object).mProductListName;
        this.mProductListSource = ((Builder)object).mProductListSource;
        this.mCurrency = ((Builder)object).mCurrency;
        this.mTransactionAttributes = ((Builder)object).mTransactionAttributes;
        this.mScreen = ((Builder)object).mScreen;
        this.mImpressions = ((Builder)object).mImpressions;
        this.mNonIteraction = ((Builder)object).mNonIteraction;
        this.mEventName = ((Builder)object).mEventName;
        if (((Builder)object).mCustomFlags != null) {
            this.setCustomFlags(((Builder)object).mCustomFlags);
        }
        if (MPUtility.isEmpty(this.mProductAction) && MPUtility.isEmpty(this.mPromotionAction) && ((object = this.mImpressions) == null || object.size() == 0)) {
            Logger.error("CommerceEvent must be created with either a product action, promotion action, or an impression.");
        }
        if ((object = this.mProductAction) != null) {
            if ((((String)object).equalsIgnoreCase("purchase") || this.mProductAction.equalsIgnoreCase("refund")) && ((object = this.mTransactionAttributes) == null || MPUtility.isEmpty(((TransactionAttributes)object).getId()))) {
                object = "CommerceEvent with action " + this.mProductAction + " must include a TransactionAttributes object with a transaction ID.";
                Logger.error(new String[]{object});
            }
            if ((object = this.promotionList) != null && object.size() > 0) {
                Logger.error("Product CommerceEvent should not contain Promotions.");
            }
            if (!(this.mProductAction.equals("add_to_cart") || this.mProductAction.equals("add_to_wishlist") || this.mProductAction.equals("checkout") || this.mProductAction.equals("checkout_option") || this.mProductAction.equals("click") || this.mProductAction.equals("view_detail") || this.mProductAction.equals("purchase") || this.mProductAction.equals("refund") || this.mProductAction.equals("remove_from_cart") || this.mProductAction.equals("remove_from_wishlist"))) {
                Logger.error("CommerceEvent created with unrecognized Product action: " + this.mProductAction);
            }
        } else if (this.mPromotionAction != null) {
            object = this.productList;
            if (object != null && object.size() > 0) {
                Logger.error("Promotion CommerceEvent should not contain Products.");
            }
            if (!this.mPromotionAction.equals("view") && !this.mPromotionAction.equals("click")) {
                Logger.error("CommerceEvent created with unrecognized Promotion action: " + this.mProductAction);
            }
        } else {
            object = this.productList;
            if (object != null && object.size() > 0) {
                Logger.error("Impression CommerceEvent should not contain Products.");
            }
            if ((object = this.promotionList) != null && object.size() > 0) {
                Logger.error("Impression CommerceEvent should not contain Promotions.");
            }
        }
        if ((object = this.mTransactionAttributes) == null || ((TransactionAttributes)object).getRevenue() == null) {
            double d2 = 0.0;
            object = this.mTransactionAttributes;
            if (object == null) {
                TransactionAttributes transactionAttributes;
                object = transactionAttributes;
                transactionAttributes = new TransactionAttributes();
                this.mTransactionAttributes = object;
            } else {
                object = ((TransactionAttributes)object).getShipping();
                Double d3 = this.mTransactionAttributes.getTax();
                d2 = (object != null ? (Double)object : 0.0) + d2;
                double d4 = d3 != null ? d3 : 0.0;
                d2 += d4;
            }
            object = this.productList;
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    Product product = (Product)object.next();
                    if (product == null) continue;
                    d2 += product.getUnitPrice() * product.getQuantity();
                }
            }
            this.mTransactionAttributes.setRevenue(d2);
        }
    }

    private CommerceEvent() {
        super(BaseEvent.Type.COMMERCE_EVENT);
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    public String toString() {
        block89: {
            block78: {
                block83: {
                    block88: {
                        block87: {
                            block86: {
                                block85: {
                                    block84: {
                                        block82: {
                                            block81: {
                                                block80: {
                                                    block79: {
                                                        block77: {
                                                            block76: {
                                                                v0 = this;
                                                                var1_1 = v1;
                                                                v1 = new JSONObject();
                                                                if (v0.mScreen == null) break block76;
                                                                var2_2 = "sn";
                                                                var1_1.put(var2_2, (Object)this.mScreen);
                                                            }
                                                            if (this.mNonIteraction == null) break block77;
                                                            var1_1.put("ni", this.mNonIteraction.booleanValue());
                                                        }
                                                        if (this.mProductAction == null) break block78;
                                                        v2 = this;
                                                        var2_2 = v3;
                                                        v4 = this;
                                                        var2_2();
                                                        var1_1.put("pd", (Object)var2_2);
                                                        var3_3 = "an";
                                                        v3.put((String)var3_3, (Object)v4.mProductAction);
                                                        if (v2.mCheckoutStep == null) break block79;
                                                        var3_3 = "cs";
                                                        var2_2.put((String)var3_3, (Object)this.mCheckoutStep);
                                                    }
                                                    if (this.mCheckoutOptions == null) break block80;
                                                    var3_3 = "co";
                                                    var2_2.put((String)var3_3, (Object)this.mCheckoutOptions);
                                                }
                                                if (this.mProductListName == null) break block81;
                                                var3_3 = "pal";
                                                var2_2.put((String)var3_3, (Object)this.mProductListName);
                                            }
                                            if (this.mProductListSource == null) break block82;
                                            var3_3 = "pls";
                                            var2_2.put((String)var3_3, (Object)this.mProductListSource);
                                        }
                                        if (this.mTransactionAttributes == null) break block83;
                                        if (this.mTransactionAttributes.getId() == null) break block84;
                                        var2_2.put("ti", (Object)this.mTransactionAttributes.getId());
                                    }
                                    if (this.mTransactionAttributes.getAffiliation() == null) break block85;
                                    var2_2.put("ta", (Object)this.mTransactionAttributes.getAffiliation());
                                }
                                if (this.mTransactionAttributes.getRevenue() == null) break block86;
                                var2_2.put("tr", (Object)this.mTransactionAttributes.getRevenue());
                            }
                            if (this.mTransactionAttributes.getTax() == null) break block87;
                            var2_2.put("tt", (Object)this.mTransactionAttributes.getTax());
                        }
                        if (this.mTransactionAttributes.getShipping() == null) break block88;
                        var2_2.put("ts", (Object)this.mTransactionAttributes.getShipping());
                    }
                    if (this.mTransactionAttributes.getCouponCode() == null) break block83;
                    var2_2.put("tcc", (Object)this.mTransactionAttributes.getCouponCode());
                }
                ** if (this.productList == null) goto lbl118
lbl-1000:
                // 1 sources

                {
                    ** if (this.productList.size() <= 0) goto lbl118
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = v5;
                        v5 = new JSONArray();
                        var4_4 = 0;
                        while (true) {
                            if (var4_4 >= this.productList.size()) break;
                            var3_3.put((Object)new JSONObject(this.productList.get(var4_4).toString()));
                            ++var4_4;
                        }
                        v6 = var2_2.put("pl", var3_3);
lbl116:
                        // 2 sources

                        while (true) {
                            ** GOTO lbl151
                            break;
                        }
                    }
                }
lbl118:
                // 2 sources

                ** GOTO lbl151
            }
            v7 = this;
            var2_2 = v8;
            v9 = this;
            var2_2();
            var1_1.put("pm", (Object)var2_2);
            var3_3 = "an";
            v8.put((String)var3_3, (Object)v9.mPromotionAction);
            if (v7.promotionList == null) ** GOTO lbl151
            if (this.promotionList.size() <= 0) ** GOTO lbl151
            var3_3 = v10;
            v10 = new JSONArray();
            var4_4 = 0;
            while (true) {
                if (var4_4 >= this.promotionList.size()) break;
                var3_3.put((Object)new JSONObject(this.promotionList.get(var4_4).toString()));
                ++var4_4;
            }
            v6 = var2_2.put("pl", var3_3);
            ** continue;
lbl151:
            // 4 sources

            if (this.mImpressions == null) break block89;
            if (this.mImpressions.size() <= 0) break block89;
            v11 = this;
            var2_2 = v12;
            v12 = new JSONArray();
            var3_3 = v11.mImpressions.iterator();
            while (true) {
                block91: {
                    block90: {
                        if (!var3_3.hasNext()) break;
                        var4_5 = (Impression)var3_3.next();
                        var5_6 = v13;
                        v13 = new JSONObject();
                        if (var4_5.getListName() == null) break block90;
                        var6_7 = "pil";
                        var5_6.put((String)var6_7, (Object)var4_5.getListName());
                    }
                    if (var4_5.getProducts() == null) break block91;
                    if (var4_5.getProducts().size() <= 0) break block91;
                    v14 = var4_5;
                    v15 = var5_6;
                    var4_5 = v16;
                    v16 = new JSONArray();
                    v15.put("pl", (Object)var4_5);
                    var6_7 = v14.getProducts().iterator();
                    while (true) {
                        if (!var6_7.hasNext()) break;
                        v17 = var4_5;
                        var7_8 = (Product)var6_7.next();
                        v17.put(new JSONObject(var7_8.toString()));
                    }
                }
                if (var5_6.length() <= 0) continue;
                var2_2.put((Object)var5_6);
            }
            try {
                if (var2_2.length() <= 0) break block89;
            }
            catch (JSONException v18) {
                return super.toString();
            }
            var1_1.put("pi", (Object)var2_2);
        }
        return var1_1.toString();
    }

    @Nullable
    public String getScreen() {
        return this.mScreen;
    }

    @Nullable
    public Boolean getNonInteraction() {
        return this.mNonIteraction;
    }

    @Nullable
    public String getProductAction() {
        return this.mProductAction;
    }

    @Nullable
    public Integer getCheckoutStep() {
        return this.mCheckoutStep;
    }

    @Nullable
    public String getCheckoutOptions() {
        return this.mCheckoutOptions;
    }

    @Nullable
    public String getProductListName() {
        return this.mProductListName;
    }

    @Nullable
    public String getProductListSource() {
        return this.mProductListSource;
    }

    @Nullable
    public TransactionAttributes getTransactionAttributes() {
        return this.mTransactionAttributes;
    }

    @Nullable
    public List<Product> getProducts() {
        List<Product> this_ = ((CommerceEvent)((Object)this_)).productList;
        if (this_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this_);
    }

    @Nullable
    public String getPromotionAction() {
        return this.mPromotionAction;
    }

    @Nullable
    public List<Promotion> getPromotions() {
        List<Promotion> this_ = ((CommerceEvent)((Object)this_)).promotionList;
        if (this_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this_);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object o2) {
        void var1_1;
        return o2 != null && var1_1.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Nullable
    public List<Impression> getImpressions() {
        List<Impression> this_ = ((CommerceEvent)((Object)this_)).mImpressions;
        if (this_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this_);
    }

    @Nullable
    public String getCurrency() {
        return this.mCurrency;
    }

    @Nullable
    public String getEventName() {
        return this.mEventName;
    }

    @Override
    public b getMessage() {
        return new d.a(this).a(this.getCustomFlags());
    }

    public static class Builder {
        private final String mProductAction;
        private final String mPromotionAction;
        private Map<String, String> customAttributes;
        private List<Promotion> promotionList;
        private List<Product> productList;
        private Integer mCheckoutStep;
        private String mCheckoutOptions;
        private String mProductListName;
        private String mProductListSource;
        private String mCurrency;
        private TransactionAttributes mTransactionAttributes;
        private String mScreen;
        private Boolean mNonIteraction;
        private List<Impression> mImpressions;
        private String mEventName;
        private Map<String, List<String>> mCustomFlags;

        private Builder() {
            this.customAttributes = null;
            this.promotionList = null;
            this.productList = null;
            this.mCheckoutStep = null;
            this.mCheckoutOptions = null;
            this.mProductListName = null;
            this.mProductListSource = null;
            this.mCurrency = null;
            this.mTransactionAttributes = null;
            this.mScreen = null;
            this.mCustomFlags = null;
            this.mPromotionAction = null;
            this.mProductAction = null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String productAction, Product product) {
            void var2_2;
            void var1_1;
            Builder builder = this;
            builder.customAttributes = null;
            builder.promotionList = null;
            builder.productList = null;
            builder.mCheckoutStep = null;
            builder.mCheckoutOptions = null;
            builder.mProductListName = null;
            builder.mProductListSource = null;
            builder.mCurrency = null;
            builder.mTransactionAttributes = null;
            builder.mScreen = null;
            builder.mCustomFlags = null;
            builder.mProductAction = var1_1;
            builder.mPromotionAction = null;
            builder.addProduct((Product)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String promotionAction, @NonNull Promotion promotion) {
            void var2_2;
            void var1_1;
            Builder builder = this;
            builder.customAttributes = null;
            builder.promotionList = null;
            builder.productList = null;
            builder.mCheckoutStep = null;
            builder.mCheckoutOptions = null;
            builder.mProductListName = null;
            builder.mProductListSource = null;
            builder.mCurrency = null;
            builder.mTransactionAttributes = null;
            builder.mScreen = null;
            builder.mCustomFlags = null;
            builder.mProductAction = null;
            builder.mPromotionAction = var1_1;
            builder.addPromotion((Promotion)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Impression impression) {
            void var1_1;
            Builder builder = this;
            builder.customAttributes = null;
            builder.promotionList = null;
            builder.productList = null;
            builder.mCheckoutStep = null;
            builder.mCheckoutOptions = null;
            builder.mProductListName = null;
            builder.mProductListSource = null;
            builder.mCurrency = null;
            builder.mTransactionAttributes = null;
            builder.mScreen = null;
            builder.mCustomFlags = null;
            builder.addImpression((Impression)var1_1);
            builder.mPromotionAction = null;
            builder.mProductAction = null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull CommerceEvent event) {
            void var1_1;
            this.customAttributes = null;
            this.promotionList = null;
            this.productList = null;
            this.mCheckoutStep = null;
            this.mCheckoutOptions = null;
            this.mProductListName = null;
            this.mProductListSource = null;
            this.mCurrency = null;
            this.mTransactionAttributes = null;
            this.mScreen = null;
            this.mCustomFlags = null;
            this.mProductAction = var1_1.getProductAction();
            this.mPromotionAction = var1_1.getPromotionAction();
            if (event.getCustomAttributes() != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.putAll(var1_1.getCustomAttributes());
                this.customAttributes = hashMap;
            }
            if (var1_1.getPromotions() != null) {
                for (Promotion object : var1_1.getPromotions()) {
                    this.addPromotion(new Promotion(object));
                }
            }
            if (var1_1.getProducts() != null) {
                for (Product product : var1_1.getProducts()) {
                    this.addProduct(new Product.Builder(product).build());
                }
            }
            this.mCheckoutStep = var1_1.getCheckoutStep();
            this.mCheckoutOptions = var1_1.getCheckoutOptions();
            this.mProductListName = var1_1.getProductListName();
            this.mProductListSource = var1_1.getProductListSource();
            this.mCurrency = var1_1.getCurrency();
            if (var1_1.getTransactionAttributes() != null) {
                this.mTransactionAttributes = new TransactionAttributes(var1_1.getTransactionAttributes());
            }
            this.mScreen = ((CommerceEvent)var1_1).mScreen;
            this.mNonIteraction = ((CommerceEvent)var1_1).mNonIteraction;
            if (var1_1.getImpressions() != null) {
                for (Impression impression : var1_1.getImpressions()) {
                    this.addImpression(new Impression(impression));
                }
            }
            this.mEventName = var1_1.getEventName();
            this.mCustomFlags = var1_1.getCustomFlags();
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder screen(@Nullable String screenName) {
            void var1_1;
            this.mScreen = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addProduct(Product product) {
            void var1_1;
            if (this.productList == null) {
                LinkedList<Product> linkedList;
                LinkedList<Product> linkedList2 = linkedList;
                linkedList = new LinkedList<Product>();
                this.productList = linkedList2;
            }
            Builder builder = this;
            builder.productList.add((Product)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder transactionAttributes(@NonNull TransactionAttributes attributes) {
            void var1_1;
            this.mTransactionAttributes = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder currency(@Nullable String currency) {
            void var1_1;
            this.mCurrency = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder nonInteraction(boolean userTriggered) {
            void var1_1;
            this.mNonIteraction = (boolean)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder customAttributes(@Nullable Map<String, String> attributes) {
            void var1_1;
            this.customAttributes = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addCustomFlag(@Nullable String key, @Nullable String value) {
            void var2_2;
            void var1_1;
            Cloneable cloneable;
            if (this.mCustomFlags == null) {
                HashMap<String, List<String>> hashMap;
                cloneable = hashMap;
                hashMap = new HashMap<String, List<String>>();
                this.mCustomFlags = cloneable;
            }
            if (!this.mCustomFlags.containsKey(var1_1)) {
                LinkedList linkedList;
                cloneable = linkedList;
                linkedList = new LinkedList();
                this.mCustomFlags.put((String)var1_1, (List<String>)((Object)cloneable));
            }
            Builder builder = this;
            builder.mCustomFlags.get(var1_1).add((String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addPromotion(@NonNull Promotion promotion) {
            void var1_1;
            if (this.promotionList == null) {
                LinkedList<Promotion> linkedList;
                LinkedList<Promotion> linkedList2 = linkedList;
                linkedList = new LinkedList<Promotion>();
                this.promotionList = linkedList2;
            }
            Builder builder = this;
            builder.promotionList.add((Promotion)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder checkoutStep(@Nullable Integer step) {
            void var1_1;
            if (step == null || var1_1.intValue() >= 0) {
                this.mCheckoutStep = var1_1;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addImpression(@NonNull Impression impression) {
            if (impression != null) {
                void var1_1;
                if (this.mImpressions == null) {
                    LinkedList<Impression> linkedList;
                    LinkedList<Impression> linkedList2 = linkedList;
                    linkedList = new LinkedList<Impression>();
                    this.mImpressions = linkedList2;
                }
                this.mImpressions.add((Impression)var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder checkoutOptions(@Nullable String options) {
            void var1_1;
            this.mCheckoutOptions = var1_1;
            return this;
        }

        @NonNull
        public CommerceEvent build() {
            return new CommerceEvent(this);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder productListName(@Nullable String listName) {
            void var1_1;
            this.mProductListName = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder productListSource(@Nullable String listSource) {
            void var1_1;
            this.mProductListSource = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder products(@NonNull List<Product> products) {
            void var1_1;
            this.productList = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder impressions(@NonNull List<Impression> impressions) {
            void var1_1;
            this.mImpressions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder promotions(@NonNull List<Promotion> promotions) {
            void var1_1;
            this.promotionList = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder internalEventName(@Nullable String eventName) {
            void var1_1;
            this.mEventName = var1_1;
            return this;
        }
    }
}

