/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.consent;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.consent.CCPAConsent;
import com.mparticle.consent.GDPRConsent;
import com.mparticle.internal.Logger;
import com.mparticle.internal.MPUtility;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class ConsentState {
    private static final String SERIALIZED_GDPR_KEY = "GDPR";
    private static final String SERIALIZED_CCPA_KEY = "CCPA";
    private Map<String, GDPRConsent> gdprConsentState = null;
    private CCPAConsent ccpaConsentState;

    private ConsentState() {
    }

    /*
     * WARNING - void declaration
     */
    private ConsentState(Builder builder) {
        void var1_1;
        this.gdprConsentState = ((Builder)var1_1).gdprConsentState;
        this.ccpaConsentState = ((Builder)var1_1).ccpaConsent;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder withConsentState(@NonNull ConsentState consentState) {
        ConsentState consentState2;
        return new Builder(consentState2);
    }

    @NonNull
    public static Builder withConsentState(@NonNull String consentState) {
        String string;
        return new Builder(string);
    }

    private static String canonicalizeForDeduplication(String source) {
        String string;
        if (MPUtility.isEmpty(source)) {
            return null;
        }
        return string.toLowerCase(Locale.US).trim();
    }

    @NonNull
    public Map<String, GDPRConsent> getGDPRConsentState() {
        return Collections.unmodifiableMap(this.gdprConsentState);
    }

    @Nullable
    public CCPAConsent getCCPAConsentState() {
        return this.ccpaConsentState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public String toString() {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2;
        JSONObject jSONObject4 = jSONObject;
        jSONObject = new JSONObject();
        new JSONObject().put(SERIALIZED_GDPR_KEY, (Object)jSONObject4);
        Iterator<Map.Entry<String, GDPRConsent>> iterator = this.gdprConsentState.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            JSONObject jSONObject5 = jSONObject4;
            Map.Entry<String, GDPRConsent> entry = iterator.next();
            jSONObject5.put(entry.getKey(), (Object)entry.getValue().toString());
        }
        try {
            if (this.ccpaConsentState == null) return jSONObject3.toString();
        }
        catch (JSONException jSONException) {}
        jSONObject3.put(SERIALIZED_CCPA_KEY, (Object)this.ccpaConsentState.toString());
        return jSONObject3.toString();
    }

    public static class Builder {
        private Map<String, GDPRConsent> gdprConsentState;
        private CCPAConsent ccpaConsent;

        public Builder() {
            HashMap hashMap;
            HashMap this_ = hashMap;
            hashMap = new HashMap();
            v1.gdprConsentState = this_;
            v1.ccpaConsent = null;
        }

        /*
         * WARNING - void declaration
         */
        private Builder(ConsentState consentState) {
            void var1_1;
            this.gdprConsentState = new HashMap<String, GDPRConsent>();
            this.ccpaConsent = null;
            this.setGDPRConsentState(var1_1.getGDPRConsentState());
            this.setCCPAConsentState(var1_1.getCCPAConsentState());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Builder(String serializedConsent) {
            JSONObject jSONObject;
            block12: {
                JSONObject jSONObject2;
                JSONObject jSONObject3;
                this.gdprConsentState = new HashMap<String, GDPRConsent>();
                this.ccpaConsent = null;
                if (MPUtility.isEmpty(serializedConsent)) {
                    return;
                }
                jSONObject = jSONObject3;
                if (!new JSONObject((String)jSONObject2).has(ConsentState.SERIALIZED_GDPR_KEY)) break block12;
                jSONObject2 = jSONObject.getJSONObject(ConsentState.SERIALIZED_GDPR_KEY);
                Iterator iterator = jSONObject2.keys();
                while (true) {
                    if (!iterator.hasNext()) break;
                    Builder builder = this;
                    JSONObject jSONObject4 = jSONObject2;
                    String string = (String)iterator.next();
                    builder.addGDPRConsentState(string, GDPRConsent.withGDPRConsent(jSONObject4.getString(string)).build());
                }
            }
            try {
                if (!jSONObject.has(ConsentState.SERIALIZED_CCPA_KEY)) return;
            }
            catch (JSONException jSONException) {}
            this.setCCPAConsentState(CCPAConsent.withCCPAConsent(jSONObject.getString(ConsentState.SERIALIZED_CCPA_KEY)).build());
            return;
        }

        @NonNull
        public Builder setGDPRConsentState(@Nullable Map<String, GDPRConsent> consentState) {
            Iterator iterator;
            HashMap hashMap;
            HashMap hashMap3;
            if (consentState == null) {
                HashMap hashMap2;
                Builder builder = hashMap3;
                hashMap3 = hashMap2;
                hashMap2 = new HashMap();
                builder.gdprConsentState = hashMap3;
                return builder;
            }
            HashMap object2 = hashMap;
            hashMap = new HashMap(iterator);
            ((Builder)((Object)hashMap3)).gdprConsentState = new HashMap<String, GDPRConsent>();
            for (Map.Entry entry : object2.entrySet()) {
                ((Builder)((Object)hashMap3)).addGDPRConsentState((String)entry.getKey(), (GDPRConsent)entry.getValue());
            }
            return hashMap3;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addGDPRConsentState(@NonNull String purpose, @NonNull GDPRConsent consent) {
            void var2_2;
            String string = ConsentState.canonicalizeForDeduplication(purpose);
            if (MPUtility.isEmpty(string)) {
                Logger.error("Cannot set GDPR Consent with null or empty purpose.");
                return this;
            }
            if (this.gdprConsentState == null) {
                HashMap<String, GDPRConsent> hashMap;
                HashMap<String, GDPRConsent> hashMap2 = hashMap;
                hashMap = new HashMap<String, GDPRConsent>();
                this.gdprConsentState = hashMap2;
            }
            Builder builder = this;
            builder.gdprConsentState.put(string, (GDPRConsent)var2_2);
            return builder;
        }

        @NonNull
        public Builder removeGDPRConsentState(@NonNull String purpose) {
            String string = ConsentState.canonicalizeForDeduplication(purpose);
            if (MPUtility.isEmpty(string)) {
                Logger.error("Cannot remove GDPR Consent with null or empty purpose");
                return this;
            }
            Map<String, GDPRConsent> map = this.gdprConsentState;
            if (map == null) {
                return this;
            }
            map.remove(string);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder setCCPAConsent(@NonNull CCPAConsent ccpaConsent) {
            void var1_1;
            return this.setCCPAConsentState((CCPAConsent)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCCPAConsentState(@NonNull CCPAConsent ccpaConsent) {
            void var1_1;
            this.ccpaConsent = var1_1;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder removeCCPAConsent() {
            return this.removeCCPAConsentState();
        }

        @NonNull
        public Builder removeCCPAConsentState() {
            this.ccpaConsent = null;
            return this;
        }

        @NonNull
        public ConsentState build() {
            return new ConsentState(this);
        }

        @NonNull
        public String toString() {
            return this.build().toString();
        }
    }
}

