/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.messaging;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.mparticle.MPService;
import com.mparticle.MParticle;
import com.mparticle.internal.Logger;
import com.mparticle.internal.MPUtility;
import com.mparticle.internal.PushRegistrationHelper;
import com.mparticle.messaging.PushAnalyticsReceiver;

public class MPMessagingAPI {
    @NonNull
    public static final String CLOUD_MESSAGE_EXTRA = "mp-push-message";
    @NonNull
    public static final String BROADCAST_NOTIFICATION_RECEIVED = "com.mparticle.push.RECEIVE";
    @NonNull
    public static final String BROADCAST_NOTIFICATION_TAPPED = "com.mparticle.push.TAP";
    private final Context mContext;

    private MPMessagingAPI() {
        this.mContext = null;
    }

    /*
     * WARNING - void declaration
     */
    public MPMessagingAPI(@NonNull Context context) {
        void var1_1;
        this.mContext = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void enablePushNotifications(@NonNull String senderId) {
        void var1_1;
        MParticle.getInstance().Internal().b().c((String)var1_1);
        if (!MPUtility.isFirebaseAvailable().booleanValue()) {
            Logger.error("Push is enabled but Firebase Cloud Messaging library not found - you must add com.google.firebase:firebase-messaging:7.5 or later to your application.");
        } else if (!MPUtility.isServiceAvailable(this.mContext, MPService.class)) {
            Logger.error("Push is enabled but you have not added <service android:name=\"com.mparticle.MPService\" /> to the <application> section of your AndroidManifest.xml.");
        } else if (!MPUtility.checkPermission(this.mContext, "com.google.android.c2dm.permission.RECEIVE")) {
            Logger.error("Attempted to enable push notifications without required permission: ", "\"com.google.android.c2dm.permission.RECEIVE\".");
        } else {
            PushRegistrationHelper.requestInstanceId(this.mContext, (String)var1_1);
        }
    }

    public void disablePushNotifications() {
        MParticle.getInstance().Internal().b().b();
    }

    /*
     * WARNING - void declaration
     */
    public void displayPushNotificationByDefault(@Nullable Boolean enabled) {
        void var1_1;
        MParticle.getInstance().Internal().b().a((Boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void registerPushAnalyticsReceiver(@NonNull PushAnalyticsReceiver receiver) {
        void var1_1;
        IntentFilter intentFilter;
        MPMessagingAPI mPMessagingAPI = this_;
        MPMessagingAPI this_ = intentFilter;
        new IntentFilter().addAction(BROADCAST_NOTIFICATION_RECEIVED);
        this_.addAction(BROADCAST_NOTIFICATION_TAPPED);
        LocalBroadcastManager.getInstance((Context)mPMessagingAPI.mContext).registerReceiver((BroadcastReceiver)var1_1, (IntentFilter)this_);
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterPushAnalyticsReceiver(@Nullable PushAnalyticsReceiver receiver) {
        void var1_1;
        LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver((BroadcastReceiver)var1_1);
    }
}

