/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.networking;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.internal.Logger;
import com.mparticle.internal.MPUtility;
import com.mparticle.networking.Certificate;
import com.mparticle.networking.f;
import com.mparticle.networking.h;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DomainMapping {
    private f.b mType;
    private String mUrl;
    private List<Certificate> mCertificates = new LinkedList<Certificate>();
    private boolean overridesSubdirectory;
    private boolean eventsOnly;

    /*
     * WARNING - void declaration
     */
    private DomainMapping(Builder builder) {
        void var1_1;
        this.mType = var1_1.type;
        this.mUrl = var1_1.newUrl;
        Object[] objectArray = builder.certificates;
        if (builder.certificates != null && objectArray.size() > 0) {
            this.mCertificates = new LinkedList<Certificate>(var1_1.certificates);
        } else {
            String[] stringArray = new String[1];
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = var1_1.type.name();
            stringArray[0] = String.format("Domain mapping for %s does not have any mCertificates, default mCertificates will be applied", objectArray);
            Logger.warning(stringArray);
        }
        this.overridesSubdirectory = var1_1.overridesSubdirectory;
        this.eventsOnly = var1_1.eventsOnly;
    }

    @NonNull
    public static Builder configMapping(@Nullable String newUrl) {
        return DomainMapping.configMapping(newUrl, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Builder configMapping(@Nullable String newUrl, boolean overridesSubdirectory) {
        void var1_1;
        String string;
        return new Builder(f.b.b, string, (boolean)var1_1);
    }

    @NonNull
    public static Builder eventsMapping(@Nullable String newUrl) {
        return DomainMapping.eventsMapping(newUrl, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Builder eventsMapping(@Nullable String newUrl, boolean overridesSubdirectory) {
        void var1_1;
        return DomainMapping.eventsMapping(newUrl, (boolean)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Builder eventsMapping(@Nullable String newUrl, boolean overridesSubdirectory, boolean eventsOnly) {
        void var2_2;
        void var1_1;
        String string;
        return new Builder(f.b.d, string, (boolean)var1_1).setEventsOnly((boolean)var2_2);
    }

    public static Builder aliasMapping(@Nullable String newUrl) {
        return DomainMapping.aliasMapping(newUrl, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Builder aliasMapping(@Nullable String newUrl, boolean overridesSubdirectory) {
        void var1_1;
        String string;
        return new Builder(f.b.f, string, (boolean)var1_1);
    }

    @NonNull
    public static Builder identityMapping(@Nullable String newUrl) {
        return DomainMapping.identityMapping(newUrl, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Builder identityMapping(@Nullable String newUrl, boolean overridesSubdirectory) {
        void var1_1;
        String string;
        return new Builder(f.b.c, string, (boolean)var1_1);
    }

    @NonNull
    public static Builder audienceMapping(@Nullable String newUrl) {
        return DomainMapping.audienceMapping(newUrl, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Builder audienceMapping(@Nullable String newUrl, boolean overridesSubdirectory) {
        void var1_1;
        String string;
        return new Builder(f.b.e, string, (boolean)var1_1);
    }

    static Builder withEndpoint(f.b endpoint) {
        f.b b2;
        return new Builder(b2);
    }

    static Builder withDomainMapping(String jsonObject) {
        return Builder.withJson(jsonObject);
    }

    f.b getType() {
        return this.mType;
    }

    @Nullable
    public String getUrl() {
        return this.mUrl;
    }

    /*
     * WARNING - void declaration
     */
    void setUrl(String url) {
        void var1_1;
        this.mUrl = var1_1;
    }

    @NonNull
    public List<Certificate> getCertificates() {
        return new LinkedList<Certificate>(this.mCertificates);
    }

    /*
     * WARNING - void declaration
     */
    void setCertificates(List<Certificate> certificates) {
        Object object;
        if (MPUtility.isEmpty(certificates)) {
            ArrayList arrayList;
            DomainMapping domainMapping = object;
            object = arrayList;
            arrayList = new ArrayList();
            domainMapping.mCertificates = object;
        } else {
            void var1_1;
            ArrayList arrayList;
            DomainMapping domainMapping = object;
            object = arrayList;
            arrayList = new ArrayList(var1_1);
            domainMapping.mCertificates = object;
        }
    }

    public boolean isOverridesSubdirectory() {
        return this.overridesSubdirectory;
    }

    boolean isEventsOnly() {
        return this.eventsOnly;
    }

    @NonNull
    public String toString() {
        return this.toJson().toString();
    }

    JSONObject toJson() {
        JSONObject jSONObject;
        JSONArray jSONArray;
        JSONObject jSONObject2;
        block11: {
            JSONArray jSONArray2;
            JSONObject jSONObject3;
            jSONObject2 = jSONObject3;
            jSONArray = jSONArray2;
            jSONArray2 = new JSONArray();
            new JSONObject().put("mCertificates", (Object)jSONArray);
            if (((DomainMapping)((Object)this_)).mCertificates == null) break block11;
            Iterator<Certificate> iterator = ((DomainMapping)((Object)this_)).mCertificates.iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                jSONArray.put((Object)iterator.next().toJson());
            }
        }
        try {
            jSONObject = new JSONObject();
        }
        catch (JSONException jSONException) {
            Logger.error(jSONException, new String[0]);
            return jSONObject2;
        }
        JSONObject jSONObject4 = jSONObject.put("mType", ((DomainMapping)((Object)this_)).mType.a);
        DomainMapping domainMapping = this_;
        String this_ = "url";
        return jSONObject4.put(this_, (Object)domainMapping.mUrl).put("mCertificates", (Object)jSONArray);
    }

    public static class Builder {
        f.b type;
        String newUrl;
        List<Certificate> certificates;
        boolean overridesSubdirectory;
        boolean eventsOnly;

        /*
         * WARNING - void declaration
         */
        private Builder(f.b type) {
            void var1_1;
            this.certificates = new LinkedList<Certificate>();
            this.overridesSubdirectory = false;
            this.type = var1_1;
            this.newUrl = h.a((f.b)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private Builder(f.b type, String newUrl) {
            void var2_2;
            void var1_1;
            LinkedList linkedList;
            LinkedList this_ = linkedList;
            linkedList = new LinkedList();
            v1.certificates = this_;
            v1.overridesSubdirectory = false;
            v1.type = var1_1;
            v1.newUrl = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private Builder(f.b type, String newUrl, boolean overridesSubdirectory) {
            void var3_3;
            void var2_2;
            void var1_1;
            LinkedList linkedList;
            LinkedList this_ = linkedList;
            linkedList = new LinkedList();
            v1.certificates = this_;
            v1.overridesSubdirectory = false;
            v1.type = var1_1;
            v1.newUrl = var2_2;
            v1.overridesSubdirectory = var3_3;
        }

        private static Builder withJson(String jsonString) {
            int n2;
            JSONArray jSONArray;
            Builder builder;
            String string;
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject(string);
            JSONObject jSONObject3 = jSONObject;
            int n3 = jSONObject.getInt("mType");
            String string2 = jSONObject3.getString("url");
            Builder builder2 = builder;
            try {
                builder = new Builder(f.b.a(n3), string2);
                jSONArray = jSONObject2.getJSONArray("mCertificates");
                n2 = 0;
            }
            catch (JSONException jSONException) {
                Logger.error(jSONException, new String[0]);
                return null;
            }
            while (true) {
                if (n2 >= jSONArray.length()) break;
                builder2.addCertificate(Certificate.withCertificate(jSONArray.getJSONObject(n2)));
                ++n2;
            }
            return builder2;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addCertificate(@NonNull Certificate certificate) {
            void var1_1;
            return this.addCertificate((Certificate)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addCertificate(@NonNull String alias, @NonNull String certificate) {
            void var2_2;
            Certificate certificate2 = Certificate.with(alias, (String)var2_2);
            if (certificate2 != null) {
                this.certificates.add(certificate2);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addCertificate(@NonNull Certificate certificate, @Nullable Integer position) {
            String string;
            block8: {
                block7: {
                    block6: {
                        void var2_2;
                        if (certificate == null) break block6;
                        if (this.certificates == null) {
                            LinkedList<Certificate> linkedList;
                            LinkedList<Certificate> linkedList2 = linkedList;
                            linkedList = new LinkedList<Certificate>();
                            this.certificates = linkedList2;
                        }
                        if (var2_2 != null) {
                            this.certificates.add(var2_2.intValue(), (Certificate)((Object)string));
                        } else {
                            this.certificates.add((Certificate)((Object)string));
                        }
                        break block7;
                    }
                    string = "NetworkOptions issue: Certificate is null, cannot be added.";
                    if (MPUtility.isDevEnv()) break block8;
                    Logger.error(string);
                }
                return this;
            }
            throw new IllegalArgumentException(string);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addCertificate(@NonNull String alias, @NonNull String certificate, @Nullable Integer position) {
            void var3_3;
            void var2_2;
            void var1_1;
            Builder builder = this;
            builder.addCertificate(Certificate.with((String)var1_1, (String)var2_2), (Integer)var3_3);
            return builder;
        }

        @NonNull
        public Builder setCertificates(@Nullable List<Certificate> certificates) {
            ArrayList<Certificate> arrayList;
            ArrayList<Certificate> arrayList2 = arrayList;
            arrayList = new ArrayList<Certificate>();
            this.certificates = arrayList2;
            for (Certificate certificate : certificates) {
                if (certificate == null) continue;
                this.addCertificate(certificate);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder setEventsOnly(boolean eventsOnly) {
            void var1_1;
            this.eventsOnly = var1_1;
            return this;
        }

        @NonNull
        public DomainMapping build() {
            return new DomainMapping(this);
        }
    }
}

