/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.networking;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.internal.Logger;
import com.mparticle.internal.MPUtility;
import com.mparticle.networking.DomainMapping;
import com.mparticle.networking.f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkOptions {
    Map<f.b, DomainMapping> domainMappings;
    boolean pinningDisabledInDevelopment;

    private NetworkOptions() {
        HashMap hashMap;
        HashMap this_ = hashMap;
        hashMap = new HashMap();
        v1.domainMappings = this_;
        v1.pinningDisabledInDevelopment = false;
    }

    /*
     * WARNING - void declaration
     */
    private NetworkOptions(Builder builder) {
        void var1_1;
        this.domainMappings = new HashMap<f.b, DomainMapping>();
        this.pinningDisabledInDevelopment = false;
        if (builder.domainMappings != null) {
            this.domainMappings = ((Builder)var1_1).domainMappings;
        }
        if (((Builder)var1_1).pinningDisabledInDevelopment != null) {
            this.pinningDisabledInDevelopment = ((Builder)var1_1).pinningDisabledInDevelopment;
        }
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static NetworkOptions withNetworkOptions(@Nullable String jsonString) {
        int n2;
        String string;
        Builder builder;
        if (MPUtility.isEmpty(jsonString)) {
            return null;
        }
        Builder builder2 = builder;
        builder = new Builder();
        JSONObject jSONObject = new JSONObject(string);
        builder2.setPinningDisabledInDevelopment(jSONObject.optBoolean("disableDevPinning", false));
        try {
            string = jSONObject.getJSONArray("domainMappings");
            n2 = 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (true) {
            if (n2 >= string.length()) return builder2.build();
            builder2.addDomainMapping(DomainMapping.withDomainMapping(string.getString(n2)).build());
            ++n2;
        }
        return builder2.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject toJson() {
        JSONArray jSONArray;
        JSONObject jSONObject;
        NetworkOptions networkOptions = this_;
        JSONObject jSONObject2 = jSONObject;
        NetworkOptions networkOptions2 = this_;
        jSONObject2();
        NetworkOptions this_ = jSONArray;
        jSONArray = new JSONArray();
        Object object = "disableDevPinning";
        jSONObject.put((String)object, networkOptions2.pinningDisabledInDevelopment);
        jSONObject.put("domainMappings", (Object)this_);
        try {
            object = networkOptions.domainMappings.values().iterator();
        }
        catch (JSONException jSONException) {
            Logger.error(jSONException, new String[0]);
        }
        while (true) {
            if (!object.hasNext()) return jSONObject2;
            this_.put(((DomainMapping)object.next()).toString());
        }
        return jSONObject2;
    }

    @Nullable
    public DomainMapping getConfigDomain() {
        return this.domainMappings.get((Object)f.b.b);
    }

    @Nullable
    public DomainMapping getEventsDomain() {
        return this.domainMappings.get((Object)f.b.d);
    }

    @Nullable
    public DomainMapping getIdentityDomain() {
        return this.domainMappings.get((Object)f.b.c);
    }

    @Nullable
    public DomainMapping getAliasDomain() {
        return this.domainMappings.get((Object)f.b.f);
    }

    @NonNull
    public List<DomainMapping> getDomainMappings() {
        return new ArrayList<DomainMapping>(this.domainMappings.values());
    }

    public boolean isPinningDisabledInDevelopment() {
        return this.pinningDisabledInDevelopment;
    }

    /*
     * WARNING - void declaration
     */
    DomainMapping getDomain(f.b endpoint) {
        void var1_1;
        return this.domainMappings.get(var1_1);
    }

    @NonNull
    public String toString() {
        return this.toJson().toString();
    }

    public static class Builder {
        private Map<f.b, DomainMapping> domainMappings;
        private Boolean pinningDisabledInDevelopment;

        private Builder() {
            HashMap hashMap;
            HashMap this_ = hashMap;
            hashMap = new HashMap();
            v1.domainMappings = this_;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addDomainMapping(@Nullable DomainMapping domain) {
            void var1_1;
            if (this.domainMappings == null) {
                HashMap<f.b, DomainMapping> hashMap;
                HashMap<f.b, DomainMapping> hashMap2 = hashMap;
                hashMap = new HashMap<f.b, DomainMapping>();
                this.domainMappings = hashMap2;
            }
            if (this.domainMappings.containsKey((Object)var1_1.getType())) {
                String[] stringArray = new String[1];
                try {
                    stringArray[0] = "Duplicate DomainMapping submitted, DomainMapping:\n" + var1_1.toJson().toString(4) + "\n will overwrite DomainMapping:\n" + var1_1.toJson().toString(4);
                    Logger.warning(stringArray);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (var1_1.getType() == f.b.d && !var1_1.isEventsOnly() && !this.domainMappings.containsKey((Object)f.b.f)) {
                this.domainMappings.put(f.b.f, (DomainMapping)var1_1);
            }
            Builder builder = this;
            builder.domainMappings.put(var1_1.getType(), (DomainMapping)var1_1);
            return builder;
        }

        @NonNull
        public Builder setDomainMappings(@Nullable List<DomainMapping> domainMappingsList) {
            Iterator iterator;
            if (domainMappingsList == null) {
                HashMap hashMap;
                Builder builder = hashMap2;
                HashMap hashMap2 = hashMap;
                hashMap = new HashMap();
                builder.domainMappings = hashMap2;
                return builder;
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((Builder)((Object)hashMap2)).addDomainMapping((DomainMapping)iterator.next());
            }
            return hashMap2;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPinningDisabledInDevelopment(boolean disabledInDevelopment) {
            void var1_1;
            this.pinningDisabledInDevelopment = (boolean)var1_1;
            return this;
        }

        @NonNull
        public NetworkOptions build() {
            return new NetworkOptions(this);
        }
    }
}

