/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

public class MutableInteger {
    private int value;
    private Integer cachedIntegerValue = null;

    public MutableInteger(int n) {
        this.value = n;
    }

    public int intValue() {
        return this.value;
    }

    public Integer integerValue() {
        if (this.cachedIntegerValue == null) {
            this.cachedIntegerValue = this.intValue();
        }
        return this.cachedIntegerValue;
    }

    public boolean equals(Object object) {
        return object instanceof MutableInteger && ((MutableInteger)object).value == this.value;
    }

    public int hashCode() {
        return this.integerValue().hashCode();
    }

    public void setValue(int n) {
        this.value = n;
        this.cachedIntegerValue = null;
    }

    public void increment() {
        this.add(1);
    }

    public void add(int n) {
        this.setValue(this.value + n);
    }

    public void decrement() {
        this.subtract(1);
    }

    public void subtract(int n) {
        this.add(n * -1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

