/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

public strictfp final class R1Interval {
    private final double lo;
    private final double hi;

    public R1Interval(double d, double d2) {
        this.lo = d;
        this.hi = d2;
    }

    public static R1Interval empty() {
        return new R1Interval(1.0, 0.0);
    }

    public static R1Interval fromPoint(double d) {
        return new R1Interval(d, d);
    }

    public static R1Interval fromPointPair(double d, double d2) {
        if (d <= d2) {
            return new R1Interval(d, d2);
        }
        return new R1Interval(d2, d);
    }

    public double lo() {
        return this.lo;
    }

    public double hi() {
        return this.hi;
    }

    public boolean isEmpty() {
        return this.lo() > this.hi();
    }

    public double getCenter() {
        return 0.5 * (this.lo() + this.hi());
    }

    public double getLength() {
        return this.hi() - this.lo();
    }

    public boolean contains(double d) {
        return d >= this.lo() && d <= this.hi();
    }

    public boolean interiorContains(double d) {
        return d > this.lo() && d < this.hi();
    }

    public boolean contains(R1Interval r1Interval) {
        if (r1Interval.isEmpty()) {
            return true;
        }
        return r1Interval.lo() >= this.lo() && r1Interval.hi() <= this.hi();
    }

    public boolean interiorContains(R1Interval r1Interval) {
        if (r1Interval.isEmpty()) {
            return true;
        }
        return r1Interval.lo() > this.lo() && r1Interval.hi() < this.hi();
    }

    public boolean intersects(R1Interval r1Interval) {
        if (this.lo() <= r1Interval.lo()) {
            return r1Interval.lo() <= this.hi() && r1Interval.lo() <= r1Interval.hi();
        }
        return this.lo() <= r1Interval.hi() && this.lo() <= this.hi();
    }

    public boolean interiorIntersects(R1Interval r1Interval) {
        return r1Interval.lo() < this.hi() && this.lo() < r1Interval.hi() && this.lo() < this.hi() && r1Interval.lo() <= r1Interval.hi();
    }

    public R1Interval addPoint(double d) {
        if (this.isEmpty()) {
            return R1Interval.fromPoint(d);
        }
        if (d < this.lo()) {
            return new R1Interval(d, this.hi());
        }
        if (d > this.hi()) {
            return new R1Interval(this.lo(), d);
        }
        return new R1Interval(this.lo(), this.hi());
    }

    public R1Interval expanded(double d) {
        if (this.isEmpty()) {
            return this;
        }
        return new R1Interval(this.lo() - d, this.hi() + d);
    }

    public R1Interval union(R1Interval r1Interval) {
        if (this.isEmpty()) {
            return r1Interval;
        }
        if (r1Interval.isEmpty()) {
            return this;
        }
        return new R1Interval(Math.min(this.lo(), r1Interval.lo()), Math.max(this.hi(), r1Interval.hi()));
    }

    public R1Interval intersection(R1Interval r1Interval) {
        return new R1Interval(Math.max(this.lo(), r1Interval.lo()), Math.min(this.hi(), r1Interval.hi()));
    }

    public boolean equals(Object object) {
        if (object instanceof R1Interval) {
            R1Interval r1Interval = (R1Interval)object;
            return this.lo() == r1Interval.lo() && this.hi() == r1Interval.hi() || this.isEmpty() && r1Interval.isEmpty();
        }
        return false;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 17;
        }
        long l = 17L;
        l = 37L * l + Double.doubleToLongBits(this.lo);
        l = 37L * l + Double.doubleToLongBits(this.hi);
        return (int)(l ^ l >>> 32);
    }

    public boolean approxEquals(R1Interval r1Interval) {
        return this.approxEquals(r1Interval, 1.0E-15);
    }

    public boolean approxEquals(R1Interval r1Interval, double d) {
        if (this.isEmpty()) {
            return r1Interval.getLength() <= d;
        }
        if (r1Interval.isEmpty()) {
            return this.getLength() <= d;
        }
        return Math.abs(r1Interval.lo() - this.lo()) + Math.abs(r1Interval.hi() - this.hi()) <= d;
    }

    public String toString() {
        return "[" + this.lo() + ", " + this.hi() + "]";
    }
}

