/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

public strictfp final class R2Vector {
    private final double x;
    private final double y;

    public R2Vector() {
        this(0.0, 0.0);
    }

    public R2Vector(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public R2Vector(double[] dArray) {
        if (dArray.length != 2) {
            throw new IllegalStateException("Points must have exactly 2 coordinates");
        }
        this.x = dArray[0];
        this.y = dArray[1];
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double get(int n) {
        if (n > 1) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return n == 0 ? this.x : this.y;
    }

    public static R2Vector add(R2Vector r2Vector, R2Vector r2Vector2) {
        return new R2Vector(r2Vector.x + r2Vector2.x, r2Vector.y + r2Vector2.y);
    }

    public static R2Vector mul(R2Vector r2Vector, double d) {
        return new R2Vector(d * r2Vector.x, d * r2Vector.y);
    }

    public double norm2() {
        return this.x * this.x + this.y * this.y;
    }

    public static double dotProd(R2Vector r2Vector, R2Vector r2Vector2) {
        return r2Vector.x * r2Vector2.x + r2Vector.y * r2Vector2.y;
    }

    public double dotProd(R2Vector r2Vector) {
        return R2Vector.dotProd(this, r2Vector);
    }

    public double crossProd(R2Vector r2Vector) {
        return this.x * r2Vector.y - this.y * r2Vector.x;
    }

    public boolean lessThan(R2Vector r2Vector) {
        if (this.x < r2Vector.x) {
            return true;
        }
        if (r2Vector.x < this.x) {
            return false;
        }
        return this.y < r2Vector.y;
    }

    public boolean equals(Object object) {
        if (!(object instanceof R2Vector)) {
            return false;
        }
        R2Vector r2Vector = (R2Vector)object;
        return this.x == r2Vector.x && this.y == r2Vector.y;
    }

    public int hashCode() {
        long l = 17L;
        l += 37L * l + Double.doubleToLongBits(Math.abs(this.x));
        l += 37L * l + Double.doubleToLongBits(Math.abs(this.y));
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

