/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S2Point;

public strictfp final class S1Angle
implements Comparable<S1Angle> {
    private final double radians;

    public double radians() {
        return this.radians;
    }

    public double degrees() {
        return this.radians * 57.29577951308232;
    }

    public long e5() {
        return Math.round(this.degrees() * 100000.0);
    }

    public long e6() {
        return Math.round(this.degrees() * 1000000.0);
    }

    public long e7() {
        return Math.round(this.degrees() * 1.0E7);
    }

    public S1Angle() {
        this.radians = 0.0;
    }

    private S1Angle(double d) {
        this.radians = d;
    }

    public S1Angle(S2Point s2Point, S2Point s2Point2) {
        this.radians = s2Point.angle(s2Point2);
    }

    public boolean equals(Object object) {
        if (object instanceof S1Angle) {
            return this.radians() == ((S1Angle)object).radians();
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.radians);
        return (int)(l ^ l >>> 32);
    }

    public boolean lessThan(S1Angle s1Angle) {
        return this.radians() < s1Angle.radians();
    }

    public boolean greaterThan(S1Angle s1Angle) {
        return this.radians() > s1Angle.radians();
    }

    public boolean lessOrEquals(S1Angle s1Angle) {
        return this.radians() <= s1Angle.radians();
    }

    public boolean greaterOrEquals(S1Angle s1Angle) {
        return this.radians() >= s1Angle.radians();
    }

    public static S1Angle max(S1Angle s1Angle, S1Angle s1Angle2) {
        return s1Angle2.greaterThan(s1Angle) ? s1Angle2 : s1Angle;
    }

    public static S1Angle min(S1Angle s1Angle, S1Angle s1Angle2) {
        return s1Angle2.greaterThan(s1Angle) ? s1Angle : s1Angle2;
    }

    public static S1Angle radians(double d) {
        return new S1Angle(d);
    }

    public static S1Angle degrees(double d) {
        return new S1Angle(d * (Math.PI / 180));
    }

    public static S1Angle e5(long l) {
        return S1Angle.degrees((double)l * 1.0E-5);
    }

    public static S1Angle e6(long l) {
        return S1Angle.degrees((double)l * 1.0E-6);
    }

    public static S1Angle e7(long l) {
        return S1Angle.degrees((double)l * 1.0E-7);
    }

    public String toString() {
        return this.degrees() + "d";
    }

    @Override
    public int compareTo(S1Angle s1Angle) {
        return this.radians < s1Angle.radians ? -1 : (this.radians > s1Angle.radians ? 1 : 0);
    }
}

