/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

public strictfp final class S1Interval
implements Cloneable {
    private final double lo;
    private final double hi;

    public S1Interval(double d, double d2) {
        this(d, d2, false);
    }

    public S1Interval(S1Interval s1Interval) {
        this.lo = s1Interval.lo;
        this.hi = s1Interval.hi;
    }

    private S1Interval(double d, double d2, boolean bl) {
        double d3 = d;
        double d4 = d2;
        if (!bl) {
            if (d == -Math.PI && d2 != Math.PI) {
                d3 = Math.PI;
            }
            if (d2 == -Math.PI && d != Math.PI) {
                d4 = Math.PI;
            }
        }
        this.lo = d3;
        this.hi = d4;
    }

    public static S1Interval empty() {
        return new S1Interval(Math.PI, -Math.PI, true);
    }

    public static S1Interval full() {
        return new S1Interval(-Math.PI, Math.PI, true);
    }

    public static S1Interval fromPoint(double d) {
        if (d == -Math.PI) {
            d = Math.PI;
        }
        return new S1Interval(d, d, true);
    }

    public static S1Interval fromPointPair(double d, double d2) {
        if (d == -Math.PI) {
            d = Math.PI;
        }
        if (d2 == -Math.PI) {
            d2 = Math.PI;
        }
        if (S1Interval.positiveDistance(d, d2) <= Math.PI) {
            return new S1Interval(d, d2, true);
        }
        return new S1Interval(d2, d, true);
    }

    public double lo() {
        return this.lo;
    }

    public double hi() {
        return this.hi;
    }

    public boolean isValid() {
        return Math.abs(this.lo()) <= Math.PI && Math.abs(this.hi()) <= Math.PI && (this.lo() != -Math.PI || this.hi() == Math.PI) && (this.hi() != -Math.PI || this.lo() == Math.PI);
    }

    public boolean isFull() {
        return this.hi() - this.lo() == Math.PI * 2;
    }

    public boolean isEmpty() {
        return this.lo() - this.hi() == Math.PI * 2;
    }

    public boolean isInverted() {
        return this.lo() > this.hi();
    }

    public double getCenter() {
        double d = 0.5 * (this.lo() + this.hi());
        if (!this.isInverted()) {
            return d;
        }
        return d <= 0.0 ? d + Math.PI : d - Math.PI;
    }

    public double getLength() {
        double d = this.hi() - this.lo();
        if (d >= 0.0) {
            return d;
        }
        return (d += Math.PI * 2) > 0.0 ? d : -1.0;
    }

    public S1Interval complement() {
        if (this.lo() == this.hi()) {
            return S1Interval.full();
        }
        return new S1Interval(this.hi(), this.lo(), true);
    }

    public boolean contains(double d) {
        if (d == -Math.PI) {
            d = Math.PI;
        }
        return this.fastContains(d);
    }

    public boolean fastContains(double d) {
        if (this.isInverted()) {
            return (d >= this.lo() || d <= this.hi()) && !this.isEmpty();
        }
        return d >= this.lo() && d <= this.hi();
    }

    public boolean interiorContains(double d) {
        if (d == -Math.PI) {
            d = Math.PI;
        }
        if (this.isInverted()) {
            return d > this.lo() || d < this.hi();
        }
        return d > this.lo() && d < this.hi() || this.isFull();
    }

    public boolean contains(S1Interval s1Interval) {
        if (this.isInverted()) {
            if (s1Interval.isInverted()) {
                return s1Interval.lo() >= this.lo() && s1Interval.hi() <= this.hi();
            }
            return (s1Interval.lo() >= this.lo() || s1Interval.hi() <= this.hi()) && !this.isEmpty();
        }
        if (s1Interval.isInverted()) {
            return this.isFull() || s1Interval.isEmpty();
        }
        return s1Interval.lo() >= this.lo() && s1Interval.hi() <= this.hi();
    }

    public boolean interiorContains(S1Interval s1Interval) {
        if (this.isInverted()) {
            if (!s1Interval.isInverted()) {
                return s1Interval.lo() > this.lo() || s1Interval.hi() < this.hi();
            }
            return s1Interval.lo() > this.lo() && s1Interval.hi() < this.hi() || s1Interval.isEmpty();
        }
        if (s1Interval.isInverted()) {
            return this.isFull() || s1Interval.isEmpty();
        }
        return s1Interval.lo() > this.lo() && s1Interval.hi() < this.hi() || this.isFull();
    }

    public boolean intersects(S1Interval s1Interval) {
        if (this.isEmpty() || s1Interval.isEmpty()) {
            return false;
        }
        if (this.isInverted()) {
            return s1Interval.isInverted() || s1Interval.lo() <= this.hi() || s1Interval.hi() >= this.lo();
        }
        if (s1Interval.isInverted()) {
            return s1Interval.lo() <= this.hi() || s1Interval.hi() >= this.lo();
        }
        return s1Interval.lo() <= this.hi() && s1Interval.hi() >= this.lo();
    }

    public boolean interiorIntersects(S1Interval s1Interval) {
        if (this.isEmpty() || s1Interval.isEmpty() || this.lo() == this.hi()) {
            return false;
        }
        if (this.isInverted()) {
            return s1Interval.isInverted() || s1Interval.lo() < this.hi() || s1Interval.hi() > this.lo();
        }
        if (s1Interval.isInverted()) {
            return s1Interval.lo() < this.hi() || s1Interval.hi() > this.lo();
        }
        return s1Interval.lo() < this.hi() && s1Interval.hi() > this.lo() || this.isFull();
    }

    public S1Interval addPoint(double d) {
        double d2;
        if (d == -Math.PI) {
            d = Math.PI;
        }
        if (this.fastContains(d)) {
            return new S1Interval(this);
        }
        if (this.isEmpty()) {
            return S1Interval.fromPoint(d);
        }
        double d3 = S1Interval.positiveDistance(d, this.lo());
        if (d3 < (d2 = S1Interval.positiveDistance(this.hi(), d))) {
            return new S1Interval(d, this.hi());
        }
        return new S1Interval(this.lo(), d);
    }

    public S1Interval expanded(double d) {
        if (this.isEmpty()) {
            return this;
        }
        if (this.getLength() + 2.0 * d >= 6.283185307179585) {
            return S1Interval.full();
        }
        double d2 = Math.IEEEremainder(this.lo() - d, Math.PI * 2);
        double d3 = Math.IEEEremainder(this.hi() + d, Math.PI * 2);
        if (d2 == -Math.PI) {
            d2 = Math.PI;
        }
        return new S1Interval(d2, d3);
    }

    public S1Interval union(S1Interval s1Interval) {
        double d;
        if (s1Interval.isEmpty()) {
            return this;
        }
        if (this.fastContains(s1Interval.lo())) {
            if (this.fastContains(s1Interval.hi())) {
                if (this.contains(s1Interval)) {
                    return this;
                }
                return S1Interval.full();
            }
            return new S1Interval(this.lo(), s1Interval.hi(), true);
        }
        if (this.fastContains(s1Interval.hi())) {
            return new S1Interval(s1Interval.lo(), this.hi(), true);
        }
        if (this.isEmpty() || s1Interval.fastContains(this.lo())) {
            return s1Interval;
        }
        double d2 = S1Interval.positiveDistance(s1Interval.hi(), this.lo());
        if (d2 < (d = S1Interval.positiveDistance(this.hi(), s1Interval.lo()))) {
            return new S1Interval(s1Interval.lo(), this.hi(), true);
        }
        return new S1Interval(this.lo(), s1Interval.hi(), true);
    }

    public S1Interval intersection(S1Interval s1Interval) {
        if (s1Interval.isEmpty()) {
            return S1Interval.empty();
        }
        if (this.fastContains(s1Interval.lo())) {
            if (this.fastContains(s1Interval.hi())) {
                if (s1Interval.getLength() < this.getLength()) {
                    return s1Interval;
                }
                return this;
            }
            return new S1Interval(s1Interval.lo(), this.hi(), true);
        }
        if (this.fastContains(s1Interval.hi())) {
            return new S1Interval(this.lo(), s1Interval.hi(), true);
        }
        if (s1Interval.fastContains(this.lo())) {
            return this;
        }
        return S1Interval.empty();
    }

    public boolean approxEquals(S1Interval s1Interval, double d) {
        if (this.isEmpty()) {
            return s1Interval.getLength() <= d;
        }
        if (s1Interval.isEmpty()) {
            return this.getLength() <= d;
        }
        return Math.abs(Math.IEEEremainder(s1Interval.lo() - this.lo(), Math.PI * 2)) + Math.abs(Math.IEEEremainder(s1Interval.hi() - this.hi(), Math.PI * 2)) <= d;
    }

    public boolean approxEquals(S1Interval s1Interval) {
        return this.approxEquals(s1Interval, 1.0E-9);
    }

    public boolean equals(Object object) {
        if (object instanceof S1Interval) {
            S1Interval s1Interval = (S1Interval)object;
            return this.lo() == s1Interval.lo() && this.hi() == s1Interval.hi();
        }
        return false;
    }

    public int hashCode() {
        long l = 17L;
        l = 37L * l + Double.doubleToLongBits(this.lo());
        l = 37L * l + Double.doubleToLongBits(this.hi());
        return (int)(l >>> 32 ^ l);
    }

    public String toString() {
        return "[" + this.lo() + ", " + this.hi() + "]";
    }

    public static double positiveDistance(double d, double d2) {
        double d3 = d2 - d;
        if (d3 >= 0.0) {
            return d3;
        }
        return d2 + Math.PI - (d - Math.PI);
    }
}

