/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.geometry.R2Vector;
import com.google.common.geometry.S2Point;

public strictfp final class S2 {
    public static final double M_PI = Math.PI;
    public static final double M_1_PI = 0.3183098861837907;
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_PI_4 = 0.7853981633974483;
    public static final double M_SQRT2 = Math.sqrt(2.0);
    public static final double M_E = Math.E;
    public static final int SWAP_MASK = 1;
    public static final int INVERT_MASK = 2;
    private static final int EXPONENT_SHIFT = 52;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final int[] POS_TO_ORIENTATION = new int[]{1, 0, 0, 3};
    private static final int[][] POS_TO_IJ = new int[][]{{0, 1, 3, 2}, {0, 2, 3, 1}, {3, 2, 0, 1}, {3, 1, 0, 2}};
    private static final int[][] IJ_TO_POS = new int[][]{{0, 1, 3, 2}, {0, 3, 1, 2}, {2, 3, 1, 0}, {2, 1, 3, 0}};

    @VisibleForTesting
    static int exp(double d) {
        if (d == 0.0) {
            return 0;
        }
        long l = Double.doubleToLongBits(d);
        return (int)((0x7FF0000000000000L & l) >> 52) - 1022;
    }

    public static int posToOrientation(int n) {
        Preconditions.checkArgument((0 <= n && n < 4 ? 1 : 0) != 0);
        return POS_TO_ORIENTATION[n];
    }

    public static int posToIJ(int n, int n2) {
        Preconditions.checkArgument((0 <= n && n < 4 ? 1 : 0) != 0);
        Preconditions.checkArgument((0 <= n2 && n2 < 4 ? 1 : 0) != 0);
        return POS_TO_IJ[n][n2];
    }

    public static final int ijToPos(int n, int n2) {
        Preconditions.checkArgument((0 <= n && n < 4 ? 1 : 0) != 0);
        Preconditions.checkArgument((0 <= n2 && n2 < 4 ? 1 : 0) != 0);
        return IJ_TO_POS[n][n2];
    }

    public static S2Point origin() {
        return new S2Point(0.0, 1.0, 0.0);
    }

    public static boolean isUnitLength(S2Point s2Point) {
        return Math.abs(s2Point.norm2() - 1.0) <= 1.0E-15;
    }

    public static boolean simpleCrossing(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        S2Point s2Point5 = S2Point.crossProd(s2Point, s2Point2);
        S2Point s2Point6 = S2Point.crossProd(s2Point3, s2Point4);
        double d = -s2Point5.dotProd(s2Point3);
        double d2 = -s2Point6.dotProd(s2Point2);
        double d3 = s2Point5.dotProd(s2Point4);
        double d4 = s2Point6.dotProd(s2Point);
        return d * d2 > 0.0 && d2 * d3 > 0.0 && d3 * d4 > 0.0;
    }

    public static S2Point robustCrossProd(S2Point s2Point, S2Point s2Point2) {
        S2Point s2Point3 = S2Point.crossProd(S2Point.add(s2Point2, s2Point), S2Point.sub(s2Point2, s2Point));
        if (!s2Point3.equals(new S2Point(0.0, 0.0, 0.0))) {
            return s2Point3;
        }
        return S2.ortho(s2Point);
    }

    public static S2Point ortho(S2Point s2Point) {
        return s2Point.ortho();
    }

    static double area(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        double d;
        double d2;
        double d3 = s2Point2.angle(s2Point3);
        double d4 = 0.5 * (d3 + (d2 = s2Point3.angle(s2Point)) + (d = s2Point.angle(s2Point2)));
        if (d4 >= 3.0E-4) {
            double d5;
            double d6 = d4 * d4;
            double d7 = d4 - Math.max(d3, Math.max(d2, d));
            if (d7 < 0.01 * d4 * d6 * d6 && d7 < d4 * (0.1 * (d5 = S2.girardArea(s2Point, s2Point2, s2Point3)))) {
                return d5;
            }
        }
        return 4.0 * Math.atan(Math.sqrt(Math.max(0.0, Math.tan(0.5 * d4) * Math.tan(0.5 * (d4 - d3)) * Math.tan(0.5 * (d4 - d2)) * Math.tan(0.5 * (d4 - d)))));
    }

    public static double girardArea(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        S2Point s2Point4 = S2Point.crossProd(s2Point, s2Point2);
        S2Point s2Point5 = S2Point.crossProd(s2Point2, s2Point3);
        S2Point s2Point6 = S2Point.crossProd(s2Point, s2Point3);
        return Math.max(0.0, s2Point4.angle(s2Point6) - s2Point4.angle(s2Point5) + s2Point5.angle(s2Point6));
    }

    public static double signedArea(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        return S2.area(s2Point, s2Point2, s2Point3) * (double)S2.robustCCW(s2Point, s2Point2, s2Point3);
    }

    public static S2Point planarCentroid(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        return new S2Point((s2Point.x + s2Point2.x + s2Point3.x) / 3.0, (s2Point.y + s2Point2.y + s2Point3.y) / 3.0, (s2Point.z + s2Point2.z + s2Point3.z) / 3.0);
    }

    public static S2Point trueCentroid(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        double d = S2Point.crossProd(s2Point2, s2Point3).norm();
        double d2 = S2Point.crossProd(s2Point3, s2Point).norm();
        double d3 = S2Point.crossProd(s2Point, s2Point2).norm();
        double d4 = d == 0.0 ? 1.0 : Math.asin(d) / d;
        double d5 = d2 == 0.0 ? 1.0 : Math.asin(d2) / d2;
        double d6 = d3 == 0.0 ? 1.0 : Math.asin(d3) / d3;
        S2Point s2Point4 = new S2Point(s2Point.x, s2Point2.x, s2Point3.x);
        S2Point s2Point5 = new S2Point(s2Point.y, s2Point2.y, s2Point3.y);
        S2Point s2Point6 = new S2Point(s2Point.z, s2Point2.z, s2Point3.z);
        S2Point s2Point7 = new S2Point(d4, d5, d6);
        return new S2Point(0.5 * S2Point.crossProd(s2Point5, s2Point6).dotProd(s2Point7), 0.5 * S2Point.crossProd(s2Point6, s2Point4).dotProd(s2Point7), 0.5 * S2Point.crossProd(s2Point4, s2Point5).dotProd(s2Point7));
    }

    public static boolean simpleCCW(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        return S2Point.crossProd(s2Point3, s2Point).dotProd(s2Point2) > 0.0;
    }

    public static int robustCCW(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        return S2.robustCCW(s2Point, s2Point2, s2Point3, S2Point.crossProd(s2Point, s2Point2));
    }

    public static int robustCCW(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        double d = s2Point4.dotProd(s2Point3);
        if (d > 1.6E-15) {
            return 1;
        }
        if (d < -1.6E-15) {
            return -1;
        }
        return S2.expensiveCCW(s2Point, s2Point2, s2Point3);
    }

    private static int expensiveCCW(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        if (s2Point.equals(s2Point2) || s2Point2.equals(s2Point3) || s2Point3.equals(s2Point)) {
            return 0;
        }
        double d = s2Point.dotProd(s2Point2) > 0.0 ? -1.0 : 1.0;
        double d2 = s2Point2.dotProd(s2Point3) > 0.0 ? -1.0 : 1.0;
        double d3 = s2Point3.dotProd(s2Point) > 0.0 ? -1.0 : 1.0;
        S2Point s2Point4 = S2Point.add(s2Point, S2Point.mul(s2Point2, d));
        S2Point s2Point5 = S2Point.add(s2Point2, S2Point.mul(s2Point3, d2));
        S2Point s2Point6 = S2Point.add(s2Point3, S2Point.mul(s2Point, d3));
        double d4 = s2Point4.norm2();
        double d5 = s2Point5.norm2();
        double d6 = s2Point6.norm2();
        double d7 = d6 < d5 || d6 == d5 && s2Point.lessThan(s2Point2) ? (d4 < d5 || d4 == d5 && s2Point.lessThan(s2Point3) ? S2Point.crossProd(s2Point4, s2Point6).dotProd(s2Point) * d : S2Point.crossProd(s2Point6, s2Point5).dotProd(s2Point3) * d3) : (d4 < d6 || d4 == d6 && s2Point2.lessThan(s2Point3) ? S2Point.crossProd(s2Point5, s2Point4).dotProd(s2Point2) * d2 : S2Point.crossProd(s2Point6, s2Point5).dotProd(s2Point3) * d3);
        if (d7 > 0.0) {
            return 1;
        }
        if (d7 < 0.0) {
            return -1;
        }
        int n = S2.planarOrderedCCW(new R2Vector(s2Point.y, s2Point.z), new R2Vector(s2Point2.y, s2Point2.z), new R2Vector(s2Point3.y, s2Point3.z));
        if (n == 0 && (n = S2.planarOrderedCCW(new R2Vector(s2Point.z, s2Point.x), new R2Vector(s2Point2.z, s2Point2.x), new R2Vector(s2Point3.z, s2Point3.x))) == 0) {
            n = S2.planarOrderedCCW(new R2Vector(s2Point.x, s2Point.y), new R2Vector(s2Point2.x, s2Point2.y), new R2Vector(s2Point3.x, s2Point3.y));
        }
        return n;
    }

    public static int planarCCW(R2Vector r2Vector, R2Vector r2Vector2) {
        double d;
        double d2 = r2Vector.dotProd(r2Vector2) > 0.0 ? -1.0 : 1.0;
        R2Vector r2Vector3 = R2Vector.add(r2Vector, R2Vector.mul(r2Vector2, d2));
        double d3 = r2Vector.norm2();
        double d4 = d3 < (d = r2Vector2.norm2()) || d3 == d && r2Vector.lessThan(r2Vector2) ? r2Vector.crossProd(r2Vector3) * d2 : r2Vector3.crossProd(r2Vector2);
        if (d4 > 0.0) {
            return 1;
        }
        if (d4 < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int planarOrderedCCW(R2Vector r2Vector, R2Vector r2Vector2, R2Vector r2Vector3) {
        int n = 0;
        n += S2.planarCCW(r2Vector, r2Vector2);
        n += S2.planarCCW(r2Vector2, r2Vector3);
        if ((n += S2.planarCCW(r2Vector3, r2Vector)) > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    public static boolean orderedCCW(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        int n = 0;
        if (S2.robustCCW(s2Point2, s2Point4, s2Point) >= 0) {
            ++n;
        }
        if (S2.robustCCW(s2Point3, s2Point4, s2Point2) >= 0) {
            ++n;
        }
        if (S2.robustCCW(s2Point, s2Point4, s2Point3) > 0) {
            ++n;
        }
        return n >= 2;
    }

    public static double angle(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        return S2Point.crossProd(s2Point, s2Point2).angle(S2Point.crossProd(s2Point3, s2Point2));
    }

    public static double turnAngle(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        double d = S2Point.crossProd(s2Point2, s2Point).angle(S2Point.crossProd(s2Point3, s2Point2));
        return S2.robustCCW(s2Point, s2Point2, s2Point3) > 0 ? d : -d;
    }

    public static boolean approxEquals(S2Point s2Point, S2Point s2Point2, double d) {
        return s2Point.angle(s2Point2) <= d;
    }

    public static boolean approxEquals(S2Point s2Point, S2Point s2Point2) {
        return S2.approxEquals(s2Point, s2Point2, 1.0E-15);
    }

    public static boolean approxEquals(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    public static boolean approxEquals(double d, double d2) {
        return S2.approxEquals(d, d2, 1.0E-15);
    }

    private S2() {
    }

    public strictfp static class Metric {
        private final double deriv;
        private final int dim;

        public Metric(int n, double d) {
            this.deriv = d;
            this.dim = n;
        }

        public double deriv() {
            return this.deriv;
        }

        public double getValue(int n) {
            return StrictMath.scalb(this.deriv, this.dim * (1 - n));
        }

        public int getClosestLevel(double d) {
            return this.getMinLevel(M_SQRT2 * d);
        }

        public int getMinLevel(double d) {
            if (d <= 0.0) {
                return 30;
            }
            int n = S2.exp(d / ((double)(1 << this.dim) * this.deriv));
            int n2 = Math.max(0, Math.min(30, -(n - 1 >> this.dim - 1)));
            return n2;
        }

        public int getMaxLevel(double d) {
            if (d <= 0.0) {
                return 30;
            }
            int n = S2.exp((double)(1 << this.dim) * this.deriv / d);
            int n2 = Math.max(0, Math.min(30, n - 1 >> this.dim - 1));
            return n2;
        }
    }
}

