/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.R1Interval;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S1Interval;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Region;

public strictfp final class S2Cap
implements S2Region {
    private static final double ROUND_UP = 1.0000000000000002;
    private final S2Point axis;
    private final double height;

    private S2Cap() {
        this.axis = new S2Point();
        this.height = 0.0;
    }

    private S2Cap(S2Point s2Point, double d) {
        this.axis = s2Point;
        this.height = d;
    }

    public static S2Cap fromAxisHeight(S2Point s2Point, double d) {
        return new S2Cap(s2Point, d);
    }

    public static S2Cap fromAxisAngle(S2Point s2Point, S1Angle s1Angle) {
        double d = Math.sin(0.5 * s1Angle.radians());
        return new S2Cap(s2Point, 2.0 * d * d);
    }

    public static S2Cap fromAxisArea(S2Point s2Point, double d) {
        return new S2Cap(s2Point, d / (Math.PI * 2));
    }

    public static S2Cap empty() {
        return new S2Cap(new S2Point(1.0, 0.0, 0.0), -1.0);
    }

    public static S2Cap full() {
        return new S2Cap(new S2Point(1.0, 0.0, 0.0), 2.0);
    }

    public S2Point axis() {
        return this.axis;
    }

    public double height() {
        return this.height;
    }

    public double area() {
        return Math.PI * 2 * Math.max(0.0, this.height);
    }

    public S1Angle angle() {
        if (this.isEmpty()) {
            return S1Angle.radians(-1.0);
        }
        return S1Angle.radians(2.0 * Math.asin(Math.sqrt(0.5 * this.height)));
    }

    public boolean isValid() {
        return S2.isUnitLength(this.axis) && this.height <= 2.0;
    }

    public boolean isEmpty() {
        return this.height < 0.0;
    }

    public boolean isFull() {
        return this.height >= 2.0;
    }

    public S2Cap complement() {
        double d = this.isFull() ? -1.0 : 2.0 - Math.max(this.height, 0.0);
        return S2Cap.fromAxisHeight(S2Point.neg(this.axis), d);
    }

    public boolean contains(S2Cap s2Cap) {
        if (this.isFull() || s2Cap.isEmpty()) {
            return true;
        }
        return this.angle().radians() >= this.axis.angle(s2Cap.axis) + s2Cap.angle().radians();
    }

    public boolean interiorIntersects(S2Cap s2Cap) {
        return !this.complement().contains(s2Cap);
    }

    public boolean interiorContains(S2Point s2Point) {
        return this.isFull() || S2Point.sub(this.axis, s2Point).norm2() < 2.0 * this.height;
    }

    public S2Cap addPoint(S2Point s2Point) {
        if (this.isEmpty()) {
            return new S2Cap(s2Point, 0.0);
        }
        double d = S2Point.sub(this.axis, s2Point).norm2();
        double d2 = Math.max(this.height, 0.5000000000000001 * d);
        return new S2Cap(this.axis, d2);
    }

    public S2Cap addCap(S2Cap s2Cap) {
        if (this.isEmpty()) {
            return new S2Cap(s2Cap.axis, s2Cap.height);
        }
        double d = this.axis.angle(s2Cap.axis) + s2Cap.angle().radians();
        if (d >= Math.PI) {
            return new S2Cap(this.axis, 2.0);
        }
        double d2 = Math.sin(0.5 * d);
        double d3 = Math.max(this.height, 2.0000000000000004 * d2 * d2);
        return new S2Cap(this.axis, d3);
    }

    @Override
    public S2Cap getCapBound() {
        return this;
    }

    @Override
    public S2LatLngRect getRectBound() {
        double d;
        double d2;
        if (this.isEmpty()) {
            return S2LatLngRect.empty();
        }
        S2LatLng s2LatLng = new S2LatLng(this.axis);
        double d3 = this.angle().radians();
        boolean bl = false;
        double[] dArray = new double[2];
        double[] dArray2 = new double[]{-Math.PI, Math.PI};
        dArray[0] = s2LatLng.lat().radians() - d3;
        if (dArray[0] <= -1.5707963267948966) {
            dArray[0] = -1.5707963267948966;
            bl = true;
        }
        dArray[1] = s2LatLng.lat().radians() + d3;
        if (dArray[1] >= 1.5707963267948966) {
            dArray[1] = 1.5707963267948966;
            bl = true;
        }
        if (!bl && (d2 = Math.sqrt(this.height * (2.0 - this.height))) <= (d = Math.cos(s2LatLng.lat().radians()))) {
            double d4 = Math.asin(d2 / d);
            dArray2[0] = Math.IEEEremainder(s2LatLng.lng().radians() - d4, Math.PI * 2);
            dArray2[1] = Math.IEEEremainder(s2LatLng.lng().radians() + d4, Math.PI * 2);
        }
        return new S2LatLngRect(new R1Interval(dArray[0], dArray[1]), new S1Interval(dArray2[0], dArray2[1]));
    }

    @Override
    public boolean contains(S2Cell s2Cell) {
        S2Point[] s2PointArray = new S2Point[4];
        for (int i = 0; i < 4; ++i) {
            s2PointArray[i] = s2Cell.getVertex(i);
            if (this.contains(s2PointArray[i])) continue;
            return false;
        }
        return !this.complement().intersects(s2Cell, s2PointArray);
    }

    @Override
    public boolean mayIntersect(S2Cell s2Cell) {
        S2Point[] s2PointArray = new S2Point[4];
        for (int i = 0; i < 4; ++i) {
            s2PointArray[i] = s2Cell.getVertex(i);
            if (!this.contains(s2PointArray[i])) continue;
            return true;
        }
        return this.intersects(s2Cell, s2PointArray);
    }

    public boolean intersects(S2Cell s2Cell, S2Point[] s2PointArray) {
        if (this.height >= 1.0) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (s2Cell.contains(this.axis)) {
            return true;
        }
        double d = this.height * (2.0 - this.height);
        for (int i = 0; i < 4; ++i) {
            S2Point s2Point = s2Cell.getEdgeRaw(i);
            double d2 = this.axis.dotProd(s2Point);
            if (d2 > 0.0) continue;
            if (d2 * d2 > d * s2Point.norm2()) {
                return false;
            }
            S2Point s2Point2 = S2Point.crossProd(s2Point, this.axis);
            if (!(s2Point2.dotProd(s2PointArray[i]) < 0.0) || !(s2Point2.dotProd(s2PointArray[i + 1 & 3]) > 0.0)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(S2Point s2Point) {
        return S2Point.sub(this.axis, s2Point).norm2() <= 2.0 * this.height;
    }

    public boolean equals(Object object) {
        if (!(object instanceof S2Cap)) {
            return false;
        }
        S2Cap s2Cap = (S2Cap)object;
        return this.axis.equals(s2Cap.axis) && this.height == s2Cap.height || this.isEmpty() && s2Cap.isEmpty() || this.isFull() && s2Cap.isFull();
    }

    public int hashCode() {
        if (this.isFull()) {
            return 17;
        }
        if (this.isEmpty()) {
            return 37;
        }
        int n = 17;
        n = 37 * n + this.axis.hashCode();
        long l = Double.doubleToLongBits(this.height);
        n = 37 * n + (int)(l >>> 32 ^ l);
        return n;
    }

    boolean approxEquals(S2Cap s2Cap, double d) {
        return this.axis.aequal(s2Cap.axis, d) && Math.abs(this.height - s2Cap.height) <= d || this.isEmpty() && s2Cap.height <= d || s2Cap.isEmpty() && this.height <= d || this.isFull() && s2Cap.height >= 2.0 - d || s2Cap.isFull() && this.height >= 2.0 - d;
    }

    boolean approxEquals(S2Cap s2Cap) {
        return this.approxEquals(s2Cap, 1.0E-14);
    }

    public String toString() {
        return "[Point = " + this.axis.toString() + " Height = " + this.height + "]";
    }
}

