/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.MutableInteger;
import com.google.common.geometry.R1Interval;
import com.google.common.geometry.R2Vector;
import com.google.common.geometry.S1Interval;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Projections;
import com.google.common.geometry.S2Region;

public strictfp final class S2Cell
implements S2Region {
    private static final int MAX_CELL_SIZE = 0x40000000;
    byte face;
    byte level;
    byte orientation;
    S2CellId cellId;
    double[][] uv = new double[2][2];
    private static final double MAX_ERROR = 4.440892098500626E-16;
    private static final double POLE_MIN_LAT = Math.asin(Math.sqrt(0.3333333333333333)) - 4.440892098500626E-16;

    S2Cell() {
    }

    public S2Cell(S2CellId s2CellId) {
        this.init(s2CellId);
    }

    public static S2Cell fromFacePosLevel(int n, byte by, int n2) {
        return new S2Cell(S2CellId.fromFacePosLevel(n, by, n2));
    }

    public S2Cell(S2Point s2Point) {
        this.init(S2CellId.fromPoint(s2Point));
    }

    public S2Cell(S2LatLng s2LatLng) {
        this.init(S2CellId.fromLatLng(s2LatLng));
    }

    public S2CellId id() {
        return this.cellId;
    }

    public int face() {
        return this.face;
    }

    public byte level() {
        return this.level;
    }

    public byte orientation() {
        return this.orientation;
    }

    public boolean isLeaf() {
        return this.level == 30;
    }

    public S2Point getVertex(int n) {
        return S2Point.normalize(this.getVertexRaw(n));
    }

    public S2Point getVertexRaw(int n) {
        return S2Projections.faceUvToXyz(this.face, this.uv[0][n >> 1 ^ n & 1], this.uv[1][n >> 1]);
    }

    public S2Point getEdge(int n) {
        return S2Point.normalize(this.getEdgeRaw(n));
    }

    public S2Point getEdgeRaw(int n) {
        switch (n) {
            case 0: {
                return S2Projections.getVNorm(this.face, this.uv[1][0]);
            }
            case 1: {
                return S2Projections.getUNorm(this.face, this.uv[0][1]);
            }
            case 2: {
                return S2Point.neg(S2Projections.getVNorm(this.face, this.uv[1][1]));
            }
        }
        return S2Point.neg(S2Projections.getUNorm(this.face, this.uv[0][0]));
    }

    public boolean subdivide(S2Cell[] s2CellArray) {
        if (this.cellId.isLeaf()) {
            return false;
        }
        R2Vector r2Vector = this.getCenterUV();
        S2CellId s2CellId = this.cellId.childBegin();
        int n = 0;
        while (n < 4) {
            S2Cell s2Cell = s2CellArray[n];
            s2Cell.face = this.face;
            s2Cell.level = (byte)(this.level + 1);
            s2Cell.orientation = (byte)(this.orientation ^ S2.posToOrientation(n));
            s2Cell.cellId = s2CellId;
            int n2 = S2.posToIJ(this.orientation, n);
            for (int i = 0; i < 2; ++i) {
                int n3 = 1 - (n2 >> 1 - i & 1);
                s2Cell.uv[i][n3] = r2Vector.get(i);
                s2Cell.uv[i][1 - n3] = this.uv[i][1 - n3];
            }
            ++n;
            s2CellId = s2CellId.next();
        }
        return true;
    }

    public S2Point getCenter() {
        return S2Point.normalize(this.getCenterRaw());
    }

    public S2Point getCenterRaw() {
        return this.cellId.toPointRaw();
    }

    public R2Vector getCenterUV() {
        MutableInteger mutableInteger = new MutableInteger(0);
        MutableInteger mutableInteger2 = new MutableInteger(0);
        this.cellId.toFaceIJOrientation(mutableInteger, mutableInteger2, null);
        int n = 1 << 30 - this.level;
        int n2 = (mutableInteger.intValue() & -n) * 2 + n - 0x40000000;
        double d = S2Projections.stToUV(9.313225746154785E-10 * (double)n2);
        int n3 = (mutableInteger2.intValue() & -n) * 2 + n - 0x40000000;
        double d2 = S2Projections.stToUV(9.313225746154785E-10 * (double)n3);
        return new R2Vector(d, d2);
    }

    public static double averageArea(int n) {
        return S2Projections.AVG_AREA.getValue(n);
    }

    public double averageArea() {
        return S2Cell.averageArea(this.level);
    }

    public double approxArea() {
        if (this.level < 2) {
            return S2Cell.averageArea(this.level);
        }
        double d = 0.5 * S2Point.crossProd(S2Point.sub(this.getVertex(2), this.getVertex(0)), S2Point.sub(this.getVertex(3), this.getVertex(1))).norm();
        return d * 2.0 / (1.0 + Math.sqrt(1.0 - Math.min(0.3183098861837907 * d, 1.0)));
    }

    public double exactArea() {
        S2Point s2Point = this.getVertex(0);
        S2Point s2Point2 = this.getVertex(1);
        S2Point s2Point3 = this.getVertex(2);
        S2Point s2Point4 = this.getVertex(3);
        return S2.area(s2Point, s2Point2, s2Point3) + S2.area(s2Point, s2Point3, s2Point4);
    }

    public S2Region clone() {
        S2Cell s2Cell = new S2Cell();
        s2Cell.face = this.face;
        s2Cell.level = this.level;
        s2Cell.orientation = this.orientation;
        s2Cell.uv = (double[][])this.uv.clone();
        return s2Cell;
    }

    @Override
    public S2Cap getCapBound() {
        double d = 0.5 * (this.uv[0][0] + this.uv[0][1]);
        double d2 = 0.5 * (this.uv[1][0] + this.uv[1][1]);
        S2Cap s2Cap = S2Cap.fromAxisHeight(S2Point.normalize(S2Projections.faceUvToXyz(this.face, d, d2)), 0.0);
        for (int i = 0; i < 4; ++i) {
            s2Cap = s2Cap.addPoint(this.getVertex(i));
        }
        return s2Cap;
    }

    @Override
    public S2LatLngRect getRectBound() {
        if (this.level > 0) {
            int n;
            double d = this.uv[0][0] + this.uv[0][1];
            double d2 = this.uv[1][0] + this.uv[1][1];
            int n2 = S2Projections.getUAxis((int)this.face).z == 0.0 ? (d < 0.0 ? 1 : 0) : (n = d > 0.0 ? 1 : 0);
            int n3 = S2Projections.getVAxis((int)this.face).z == 0.0 ? (d2 < 0.0 ? 1 : 0) : (d2 > 0.0 ? 1 : 0);
            R1Interval r1Interval = R1Interval.fromPointPair(this.getLatitude(n, n3), this.getLatitude(1 - n, 1 - n3));
            r1Interval = r1Interval.expanded(4.440892098500626E-16).intersection(S2LatLngRect.fullLat());
            if (r1Interval.lo() == -1.5707963267948966 || r1Interval.hi() == 1.5707963267948966) {
                return new S2LatLngRect(r1Interval, S1Interval.full());
            }
            S1Interval s1Interval = S1Interval.fromPointPair(this.getLongitude(n, 1 - n3), this.getLongitude(1 - n, n3));
            return new S2LatLngRect(r1Interval, s1Interval.expanded(4.440892098500626E-16));
        }
        switch (this.face) {
            case 0: {
                return new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(-0.7853981633974483, 0.7853981633974483));
            }
            case 1: {
                return new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(0.7853981633974483, 2.356194490192345));
            }
            case 2: {
                return new S2LatLngRect(new R1Interval(POLE_MIN_LAT, 1.5707963267948966), new S1Interval(-Math.PI, Math.PI));
            }
            case 3: {
                return new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(2.356194490192345, -2.356194490192345));
            }
            case 4: {
                return new S2LatLngRect(new R1Interval(-0.7853981633974483, 0.7853981633974483), new S1Interval(-2.356194490192345, -0.7853981633974483));
            }
        }
        return new S2LatLngRect(new R1Interval(-1.5707963267948966, -POLE_MIN_LAT), new S1Interval(-Math.PI, Math.PI));
    }

    @Override
    public boolean mayIntersect(S2Cell s2Cell) {
        return this.cellId.intersects(s2Cell.cellId);
    }

    public boolean contains(S2Point s2Point) {
        R2Vector r2Vector = S2Projections.faceXyzToUv(this.face, s2Point);
        if (r2Vector == null) {
            return false;
        }
        return r2Vector.x() >= this.uv[0][0] && r2Vector.x() <= this.uv[0][1] && r2Vector.y() >= this.uv[1][0] && r2Vector.y() <= this.uv[1][1];
    }

    @Override
    public boolean contains(S2Cell s2Cell) {
        return this.cellId.contains(s2Cell.cellId);
    }

    private void init(S2CellId s2CellId) {
        int n;
        this.cellId = s2CellId;
        MutableInteger[] mutableIntegerArray = new MutableInteger[2];
        MutableInteger mutableInteger = new MutableInteger(0);
        for (n = 0; n < 2; ++n) {
            mutableIntegerArray[n] = new MutableInteger(0);
        }
        this.face = (byte)s2CellId.toFaceIJOrientation(mutableIntegerArray[0], mutableIntegerArray[1], mutableInteger);
        this.orientation = (byte)mutableInteger.intValue();
        this.level = (byte)s2CellId.level();
        n = 1 << 30 - this.level;
        for (int i = 0; i < 2; ++i) {
            int n2 = (mutableIntegerArray[i].intValue() & -n) * 2 - 0x40000000;
            int n3 = n2 + n * 2;
            this.uv[i][0] = S2Projections.stToUV(9.313225746154785E-10 * (double)n2);
            this.uv[i][1] = S2Projections.stToUV(9.313225746154785E-10 * (double)n3);
        }
    }

    private double getLatitude(int n, int n2) {
        S2Point s2Point = S2Projections.faceUvToXyz(this.face, this.uv[0][n], this.uv[1][n2]);
        return Math.atan2(s2Point.z, Math.sqrt(s2Point.x * s2Point.x + s2Point.y * s2Point.y));
    }

    private double getLongitude(int n, int n2) {
        S2Point s2Point = S2Projections.faceUvToXyz(this.face, this.uv[0][n], this.uv[1][n2]);
        return Math.atan2(s2Point.y, s2Point.x);
    }

    public String toString() {
        return "[" + this.face + ", " + this.level + ", " + this.orientation + ", " + this.cellId + "]";
    }

    public int hashCode() {
        int n = 17;
        n = 37 * (37 * (37 * n + this.face) + this.orientation) + this.level;
        return 37 * n + this.id().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof S2Cell) {
            S2Cell s2Cell = (S2Cell)object;
            return this.face == s2Cell.face && this.level == s2Cell.level && this.orientation == s2Cell.orientation && this.cellId.equals(s2Cell.cellId);
        }
        return false;
    }
}

