/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.MutableInteger;
import com.google.common.geometry.R2Vector;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Projections;
import java.util.List;
import java.util.Locale;

public strictfp final class S2CellId
implements Comparable<S2CellId> {
    public static final int FACE_BITS = 3;
    public static final int NUM_FACES = 6;
    public static final int MAX_LEVEL = 30;
    public static final int POS_BITS = 61;
    public static final int MAX_SIZE = 0x40000000;
    public static final long MAX_UNSIGNED = -1L;
    private static final int LOOKUP_BITS = 4;
    private static final int SWAP_MASK = 1;
    private static final int INVERT_MASK = 2;
    private static final int[] LOOKUP_POS = new int[1024];
    private static final int[] LOOKUP_IJ = new int[1024];
    private static final long WRAP_OFFSET = -4611686018427387904L;
    private final long id;
    private static final long[] maxValueDivs;
    private static final int[] maxValueMods;

    public S2CellId(long l) {
        this.id = l;
    }

    public S2CellId() {
        this.id = 0L;
    }

    public static S2CellId none() {
        return new S2CellId();
    }

    public static S2CellId sentinel() {
        return new S2CellId(-1L);
    }

    public static S2CellId fromFacePosLevel(int n, long l, int n2) {
        return new S2CellId(((long)n << 61) + (l | 1L)).parent(n2);
    }

    public static S2CellId fromPoint(S2Point s2Point) {
        int n = S2Projections.xyzToFace(s2Point);
        R2Vector r2Vector = S2Projections.validFaceXyzToUv(n, s2Point);
        int n2 = S2CellId.stToIJ(S2Projections.uvToST(r2Vector.x()));
        int n3 = S2CellId.stToIJ(S2Projections.uvToST(r2Vector.y()));
        return S2CellId.fromFaceIJ(n, n2, n3);
    }

    public static S2CellId fromLatLng(S2LatLng s2LatLng) {
        return S2CellId.fromPoint(s2LatLng.toPoint());
    }

    public S2Point toPoint() {
        return S2Point.normalize(this.toPointRaw());
    }

    public S2Point toPointRaw() {
        MutableInteger mutableInteger = new MutableInteger(0);
        MutableInteger mutableInteger2 = new MutableInteger(0);
        int n = this.toFaceIJOrientation(mutableInteger, mutableInteger2, null);
        int n2 = this.isLeaf() ? 1 : (((mutableInteger.intValue() ^ (int)this.id >>> 2) & 1) != 0 ? 2 : 0);
        int n3 = (mutableInteger.intValue() << 1) + n2 - 0x40000000;
        int n4 = (mutableInteger2.intValue() << 1) + n2 - 0x40000000;
        return S2CellId.faceSiTiToXYZ(n, n3, n4);
    }

    public S2LatLng toLatLng() {
        return new S2LatLng(this.toPointRaw());
    }

    public long id() {
        return this.id;
    }

    public boolean isValid() {
        return this.face() < 6 && (this.lowestOnBit() & 0x1555555555555555L) != 0L;
    }

    public int face() {
        return (int)(this.id >>> 61);
    }

    public long pos() {
        return this.id & 0x1FFFFFFFFFFFFFFFL;
    }

    public int level() {
        if (this.isLeaf()) {
            return 30;
        }
        int n = (int)this.id;
        int n2 = -1;
        if (n != 0) {
            n2 += 16;
        } else {
            n = (int)(this.id >>> 32);
        }
        n &= -n;
        if ((n & 0x5555) != 0) {
            n2 += 8;
        }
        if ((n & 0x550055) != 0) {
            n2 += 4;
        }
        if ((n & 0x5050505) != 0) {
            n2 += 2;
        }
        if ((n & 0x11111111) != 0) {
            ++n2;
        }
        return n2;
    }

    public boolean isLeaf() {
        return ((int)this.id & 1) != 0;
    }

    public boolean isFace() {
        return (this.id & S2CellId.lowestOnBitForLevel(0) - 1L) == 0L;
    }

    public int childPosition(int n) {
        return (int)(this.id >>> 2 * (30 - n) + 1) & 3;
    }

    public S2CellId rangeMin() {
        return new S2CellId(this.id - (this.lowestOnBit() - 1L));
    }

    public S2CellId rangeMax() {
        return new S2CellId(this.id + (this.lowestOnBit() - 1L));
    }

    public boolean contains(S2CellId s2CellId) {
        return s2CellId.greaterOrEquals(this.rangeMin()) && s2CellId.lessOrEquals(this.rangeMax());
    }

    public boolean intersects(S2CellId s2CellId) {
        return s2CellId.rangeMin().lessOrEquals(this.rangeMax()) && s2CellId.rangeMax().greaterOrEquals(this.rangeMin());
    }

    public S2CellId parent() {
        long l = this.lowestOnBit() << 2;
        return new S2CellId(this.id & -l | l);
    }

    public S2CellId parent(int n) {
        long l = S2CellId.lowestOnBitForLevel(n);
        return new S2CellId(this.id & -l | l);
    }

    public S2CellId childBegin() {
        long l = this.lowestOnBit();
        return new S2CellId(this.id - l + (l >>> 2));
    }

    public S2CellId childBegin(int n) {
        return new S2CellId(this.id - this.lowestOnBit() + S2CellId.lowestOnBitForLevel(n));
    }

    public S2CellId childEnd() {
        long l = this.lowestOnBit();
        return new S2CellId(this.id + l + (l >>> 2));
    }

    public S2CellId childEnd(int n) {
        return new S2CellId(this.id + this.lowestOnBit() + S2CellId.lowestOnBitForLevel(n));
    }

    public S2CellId next() {
        return new S2CellId(this.id + (this.lowestOnBit() << 1));
    }

    public S2CellId prev() {
        return new S2CellId(this.id - (this.lowestOnBit() << 1));
    }

    public S2CellId nextWrap() {
        S2CellId s2CellId = this.next();
        if (S2CellId.unsignedLongLessThan(s2CellId.id, -4611686018427387904L)) {
            return s2CellId;
        }
        return new S2CellId(s2CellId.id - -4611686018427387904L);
    }

    public S2CellId prevWrap() {
        S2CellId s2CellId = this.prev();
        if (s2CellId.id < -4611686018427387904L) {
            return s2CellId;
        }
        return new S2CellId(s2CellId.id + -4611686018427387904L);
    }

    public static S2CellId begin(int n) {
        return S2CellId.fromFacePosLevel(0, 0L, 0).childBegin(n);
    }

    public static S2CellId end(int n) {
        return S2CellId.fromFacePosLevel(5, 0L, 0).childEnd(n);
    }

    public static S2CellId fromToken(String string) {
        if (string == null) {
            throw new NumberFormatException("Null string in S2CellId.fromToken");
        }
        if (string.length() == 0) {
            throw new NumberFormatException("Empty string in S2CellId.fromToken");
        }
        if (string.length() > 16 || "X".equals(string)) {
            return S2CellId.none();
        }
        long l = 0L;
        for (int i = 0; i < 16; ++i) {
            int n = 0;
            if (i < string.length()) {
                n = Character.digit(string.charAt(i), 16);
                if (n == -1) {
                    throw new NumberFormatException(string);
                }
                if (S2CellId.overflowInParse(l, n)) {
                    throw new NumberFormatException("Too large for unsigned long: " + string);
                }
            }
            l = l * 16L + (long)n;
        }
        return new S2CellId(l);
    }

    public String toToken() {
        int n;
        if (this.id == 0L) {
            return "X";
        }
        String string = Long.toHexString(this.id).toLowerCase(Locale.ENGLISH);
        StringBuilder stringBuilder = new StringBuilder(16);
        for (n = string.length(); n < 16; ++n) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        for (n = 16; n > 0; --n) {
            if (stringBuilder.charAt(n - 1) == '0') continue;
            return stringBuilder.substring(0, n);
        }
        throw new RuntimeException("Shouldn't make it here");
    }

    private static boolean overflowInParse(long l, int n) {
        return S2CellId.overflowInParse(l, n, 10);
    }

    private static boolean overflowInParse(long l, int n, int n2) {
        if (l >= 0L) {
            if (l < maxValueDivs[n2]) {
                return false;
            }
            if (l > maxValueDivs[n2]) {
                return true;
            }
            return n > maxValueMods[n2];
        }
        return true;
    }

    public void getEdgeNeighbors(S2CellId[] s2CellIdArray) {
        MutableInteger mutableInteger = new MutableInteger(0);
        MutableInteger mutableInteger2 = new MutableInteger(0);
        int n = this.level();
        int n2 = 1 << 30 - n;
        int n3 = this.toFaceIJOrientation(mutableInteger, mutableInteger2, null);
        s2CellIdArray[0] = S2CellId.fromFaceIJSame(n3, mutableInteger.intValue(), mutableInteger2.intValue() - n2, mutableInteger2.intValue() - n2 >= 0).parent(n);
        s2CellIdArray[1] = S2CellId.fromFaceIJSame(n3, mutableInteger.intValue() + n2, mutableInteger2.intValue(), mutableInteger.intValue() + n2 < 0x40000000).parent(n);
        s2CellIdArray[2] = S2CellId.fromFaceIJSame(n3, mutableInteger.intValue(), mutableInteger2.intValue() + n2, mutableInteger2.intValue() + n2 < 0x40000000).parent(n);
        s2CellIdArray[3] = S2CellId.fromFaceIJSame(n3, mutableInteger.intValue() - n2, mutableInteger2.intValue(), mutableInteger.intValue() - n2 >= 0).parent(n);
    }

    public void getVertexNeighbors(int n, List<S2CellId> list) {
        boolean bl;
        int n2;
        boolean bl2;
        int n3;
        MutableInteger mutableInteger = new MutableInteger(0);
        MutableInteger mutableInteger2 = new MutableInteger(0);
        int n4 = this.toFaceIJOrientation(mutableInteger, mutableInteger2, null);
        int n5 = 1 << 30 - (n + 1);
        int n6 = n5 << 1;
        if ((mutableInteger.intValue() & n5) != 0) {
            n3 = n6;
            bl2 = mutableInteger.intValue() + n6 < 0x40000000;
        } else {
            n3 = -n6;
            boolean bl3 = bl2 = mutableInteger.intValue() - n6 >= 0;
        }
        if ((mutableInteger2.intValue() & n5) != 0) {
            n2 = n6;
            bl = mutableInteger2.intValue() + n6 < 0x40000000;
        } else {
            n2 = -n6;
            bl = mutableInteger2.intValue() - n6 >= 0;
        }
        list.add(this.parent(n));
        list.add(S2CellId.fromFaceIJSame(n4, mutableInteger.intValue() + n3, mutableInteger2.intValue(), bl2).parent(n));
        list.add(S2CellId.fromFaceIJSame(n4, mutableInteger.intValue(), mutableInteger2.intValue() + n2, bl).parent(n));
        if (bl2 || bl) {
            list.add(S2CellId.fromFaceIJSame(n4, mutableInteger.intValue() + n3, mutableInteger2.intValue() + n2, bl2 && bl).parent(n));
        }
    }

    public void getAllNeighbors(int n, List<S2CellId> list) {
        MutableInteger mutableInteger = new MutableInteger(0);
        MutableInteger mutableInteger2 = new MutableInteger(0);
        int n2 = this.toFaceIJOrientation(mutableInteger, mutableInteger2, null);
        int n3 = 1 << 30 - this.level();
        mutableInteger.setValue(mutableInteger.intValue() & -n3);
        mutableInteger2.setValue(mutableInteger2.intValue() & -n3);
        int n4 = 1 << 30 - n;
        int n5 = -n4;
        while (true) {
            boolean bl;
            if (n5 < 0) {
                bl = mutableInteger2.intValue() + n5 >= 0;
            } else if (n5 >= n3) {
                bl = mutableInteger2.intValue() + n5 < 0x40000000;
            } else {
                bl = true;
                list.add(S2CellId.fromFaceIJSame(n2, mutableInteger.intValue() + n5, mutableInteger2.intValue() - n4, mutableInteger2.intValue() - n3 >= 0).parent(n));
                list.add(S2CellId.fromFaceIJSame(n2, mutableInteger.intValue() + n5, mutableInteger2.intValue() + n3, mutableInteger2.intValue() + n3 < 0x40000000).parent(n));
            }
            list.add(S2CellId.fromFaceIJSame(n2, mutableInteger.intValue() - n4, mutableInteger2.intValue() + n5, bl && mutableInteger.intValue() - n3 >= 0).parent(n));
            list.add(S2CellId.fromFaceIJSame(n2, mutableInteger.intValue() + n3, mutableInteger2.intValue() + n5, bl && mutableInteger.intValue() + n3 < 0x40000000).parent(n));
            if (n5 >= n3) break;
            n5 += n4;
        }
    }

    public static S2CellId fromFaceIJ(int n, int n2, int n3) {
        long[] lArray = new long[]{0L, n << 28};
        int n4 = n & 1;
        for (int i = 7; i >= 0; --i) {
            n4 = S2CellId.getBits(lArray, n2, n3, i, n4);
        }
        S2CellId s2CellId = new S2CellId(((lArray[1] << 32) + lArray[0] << 1) + 1L);
        return s2CellId;
    }

    private static int getBits(long[] lArray, int n, int n2, int n3, int n4) {
        n4 += (n >> n3 * 4 & 0xF) << 6;
        n4 += (n2 >> n3 * 4 & 0xF) << 2;
        n4 = LOOKUP_POS[n4];
        int n5 = n3 >> 2;
        lArray[n5] = lArray[n5] | (long)n4 >> 2 << (n3 & 3) * 2 * 4;
        return n4 &= 3;
    }

    public int toFaceIJOrientation(MutableInteger mutableInteger, MutableInteger mutableInteger2, MutableInteger mutableInteger3) {
        int n = this.face();
        int n2 = n & 1;
        for (int i = 7; i >= 0; --i) {
            n2 = this.getBits1(mutableInteger, mutableInteger2, i, n2);
        }
        if (mutableInteger3 != null) {
            if ((this.lowestOnBit() & 0x1111111111111110L) != 0L) {
                n2 ^= 1;
            }
            mutableInteger3.setValue(n2);
        }
        return n;
    }

    private int getBits1(MutableInteger mutableInteger, MutableInteger mutableInteger2, int n, int n2) {
        int n3 = n == 7 ? 2 : 4;
        n2 += ((int)(this.id >>> n * 2 * 4 + 1) & (1 << 2 * n3) - 1) << 2;
        n2 = LOOKUP_IJ[n2];
        mutableInteger.setValue(mutableInteger.intValue() + (n2 >> 6 << n * 4));
        mutableInteger2.setValue(mutableInteger2.intValue() + ((n2 >> 2 & 0xF) << n * 4));
        return n2 &= 3;
    }

    public long lowestOnBit() {
        return this.id & -this.id;
    }

    public static long lowestOnBitForLevel(int n) {
        return 1L << 2 * (30 - n);
    }

    private static int stToIJ(double d) {
        return (int)Math.max(0L, Math.min(0x3FFFFFFFL, Math.round(5.36870912E8 * d + 5.368709115E8)));
    }

    private static S2Point faceSiTiToXYZ(int n, int n2, int n3) {
        double d = S2Projections.stToUV(9.313225746154785E-10 * (double)n2);
        double d2 = S2Projections.stToUV(9.313225746154785E-10 * (double)n3);
        return S2Projections.faceUvToXyz(n, d, d2);
    }

    private static S2CellId fromFaceIJWrap(int n, int n2, int n3) {
        n2 = Math.max(-1, Math.min(0x40000000, n2));
        n3 = Math.max(-1, Math.min(0x40000000, n3));
        double d = 9.313225746154785E-10 * (double)((n2 << 1) + 1 - 0x40000000);
        double d2 = 9.313225746154785E-10 * (double)((n3 << 1) + 1 - 0x40000000);
        S2Point s2Point = S2Projections.faceUvToXyz(n, d, d2);
        n = S2Projections.xyzToFace(s2Point);
        R2Vector r2Vector = S2Projections.validFaceXyzToUv(n, s2Point);
        return S2CellId.fromFaceIJ(n, S2CellId.stToIJ(r2Vector.x()), S2CellId.stToIJ(r2Vector.y()));
    }

    public static S2CellId fromFaceIJSame(int n, int n2, int n3, boolean bl) {
        if (bl) {
            return S2CellId.fromFaceIJ(n, n2, n3);
        }
        return S2CellId.fromFaceIJWrap(n, n2, n3);
    }

    public boolean equals(Object object) {
        if (!(object instanceof S2CellId)) {
            return false;
        }
        S2CellId s2CellId = (S2CellId)object;
        return this.id() == s2CellId.id();
    }

    public static boolean unsignedLongLessThan(long l, long l2) {
        return l + Long.MIN_VALUE < l2 + Long.MIN_VALUE;
    }

    public static boolean unsignedLongGreaterThan(long l, long l2) {
        return l + Long.MIN_VALUE > l2 + Long.MIN_VALUE;
    }

    public boolean lessThan(S2CellId s2CellId) {
        return S2CellId.unsignedLongLessThan(this.id, s2CellId.id);
    }

    public boolean greaterThan(S2CellId s2CellId) {
        return S2CellId.unsignedLongGreaterThan(this.id, s2CellId.id);
    }

    public boolean lessOrEquals(S2CellId s2CellId) {
        return S2CellId.unsignedLongLessThan(this.id, s2CellId.id) || this.id == s2CellId.id;
    }

    public boolean greaterOrEquals(S2CellId s2CellId) {
        return S2CellId.unsignedLongGreaterThan(this.id, s2CellId.id) || this.id == s2CellId.id;
    }

    public int hashCode() {
        return (int)((this.id >>> 32) + this.id);
    }

    public String toString() {
        return "(face=" + this.face() + ", pos=" + Long.toHexString(this.pos()) + ", level=" + this.level() + ")";
    }

    private static void initLookupCell(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n == 4) {
            int n7 = (n2 << 4) + n3;
            S2CellId.LOOKUP_POS[(n7 << 2) + n4] = (n5 << 2) + n6;
            S2CellId.LOOKUP_IJ[(n5 << 2) + n4] = (n7 << 2) + n6;
        } else {
            ++n;
            n2 <<= 1;
            n3 <<= 1;
            n5 <<= 2;
            for (int i = 0; i < 4; ++i) {
                int n8 = S2.posToIJ(n6, i);
                int n9 = S2.posToOrientation(i);
                S2CellId.initLookupCell(n, n2 + (n8 >>> 1), n3 + (n8 & 1), n4, n5 + i, n6 ^ n9);
            }
        }
    }

    @Override
    public int compareTo(S2CellId s2CellId) {
        return S2CellId.unsignedLongLessThan(this.id, s2CellId.id) ? -1 : (S2CellId.unsignedLongGreaterThan(this.id, s2CellId.id) ? 1 : 0);
    }

    static {
        S2CellId.initLookupCell(0, 0, 0, 0, 0, 0);
        S2CellId.initLookupCell(0, 0, 0, 1, 0, 1);
        S2CellId.initLookupCell(0, 0, 0, 2, 0, 2);
        S2CellId.initLookupCell(0, 0, 0, 3, 0, 3);
        maxValueDivs = new long[]{0L, 0L, Long.MAX_VALUE, 0x5555555555555555L, 0x3FFFFFFFFFFFFFFFL, 0x3333333333333333L, 0x2AAAAAAAAAAAAAAAL, 0x2492492492492492L, 0x1FFFFFFFFFFFFFFFL, 0x1C71C71C71C71C71L, 0x1999999999999999L, 1676976733973595601L, 0x1555555555555555L, 0x13B13B13B13B13B1L, 1317624576693539401L, 0x1111111111111111L, 0xFFFFFFFFFFFFFFFL, 0xF0F0F0F0F0F0F0FL, 0xE38E38E38E38E38L, 970881267037344821L, 0xCCCCCCCCCCCCCCCL, 0xC30C30C30C30C30L, 838488366986797800L, 802032351030850070L, 0xAAAAAAAAAAAAAAAL, 737869762948382064L, 0x9D89D89D89D89D8L, 683212743470724133L, 0x924924924924924L, 636094623231363848L, 0x888888888888888L, 595056260442243600L, 0x7FFFFFFFFFFFFFFL, 558992244657865200L, 0x787878787878787L, 0x750750750750750L, 0x71C71C71C71C71CL};
        maxValueMods = new int[]{0, 0, 1, 0, 3, 0, 3, 1, 7, 6, 5, 4, 3, 2, 1, 0, 15, 0, 15, 16, 15, 15, 15, 5, 15, 15, 15, 24, 15, 23, 15, 15, 31, 15, 17, 15, 15};
    }
}

