/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.collect.Lists;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Projections;
import com.google.common.geometry.S2Region;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public strictfp class S2CellUnion
implements S2Region,
Iterable<S2CellId> {
    private ArrayList<S2CellId> cellIds = new ArrayList();

    public void initFromCellIds(ArrayList<S2CellId> arrayList) {
        this.initRawCellIds(arrayList);
        this.normalize();
    }

    public void initFromIds(ArrayList<Long> arrayList) {
        this.initRawIds(arrayList);
        this.normalize();
    }

    public void initSwap(ArrayList<S2CellId> arrayList) {
        this.initRawSwap(arrayList);
        this.normalize();
    }

    public void initRawCellIds(ArrayList<S2CellId> arrayList) {
        this.cellIds = arrayList;
    }

    public void initRawIds(ArrayList<Long> arrayList) {
        int n = arrayList.size();
        this.cellIds = new ArrayList(n);
        for (Long l : arrayList) {
            this.cellIds.add(new S2CellId(l));
        }
    }

    public void initRawSwap(ArrayList<S2CellId> arrayList) {
        this.cellIds = new ArrayList<S2CellId>(arrayList);
        arrayList.clear();
    }

    public int size() {
        return this.cellIds.size();
    }

    public S2CellId cellId(int n) {
        return this.cellIds.get(n);
    }

    @Override
    public Iterator<S2CellId> iterator() {
        return this.cellIds.iterator();
    }

    public ArrayList<S2CellId> cellIds() {
        return this.cellIds;
    }

    public void denormalize(int n, int n2, ArrayList<S2CellId> arrayList) {
        arrayList.clear();
        arrayList.ensureCapacity(this.size());
        for (S2CellId s2CellId : this) {
            int n3 = s2CellId.level();
            int n4 = Math.max(n, n3);
            if (n2 > 1) {
                n4 += (30 - (n4 - n)) % n2;
                n4 = Math.min(30, n4);
            }
            if (n4 == n3) {
                arrayList.add(s2CellId);
                continue;
            }
            S2CellId s2CellId2 = s2CellId.childEnd(n4);
            s2CellId = s2CellId.childBegin(n4);
            while (!s2CellId.equals(s2CellId2)) {
                arrayList.add(s2CellId);
                s2CellId = s2CellId.next();
            }
        }
    }

    public void pack() {
        this.cellIds.trimToSize();
    }

    public boolean contains(S2CellId s2CellId) {
        int n = Collections.binarySearch(this.cellIds, s2CellId);
        if (n < 0) {
            n = -n - 1;
        }
        if (n < this.cellIds.size() && this.cellIds.get(n).rangeMin().lessOrEquals(s2CellId)) {
            return true;
        }
        return n != 0 && this.cellIds.get(n - 1).rangeMax().greaterOrEquals(s2CellId);
    }

    public boolean intersects(S2CellId s2CellId) {
        int n = Collections.binarySearch(this.cellIds, s2CellId);
        if (n < 0) {
            n = -n - 1;
        }
        if (n < this.cellIds.size() && this.cellIds.get(n).rangeMin().lessOrEquals(s2CellId.rangeMax())) {
            return true;
        }
        return n != 0 && this.cellIds.get(n - 1).rangeMax().greaterOrEquals(s2CellId.rangeMin());
    }

    public boolean contains(S2CellUnion s2CellUnion) {
        for (S2CellId s2CellId : s2CellUnion) {
            if (this.contains(s2CellId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(S2Cell s2Cell) {
        return this.contains(s2Cell.id());
    }

    public boolean intersects(S2CellUnion s2CellUnion) {
        for (S2CellId s2CellId : s2CellUnion) {
            if (!this.intersects(s2CellId)) continue;
            return true;
        }
        return false;
    }

    public void getUnion(S2CellUnion s2CellUnion, S2CellUnion s2CellUnion2) {
        this.cellIds.clear();
        this.cellIds.ensureCapacity(s2CellUnion.size() + s2CellUnion2.size());
        this.cellIds.addAll(s2CellUnion.cellIds);
        this.cellIds.addAll(s2CellUnion2.cellIds);
        this.normalize();
    }

    public void getIntersection(S2CellUnion s2CellUnion, S2CellId s2CellId) {
        this.cellIds.clear();
        if (s2CellUnion.contains(s2CellId)) {
            this.cellIds.add(s2CellId);
        } else {
            int n = Collections.binarySearch(s2CellUnion.cellIds, s2CellId.rangeMin());
            if (n < 0) {
                n = -n - 1;
            }
            S2CellId s2CellId2 = s2CellId.rangeMax();
            int n2 = s2CellUnion.cellIds.size();
            while (n < n2 && s2CellUnion.cellIds.get(n).lessOrEquals(s2CellId2)) {
                this.cellIds.add(s2CellUnion.cellIds.get(n++));
            }
        }
    }

    public void getIntersection(S2CellUnion s2CellUnion, S2CellUnion s2CellUnion2) {
        this.cellIds.clear();
        int n = 0;
        int n2 = 0;
        while (n < s2CellUnion.cellIds.size() && n2 < s2CellUnion2.cellIds.size()) {
            S2CellId s2CellId;
            S2CellId s2CellId2 = s2CellUnion.cellId(n).rangeMin();
            if (s2CellId2.greaterThan(s2CellId = s2CellUnion2.cellId(n2).rangeMin())) {
                if (s2CellUnion.cellId(n).lessOrEquals(s2CellUnion2.cellId(n2).rangeMax())) {
                    this.cellIds.add(s2CellUnion.cellId(n++));
                    continue;
                }
                n2 = this.indexedBinarySearch(s2CellUnion2.cellIds, s2CellId2, n2 + 1);
                if (!s2CellUnion.cellId(n).lessOrEquals(s2CellUnion2.cellId(n2 - 1).rangeMax())) continue;
                --n2;
                continue;
            }
            if (s2CellId.greaterThan(s2CellId2)) {
                if (s2CellUnion2.cellId(n2).lessOrEquals(s2CellUnion.cellId(n).rangeMax())) {
                    this.cellIds.add(s2CellUnion2.cellId(n2++));
                    continue;
                }
                n = this.indexedBinarySearch(s2CellUnion.cellIds, s2CellId, n + 1);
                if (!s2CellUnion2.cellId(n2).lessOrEquals(s2CellUnion.cellId(n - 1).rangeMax())) continue;
                --n;
                continue;
            }
            if (s2CellUnion.cellId(n).lessThan(s2CellUnion2.cellId(n2))) {
                this.cellIds.add(s2CellUnion.cellId(n++));
                continue;
            }
            this.cellIds.add(s2CellUnion2.cellId(n2++));
        }
    }

    private int indexedBinarySearch(List<S2CellId> list, S2CellId s2CellId, int n) {
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            S2CellId s2CellId2 = list.get(n3);
            int n4 = s2CellId2.compareTo(s2CellId);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return n;
    }

    public void expand(int n) {
        ArrayList<S2CellId> arrayList = new ArrayList<S2CellId>();
        long l = S2CellId.lowestOnBitForLevel(n);
        int n2 = this.size() - 1;
        do {
            S2CellId s2CellId;
            if ((s2CellId = this.cellId(n2)).lowestOnBit() < l) {
                s2CellId = s2CellId.parent(n);
                while (n2 > 0 && s2CellId.contains(this.cellId(n2 - 1))) {
                    --n2;
                }
            }
            arrayList.add(s2CellId);
            s2CellId.getAllNeighbors(n, arrayList);
        } while (--n2 >= 0);
        this.initSwap(arrayList);
    }

    public void expand(S1Angle s1Angle, int n) {
        int n2 = 30;
        for (S2CellId s2CellId : this) {
            n2 = Math.min(n2, s2CellId.level());
        }
        int n3 = S2Projections.MIN_WIDTH.getMaxLevel(s1Angle.radians());
        if (n3 == 0 && s1Angle.radians() > S2Projections.MIN_WIDTH.getValue(0)) {
            this.expand(0);
        }
        this.expand(Math.min(n2 + n, n3));
    }

    public S2Region clone() {
        S2CellUnion s2CellUnion = new S2CellUnion();
        s2CellUnion.initRawCellIds(Lists.newArrayList(this.cellIds));
        return s2CellUnion;
    }

    @Override
    public S2Cap getCapBound() {
        if (this.cellIds.isEmpty()) {
            return S2Cap.empty();
        }
        S2Point s2Point = new S2Point(0.0, 0.0, 0.0);
        for (Object object : this) {
            double d = S2Cell.averageArea(((S2CellId)object).level());
            s2Point = S2Point.add(s2Point, S2Point.mul(((S2CellId)object).toPoint(), d));
        }
        s2Point = s2Point.equals(new S2Point(0.0, 0.0, 0.0)) ? new S2Point(1.0, 0.0, 0.0) : S2Point.normalize(s2Point);
        Object object = S2Cap.fromAxisHeight(s2Point, 0.0);
        for (S2CellId s2CellId : this) {
            object = ((S2Cap)object).addCap(new S2Cell(s2CellId).getCapBound());
        }
        return object;
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2LatLngRect s2LatLngRect = S2LatLngRect.empty();
        for (S2CellId s2CellId : this) {
            s2LatLngRect = s2LatLngRect.union(new S2Cell(s2CellId).getRectBound());
        }
        return s2LatLngRect;
    }

    @Override
    public boolean mayIntersect(S2Cell s2Cell) {
        return this.intersects(s2Cell.id());
    }

    public boolean contains(S2Point s2Point) {
        return this.contains(S2CellId.fromPoint(s2Point));
    }

    public long leafCellsCovered() {
        long l = 0L;
        for (S2CellId s2CellId : this.cellIds) {
            int n = 30 - s2CellId.level();
            l += 1L << (n << 1);
        }
        return l;
    }

    public double averageBasedArea() {
        return S2Cell.averageArea(30) * (double)this.leafCellsCovered();
    }

    public double approxArea() {
        double d = 0.0;
        for (S2CellId s2CellId : this.cellIds) {
            d += new S2Cell(s2CellId).approxArea();
        }
        return d;
    }

    public double exactArea() {
        double d = 0.0;
        for (S2CellId s2CellId : this.cellIds) {
            d += new S2Cell(s2CellId).exactArea();
        }
        return d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof S2CellUnion)) {
            return false;
        }
        S2CellUnion s2CellUnion = (S2CellUnion)object;
        return this.cellIds.equals(s2CellUnion.cellIds);
    }

    public int hashCode() {
        int n = 17;
        for (S2CellId s2CellId : this) {
            n = 37 * n + s2CellId.hashCode();
        }
        return n;
    }

    public boolean normalize() {
        ArrayList<S2CellId> arrayList = new ArrayList<S2CellId>(this.cellIds.size());
        arrayList.ensureCapacity(this.cellIds.size());
        Collections.sort(this.cellIds);
        for (S2CellId s2CellId : this) {
            int n = arrayList.size();
            if (!arrayList.isEmpty() && arrayList.get(n - 1).contains(s2CellId)) continue;
            while (!arrayList.isEmpty() && s2CellId.contains(arrayList.get(arrayList.size() - 1))) {
                arrayList.remove(arrayList.size() - 1);
            }
            while (arrayList.size() >= 3 && (arrayList.get((n = arrayList.size()) - 3).id() ^ arrayList.get(n - 2).id() ^ arrayList.get(n - 1).id()) == s2CellId.id()) {
                long l = s2CellId.lowestOnBit() << 1;
                l = l + (l << 1) ^ 0xFFFFFFFFFFFFFFFFL;
                long l2 = s2CellId.id() & l;
                if ((arrayList.get(n - 3).id() & l) != l2 || (arrayList.get(n - 2).id() & l) != l2 || (arrayList.get(n - 1).id() & l) != l2 || s2CellId.isFace()) break;
                arrayList.remove(n - 1);
                arrayList.remove(n - 2);
                arrayList.remove(n - 3);
                s2CellId = s2CellId.parent();
            }
            arrayList.add(s2CellId);
        }
        if (arrayList.size() < this.size()) {
            this.initRawSwap(arrayList);
            return true;
        }
        return false;
    }
}

