/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S2Point;

public final class S2Edge {
    private final S2Point start;
    private final S2Point end;

    public S2Edge(S2Point s2Point, S2Point s2Point2) {
        this.start = s2Point;
        this.end = s2Point2;
    }

    public S2Point getStart() {
        return this.start;
    }

    public S2Point getEnd() {
        return this.end;
    }

    public String toString() {
        return String.format("Edge: (%s -> %s)\n   or [%s -> %s]", this.start.toDegreesString(), this.end.toDegreesString(), this.start, this.end);
    }

    public int hashCode() {
        return this.getStart().hashCode() - this.getEnd().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof S2Edge)) {
            return false;
        }
        S2Edge s2Edge = (S2Edge)object;
        return this.getStart().equals(s2Edge.getStart()) && this.getEnd().equals(s2Edge.getEnd());
    }
}

