/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Projections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public strictfp abstract class S2EdgeIndex {
    private static final double THICKENING = 0.01;
    private static final double MAX_DET_ERROR = 1.0E-14;
    private long[] cells;
    private int[] edges;
    private int minimumS2LevelUsed;
    private boolean indexComputed;
    private int queryCount;

    public void reset() {
        this.minimumS2LevelUsed = 30;
        this.indexComputed = false;
        this.queryCount = 0;
        this.cells = null;
        this.edges = null;
    }

    private static final int compare(long l, int n, long l2, int n2) {
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public final void computeIndex() {
        int n;
        if (this.indexComputed) {
            return;
        }
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        for (n = 0; n < this.getNumEdges(); ++n) {
            S2Point s2Point = this.edgeFrom(n);
            S2Point s2Point2 = this.edgeTo(n);
            ArrayList arrayList3 = Lists.newArrayList();
            int n2 = this.getCovering(s2Point, s2Point2, true, arrayList3);
            this.minimumS2LevelUsed = Math.min(this.minimumS2LevelUsed, n2);
            for (S2CellId s2CellId : arrayList3) {
                arrayList.add(s2CellId.id());
                arrayList2.add(n);
            }
        }
        this.cells = new long[arrayList.size()];
        this.edges = new int[arrayList2.size()];
        for (n = 0; n < this.cells.length; ++n) {
            this.cells[n] = (Long)arrayList.get(n);
            this.edges[n] = (Integer)arrayList2.get(n);
        }
        this.sortIndex();
        this.indexComputed = true;
    }

    private void sortIndex() {
        Integer[] integerArray = new Integer[this.cells.length];
        for (int i = 0; i < integerArray.length; ++i) {
            integerArray[i] = i;
        }
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return S2EdgeIndex.compare(S2EdgeIndex.this.cells[n], S2EdgeIndex.this.edges[n], S2EdgeIndex.this.cells[n2], S2EdgeIndex.this.edges[n2]);
            }
        });
        long[] lArray = new long[this.cells.length];
        int[] nArray = new int[this.edges.length];
        for (int i = 0; i < integerArray.length; ++i) {
            lArray[i] = this.cells[integerArray[i]];
            nArray[i] = this.edges[integerArray[i]];
        }
        this.cells = lArray;
        this.edges = nArray;
    }

    public final boolean isIndexComputed() {
        return this.indexComputed;
    }

    protected final void incrementQueryCount() {
        ++this.queryCount;
    }

    public final void predictAdditionalCalls(int n) {
        if (this.indexComputed) {
            return;
        }
        if (this.getNumEdges() > 100 && this.queryCount + n > 30) {
            this.computeIndex();
        }
    }

    protected abstract int getNumEdges();

    protected abstract S2Point edgeFrom(int var1);

    protected abstract S2Point edgeTo(int var1);

    protected void findCandidateCrossings(S2Point s2Point, S2Point s2Point2, List<Integer> list) {
        Preconditions.checkState((boolean)this.indexComputed);
        ArrayList arrayList = Lists.newArrayList();
        this.getCovering(s2Point, s2Point2, false, arrayList);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        this.getEdgesInParentCells(arrayList, hashSet);
        this.getEdgesInChildrenCells(s2Point, s2Point2, arrayList, hashSet);
        list.clear();
        list.addAll(hashSet);
    }

    private static S2CellId containingCell(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        S2CellId s2CellId = S2CellId.fromPoint(s2Point);
        S2CellId s2CellId2 = S2CellId.fromPoint(s2Point2);
        S2CellId s2CellId3 = S2CellId.fromPoint(s2Point3);
        S2CellId s2CellId4 = S2CellId.fromPoint(s2Point4);
        if (s2CellId.face() != s2CellId2.face() || s2CellId.face() != s2CellId3.face() || s2CellId.face() != s2CellId4.face()) {
            return S2CellId.sentinel();
        }
        while (!(s2CellId.equals(s2CellId2) && s2CellId.equals(s2CellId3) && s2CellId.equals(s2CellId4))) {
            s2CellId = s2CellId.parent();
            s2CellId2 = s2CellId2.parent();
            s2CellId3 = s2CellId3.parent();
            s2CellId4 = s2CellId4.parent();
        }
        return s2CellId;
    }

    private static S2CellId containingCell(S2Point s2Point, S2Point s2Point2) {
        S2CellId s2CellId = S2CellId.fromPoint(s2Point);
        S2CellId s2CellId2 = S2CellId.fromPoint(s2Point2);
        if (s2CellId.face() != s2CellId2.face()) {
            return S2CellId.sentinel();
        }
        while (!s2CellId.equals(s2CellId2)) {
            s2CellId = s2CellId.parent();
            s2CellId2 = s2CellId2.parent();
        }
        return s2CellId;
    }

    private int getCovering(S2Point s2Point, S2Point s2Point2, boolean bl, ArrayList<S2CellId> arrayList) {
        Comparable<S2Point> comparable;
        S2CellId s2CellId;
        arrayList.clear();
        double d = s2Point.angle(s2Point2);
        int n = S2Projections.MIN_WIDTH.getMaxLevel(d * 1.02);
        if (!bl) {
            s2CellId = S2EdgeIndex.containingCell(s2Point, s2Point2);
        } else if (n == 30) {
            s2CellId = new S2CellId(65520L).parent(3);
        } else {
            comparable = S2Point.mul(S2Point.minus(s2Point2, s2Point), 0.01);
            S2Point s2Point3 = S2Point.mul(S2Point.normalize(S2Point.crossProd((S2Point)comparable, s2Point)), d * 0.01);
            S2Point s2Point4 = S2Point.minus(s2Point, comparable);
            S2Point s2Point5 = S2Point.add(s2Point2, comparable);
            s2CellId = S2EdgeIndex.containingCell(S2Point.minus(s2Point4, s2Point3), S2Point.add(s2Point4, s2Point3), S2Point.minus(s2Point5, s2Point3), S2Point.add(s2Point5, s2Point3));
        }
        if (!s2CellId.equals(S2CellId.sentinel()) && s2CellId.level() >= n - 2) {
            arrayList.add(s2CellId);
            return s2CellId.level();
        }
        if (n == 0) {
            comparable = S2CellId.begin(0);
            while (!((S2CellId)comparable).equals(S2CellId.end(0))) {
                arrayList.add((S2CellId)comparable);
                comparable = ((S2CellId)comparable).next();
            }
            return 0;
        }
        comparable = S2Point.normalize(S2Point.div(S2Point.add(s2Point, s2Point2), 2.0));
        int n2 = Math.min(n, 29);
        S2CellId.fromPoint(comparable).getVertexNeighbors(n2, arrayList);
        return n2;
    }

    private int[] getEdges(long l, long l2) {
        if (l > l2) {
            long l3 = l;
            l = l2;
            l2 = l3;
        }
        return new int[]{-1 - this.binarySearch(l, Integer.MIN_VALUE), -1 - this.binarySearch(l2, Integer.MAX_VALUE)};
    }

    private int binarySearch(long l, int n) {
        int n2 = 0;
        int n3 = this.cells.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = S2EdgeIndex.compare(this.cells[n4], this.edges[n4], l, n);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    private void getEdgesInParentCells(List<S2CellId> list, Set<Integer> set) {
        HashSet hashSet = Sets.newHashSet();
        for (S2CellId s2CellId : list) {
            for (int i = s2CellId.level() - 1; i >= this.minimumS2LevelUsed && hashSet.add(s2CellId.parent(i)); --i) {
            }
        }
        for (S2CellId s2CellId : hashSet) {
            int[] nArray = this.getEdges(s2CellId.id(), s2CellId.id());
            for (int i = nArray[0]; i < nArray[1]; ++i) {
                set.add(this.edges[i]);
            }
        }
    }

    private static boolean lenientCrossing(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        double d = S2Point.crossProd(s2Point, s2Point3).dotProd(s2Point2);
        double d2 = S2Point.crossProd(s2Point2, s2Point4).dotProd(s2Point);
        if (Math.abs(d) < 1.0E-14 || Math.abs(d2) < 1.0E-14) {
            return true;
        }
        if (d * d2 < 0.0) {
            return false;
        }
        double d3 = S2Point.crossProd(s2Point3, s2Point2).dotProd(s2Point4);
        double d4 = S2Point.crossProd(s2Point3, s2Point).dotProd(s2Point3);
        if (Math.abs(d3) < 1.0E-14 || Math.abs(d4) < 1.0E-14) {
            return true;
        }
        return d * d3 >= 0.0 && d * d4 >= 0.0;
    }

    private static boolean edgeIntersectsCellBoundary(S2Point s2Point, S2Point s2Point2, S2Cell s2Cell) {
        int n;
        S2Point[] s2PointArray = new S2Point[4];
        for (n = 0; n < 4; ++n) {
            s2PointArray[n] = s2Cell.getVertex(n);
        }
        for (n = 0; n < 4; ++n) {
            S2Point s2Point3 = s2PointArray[n];
            S2Point s2Point4 = s2PointArray[(n + 1) % 4];
            if (!S2EdgeIndex.lenientCrossing(s2Point, s2Point2, s2Point3, s2Point4)) continue;
            return true;
        }
        return false;
    }

    private void getEdgesInChildrenCells(S2Point s2Point, S2Point s2Point2, List<S2CellId> list, Set<Integer> set) {
        S2Cell[] s2CellArray = null;
        while (!list.isEmpty()) {
            int n;
            S2CellId s2CellId = list.remove(list.size() - 1);
            int[] nArray = this.getEdges(s2CellId.rangeMin().id(), s2CellId.rangeMax().id());
            if (nArray[1] - nArray[0] <= 16) {
                for (n = nArray[0]; n < nArray[1]; ++n) {
                    set.add(this.edges[n]);
                }
                continue;
            }
            nArray = this.getEdges(s2CellId.id(), s2CellId.id());
            for (n = nArray[0]; n < nArray[1]; ++n) {
                set.add(this.edges[n]);
            }
            if (s2CellArray == null) {
                s2CellArray = new S2Cell[4];
                for (n = 0; n < 4; ++n) {
                    s2CellArray[n] = new S2Cell();
                }
            }
            new S2Cell(s2CellId).subdivide(s2CellArray);
            for (S2Cell s2Cell : s2CellArray) {
                if (!S2EdgeIndex.edgeIntersectsCellBoundary(s2Point, s2Point2, s2Cell)) continue;
                list.add(s2Cell.id());
            }
        }
    }

    public strictfp static class DataEdgeIterator {
        private final S2EdgeIndex edgeIndex;
        private boolean isBruteForce;
        private int currentIndex;
        private int numEdges;
        ArrayList<Integer> candidates;
        private int currentIndexInCandidates;

        public DataEdgeIterator(S2EdgeIndex s2EdgeIndex) {
            this.edgeIndex = s2EdgeIndex;
            this.candidates = Lists.newArrayList();
        }

        public void getCandidates(S2Point s2Point, S2Point s2Point2) {
            this.edgeIndex.predictAdditionalCalls(1);
            boolean bl = this.isBruteForce = !this.edgeIndex.isIndexComputed();
            if (this.isBruteForce) {
                this.edgeIndex.incrementQueryCount();
                this.currentIndex = 0;
                this.numEdges = this.edgeIndex.getNumEdges();
            } else {
                this.candidates.clear();
                this.edgeIndex.findCandidateCrossings(s2Point, s2Point2, this.candidates);
                this.currentIndexInCandidates = 0;
                if (!this.candidates.isEmpty()) {
                    this.currentIndex = this.candidates.get(0);
                }
            }
        }

        public int index() {
            Preconditions.checkState((boolean)this.hasNext());
            return this.currentIndex;
        }

        public boolean hasNext() {
            if (this.isBruteForce) {
                return this.currentIndex < this.numEdges;
            }
            return this.currentIndexInCandidates < this.candidates.size();
        }

        public void next() {
            Preconditions.checkState((boolean)this.hasNext());
            if (this.isBruteForce) {
                ++this.currentIndex;
            } else {
                ++this.currentIndexInCandidates;
                if (this.currentIndexInCandidates < this.candidates.size()) {
                    this.currentIndex = this.candidates.get(this.currentIndexInCandidates);
                }
            }
        }
    }
}

