/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.geometry.R1Interval;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S1Interval;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Point;

public strictfp class S2EdgeUtil {
    public static final S1Angle DEFAULT_INTERSECTION_TOLERANCE = S1Angle.radians(1.5E-15);

    public static boolean simpleCrossing(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        double d;
        S2Point s2Point5 = S2Point.crossProd(s2Point, s2Point2);
        double d2 = -s2Point5.dotProd(s2Point3);
        if (d2 * (d = s2Point5.dotProd(s2Point4)) <= 0.0) {
            return false;
        }
        S2Point s2Point6 = S2Point.crossProd(s2Point3, s2Point4);
        double d3 = -s2Point6.dotProd(s2Point2);
        double d4 = s2Point6.dotProd(s2Point);
        return d2 * d3 > 0.0 && d2 * d4 > 0.0;
    }

    public static int robustCrossing(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        S2Point s2Point5 = S2Point.crossProd(s2Point, s2Point2);
        int n = -S2.robustCCW(s2Point, s2Point2, s2Point3, s2Point5);
        int n2 = S2.robustCCW(s2Point, s2Point2, s2Point4, s2Point5);
        if ((n2 & n) == 0) {
            return 0;
        }
        if (n2 != n) {
            return -1;
        }
        S2Point s2Point6 = S2Point.crossProd(s2Point3, s2Point4);
        int n3 = -S2.robustCCW(s2Point3, s2Point4, s2Point2, s2Point6);
        if (n3 != n) {
            return -1;
        }
        int n4 = S2.robustCCW(s2Point3, s2Point4, s2Point, s2Point6);
        return n4 == n ? 1 : -1;
    }

    public static boolean vertexCrossing(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        if (s2Point.equals(s2Point2) || s2Point3.equals(s2Point4)) {
            return false;
        }
        if (s2Point.equals(s2Point4)) {
            return S2.orderedCCW(S2.ortho(s2Point), s2Point3, s2Point2, s2Point);
        }
        if (s2Point2.equals(s2Point3)) {
            return S2.orderedCCW(S2.ortho(s2Point2), s2Point4, s2Point, s2Point2);
        }
        if (s2Point.equals(s2Point3)) {
            return S2.orderedCCW(S2.ortho(s2Point), s2Point4, s2Point2, s2Point);
        }
        if (s2Point2.equals(s2Point4)) {
            return S2.orderedCCW(S2.ortho(s2Point2), s2Point3, s2Point, s2Point2);
        }
        return false;
    }

    public static boolean edgeOrVertexCrossing(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        int n = S2EdgeUtil.robustCrossing(s2Point, s2Point2, s2Point3, s2Point4);
        if (n < 0) {
            return false;
        }
        if (n > 0) {
            return true;
        }
        return S2EdgeUtil.vertexCrossing(s2Point, s2Point2, s2Point3, s2Point4);
    }

    public static S2Point getIntersection(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        Preconditions.checkArgument((S2EdgeUtil.robustCrossing(s2Point, s2Point2, s2Point3, s2Point4) > 0 ? 1 : 0) != 0, (Object)"Input edges a0a1 and b0b1 muct have a true robustCrossing.");
        S2Point s2Point5 = S2Point.normalize(S2.robustCrossProd(s2Point, s2Point2));
        S2Point s2Point6 = S2Point.normalize(S2.robustCrossProd(s2Point3, s2Point4));
        S2Point s2Point7 = S2Point.normalize(S2.robustCrossProd(s2Point5, s2Point6));
        if (s2Point7.dotProd(S2Point.add(S2Point.add(s2Point, s2Point2), S2Point.add(s2Point3, s2Point4))) < 0.0) {
            s2Point7 = S2Point.neg(s2Point7);
        }
        if (S2.orderedCCW(s2Point, s2Point7, s2Point2, s2Point5) && S2.orderedCCW(s2Point3, s2Point7, s2Point4, s2Point6)) {
            return s2Point7;
        }
        CloserResult closerResult = new CloserResult(10.0, s2Point7);
        if (S2.orderedCCW(s2Point3, s2Point, s2Point4, s2Point6)) {
            closerResult.replaceIfCloser(s2Point7, s2Point);
        }
        if (S2.orderedCCW(s2Point3, s2Point2, s2Point4, s2Point6)) {
            closerResult.replaceIfCloser(s2Point7, s2Point2);
        }
        if (S2.orderedCCW(s2Point, s2Point3, s2Point2, s2Point5)) {
            closerResult.replaceIfCloser(s2Point7, s2Point3);
        }
        if (S2.orderedCCW(s2Point, s2Point4, s2Point2, s2Point5)) {
            closerResult.replaceIfCloser(s2Point7, s2Point4);
        }
        return closerResult.getVmin();
    }

    public static double getDistanceFraction(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        Preconditions.checkArgument((!s2Point2.equals(s2Point3) ? 1 : 0) != 0);
        double d = s2Point.angle(s2Point2);
        double d2 = s2Point.angle(s2Point3);
        return d / (d + d2);
    }

    public static S1Angle getDistance(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        return S2EdgeUtil.getDistance(s2Point, s2Point2, s2Point3, S2.robustCrossProd(s2Point2, s2Point3));
    }

    public static S1Angle getDistance(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4) {
        Preconditions.checkArgument((boolean)S2.isUnitLength(s2Point));
        Preconditions.checkArgument((boolean)S2.isUnitLength(s2Point2));
        Preconditions.checkArgument((boolean)S2.isUnitLength(s2Point3));
        if (S2.simpleCCW(s2Point4, s2Point2, s2Point) && S2.simpleCCW(s2Point, s2Point3, s2Point4)) {
            double d = Math.abs(s2Point.dotProd(s2Point4)) / s2Point4.norm();
            return S1Angle.radians(Math.asin(Math.min(1.0, d)));
        }
        double d = Math.min(S2Point.minus(s2Point, s2Point2).norm2(), S2Point.minus(s2Point, s2Point3).norm2());
        return S1Angle.radians(2.0 * Math.asin(Math.min(1.0, 0.5 * Math.sqrt(d))));
    }

    public static S2Point getClosestPoint(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
        Preconditions.checkArgument((boolean)S2.isUnitLength(s2Point));
        Preconditions.checkArgument((boolean)S2.isUnitLength(s2Point2));
        Preconditions.checkArgument((boolean)S2.isUnitLength(s2Point3));
        S2Point s2Point4 = S2.robustCrossProd(s2Point2, s2Point3);
        S2Point s2Point5 = S2Point.minus(s2Point, S2Point.mul(s2Point4, s2Point.dotProd(s2Point4) / s2Point4.norm2()));
        if (S2.simpleCCW(s2Point4, s2Point2, s2Point5) && S2.simpleCCW(s2Point5, s2Point3, s2Point4)) {
            return S2Point.normalize(s2Point5);
        }
        return S2Point.minus(s2Point, s2Point2).norm2() <= S2Point.minus(s2Point, s2Point3).norm2() ? s2Point2 : s2Point3;
    }

    private S2EdgeUtil() {
    }

    strictfp static class CloserResult {
        private double dmin2;
        private S2Point vmin;

        public double getDmin2() {
            return this.dmin2;
        }

        public S2Point getVmin() {
            return this.vmin;
        }

        public CloserResult(double d, S2Point s2Point) {
            this.dmin2 = d;
            this.vmin = s2Point;
        }

        public void replaceIfCloser(S2Point s2Point, S2Point s2Point2) {
            double d = S2Point.minus(s2Point, s2Point2).norm2();
            if (d < this.dmin2 || d == this.dmin2 && s2Point2.lessThan(this.vmin)) {
                this.dmin2 = d;
                this.vmin = s2Point2;
            }
        }
    }

    public strictfp static class WedgeContainsOrCrosses
    implements WedgeRelation {
        @Override
        public int test(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4, S2Point s2Point5) {
            if (S2.orderedCCW(s2Point, s2Point3, s2Point5, s2Point2)) {
                if (S2.orderedCCW(s2Point5, s2Point4, s2Point, s2Point2)) {
                    return 1;
                }
                return s2Point3.equals(s2Point5) ? 0 : -1;
            }
            return S2.orderedCCW(s2Point, s2Point4, s2Point3, s2Point2) ? 0 : -1;
        }
    }

    public strictfp static class WedgeContainsOrIntersects
    implements WedgeRelation {
        @Override
        public int test(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4, S2Point s2Point5) {
            if (S2.orderedCCW(s2Point, s2Point3, s2Point5, s2Point2)) {
                return S2.orderedCCW(s2Point5, s2Point4, s2Point, s2Point2) ? 1 : -1;
            }
            if (!S2.orderedCCW(s2Point3, s2Point4, s2Point5, s2Point2)) {
                return 0;
            }
            return s2Point3.equals(s2Point4) ? 0 : -1;
        }
    }

    public strictfp static class WedgeIntersects
    implements WedgeRelation {
        @Override
        public int test(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4, S2Point s2Point5) {
            return S2.orderedCCW(s2Point, s2Point5, s2Point4, s2Point2) && S2.orderedCCW(s2Point4, s2Point3, s2Point, s2Point2) ? 0 : -1;
        }
    }

    public strictfp static class WedgeContains
    implements WedgeRelation {
        @Override
        public int test(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4, S2Point s2Point5) {
            return S2.orderedCCW(s2Point3, s2Point5, s2Point4, s2Point2) && S2.orderedCCW(s2Point4, s2Point, s2Point3, s2Point2) ? 1 : 0;
        }
    }

    public static interface WedgeRelation {
        public int test(S2Point var1, S2Point var2, S2Point var3, S2Point var4, S2Point var5);
    }

    public strictfp static class LongitudePruner {
        private S1Interval interval;
        private double lng0;

        public LongitudePruner(S1Interval s1Interval, S2Point s2Point) {
            this.interval = s1Interval;
            this.lng0 = S2LatLng.longitude(s2Point).radians();
        }

        public boolean intersects(S2Point s2Point) {
            double d = S2LatLng.longitude(s2Point).radians();
            boolean bl = this.interval.intersects(S1Interval.fromPointPair(this.lng0, d));
            this.lng0 = d;
            return bl;
        }
    }

    public strictfp static class XYZPruner {
        private S2Point lastVertex;
        private boolean boundSet = false;
        private double xmin;
        private double ymin;
        private double zmin;
        private double xmax;
        private double ymax;
        private double zmax;
        private double maxDeformation;

        public void addEdgeToBounds(S2Point s2Point, S2Point s2Point2) {
            if (!this.boundSet) {
                this.boundSet = true;
                this.xmin = this.xmax = s2Point.x;
                this.ymin = this.ymax = s2Point.y;
                this.zmin = this.zmax = s2Point.z;
            }
            this.xmin = Math.min(this.xmin, Math.min(s2Point2.x, s2Point.x));
            this.ymin = Math.min(this.ymin, Math.min(s2Point2.y, s2Point.y));
            this.zmin = Math.min(this.zmin, Math.min(s2Point2.z, s2Point.z));
            this.xmax = Math.max(this.xmax, Math.max(s2Point2.x, s2Point.x));
            this.ymax = Math.max(this.ymax, Math.max(s2Point2.y, s2Point.y));
            this.zmax = Math.max(this.zmax, Math.max(s2Point2.z, s2Point.z));
            double d = Math.abs(s2Point.x - s2Point2.x) + Math.abs(s2Point.y - s2Point2.y) + Math.abs(s2Point.z - s2Point2.z);
            this.maxDeformation = d < 0.025 ? Math.max(this.maxDeformation, d * 0.0025) : (d < 1.0 ? Math.max(this.maxDeformation, d * 0.11) : d * 0.5);
        }

        public void setFirstIntersectPoint(S2Point s2Point) {
            this.xmin -= this.maxDeformation;
            this.ymin -= this.maxDeformation;
            this.zmin -= this.maxDeformation;
            this.xmax += this.maxDeformation;
            this.ymax += this.maxDeformation;
            this.zmax += this.maxDeformation;
            this.lastVertex = s2Point;
        }

        public boolean intersects(S2Point s2Point) {
            boolean bl = true;
            if (s2Point.x < this.xmin && this.lastVertex.x < this.xmin || s2Point.x > this.xmax && this.lastVertex.x > this.xmax) {
                bl = false;
            } else if (s2Point.y < this.ymin && this.lastVertex.y < this.ymin || s2Point.y > this.ymax && this.lastVertex.y > this.ymax) {
                bl = false;
            } else if (s2Point.z < this.zmin && this.lastVertex.z < this.zmin || s2Point.z > this.zmax && this.lastVertex.z > this.zmax) {
                bl = false;
            }
            this.lastVertex = s2Point;
            return bl;
        }
    }

    public strictfp static class RectBounder {
        private S2Point a;
        private S2LatLng aLatLng;
        private S2LatLngRect bound = S2LatLngRect.empty();

        public void addPoint(S2Point s2Point) {
            S2LatLng s2LatLng = new S2LatLng(s2Point);
            if (this.bound.isEmpty()) {
                this.bound = this.bound.addPoint(s2LatLng);
            } else {
                double d;
                this.bound = this.bound.union(S2LatLngRect.fromPointPair(this.aLatLng, s2LatLng));
                S2Point s2Point2 = S2.robustCrossProd(this.a, s2Point);
                S2Point s2Point3 = S2Point.crossProd(s2Point2, new S2Point(0.0, 0.0, 1.0));
                double d2 = s2Point3.dotProd(this.a);
                if (d2 * (d = s2Point3.dotProd(s2Point)) < 0.0) {
                    double d3 = Math.acos(Math.abs(s2Point2.get(2) / s2Point2.norm()));
                    R1Interval r1Interval = this.bound.lat();
                    r1Interval = d2 < 0.0 ? new R1Interval(r1Interval.lo(), Math.max(d3, this.bound.lat().hi())) : new R1Interval(Math.min(-d3, this.bound.lat().lo()), r1Interval.hi());
                    this.bound = new S2LatLngRect(r1Interval, this.bound.lng());
                }
            }
            this.a = s2Point;
            this.aLatLng = s2LatLng;
        }

        public S2LatLngRect getBound() {
            return this.bound;
        }
    }

    public strictfp static class EdgeCrosser {
        private final S2Point a;
        private final S2Point b;
        private final S2Point aCrossB;
        private S2Point c;
        private int acb;

        public EdgeCrosser(S2Point s2Point, S2Point s2Point2, S2Point s2Point3) {
            this.a = s2Point;
            this.b = s2Point2;
            this.aCrossB = S2Point.crossProd(s2Point, s2Point2);
            this.restartAt(s2Point3);
        }

        public void restartAt(S2Point s2Point) {
            this.c = s2Point;
            this.acb = -S2.robustCCW(this.a, this.b, s2Point, this.aCrossB);
        }

        public int robustCrossing(S2Point s2Point) {
            int n = S2.robustCCW(this.a, this.b, s2Point, this.aCrossB);
            int n2 = n == -this.acb && n != 0 ? -1 : ((n & this.acb) == 0 ? 0 : this.robustCrossingInternal(s2Point));
            this.c = s2Point;
            this.acb = -n;
            return n2;
        }

        public boolean edgeOrVertexCrossing(S2Point s2Point) {
            S2Point s2Point2 = new S2Point(this.c.get(0), this.c.get(1), this.c.get(2));
            int n = this.robustCrossing(s2Point);
            if (n < 0) {
                return false;
            }
            if (n > 0) {
                return true;
            }
            return S2EdgeUtil.vertexCrossing(this.a, this.b, s2Point2, s2Point);
        }

        private int robustCrossingInternal(S2Point s2Point) {
            S2Point s2Point2 = S2Point.crossProd(this.c, s2Point);
            int n = -S2.robustCCW(this.c, s2Point, this.b, s2Point2);
            if (n != this.acb) {
                return -1;
            }
            int n2 = S2.robustCCW(this.c, s2Point, this.a, s2Point2);
            return n2 == this.acb ? 1 : -1;
        }
    }
}

