/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2Point;

public strictfp class S2LatLng {
    public static final double EARTH_RADIUS_METERS = 6367000.0;
    public static final S2LatLng CENTER = new S2LatLng(0.0, 0.0);
    private final double latRadians;
    private final double lngRadians;

    public static S2LatLng fromRadians(double d, double d2) {
        return new S2LatLng(d, d2);
    }

    public static S2LatLng fromDegrees(double d, double d2) {
        return new S2LatLng(S1Angle.degrees(d), S1Angle.degrees(d2));
    }

    public static S2LatLng fromE5(long l, long l2) {
        return new S2LatLng(S1Angle.e5(l), S1Angle.e5(l2));
    }

    public static S2LatLng fromE6(long l, long l2) {
        return new S2LatLng(S1Angle.e6(l), S1Angle.e6(l2));
    }

    public static S2LatLng fromE7(long l, long l2) {
        return new S2LatLng(S1Angle.e7(l), S1Angle.e7(l2));
    }

    public static S1Angle latitude(S2Point s2Point) {
        return S1Angle.radians(Math.atan2(s2Point.get(2), Math.sqrt(s2Point.get(0) * s2Point.get(0) + s2Point.get(1) * s2Point.get(1))));
    }

    public static S1Angle longitude(S2Point s2Point) {
        return S1Angle.radians(Math.atan2(s2Point.get(1), s2Point.get(0)));
    }

    private S2LatLng(double d, double d2) {
        this.latRadians = d;
        this.lngRadians = d2;
    }

    public S2LatLng(S1Angle s1Angle, S1Angle s1Angle2) {
        this(s1Angle.radians(), s1Angle2.radians());
    }

    public S2LatLng() {
        this(0.0, 0.0);
    }

    public S2LatLng(S2Point s2Point) {
        this(Math.atan2(s2Point.z, Math.sqrt(s2Point.x * s2Point.x + s2Point.y * s2Point.y)), Math.atan2(s2Point.y, s2Point.x));
    }

    public S1Angle lat() {
        return S1Angle.radians(this.latRadians);
    }

    public double latRadians() {
        return this.latRadians;
    }

    public double latDegrees() {
        return 57.29577951308232 * this.latRadians;
    }

    public S1Angle lng() {
        return S1Angle.radians(this.lngRadians);
    }

    public double lngRadians() {
        return this.lngRadians;
    }

    public double lngDegrees() {
        return 57.29577951308232 * this.lngRadians;
    }

    public boolean isValid() {
        return Math.abs(this.lat().radians()) <= 1.5707963267948966 && Math.abs(this.lng().radians()) <= Math.PI;
    }

    public S2LatLng normalized() {
        return new S2LatLng(Math.max(-1.5707963267948966, Math.min(1.5707963267948966, this.lat().radians())), Math.IEEEremainder(this.lng().radians(), Math.PI * 2));
    }

    public S2Point toPoint() {
        double d = this.lat().radians();
        double d2 = this.lng().radians();
        double d3 = Math.cos(d);
        return new S2Point(Math.cos(d2) * d3, Math.sin(d2) * d3, Math.sin(d));
    }

    public S1Angle getDistance(S2LatLng s2LatLng) {
        double d = this.lat().radians();
        double d2 = s2LatLng.lat().radians();
        double d3 = this.lng().radians();
        double d4 = s2LatLng.lng().radians();
        double d5 = Math.sin(0.5 * (d2 - d));
        double d6 = Math.sin(0.5 * (d4 - d3));
        double d7 = d5 * d5 + d6 * d6 * Math.cos(d) * Math.cos(d2);
        return S1Angle.radians(2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(Math.max(0.0, 1.0 - d7))));
    }

    public double getDistance(S2LatLng s2LatLng, double d) {
        return this.getDistance(s2LatLng).radians() * d;
    }

    public double getEarthDistance(S2LatLng s2LatLng) {
        return this.getDistance(s2LatLng, 6367000.0);
    }

    public S2LatLng add(S2LatLng s2LatLng) {
        return new S2LatLng(this.latRadians + s2LatLng.latRadians, this.lngRadians + s2LatLng.lngRadians);
    }

    public S2LatLng sub(S2LatLng s2LatLng) {
        return new S2LatLng(this.latRadians - s2LatLng.latRadians, this.lngRadians - s2LatLng.lngRadians);
    }

    public S2LatLng mul(double d) {
        return new S2LatLng(this.latRadians * d, this.lngRadians * d);
    }

    public boolean equals(Object object) {
        if (object instanceof S2LatLng) {
            S2LatLng s2LatLng = (S2LatLng)object;
            return this.latRadians == s2LatLng.latRadians && this.lngRadians == s2LatLng.lngRadians;
        }
        return false;
    }

    public int hashCode() {
        long l = 17L;
        l += 37L * l + Double.doubleToLongBits(this.latRadians);
        l += 37L * l + Double.doubleToLongBits(this.lngRadians);
        return (int)(l ^ l >>> 32);
    }

    public boolean approxEquals(S2LatLng s2LatLng, double d) {
        return Math.abs(this.latRadians - s2LatLng.latRadians) < d && Math.abs(this.lngRadians - s2LatLng.lngRadians) < d;
    }

    public boolean approxEquals(S2LatLng s2LatLng) {
        return this.approxEquals(s2LatLng, 1.0E-9);
    }

    public String toString() {
        return "(" + this.latRadians + ", " + this.lngRadians + ")";
    }

    public String toStringDegrees() {
        return "(" + this.latDegrees() + ", " + this.lngDegrees() + ")";
    }
}

