/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.geometry.R1Interval;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S1Interval;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Region;

public strictfp class S2LatLngRect
implements S2Region {
    private final R1Interval lat;
    private final S1Interval lng;

    public S2LatLngRect(S2LatLng s2LatLng, S2LatLng s2LatLng2) {
        this.lat = new R1Interval(s2LatLng.lat().radians(), s2LatLng2.lat().radians());
        this.lng = new S1Interval(s2LatLng.lng().radians(), s2LatLng2.lng().radians());
    }

    public S2LatLngRect(R1Interval r1Interval, S1Interval s1Interval) {
        this.lat = r1Interval;
        this.lng = s1Interval;
    }

    public static S2LatLngRect empty() {
        return new S2LatLngRect(R1Interval.empty(), S1Interval.empty());
    }

    public static S2LatLngRect full() {
        return new S2LatLngRect(S2LatLngRect.fullLat(), S2LatLngRect.fullLng());
    }

    public static R1Interval fullLat() {
        return new R1Interval(-1.5707963267948966, 1.5707963267948966);
    }

    public static S1Interval fullLng() {
        return S1Interval.full();
    }

    public static S2LatLngRect fromCenterSize(S2LatLng s2LatLng, S2LatLng s2LatLng2) {
        return S2LatLngRect.fromPoint(s2LatLng).expanded(s2LatLng2.mul(0.5));
    }

    public static S2LatLngRect fromPoint(S2LatLng s2LatLng) {
        return new S2LatLngRect(s2LatLng, s2LatLng);
    }

    public static S2LatLngRect fromPointPair(S2LatLng s2LatLng, S2LatLng s2LatLng2) {
        return new S2LatLngRect(R1Interval.fromPointPair(s2LatLng.lat().radians(), s2LatLng2.lat().radians()), S1Interval.fromPointPair(s2LatLng.lng().radians(), s2LatLng2.lng().radians()));
    }

    public static S2LatLngRect fromEdge(S2Point s2Point, S2Point s2Point2) {
        double d;
        S2LatLngRect s2LatLngRect = S2LatLngRect.fromPointPair(new S2LatLng(s2Point), new S2LatLng(s2Point2));
        S2Point s2Point3 = S2.robustCrossProd(s2Point, s2Point2);
        S2Point s2Point4 = S2Point.crossProd(s2Point3, new S2Point(0.0, 0.0, 1.0));
        double d2 = s2Point4.dotProd(s2Point);
        if (d2 * (d = s2Point4.dotProd(s2Point2)) >= 0.0) {
            return s2LatLngRect;
        }
        double d3 = Math.acos(Math.abs(s2Point3.z / s2Point3.norm()));
        if (d2 < 0.0) {
            return new S2LatLngRect(new R1Interval(s2LatLngRect.lat().lo(), d3), s2LatLngRect.lng());
        }
        return new S2LatLngRect(new R1Interval(-d3, s2LatLngRect.lat().hi()), s2LatLngRect.lng());
    }

    public boolean isValid() {
        return Math.abs(this.lat.lo()) <= 1.5707963267948966 && Math.abs(this.lat.hi()) <= 1.5707963267948966 && this.lng.isValid() && this.lat.isEmpty() == this.lng.isEmpty();
    }

    public S1Angle latLo() {
        return S1Angle.radians(this.lat.lo());
    }

    public S1Angle latHi() {
        return S1Angle.radians(this.lat.hi());
    }

    public S1Angle lngLo() {
        return S1Angle.radians(this.lng.lo());
    }

    public S1Angle lngHi() {
        return S1Angle.radians(this.lng.hi());
    }

    public R1Interval lat() {
        return this.lat;
    }

    public S1Interval lng() {
        return this.lng;
    }

    public S2LatLng lo() {
        return new S2LatLng(this.latLo(), this.lngLo());
    }

    public S2LatLng hi() {
        return new S2LatLng(this.latHi(), this.lngHi());
    }

    public boolean isEmpty() {
        return this.lat.isEmpty();
    }

    public boolean isFull() {
        return this.lat.equals(S2LatLngRect.fullLat()) && this.lng.isFull();
    }

    public boolean isInverted() {
        return this.lng.isInverted();
    }

    public S2LatLng getVertex(int n) {
        switch (n) {
            case 0: {
                return S2LatLng.fromRadians(this.lat.lo(), this.lng.lo());
            }
            case 1: {
                return S2LatLng.fromRadians(this.lat.lo(), this.lng.hi());
            }
            case 2: {
                return S2LatLng.fromRadians(this.lat.hi(), this.lng.hi());
            }
            case 3: {
                return S2LatLng.fromRadians(this.lat.hi(), this.lng.lo());
            }
        }
        throw new IllegalArgumentException("Invalid vertex index.");
    }

    public S2LatLng getCenter() {
        return S2LatLng.fromRadians(this.lat.getCenter(), this.lng.getCenter());
    }

    public S1Angle getDistance(S2LatLng s2LatLng) {
        S2LatLngRect s2LatLngRect = this;
        Preconditions.checkState((!s2LatLngRect.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)s2LatLng.isValid());
        if (s2LatLngRect.lng().contains(s2LatLng.lng().radians())) {
            return S1Angle.radians(Math.max(0.0, Math.max(s2LatLng.lat().radians() - s2LatLngRect.lat().hi(), s2LatLngRect.lat().lo() - s2LatLng.lat().radians())));
        }
        S1Interval s1Interval = new S1Interval(s2LatLngRect.lng().hi(), s2LatLngRect.lng().complement().getCenter());
        double d = s2LatLngRect.lng().lo();
        if (s1Interval.contains(s2LatLng.lng().radians())) {
            d = s2LatLngRect.lng().hi();
        }
        S2Point s2Point = S2LatLng.fromRadians(s2LatLngRect.lat().lo(), d).toPoint();
        S2Point s2Point2 = S2LatLng.fromRadians(s2LatLngRect.lat().hi(), d).toPoint();
        S2Point s2Point3 = S2LatLng.fromRadians(0.0, d - 1.5707963267948966).normalized().toPoint();
        return S2EdgeUtil.getDistance(s2LatLng.toPoint(), s2Point, s2Point2, s2Point3);
    }

    public S1Angle getDistance(S2LatLngRect s2LatLngRect) {
        S1Angle s1Angle;
        S1Angle s1Angle2;
        S2LatLngRect s2LatLngRect2 = this;
        S2LatLngRect s2LatLngRect3 = s2LatLngRect;
        Preconditions.checkState((!s2LatLngRect2.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!s2LatLngRect3.isEmpty() ? 1 : 0) != 0);
        if (s2LatLngRect2.lng().intersects(s2LatLngRect3.lng())) {
            S1Angle s1Angle3;
            S1Angle s1Angle4;
            if (s2LatLngRect2.lat().intersects(s2LatLngRect3.lat())) {
                return S1Angle.radians(0.0);
            }
            if (s2LatLngRect2.lat().lo() > s2LatLngRect3.lat().hi()) {
                s1Angle4 = s2LatLngRect3.latHi();
                s1Angle3 = s2LatLngRect2.latLo();
            } else {
                s1Angle4 = s2LatLngRect2.latHi();
                s1Angle3 = s2LatLngRect3.latLo();
            }
            return S1Angle.radians(s1Angle3.radians() - s1Angle4.radians());
        }
        S1Interval s1Interval = S1Interval.fromPointPair(s2LatLngRect2.lng().lo(), s2LatLngRect3.lng().hi());
        S1Interval s1Interval2 = S1Interval.fromPointPair(s2LatLngRect2.lng().hi(), s2LatLngRect3.lng().lo());
        if (s1Interval.getLength() < s1Interval2.getLength()) {
            s1Angle2 = s2LatLngRect2.lngLo();
            s1Angle = s2LatLngRect3.lngHi();
        } else {
            s1Angle2 = s2LatLngRect2.lngHi();
            s1Angle = s2LatLngRect3.lngLo();
        }
        S2Point s2Point = new S2LatLng(s2LatLngRect2.latLo(), s1Angle2).toPoint();
        S2Point s2Point2 = new S2LatLng(s2LatLngRect2.latHi(), s1Angle2).toPoint();
        S2Point s2Point3 = S2LatLng.fromRadians(0.0, s1Angle2.radians() - 1.5707963267948966).normalized().toPoint();
        S2Point s2Point4 = new S2LatLng(s2LatLngRect3.latLo(), s1Angle).toPoint();
        S2Point s2Point5 = new S2LatLng(s2LatLngRect3.latHi(), s1Angle).toPoint();
        S2Point s2Point6 = S2LatLng.fromRadians(0.0, s1Angle.radians() - 1.5707963267948966).normalized().toPoint();
        return S1Angle.min(S2EdgeUtil.getDistance(s2Point, s2Point4, s2Point5, s2Point6), S1Angle.min(S2EdgeUtil.getDistance(s2Point2, s2Point4, s2Point5, s2Point6), S1Angle.min(S2EdgeUtil.getDistance(s2Point4, s2Point, s2Point2, s2Point3), S2EdgeUtil.getDistance(s2Point5, s2Point, s2Point2, s2Point3))));
    }

    public S2LatLng getSize() {
        return S2LatLng.fromRadians(this.lat.getLength(), this.lng.getLength());
    }

    public boolean contains(S2LatLng s2LatLng) {
        return this.lat.contains(s2LatLng.lat().radians()) && this.lng.contains(s2LatLng.lng().radians());
    }

    public boolean interiorContains(S2Point s2Point) {
        return this.interiorContains(new S2LatLng(s2Point));
    }

    public boolean interiorContains(S2LatLng s2LatLng) {
        return this.lat.interiorContains(s2LatLng.lat().radians()) && this.lng.interiorContains(s2LatLng.lng().radians());
    }

    public boolean contains(S2LatLngRect s2LatLngRect) {
        return this.lat.contains(s2LatLngRect.lat) && this.lng.contains(s2LatLngRect.lng);
    }

    public boolean interiorContains(S2LatLngRect s2LatLngRect) {
        return this.lat.interiorContains(s2LatLngRect.lat) && this.lng.interiorContains(s2LatLngRect.lng);
    }

    public boolean intersects(S2LatLngRect s2LatLngRect) {
        return this.lat.intersects(s2LatLngRect.lat) && this.lng.intersects(s2LatLngRect.lng);
    }

    public boolean intersects(S2Cell s2Cell) {
        int n;
        if (this.isEmpty()) {
            return false;
        }
        if (this.contains(s2Cell.getCenter())) {
            return true;
        }
        if (s2Cell.contains(this.getCenter().toPoint())) {
            return true;
        }
        if (!this.intersects(s2Cell.getRectBound())) {
            return false;
        }
        S2Point[] s2PointArray = new S2Point[4];
        S2LatLng[] s2LatLngArray = new S2LatLng[4];
        for (n = 0; n < 4; ++n) {
            s2PointArray[n] = s2Cell.getVertex(n);
            s2LatLngArray[n] = new S2LatLng(s2PointArray[n]);
            if (!this.contains(s2LatLngArray[n])) continue;
            return true;
        }
        for (n = 0; n < 4; ++n) {
            S1Interval s1Interval = S1Interval.fromPointPair(s2LatLngArray[n].lng().radians(), s2LatLngArray[n + 1 & 3].lng().radians());
            if (!this.lng.intersects(s1Interval)) continue;
            S2Point s2Point = s2PointArray[n];
            S2Point s2Point2 = s2PointArray[n + 1 & 3];
            if (s1Interval.contains(this.lng.lo()) && S2LatLngRect.intersectsLngEdge(s2Point, s2Point2, this.lat, this.lng.lo())) {
                return true;
            }
            if (s1Interval.contains(this.lng.hi()) && S2LatLngRect.intersectsLngEdge(s2Point, s2Point2, this.lat, this.lng.hi())) {
                return true;
            }
            if (S2LatLngRect.intersectsLatEdge(s2Point, s2Point2, this.lat.lo(), this.lng)) {
                return true;
            }
            if (!S2LatLngRect.intersectsLatEdge(s2Point, s2Point2, this.lat.hi(), this.lng)) continue;
            return true;
        }
        return false;
    }

    public boolean interiorIntersects(S2LatLngRect s2LatLngRect) {
        return this.lat.interiorIntersects(s2LatLngRect.lat) && this.lng.interiorIntersects(s2LatLngRect.lng);
    }

    public S2LatLngRect addPoint(S2Point s2Point) {
        return this.addPoint(new S2LatLng(s2Point));
    }

    public S2LatLngRect addPoint(S2LatLng s2LatLng) {
        R1Interval r1Interval = this.lat.addPoint(s2LatLng.lat().radians());
        S1Interval s1Interval = this.lng.addPoint(s2LatLng.lng().radians());
        return new S2LatLngRect(r1Interval, s1Interval);
    }

    public S2LatLngRect expanded(S2LatLng s2LatLng) {
        if (this.isEmpty()) {
            return this;
        }
        return new S2LatLngRect(this.lat.expanded(s2LatLng.lat().radians()).intersection(S2LatLngRect.fullLat()), this.lng.expanded(s2LatLng.lng().radians()));
    }

    public S2LatLngRect union(S2LatLngRect s2LatLngRect) {
        return new S2LatLngRect(this.lat.union(s2LatLngRect.lat), this.lng.union(s2LatLngRect.lng));
    }

    public S2LatLngRect intersection(S2LatLngRect s2LatLngRect) {
        R1Interval r1Interval = this.lat.intersection(s2LatLngRect.lat);
        S1Interval s1Interval = this.lng.intersection(s2LatLngRect.lng);
        if (r1Interval.isEmpty() || s1Interval.isEmpty()) {
            return S2LatLngRect.empty();
        }
        return new S2LatLngRect(r1Interval, s1Interval);
    }

    public S2LatLngRect convolveWithCap(S1Angle s1Angle) {
        S2Cap s2Cap = S2Cap.fromAxisAngle(new S2Point(1.0, 0.0, 0.0), s1Angle);
        S2LatLngRect s2LatLngRect = this;
        for (int i = 0; i < 4; ++i) {
            S2Cap s2Cap2 = S2Cap.fromAxisHeight(this.getVertex(i).toPoint(), s2Cap.height());
            s2LatLngRect = s2LatLngRect.union(s2Cap2.getRectBound());
        }
        return s2LatLngRect;
    }

    public double area() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return this.lng().getLength() * Math.abs(Math.sin(this.latHi().radians()) - Math.sin(this.latLo().radians()));
    }

    public boolean equals(Object object) {
        if (!(object instanceof S2LatLngRect)) {
            return false;
        }
        S2LatLngRect s2LatLngRect = (S2LatLngRect)object;
        return this.lat().equals(s2LatLngRect.lat()) && this.lng().equals(s2LatLngRect.lng());
    }

    public boolean approxEquals(S2LatLngRect s2LatLngRect, double d) {
        return this.lat.approxEquals(s2LatLngRect.lat, d) && this.lng.approxEquals(s2LatLngRect.lng, d);
    }

    public boolean approxEquals(S2LatLngRect s2LatLngRect) {
        return this.approxEquals(s2LatLngRect, 1.0E-15);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.lat.hashCode();
        return 37 * n + this.lng.hashCode();
    }

    public S2Region clone() {
        return new S2LatLngRect(this.lo(), this.hi());
    }

    @Override
    public S2Cap getCapBound() {
        double d;
        double d2;
        if (this.isEmpty()) {
            return S2Cap.empty();
        }
        if (this.lat.lo() + this.lat.hi() < 0.0) {
            d2 = -1.0;
            d = 1.5707963267948966 + this.lat.hi();
        } else {
            d2 = 1.0;
            d = 1.5707963267948966 - this.lat.lo();
        }
        S2Cap s2Cap = S2Cap.fromAxisAngle(new S2Point(0.0, 0.0, d2), S1Angle.radians(d));
        double d3 = this.lng.hi() - this.lng.lo();
        if (Math.IEEEremainder(d3, Math.PI * 2) >= 0.0 && d3 < Math.PI * 2) {
            S2Cap s2Cap2 = S2Cap.fromAxisAngle(this.getCenter().toPoint(), S1Angle.radians(0.0));
            for (int i = 0; i < 4; ++i) {
                s2Cap2 = s2Cap2.addPoint(this.getVertex(i).toPoint());
            }
            if (s2Cap2.height() < s2Cap.height()) {
                return s2Cap2;
            }
        }
        return s2Cap;
    }

    @Override
    public S2LatLngRect getRectBound() {
        return this;
    }

    @Override
    public boolean contains(S2Cell s2Cell) {
        return this.contains(s2Cell.getRectBound());
    }

    @Override
    public boolean mayIntersect(S2Cell s2Cell) {
        return this.intersects(s2Cell.getRectBound());
    }

    public boolean contains(S2Point s2Point) {
        return this.contains(new S2LatLng(s2Point));
    }

    private static boolean intersectsLngEdge(S2Point s2Point, S2Point s2Point2, R1Interval r1Interval, double d) {
        return S2.simpleCrossing(s2Point, s2Point2, S2LatLng.fromRadians(r1Interval.lo(), d).toPoint(), S2LatLng.fromRadians(r1Interval.hi(), d).toPoint());
    }

    private static boolean intersectsLatEdge(S2Point s2Point, S2Point s2Point2, double d, S1Interval s1Interval) {
        S2Point s2Point3;
        S2Point s2Point4 = S2Point.normalize(S2.robustCrossProd(s2Point, s2Point2));
        if (s2Point4.z < 0.0) {
            s2Point4 = S2Point.neg(s2Point4);
        }
        S2Point s2Point5 = S2Point.normalize(S2.robustCrossProd(s2Point4, new S2Point(0.0, 0.0, 1.0)));
        S2Point s2Point6 = S2Point.crossProd(s2Point5, s2Point4);
        double d2 = Math.sin(d);
        if (Math.abs(d2) >= s2Point6.z) {
            return false;
        }
        double d3 = d2 / s2Point6.z;
        double d4 = Math.sqrt(1.0 - d3 * d3);
        double d5 = Math.atan2(d4, d3);
        S1Interval s1Interval2 = S1Interval.fromPointPair(Math.atan2(s2Point.dotProd(s2Point5), s2Point.dotProd(s2Point6)), Math.atan2(s2Point2.dotProd(s2Point5), s2Point2.dotProd(s2Point6)));
        if (s1Interval2.contains(d5)) {
            s2Point3 = S2Point.add(S2Point.mul(s2Point6, d3), S2Point.mul(s2Point5, d4));
            if (s1Interval.contains(Math.atan2(s2Point3.y, s2Point3.x))) {
                return true;
            }
        }
        if (s1Interval2.contains(-d5)) {
            s2Point3 = S2Point.sub(S2Point.mul(s2Point6, d3), S2Point.mul(s2Point5, d4));
            if (s1Interval.contains(Math.atan2(s2Point3.y, s2Point3.x))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "[Lo=" + this.lo() + ", Hi=" + this.hi() + "]";
    }
}

