/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.geometry.R1Interval;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S1Interval;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2AreaCentroid;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2EdgeIndex;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Region;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public strictfp final class S2Loop
implements S2Region,
Comparable<S2Loop> {
    private static final Logger log = Logger.getLogger(S2Loop.class.getCanonicalName());
    public static final double MAX_INTERSECTION_ERROR = 1.0E-15;
    private S2EdgeIndex index;
    private Map<S2Point, Integer> vertexToIndex;
    private final S2Point[] vertices;
    private final int numVertices;
    private int firstLogicalVertex;
    private S2LatLngRect bound;
    private boolean originInside;
    private int depth;

    public S2Loop(List<S2Point> list) {
        this.numVertices = list.size();
        this.vertices = new S2Point[this.numVertices];
        this.bound = S2LatLngRect.full();
        this.depth = 0;
        list.toArray(this.vertices);
        this.initOrigin();
        this.initBound();
        this.initFirstLogicalVertex();
    }

    public S2Loop(S2Cell s2Cell) {
        this(s2Cell, s2Cell.getRectBound());
    }

    public S2Loop(S2Cell s2Cell, S2LatLngRect s2LatLngRect) {
        this.bound = s2LatLngRect;
        this.numVertices = 4;
        this.vertices = new S2Point[this.numVertices];
        this.vertexToIndex = null;
        this.index = null;
        this.depth = 0;
        for (int i = 0; i < 4; ++i) {
            this.vertices[i] = s2Cell.getVertex(i);
        }
        this.initOrigin();
        this.initFirstLogicalVertex();
    }

    public S2Loop(S2Loop s2Loop) {
        this.numVertices = s2Loop.numVertices();
        this.vertices = (S2Point[])s2Loop.vertices.clone();
        this.vertexToIndex = s2Loop.vertexToIndex;
        this.index = s2Loop.index;
        this.firstLogicalVertex = s2Loop.firstLogicalVertex;
        this.bound = s2Loop.getRectBound();
        this.originInside = s2Loop.originInside;
        this.depth = s2Loop.depth();
    }

    public int depth() {
        return this.depth;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public boolean isHole() {
        return (this.depth & 1) != 0;
    }

    public int sign() {
        return this.isHole() ? -1 : 1;
    }

    public int numVertices() {
        return this.numVertices;
    }

    public S2Point vertex(int n) {
        try {
            return this.vertices[n >= this.vertices.length ? n - this.vertices.length : n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalStateException("Invalid vertex index");
        }
    }

    @Override
    public int compareTo(S2Loop s2Loop) {
        if (this.numVertices() != s2Loop.numVertices()) {
            return this.numVertices() - s2Loop.numVertices();
        }
        int n = this.numVertices();
        int n2 = this.firstLogicalVertex;
        int n3 = s2Loop.firstLogicalVertex;
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.vertex(n2).compareTo(s2Loop.vertex(n3));
            if (n5 != 0) {
                return n5;
            }
            ++n4;
            ++n2;
            ++n3;
        }
        return 0;
    }

    private void initFirstLogicalVertex() {
        int n = 0;
        for (int i = 1; i < this.numVertices; ++i) {
            if (this.vertex(i).compareTo(this.vertex(n)) >= 0) continue;
            n = i;
        }
        this.firstLogicalVertex = n;
    }

    public boolean isNormalized() {
        return this.getArea() <= 6.283185307179596;
    }

    public void normalize() {
        if (!this.isNormalized()) {
            this.invert();
        }
    }

    public void invert() {
        int n = this.numVertices() - 1;
        for (int i = (n - 1) / 2; i >= 0; --i) {
            S2Point s2Point = this.vertices[i];
            this.vertices[i] = this.vertices[n - i];
            this.vertices[n - i] = s2Point;
        }
        this.vertexToIndex = null;
        this.index = null;
        this.originInside ^= true;
        if (this.bound.lat().lo() > -1.5707963267948966 && this.bound.lat().hi() < 1.5707963267948966) {
            this.bound = S2LatLngRect.full();
        } else {
            this.initBound();
        }
        this.initFirstLogicalVertex();
    }

    private S2AreaCentroid getAreaCentroid(boolean bl) {
        S2Point s2Point = null;
        if (this.numVertices() < 3) {
            return new S2AreaCentroid(0.0, s2Point);
        }
        S2Point s2Point2 = this.vertex(0);
        int n = (s2Point2.largestAbsComponent() + 1) % 3;
        double d = s2Point2.get(n) + 2.718281828459045E-10;
        s2Point2 = new S2Point(n == 0 ? d : s2Point2.x, n == 1 ? d : s2Point2.y, n == 2 ? d : s2Point2.z);
        s2Point2 = S2Point.normalize(s2Point2);
        double d2 = 0.0;
        S2Point s2Point3 = new S2Point(0.0, 0.0, 0.0);
        for (int i = 1; i <= this.numVertices(); ++i) {
            d2 += S2.signedArea(s2Point2, this.vertex(i - 1), this.vertex(i));
            if (!bl) continue;
            S2Point s2Point4 = S2.trueCentroid(s2Point2, this.vertex(i - 1), this.vertex(i));
            s2Point3 = S2Point.add(s2Point3, s2Point4);
        }
        if (d2 < 0.0) {
            d2 += Math.PI * 4;
        }
        if (bl) {
            s2Point = s2Point3;
        }
        return new S2AreaCentroid(d2, s2Point);
    }

    public S2AreaCentroid getAreaAndCentroid() {
        return this.getAreaCentroid(true);
    }

    public double getArea() {
        return this.getAreaCentroid(false).getArea();
    }

    public S2Point getCentroid() {
        return this.getAreaCentroid(true).getCentroid();
    }

    public boolean contains(S2Loop s2Loop) {
        if (!this.bound.contains(s2Loop.getRectBound())) {
            return false;
        }
        if (!this.contains(s2Loop.vertex(0)) && this.findVertex(s2Loop.vertex(0)) < 0) {
            return false;
        }
        if (this.checkEdgeCrossings(s2Loop, new S2EdgeUtil.WedgeContains()) <= 0) {
            return false;
        }
        return !this.bound.union(s2Loop.getRectBound()).isFull() || !s2Loop.contains(this.vertex(0)) || s2Loop.findVertex(this.vertex(0)) >= 0;
    }

    public boolean intersects(S2Loop s2Loop) {
        if (!this.bound.intersects(s2Loop.getRectBound())) {
            return false;
        }
        if (s2Loop.getRectBound().lng().getLength() > this.bound.lng().getLength()) {
            return s2Loop.intersects(this);
        }
        if (this.contains(s2Loop.vertex(0)) && this.findVertex(s2Loop.vertex(0)) < 0) {
            return true;
        }
        if (this.checkEdgeCrossings(s2Loop, new S2EdgeUtil.WedgeIntersects()) < 0) {
            return true;
        }
        return s2Loop.getRectBound().contains(this.bound) && s2Loop.contains(this.vertex(0)) && s2Loop.findVertex(this.vertex(0)) < 0;
    }

    public boolean containsNested(S2Loop s2Loop) {
        if (!this.bound.contains(s2Loop.getRectBound())) {
            return false;
        }
        int n = this.findVertex(s2Loop.vertex(1));
        if (n < 0) {
            return this.contains(s2Loop.vertex(1));
        }
        return new S2EdgeUtil.WedgeContains().test(this.vertex(n - 1), this.vertex(n), this.vertex(n + 1), s2Loop.vertex(0), s2Loop.vertex(2)) > 0;
    }

    public int containsOrCrosses(S2Loop s2Loop) {
        if (!this.bound.intersects(s2Loop.getRectBound())) {
            return 0;
        }
        int n = this.checkEdgeCrossings(s2Loop, new S2EdgeUtil.WedgeContainsOrCrosses());
        if (n <= 0) {
            return n;
        }
        if (!this.bound.contains(s2Loop.getRectBound())) {
            return 0;
        }
        if (!this.contains(s2Loop.vertex(0)) && this.findVertex(s2Loop.vertex(0)) < 0) {
            return 0;
        }
        return 1;
    }

    boolean boundaryApproxEquals(S2Loop s2Loop, double d) {
        if (this.numVertices() != s2Loop.numVertices()) {
            return false;
        }
        int n = this.numVertices();
        int n2 = this.firstLogicalVertex;
        int n3 = s2Loop.firstLogicalVertex;
        int n4 = 0;
        while (n4 < n) {
            if (!S2.approxEquals(this.vertex(n2), s2Loop.vertex(n3), d)) {
                return false;
            }
            ++n4;
            ++n2;
            ++n3;
        }
        return true;
    }

    @Override
    public S2Cap getCapBound() {
        return this.bound.getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        return this.bound;
    }

    @Override
    public boolean contains(S2Cell s2Cell) {
        S2LatLngRect s2LatLngRect = s2Cell.getRectBound();
        if (!this.bound.contains(s2LatLngRect)) {
            return false;
        }
        S2Loop s2Loop = new S2Loop(s2Cell, s2LatLngRect);
        return this.contains(s2Loop);
    }

    @Override
    public boolean mayIntersect(S2Cell s2Cell) {
        S2LatLngRect s2LatLngRect = s2Cell.getRectBound();
        if (!this.bound.intersects(s2LatLngRect)) {
            return false;
        }
        return new S2Loop(s2Cell, s2LatLngRect).intersects(this);
    }

    public boolean contains(S2Point s2Point) {
        if (!this.bound.contains(s2Point)) {
            return false;
        }
        boolean bl = this.originInside;
        S2Point s2Point2 = S2.origin();
        S2EdgeUtil.EdgeCrosser edgeCrosser = new S2EdgeUtil.EdgeCrosser(s2Point2, s2Point, this.vertices[this.numVertices - 1]);
        if (this.numVertices < 2000) {
            for (int i = 0; i < this.numVertices; ++i) {
                bl ^= edgeCrosser.edgeOrVertexCrossing(this.vertices[i]);
            }
        } else {
            S2EdgeIndex.DataEdgeIterator dataEdgeIterator = this.getEdgeIterator(this.numVertices);
            int n = -2;
            dataEdgeIterator.getCandidates(s2Point2, s2Point);
            while (dataEdgeIterator.hasNext()) {
                int n2 = dataEdgeIterator.index();
                if (n != n2 - 1) {
                    edgeCrosser.restartAt(this.vertices[n2]);
                }
                n = n2;
                bl ^= edgeCrosser.edgeOrVertexCrossing(this.vertex(n2 + 1));
                dataEdgeIterator.next();
            }
        }
        return bl;
    }

    public S1Angle getDistance(S2Point s2Point) {
        S2Point s2Point2 = S2Point.normalize(s2Point);
        S1Angle s1Angle = S1Angle.radians(Math.PI);
        for (int i = 0; i < this.numVertices(); ++i) {
            s1Angle = S1Angle.min(s1Angle, S2EdgeUtil.getDistance(s2Point2, this.vertex(i), this.vertex(i + 1)));
        }
        return s1Angle;
    }

    private final S2EdgeIndex.DataEdgeIterator getEdgeIterator(int n) {
        if (this.index == null) {
            this.index = new S2EdgeIndex(){

                @Override
                protected int getNumEdges() {
                    return S2Loop.this.numVertices;
                }

                @Override
                protected S2Point edgeFrom(int n) {
                    return S2Loop.this.vertex(n);
                }

                @Override
                protected S2Point edgeTo(int n) {
                    return S2Loop.this.vertex(n + 1);
                }
            };
        }
        this.index.predictAdditionalCalls(n);
        return new S2EdgeIndex.DataEdgeIterator(this.index);
    }

    public boolean isValid() {
        Object object;
        int n;
        if (this.numVertices < 3) {
            log.info("Degenerate loop");
            return false;
        }
        for (int i = 0; i < this.numVertices; ++i) {
            if (S2.isUnitLength(this.vertex(i))) continue;
            log.info("Vertex " + i + " is not unit length");
            return false;
        }
        HashMap hashMap = Maps.newHashMap();
        for (n = 0; n < this.numVertices; ++n) {
            object = hashMap.put(this.vertex(n), n);
            if (object == null) continue;
            log.info("Duplicate vertices: " + object + " and " + n);
            return false;
        }
        n = 0;
        object = this.getEdgeIterator(this.numVertices);
        for (int i = 0; i < this.numVertices; ++i) {
            int n2 = (i + 1) % this.numVertices;
            S2EdgeUtil.EdgeCrosser edgeCrosser = new S2EdgeUtil.EdgeCrosser(this.vertex(i), this.vertex(n2), this.vertex(0));
            int n3 = -2;
            ((S2EdgeIndex.DataEdgeIterator)object).getCandidates(this.vertex(i), this.vertex(n2));
            while (((S2EdgeIndex.DataEdgeIterator)object).hasNext()) {
                int n4 = ((S2EdgeIndex.DataEdgeIterator)object).index();
                int n5 = (n4 + 1) % this.numVertices;
                if (i != n5 && n2 != n4 && i != n4) {
                    boolean bl;
                    double d = S2.angle(this.vertex(i), this.vertex(n2), this.vertex(n4));
                    boolean bl2 = S2.approxEquals(d, 0.0, 1.0E-15) || S2.approxEquals(d, Math.PI, 1.0E-15);
                    double d2 = S2.angle(this.vertex(i), this.vertex(n2), this.vertex(n5));
                    boolean bl3 = bl = S2.approxEquals(d2, 0.0, 1.0E-15) || S2.approxEquals(d2, Math.PI, 1.0E-15);
                    if (!bl2 || !bl) {
                        if (n3 != n4) {
                            edgeCrosser.restartAt(this.vertex(n4));
                        }
                        n = edgeCrosser.robustCrossing(this.vertex(n5)) > 0 ? 1 : 0;
                        n3 = n5;
                        if (n != 0) {
                            log.info("Edges " + i + " and " + n4 + " cross");
                            log.info(String.format("Edge locations in degrees: %s-%s and %s-%s", new S2LatLng(this.vertex(i)).toStringDegrees(), new S2LatLng(this.vertex(n2)).toStringDegrees(), new S2LatLng(this.vertex(n4)).toStringDegrees(), new S2LatLng(this.vertex(n5)).toStringDegrees()));
                            return false;
                        }
                    }
                }
                ((S2EdgeIndex.DataEdgeIterator)object).next();
            }
        }
        return true;
    }

    public static boolean isValid(List<S2Point> list) {
        return new S2Loop(list).isValid();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("S2Loop, ");
        stringBuilder.append(this.vertices.length).append(" points. [");
        for (S2Point s2Point : this.vertices) {
            stringBuilder.append(s2Point.toString()).append(" ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void initOrigin() {
        Preconditions.checkState((boolean)this.bound.contains(this.vertex(1)));
        this.originInside = false;
        boolean bl = S2.orderedCCW(S2.ortho(this.vertex(1)), this.vertex(0), this.vertex(2), this.vertex(1));
        if (bl != this.contains(this.vertex(1))) {
            this.originInside = true;
        }
    }

    private void initBound() {
        S2EdgeUtil.RectBounder rectBounder = new S2EdgeUtil.RectBounder();
        for (int i = 0; i <= this.numVertices(); ++i) {
            rectBounder.addPoint(this.vertex(i));
        }
        S2LatLngRect s2LatLngRect = rectBounder.getBound();
        this.bound = S2LatLngRect.full();
        if (this.contains(new S2Point(0.0, 0.0, 1.0))) {
            s2LatLngRect = new S2LatLngRect(new R1Interval(s2LatLngRect.lat().lo(), 1.5707963267948966), S1Interval.full());
        }
        if (s2LatLngRect.lng().isFull() && this.contains(new S2Point(0.0, 0.0, -1.0))) {
            s2LatLngRect = new S2LatLngRect(new R1Interval(-1.5707963267948966, s2LatLngRect.lat().hi()), s2LatLngRect.lng());
        }
        this.bound = s2LatLngRect;
    }

    private int findVertex(S2Point s2Point) {
        Integer n;
        if (this.vertexToIndex == null) {
            this.vertexToIndex = new HashMap<S2Point, Integer>();
            for (int i = 1; i <= this.numVertices; ++i) {
                this.vertexToIndex.put(this.vertex(i), i);
            }
        }
        if ((n = this.vertexToIndex.get(s2Point)) == null) {
            return -1;
        }
        return n;
    }

    private int checkEdgeCrossings(S2Loop s2Loop, S2EdgeUtil.WedgeRelation wedgeRelation) {
        S2EdgeIndex.DataEdgeIterator dataEdgeIterator = this.getEdgeIterator(s2Loop.numVertices);
        int n = 1;
        for (int i = 0; i < s2Loop.numVertices(); ++i) {
            S2EdgeUtil.EdgeCrosser edgeCrosser = new S2EdgeUtil.EdgeCrosser(s2Loop.vertex(i), s2Loop.vertex(i + 1), this.vertex(0));
            int n2 = -2;
            dataEdgeIterator.getCandidates(s2Loop.vertex(i), s2Loop.vertex(i + 1));
            while (dataEdgeIterator.hasNext()) {
                int n3 = dataEdgeIterator.index();
                if (n2 != n3 - 1) {
                    edgeCrosser.restartAt(this.vertex(n3));
                }
                n2 = n3;
                int n4 = edgeCrosser.robustCrossing(this.vertex(n3 + 1));
                if (n4 >= 0) {
                    if (n4 > 0) {
                        return -1;
                    }
                    if (this.vertex(n3 + 1).equals(s2Loop.vertex(i + 1)) && (n = Math.min(n, wedgeRelation.test(this.vertex(n3), this.vertex(n3 + 1), this.vertex(n3 + 2), s2Loop.vertex(i), s2Loop.vertex(i + 2)))) < 0) {
                        return n;
                    }
                }
                dataEdgeIterator.next();
            }
        }
        return n;
    }
}

