/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S2LatLng;

public strictfp class S2Point
implements Comparable<S2Point> {
    final double x;
    final double y;
    final double z;

    public S2Point() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public S2Point(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public static S2Point minus(S2Point s2Point, S2Point s2Point2) {
        return S2Point.sub(s2Point, s2Point2);
    }

    public static S2Point neg(S2Point s2Point) {
        return new S2Point(-s2Point.x, -s2Point.y, -s2Point.z);
    }

    public double norm2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double norm() {
        return Math.sqrt(this.norm2());
    }

    public static S2Point crossProd(S2Point s2Point, S2Point s2Point2) {
        return new S2Point(s2Point.y * s2Point2.z - s2Point.z * s2Point2.y, s2Point.z * s2Point2.x - s2Point.x * s2Point2.z, s2Point.x * s2Point2.y - s2Point.y * s2Point2.x);
    }

    public static S2Point add(S2Point s2Point, S2Point s2Point2) {
        return new S2Point(s2Point.x + s2Point2.x, s2Point.y + s2Point2.y, s2Point.z + s2Point2.z);
    }

    public static S2Point sub(S2Point s2Point, S2Point s2Point2) {
        return new S2Point(s2Point.x - s2Point2.x, s2Point.y - s2Point2.y, s2Point.z - s2Point2.z);
    }

    public double dotProd(S2Point s2Point) {
        return this.x * s2Point.x + this.y * s2Point.y + this.z * s2Point.z;
    }

    public static S2Point mul(S2Point s2Point, double d) {
        return new S2Point(d * s2Point.x, d * s2Point.y, d * s2Point.z);
    }

    public static S2Point div(S2Point s2Point, double d) {
        return new S2Point(s2Point.x / d, s2Point.y / d, s2Point.z / d);
    }

    public S2Point ortho() {
        int n = this.largestAbsComponent();
        S2Point s2Point = n == 1 ? new S2Point(1.0, 0.0, 0.0) : (n == 2 ? new S2Point(0.0, 1.0, 0.0) : new S2Point(0.0, 0.0, 1.0));
        return S2Point.normalize(S2Point.crossProd(this, s2Point));
    }

    public int largestAbsComponent() {
        S2Point s2Point = S2Point.fabs(this);
        if (s2Point.x > s2Point.y) {
            if (s2Point.x > s2Point.z) {
                return 0;
            }
            return 2;
        }
        if (s2Point.y > s2Point.z) {
            return 1;
        }
        return 2;
    }

    public static S2Point fabs(S2Point s2Point) {
        return new S2Point(Math.abs(s2Point.x), Math.abs(s2Point.y), Math.abs(s2Point.z));
    }

    public static S2Point normalize(S2Point s2Point) {
        double d = s2Point.norm();
        if (d != 0.0) {
            d = 1.0 / d;
        }
        return S2Point.mul(s2Point, d);
    }

    public double get(int n) {
        return n == 0 ? this.x : (n == 1 ? this.y : this.z);
    }

    public double angle(S2Point s2Point) {
        return Math.atan2(S2Point.crossProd(this, s2Point).norm(), this.dotProd(s2Point));
    }

    boolean aequal(S2Point s2Point, double d) {
        return Math.abs(this.x - s2Point.x) < d && Math.abs(this.y - s2Point.y) < d && Math.abs(this.z - s2Point.z) < d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof S2Point)) {
            return false;
        }
        S2Point s2Point = (S2Point)object;
        return this.x == s2Point.x && this.y == s2Point.y && this.z == s2Point.z;
    }

    public boolean lessThan(S2Point s2Point) {
        if (this.x < s2Point.x) {
            return true;
        }
        if (s2Point.x < this.x) {
            return false;
        }
        if (this.y < s2Point.y) {
            return true;
        }
        if (s2Point.y < this.y) {
            return false;
        }
        return this.z < s2Point.z;
    }

    @Override
    public int compareTo(S2Point s2Point) {
        return this.lessThan(s2Point) ? -1 : (this.equals(s2Point) ? 0 : 1);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public String toDegreesString() {
        S2LatLng s2LatLng = new S2LatLng(this);
        return "(" + Double.toString(s2LatLng.latDegrees()) + ", " + Double.toString(s2LatLng.lngDegrees()) + ")";
    }

    public int hashCode() {
        long l = 17L;
        l += 37L * l + Double.doubleToLongBits(Math.abs(this.x));
        l += 37L * l + Double.doubleToLongBits(Math.abs(this.y));
        l += 37L * l + Double.doubleToLongBits(Math.abs(this.z));
        return (int)(l ^ l >>> 32);
    }
}

