/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeMultimap;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2AreaCentroid;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2Edge;
import com.google.common.geometry.S2EdgeIndex;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2PolygonBuilder;
import com.google.common.geometry.S2Region;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public strictfp final class S2Polygon
implements S2Region,
Comparable<S2Polygon> {
    private static final Logger log = Logger.getLogger(S2Polygon.class.getCanonicalName());
    private List<S2Loop> loops = Lists.newArrayList();
    private S2LatLngRect bound;
    private boolean hasHoles;
    private int numVertices;

    public S2Polygon() {
        this.bound = S2LatLngRect.empty();
        this.hasHoles = false;
        this.numVertices = 0;
    }

    public S2Polygon(List<S2Loop> list) {
        this.bound = S2LatLngRect.empty();
        this.init(list);
    }

    public S2Polygon(S2Loop s2Loop) {
        this.bound = s2Loop.getRectBound();
        this.hasHoles = false;
        this.numVertices = s2Loop.numVertices();
        this.loops.add(s2Loop);
    }

    public S2Polygon(S2Polygon s2Polygon) {
        this.bound = s2Polygon.getRectBound();
        this.hasHoles = s2Polygon.hasHoles;
        this.numVertices = s2Polygon.numVertices;
        for (int i = 0; i < s2Polygon.numLoops(); ++i) {
            this.loops.add(new S2Loop(s2Polygon.loop(i)));
        }
    }

    @Override
    public int compareTo(S2Polygon s2Polygon) {
        if (this.numLoops() != s2Polygon.numLoops()) {
            return this.numLoops() - s2Polygon.numLoops();
        }
        for (int i = 0; i < this.numLoops(); ++i) {
            int n = this.loops.get(i).compareTo(s2Polygon.loops.get(i));
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public void init(List<S2Loop> list) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(null, Lists.newArrayList());
        for (S2Loop s2Loop : list) {
            S2Polygon.insertLoop(s2Loop, null, hashMap);
            this.numVertices += s2Loop.numVertices();
        }
        list.clear();
        S2Polygon.sortValueLoops(hashMap);
        this.initLoop(null, -1, hashMap);
        this.hasHoles = false;
        this.bound = S2LatLngRect.empty();
        for (int i = 0; i < this.numLoops(); ++i) {
            if (this.loop(i).sign() < 0) {
                this.hasHoles = true;
                continue;
            }
            this.bound = this.bound.union(this.loop(i).getRectBound());
        }
    }

    public void release(List<S2Loop> list) {
        list.addAll(this.loops);
        this.loops.clear();
        this.bound = S2LatLngRect.empty();
        this.hasHoles = false;
        this.numVertices = 0;
    }

    public static boolean isValid(List<S2Loop> list) {
        int n;
        if (list.size() > 1) {
            HashMap hashMap = Maps.newHashMap();
            for (n = 0; n < list.size(); ++n) {
                S2Loop s2Loop = list.get(n);
                for (int i = 0; i < s2Loop.numVertices(); ++i) {
                    UndirectedEdge undirectedEdge = new UndirectedEdge(s2Loop.vertex(i), s2Loop.vertex(i + 1));
                    LoopVertexIndexPair loopVertexIndexPair = new LoopVertexIndexPair(n, i);
                    if (hashMap.containsKey(undirectedEdge)) {
                        LoopVertexIndexPair loopVertexIndexPair2 = (LoopVertexIndexPair)hashMap.get(undirectedEdge);
                        log.info("Duplicate edge: loop " + n + ", edge " + i + " and loop " + loopVertexIndexPair2.getLoopIndex() + ", edge " + loopVertexIndexPair2.getVertexIndex());
                        return false;
                    }
                    hashMap.put(undirectedEdge, loopVertexIndexPair);
                }
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isNormalized()) {
                log.info("Loop " + i + " encloses more than half the sphere");
                return false;
            }
            for (n = i + 1; n < list.size(); ++n) {
                if (list.get(i).containsOrCrosses(list.get(n)) >= 0) continue;
                log.info("Loop " + i + " crosses loop " + n);
                return false;
            }
        }
        return true;
    }

    public int numLoops() {
        return this.loops.size();
    }

    public S2Loop loop(int n) {
        return this.loops.get(n);
    }

    public int getParent(int n) {
        int n2 = this.loop(n).depth();
        if (n2 == 0) {
            return -1;
        }
        while (--n >= 0 && this.loop(n).depth() >= n2) {
        }
        return n;
    }

    public int getLastDescendant(int n) {
        if (n < 0) {
            return this.numLoops() - 1;
        }
        int n2 = this.loop(n).depth();
        while (++n < this.numLoops() && this.loop(n).depth() > n2) {
        }
        return n - 1;
    }

    private S2AreaCentroid getAreaCentroid(boolean bl) {
        double d = 0.0;
        S2Point s2Point = new S2Point(0.0, 0.0, 0.0);
        for (int i = 0; i < this.numLoops(); ++i) {
            S2AreaCentroid s2AreaCentroid = bl ? this.loop(i).getAreaAndCentroid() : null;
            double d2 = bl ? s2AreaCentroid.getArea() : this.loop(i).getArea();
            int n = this.loop(i).sign();
            d += (double)n * d2;
            if (!bl) continue;
            S2Point s2Point2 = s2AreaCentroid.getCentroid();
            s2Point = new S2Point(s2Point.x + (double)n * s2Point2.x, s2Point.y + (double)n * s2Point2.y, s2Point.z + (double)n * s2Point2.z);
        }
        return new S2AreaCentroid(d, bl ? s2Point : null);
    }

    public S2AreaCentroid getAreaAndCentroid() {
        return this.getAreaCentroid(true);
    }

    public double getArea() {
        return this.getAreaCentroid(false).getArea();
    }

    public S2Point getCentroid() {
        return this.getAreaCentroid(true).getCentroid();
    }

    public S1Angle getDistance(S2Point s2Point) {
        if (this.contains(s2Point)) {
            return S1Angle.radians(0.0);
        }
        S1Angle s1Angle = S1Angle.radians(Math.PI);
        for (int i = 0; i < this.numLoops(); ++i) {
            s1Angle = S1Angle.min(s1Angle, this.loop(i).getDistance(s2Point));
        }
        return s1Angle;
    }

    public boolean contains(S2Polygon s2Polygon) {
        if (this.numLoops() == 1 && s2Polygon.numLoops() == 1) {
            return this.loop(0).contains(s2Polygon.loop(0));
        }
        if (!this.bound.contains(s2Polygon.getRectBound()) && !this.bound.lng().union(s2Polygon.getRectBound().lng()).isFull()) {
            return false;
        }
        if (!this.hasHoles && !s2Polygon.hasHoles) {
            for (int i = 0; i < s2Polygon.numLoops(); ++i) {
                if (this.anyLoopContains(s2Polygon.loop(i))) continue;
                return false;
            }
            return true;
        }
        return this.containsAllShells(s2Polygon) && s2Polygon.excludesAllHoles(this);
    }

    public boolean intersects(S2Polygon s2Polygon) {
        if (this.numLoops() == 1 && s2Polygon.numLoops() == 1) {
            return this.loop(0).intersects(s2Polygon.loop(0));
        }
        if (!this.bound.intersects(s2Polygon.getRectBound())) {
            return false;
        }
        if (!this.hasHoles && !s2Polygon.hasHoles) {
            for (int i = 0; i < this.numLoops(); ++i) {
                for (int j = 0; j < s2Polygon.numLoops(); ++j) {
                    if (!this.loop(i).intersects(s2Polygon.loop(j))) continue;
                    return true;
                }
            }
            return false;
        }
        return this.intersectsAnyShell(s2Polygon) || s2Polygon.intersectsAnyShell(this);
    }

    private static void addIntersection(S2Point s2Point, S2Point s2Point2, S2Point s2Point3, S2Point s2Point4, boolean bl, int n, List<ParametrizedS2Point> list) {
        if (n > 0) {
            S2Point s2Point5 = S2EdgeUtil.getIntersection(s2Point, s2Point2, s2Point3, s2Point4);
            double d = S2EdgeUtil.getDistanceFraction(s2Point5, s2Point, s2Point2);
            list.add(new ParametrizedS2Point(d, s2Point5));
        } else if (S2EdgeUtil.vertexCrossing(s2Point, s2Point2, s2Point3, s2Point4)) {
            double d;
            double d2 = d = s2Point.equals(s2Point3) || s2Point.equals(s2Point4) ? 0.0 : 1.0;
            if (!bl && s2Point2.equals(s2Point4)) {
                d = 1.0;
            }
            list.add(new ParametrizedS2Point(d, d == 0.0 ? s2Point : s2Point2));
        }
    }

    private static void clipEdge(S2Point s2Point, S2Point s2Point2, S2LoopSequenceIndex s2LoopSequenceIndex, boolean bl, List<ParametrizedS2Point> list) {
        S2EdgeIndex.DataEdgeIterator dataEdgeIterator = new S2EdgeIndex.DataEdgeIterator(s2LoopSequenceIndex);
        dataEdgeIterator.getCandidates(s2Point, s2Point2);
        S2EdgeUtil.EdgeCrosser edgeCrosser = new S2EdgeUtil.EdgeCrosser(s2Point, s2Point2, s2Point);
        S2Point s2Point3 = null;
        S2Point s2Point4 = null;
        while (dataEdgeIterator.hasNext()) {
            int n;
            S2Point s2Point5 = s2Point4;
            S2Edge s2Edge = s2LoopSequenceIndex.edgeFromTo(dataEdgeIterator.index());
            s2Point3 = s2Edge.getStart();
            s2Point4 = s2Edge.getEnd();
            if (s2Point5 != s2Point3) {
                edgeCrosser.restartAt(s2Point3);
            }
            if ((n = edgeCrosser.robustCrossing(s2Point4)) >= 0) {
                S2Polygon.addIntersection(s2Point, s2Point2, s2Point3, s2Point4, bl, n, list);
            }
            dataEdgeIterator.next();
        }
    }

    private static void clipBoundary(S2Polygon s2Polygon, boolean bl, S2Polygon s2Polygon2, boolean bl2, boolean bl3, boolean bl4, S2PolygonBuilder s2PolygonBuilder) {
        S2PolygonIndex s2PolygonIndex = new S2PolygonIndex(s2Polygon2, bl2);
        s2PolygonIndex.predictAdditionalCalls(s2Polygon.getNumVertices());
        ArrayList arrayList = Lists.newArrayList();
        for (S2Loop s2Loop : s2Polygon.loops) {
            int n;
            int n2 = s2Loop.numVertices();
            int n3 = s2Loop.isHole() ^ bl ? -1 : 1;
            boolean bl5 = s2Polygon2.contains(s2Loop.vertex(0)) ^ bl3;
            int n4 = n = n3 > 0 ? 0 : n2;
            while (n2 > 0) {
                S2Point s2Point = s2Loop.vertex(n);
                S2Point s2Point2 = s2Loop.vertex(n + n3);
                arrayList.clear();
                S2Polygon.clipEdge(s2Point, s2Point2, s2PolygonIndex, bl4, arrayList);
                if (bl5) {
                    arrayList.add(new ParametrizedS2Point(0.0, s2Point));
                }
                boolean bl6 = bl5 = (arrayList.size() & 1) == 1;
                if (bl5) {
                    arrayList.add(new ParametrizedS2Point(1.0, s2Point2));
                }
                Collections.sort(arrayList);
                int n5 = arrayList.size();
                for (int i = 1; i < n5; i += 2) {
                    s2PolygonBuilder.addEdge(((ParametrizedS2Point)arrayList.get(i - 1)).getPoint(), ((ParametrizedS2Point)arrayList.get(i)).getPoint());
                }
                --n2;
                n += n3;
            }
        }
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public void initToIntersection(S2Polygon s2Polygon, S2Polygon s2Polygon2) {
        this.initToIntersectionSloppy(s2Polygon, s2Polygon2, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public void initToIntersectionSloppy(S2Polygon s2Polygon, S2Polygon s2Polygon2, S1Angle s1Angle) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        if (!s2Polygon.bound.intersects(s2Polygon2.bound)) {
            return;
        }
        S2PolygonBuilder.Options options = S2PolygonBuilder.Options.DIRECTED_XOR;
        options.setMergeDistance(s1Angle);
        S2PolygonBuilder s2PolygonBuilder = new S2PolygonBuilder(options);
        S2Polygon.clipBoundary(s2Polygon, false, s2Polygon2, false, false, true, s2PolygonBuilder);
        S2Polygon.clipBoundary(s2Polygon2, false, s2Polygon, false, false, false, s2PolygonBuilder);
        if (!s2PolygonBuilder.assemblePolygon(this, null)) {
            log.severe("Bad directed edges");
        }
    }

    public void initToUnion(S2Polygon s2Polygon, S2Polygon s2Polygon2) {
        this.initToUnionSloppy(s2Polygon, s2Polygon2, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public void initToUnionSloppy(S2Polygon s2Polygon, S2Polygon s2Polygon2, S1Angle s1Angle) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        S2PolygonBuilder.Options options = S2PolygonBuilder.Options.DIRECTED_XOR;
        options.setMergeDistance(s1Angle);
        S2PolygonBuilder s2PolygonBuilder = new S2PolygonBuilder(options);
        S2Polygon.clipBoundary(s2Polygon, false, s2Polygon2, false, true, true, s2PolygonBuilder);
        S2Polygon.clipBoundary(s2Polygon2, false, s2Polygon, false, true, false, s2PolygonBuilder);
        if (!s2PolygonBuilder.assemblePolygon(this, null)) {
            log.severe("Bad directed edges");
        }
    }

    public static S2Polygon destructiveUnion(List<S2Polygon> list) {
        return S2Polygon.destructiveUnionSloppy(list, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public static S2Polygon destructiveUnionSloppy(List<S2Polygon> list, S1Angle s1Angle) {
        TreeMultimap treeMultimap = TreeMultimap.create();
        for (S2Polygon object2 : list) {
            treeMultimap.put((Object)object2.getNumVertices(), (Object)object2);
        }
        list.clear();
        Object object = treeMultimap.entries();
        while (object.size() > 1) {
            object = treeMultimap.entries();
            Iterator iterator = object.iterator();
            Map.Entry entry = (Map.Entry)iterator.next();
            int n = (Integer)entry.getKey();
            S2Polygon s2Polygon = (S2Polygon)entry.getValue();
            iterator.remove();
            entry = (Map.Entry)iterator.next();
            int n2 = (Integer)entry.getKey();
            S2Polygon s2Polygon2 = (S2Polygon)entry.getValue();
            iterator.remove();
            S2Polygon s2Polygon3 = new S2Polygon();
            s2Polygon3.initToUnionSloppy(s2Polygon, s2Polygon2, s1Angle);
            int n3 = n + n2;
            treeMultimap.put((Object)n3, (Object)s2Polygon3);
        }
        if (treeMultimap.isEmpty()) {
            return new S2Polygon();
        }
        return (S2Polygon)treeMultimap.get(treeMultimap.asMap().firstKey()).first();
    }

    public boolean isNormalized() {
        HashMultiset hashMultiset = HashMultiset.create();
        S2Loop s2Loop = null;
        for (int i = 0; i < this.numLoops(); ++i) {
            int n;
            S2Loop s2Loop2 = this.loop(i);
            if (s2Loop2.depth() == 0) continue;
            S2Loop s2Loop3 = this.loop(this.getParent(i));
            if (s2Loop3 != s2Loop) {
                hashMultiset.clear();
                for (n = 0; n < s2Loop3.numVertices(); ++n) {
                    hashMultiset.add((Object)s2Loop3.vertex(n));
                }
                s2Loop = s2Loop3;
            }
            n = 0;
            for (int j = 0; j < s2Loop2.numVertices(); ++j) {
                if (hashMultiset.count((Object)s2Loop2.vertex(j)) <= 0) continue;
                ++n;
            }
            if (n <= 1) continue;
            return false;
        }
        return true;
    }

    boolean boundaryApproxEquals(S2Polygon s2Polygon, double d) {
        if (this.numLoops() != s2Polygon.numLoops()) {
            log.severe("!= loops: " + Integer.toString(this.numLoops()) + " vs. " + Integer.toString(s2Polygon.numLoops()));
            return false;
        }
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop s2Loop = this.loop(i);
            boolean bl = false;
            for (int j = 0; j < this.numLoops(); ++j) {
                S2Loop s2Loop2 = s2Polygon.loop(j);
                if (s2Loop2.depth() != s2Loop.depth() || !s2Loop2.boundaryApproxEquals(s2Loop, d)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public S2Cap getCapBound() {
        return this.bound.getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        return this.bound;
    }

    @Override
    public boolean contains(S2Cell s2Cell) {
        if (this.numLoops() == 1) {
            return this.loop(0).contains(s2Cell);
        }
        S2LatLngRect s2LatLngRect = s2Cell.getRectBound();
        if (!this.bound.contains(s2LatLngRect)) {
            return false;
        }
        S2Loop s2Loop = new S2Loop(s2Cell, s2LatLngRect);
        S2Polygon s2Polygon = new S2Polygon(s2Loop);
        return this.contains(s2Polygon);
    }

    @Override
    public boolean mayIntersect(S2Cell s2Cell) {
        if (this.numLoops() == 1) {
            return this.loop(0).mayIntersect(s2Cell);
        }
        S2LatLngRect s2LatLngRect = s2Cell.getRectBound();
        if (!this.bound.intersects(s2LatLngRect)) {
            return false;
        }
        S2Loop s2Loop = new S2Loop(s2Cell, s2LatLngRect);
        S2Polygon s2Polygon = new S2Polygon(s2Loop);
        return this.intersects(s2Polygon);
    }

    public boolean contains(S2Point s2Point) {
        if (this.numLoops() == 1) {
            return this.loop(0).contains(s2Point);
        }
        if (!this.bound.contains(s2Point)) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.numLoops() && (!(bl ^= this.loop(i).contains(s2Point)) || this.hasHoles); ++i) {
        }
        return bl;
    }

    private static void sortValueLoops(Map<S2Loop, List<S2Loop>> map) {
        for (S2Loop s2Loop : map.keySet()) {
            Collections.sort(map.get(s2Loop));
        }
    }

    private static void insertLoop(S2Loop s2Loop, S2Loop s2Loop2, Map<S2Loop, List<S2Loop>> map) {
        ArrayList arrayList = map.get(s2Loop2);
        if (arrayList == null) {
            arrayList = Lists.newArrayList();
            map.put(s2Loop2, arrayList);
        }
        for (S2Loop s2Loop3 : arrayList) {
            if (!s2Loop3.containsNested(s2Loop)) continue;
            S2Polygon.insertLoop(s2Loop, s2Loop3, map);
            return;
        }
        Object object = map.get(s2Loop);
        int n = 0;
        while (n < arrayList.size()) {
            S2Loop s2Loop4 = (S2Loop)arrayList.get(n);
            if (s2Loop.containsNested(s2Loop4)) {
                if (object == null) {
                    object = Lists.newArrayList();
                    map.put(s2Loop, (List<S2Loop>)object);
                }
                object.add(s2Loop4);
                arrayList.remove(n);
                continue;
            }
            ++n;
        }
        arrayList.add(s2Loop);
    }

    private void initLoop(S2Loop s2Loop, int n, Map<S2Loop, List<S2Loop>> map) {
        List<S2Loop> list;
        if (s2Loop != null) {
            s2Loop.setDepth(n);
            this.loops.add(s2Loop);
        }
        if ((list = map.get(s2Loop)) != null) {
            for (S2Loop s2Loop2 : list) {
                this.initLoop(s2Loop2, n + 1, map);
            }
        }
    }

    private int containsOrCrosses(S2Loop s2Loop) {
        boolean bl = false;
        for (int i = 0; i < this.numLoops(); ++i) {
            int n = this.loop(i).containsOrCrosses(s2Loop);
            if (n < 0) {
                return -1;
            }
            if (n <= 0) continue;
            bl ^= true;
        }
        return bl ? 1 : 0;
    }

    private boolean anyLoopContains(S2Loop s2Loop) {
        for (int i = 0; i < this.numLoops(); ++i) {
            if (!this.loop(i).contains(s2Loop)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAllShells(S2Polygon s2Polygon) {
        for (int i = 0; i < s2Polygon.numLoops(); ++i) {
            if (s2Polygon.loop(i).sign() < 0 || this.containsOrCrosses(s2Polygon.loop(i)) > 0) continue;
            return false;
        }
        return true;
    }

    private boolean excludesAllHoles(S2Polygon s2Polygon) {
        for (int i = 0; i < s2Polygon.numLoops(); ++i) {
            if (s2Polygon.loop(i).sign() > 0 || this.containsOrCrosses(s2Polygon.loop(i)) == 0) continue;
            return false;
        }
        return true;
    }

    private boolean intersectsAnyShell(S2Polygon s2Polygon) {
        for (int i = 0; i < s2Polygon.numLoops(); ++i) {
            if (s2Polygon.loop(i).sign() < 0 || this.containsOrCrosses(s2Polygon.loop(i)) == 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Polygon: (").append(this.numLoops()).append(") loops:\n");
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop s2Loop = this.loop(i);
            stringBuilder.append("loop <\n");
            for (int j = 0; j < s2Loop.numVertices(); ++j) {
                S2Point s2Point = s2Loop.vertex(j);
                stringBuilder.append(s2Point.toDegreesString());
                stringBuilder.append("\n");
            }
            stringBuilder.append(">\n");
        }
        return stringBuilder.toString();
    }

    private strictfp static final class ParametrizedS2Point
    implements Comparable<ParametrizedS2Point> {
        private final double time;
        private final S2Point point;

        public ParametrizedS2Point(double d, S2Point s2Point) {
            this.time = d;
            this.point = s2Point;
        }

        public double getTime() {
            return this.time;
        }

        public S2Point getPoint() {
            return this.point;
        }

        @Override
        public int compareTo(ParametrizedS2Point parametrizedS2Point) {
            int n = Double.compare(this.time, parametrizedS2Point.time);
            if (n != 0) {
                return n;
            }
            return this.point.compareTo(parametrizedS2Point.point);
        }
    }

    private strictfp static final class LoopVertexIndexPair {
        private final int loopIndex;
        private final int vertexIndex;

        public LoopVertexIndexPair(int n, int n2) {
            this.loopIndex = n;
            this.vertexIndex = n2;
        }

        public int getLoopIndex() {
            return this.loopIndex;
        }

        public int getVertexIndex() {
            return this.vertexIndex;
        }
    }

    private strictfp static final class UndirectedEdge {
        private final S2Point a;
        private final S2Point b;

        public UndirectedEdge(S2Point s2Point, S2Point s2Point2) {
            this.a = s2Point;
            this.b = s2Point2;
        }

        public S2Point getStart() {
            return this.a;
        }

        public S2Point getEnd() {
            return this.b;
        }

        public String toString() {
            return String.format("Edge: (%s <-> %s)\n   or [%s <-> %s]", this.a.toDegreesString(), this.b.toDegreesString(), this.a, this.b);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof UndirectedEdge)) {
                return false;
            }
            UndirectedEdge undirectedEdge = (UndirectedEdge)object;
            return this.getStart().equals(undirectedEdge.getStart()) && this.getEnd().equals(undirectedEdge.getEnd()) || this.getStart().equals(undirectedEdge.getEnd()) && this.getEnd().equals(undirectedEdge.getStart());
        }

        public int hashCode() {
            return this.getStart().hashCode() + this.getEnd().hashCode();
        }
    }

    private strictfp static final class S2PolygonIndex
    extends S2LoopSequenceIndex {
        private final S2Polygon poly;
        private final boolean reverse;

        private static int[] getVertices(S2Polygon s2Polygon) {
            int[] nArray = new int[s2Polygon.numLoops()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = s2Polygon.loop(i).numVertices();
            }
            return nArray;
        }

        public S2PolygonIndex(S2Polygon s2Polygon, boolean bl) {
            super(S2PolygonIndex.getVertices(s2Polygon));
            this.poly = s2Polygon;
            this.reverse = bl;
        }

        @Override
        public S2Edge edgeFromTo(int n) {
            int n2;
            int n3;
            LoopVertexIndexPair loopVertexIndexPair = this.decodeIndex(n);
            int n4 = loopVertexIndexPair.getLoopIndex();
            int n5 = loopVertexIndexPair.getVertexIndex();
            S2Loop s2Loop = this.poly.loop(n4);
            if (s2Loop.isHole() ^ this.reverse) {
                n3 = s2Loop.numVertices() - 1 - n5;
                n2 = 2 * s2Loop.numVertices() - 2 - n5;
            } else {
                n3 = n5;
                n2 = n5 + 1;
            }
            S2Point s2Point = s2Loop.vertex(n3);
            S2Point s2Point2 = s2Loop.vertex(n2);
            return new S2Edge(s2Point, s2Point2);
        }
    }

    private strictfp static abstract class S2LoopSequenceIndex
    extends S2EdgeIndex {
        private final int[] indexToLoop;
        private final int[] loopToFirstIndex;

        public S2LoopSequenceIndex(int[] nArray) {
            int n = 0;
            int[] nArray2 = nArray;
            int n2 = nArray2.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray2[i];
                n += n3;
            }
            this.indexToLoop = new int[n];
            this.loopToFirstIndex = new int[nArray.length];
            n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                this.loopToFirstIndex[i] = n;
                for (n2 = 0; n2 < nArray[i]; ++n2) {
                    this.indexToLoop[n] = i;
                    ++n;
                }
            }
        }

        public final LoopVertexIndexPair decodeIndex(int n) {
            int n2 = this.indexToLoop[n];
            int n3 = n - this.loopToFirstIndex[n2];
            return new LoopVertexIndexPair(n2, n3);
        }

        public abstract S2Edge edgeFromTo(int var1);

        @Override
        public final int getNumEdges() {
            return this.indexToLoop.length;
        }

        @Override
        public S2Point edgeFrom(int n) {
            S2Edge s2Edge = this.edgeFromTo(n);
            S2Point s2Point = s2Edge.getStart();
            return s2Point;
        }

        @Override
        protected S2Point edgeTo(int n) {
            S2Edge s2Edge = this.edgeFromTo(n);
            S2Point s2Point = s2Edge.getEnd();
            return s2Point;
        }
    }
}

