/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2Edge;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Polygon;
import com.google.common.geometry.S2Projections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;

public strictfp class S2PolygonBuilder {
    private static final Logger log = Logger.getLogger(S2PolygonBuilder.class.getCanonicalName());
    private Options options;
    private Map<S2Point, Multiset<S2Point>> edges;

    public S2PolygonBuilder() {
        this(Options.DIRECTED_XOR);
    }

    public S2PolygonBuilder(Options options) {
        this.options = options;
        this.edges = Maps.newHashMap();
    }

    public Options options() {
        return this.options;
    }

    public void addEdge(S2Point s2Point, S2Point s2Point2) {
        Multiset<S2Point> multiset;
        if (s2Point.equals(s2Point2)) {
            return;
        }
        if (this.options.getXorEdges() && (multiset = this.edges.get(s2Point2)) != null && multiset.count((Object)s2Point) > 0) {
            this.eraseEdge(s2Point2, s2Point);
            return;
        }
        if (this.edges.get(s2Point) == null) {
            this.edges.put(s2Point, (Multiset<S2Point>)HashMultiset.create());
        }
        this.edges.get(s2Point).add((Object)s2Point2);
        if (this.options.getUndirectedEdges()) {
            if (this.edges.get(s2Point2) == null) {
                this.edges.put(s2Point2, (Multiset<S2Point>)HashMultiset.create());
            }
            this.edges.get(s2Point2).add((Object)s2Point);
        }
    }

    public void addLoop(S2Loop s2Loop) {
        int n = s2Loop.sign();
        for (int i = s2Loop.numVertices(); i > 0; --i) {
            this.addEdge(s2Loop.vertex(i), s2Loop.vertex(i + n));
        }
    }

    public void addPolygon(S2Polygon s2Polygon) {
        for (int i = 0; i < s2Polygon.numLoops(); ++i) {
            this.addLoop(s2Polygon.loop(i));
        }
    }

    public boolean assembleLoops(List<S2Loop> list, List<S2Edge> arrayList) {
        if (this.options.getMergeDistance().radians() > 0.0) {
            this.mergeVertices();
        }
        ArrayList arrayList2 = Lists.newArrayList();
        if (arrayList == null) {
            arrayList = arrayList2;
        }
        arrayList.clear();
        while (!this.edges.isEmpty()) {
            S2Point s2Point;
            Map.Entry<S2Point, Multiset<S2Point>> entry = this.edges.entrySet().iterator().next();
            S2Point s2Point2 = entry.getKey();
            S2Loop s2Loop = this.assembleLoop(s2Point2, s2Point = (S2Point)entry.getValue().iterator().next(), arrayList);
            if (s2Loop == null) continue;
            while (this.options.getUndirectedEdges() && !s2Loop.isNormalized()) {
                s2Loop = this.assembleLoop(s2Loop.vertex(1), s2Loop.vertex(0), arrayList);
            }
            list.add(s2Loop);
            this.eraseLoop(s2Loop, s2Loop.numVertices());
        }
        return arrayList.isEmpty();
    }

    public boolean assemblePolygon(S2Polygon s2Polygon, List<S2Edge> list) {
        ArrayList arrayList = Lists.newArrayList();
        boolean bl = this.assembleLoops(arrayList, list);
        if (!this.options.getUndirectedEdges()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ((S2Loop)arrayList.get(i)).normalize();
            }
        }
        if (this.options.getValidate() && !S2Polygon.isValid(arrayList)) {
            if (list != null) {
                for (S2Loop s2Loop : arrayList) {
                    this.rejectLoop(s2Loop, s2Loop.numVertices(), list);
                }
            }
            return false;
        }
        s2Polygon.init(arrayList);
        return bl;
    }

    public S2Polygon assemblePolygon() {
        S2Polygon s2Polygon = new S2Polygon();
        ArrayList arrayList = Lists.newArrayList();
        this.assemblePolygon(s2Polygon, arrayList);
        return s2Polygon;
    }

    protected void dumpEdges(S2Point s2Point) {
        log.info(s2Point.toString());
        Multiset<S2Point> multiset = this.edges.get(s2Point);
        if (multiset != null) {
            for (S2Point s2Point2 : multiset) {
                log.info("    " + s2Point2.toString());
            }
        }
    }

    protected void dump() {
        for (S2Point s2Point : this.edges.keySet()) {
            this.dumpEdges(s2Point);
        }
    }

    private void eraseEdge(S2Point s2Point, S2Point s2Point2) {
        Multiset<S2Point> multiset = this.edges.get(s2Point);
        multiset.remove((Object)s2Point2);
        if (multiset.isEmpty()) {
            this.edges.remove(s2Point);
        }
        if (this.options.getUndirectedEdges()) {
            multiset = this.edges.get(s2Point2);
            multiset.remove((Object)s2Point);
            if (multiset.isEmpty()) {
                this.edges.remove(s2Point2);
            }
        }
    }

    private void eraseLoop(List<S2Point> list, int n) {
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            this.eraseEdge(list.get(n2), list.get(n3));
            n2 = n3++;
        }
    }

    private void eraseLoop(S2Loop s2Loop, int n) {
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            this.eraseEdge(s2Loop.vertex(n2), s2Loop.vertex(n3));
            n2 = n3++;
        }
    }

    private S2Loop assembleLoop(S2Point s2Point, S2Point s2Point2, List<S2Edge> list) {
        List<S2Point> list2 = Lists.newArrayList();
        HashMap hashMap = Maps.newHashMap();
        list2.add(s2Point);
        list2.add(s2Point2);
        hashMap.put(s2Point2, 1);
        while (list2.size() >= 2) {
            s2Point = (S2Point)list2.get(list2.size() - 2);
            s2Point2 = (S2Point)list2.get(list2.size() - 1);
            S2Point s2Point3 = null;
            boolean bl = false;
            Multiset<S2Point> multiset = this.edges.get(s2Point2);
            if (multiset != null) {
                for (S2Point s2Point4 : multiset) {
                    if (s2Point4.equals(s2Point)) continue;
                    if (!bl || S2.orderedCCW(s2Point, s2Point3, s2Point4, s2Point2)) {
                        s2Point3 = s2Point4;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                list.add(new S2Edge(s2Point, s2Point2));
                this.eraseEdge(s2Point, s2Point2);
                hashMap.remove(s2Point2);
                list2.remove(list2.size() - 1);
                continue;
            }
            if (hashMap.get(s2Point3) == null) {
                hashMap.put(s2Point3, list2.size());
                list2.add(s2Point3);
                continue;
            }
            list2 = list2.subList((Integer)hashMap.get(s2Point3), list2.size());
            if (this.options.getValidate() && !S2Loop.isValid(list2)) {
                this.rejectLoop(list2, list2.size(), list);
                this.eraseLoop(list2, list2.size());
                return null;
            }
            return new S2Loop(list2);
        }
        return null;
    }

    private void rejectLoop(S2Loop s2Loop, int n, List<S2Edge> list) {
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            list.add(new S2Edge(s2Loop.vertex(n2), s2Loop.vertex(n3)));
            n2 = n3++;
        }
    }

    private void rejectLoop(List<S2Point> list, int n, List<S2Edge> list2) {
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            list2.add(new S2Edge(list.get(n2), list.get(n3)));
            n2 = n3++;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void moveVertices(Map<S2Point, S2Point> map) {
        S2Point s2Point;
        if (map.isEmpty()) {
            return;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<S2Point, Multiset<S2Point>> entry : this.edges.entrySet()) {
            s2Point = entry.getKey();
            Multiset<S2Point> multiset = entry.getValue();
            for (S2Point s2Point2 : multiset) {
                if (map.get(s2Point) == null && map.get(s2Point2) == null || this.options.getUndirectedEdges() && !s2Point.lessThan(s2Point2)) continue;
                arrayList.add(new S2Edge(s2Point, s2Point2));
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            void var4_9;
            S2Point s2Point3 = ((S2Edge)arrayList.get(i)).getStart();
            s2Point = ((S2Edge)arrayList.get(i)).getEnd();
            this.eraseEdge(s2Point3, s2Point);
            if (map.get(s2Point3) != null) {
                S2Point s2Point4 = map.get(s2Point3);
            }
            if (map.get(s2Point) != null) {
                s2Point = map.get(s2Point);
            }
            this.addEdge((S2Point)var4_9, s2Point);
        }
    }

    private void mergeVertices() {
        Multiset<S2Point> multiset;
        PointIndex pointIndex = new PointIndex(this.options.getMergeDistance().radians());
        for (Map.Entry<S2Point, Multiset<S2Point>> object2 : this.edges.entrySet()) {
            pointIndex.add(object2.getKey());
            multiset = object2.getValue();
            for (Object object : multiset) {
                pointIndex.add((S2Point)object);
            }
        }
        HashMap hashMap = Maps.newHashMap();
        Stack<S2Point> stack = new Stack<S2Point>();
        multiset = Lists.newArrayList();
        for (Object object : pointIndex.entries()) {
            MarkedS2Point markedS2Point = (MarkedS2Point)object.getValue();
            if (markedS2Point.isMarked()) continue;
            markedS2Point.mark();
            S2Point s2Point = markedS2Point.getPoint();
            stack.push(s2Point);
            while (!stack.isEmpty()) {
                S2Point s2Point2 = (S2Point)stack.pop();
                pointIndex.query(s2Point2, (List<S2Point>)multiset);
                for (S2Point s2Point3 : multiset) {
                    stack.push(s2Point3);
                    hashMap.put(s2Point3, s2Point);
                }
            }
        }
        this.moveVertices(hashMap);
    }

    private strictfp class MarkedS2Point {
        private S2Point point;
        private boolean mark;

        public MarkedS2Point(S2Point s2Point) {
            this.point = s2Point;
            this.mark = false;
        }

        public boolean isMarked() {
            return this.mark;
        }

        public S2Point getPoint() {
            return this.point;
        }

        public void mark() {
            this.mark = true;
        }
    }

    private strictfp class PointIndex
    extends ForwardingMultimap<S2CellId, MarkedS2Point> {
        private double searchRadius;
        private int level;
        private final Multimap<S2CellId, MarkedS2Point> delegate = HashMultimap.create();

        public PointIndex(double d) {
            this.searchRadius = d;
            this.level = Math.min(S2Projections.MIN_WIDTH.getMaxLevel(2.0 * d), 29);
        }

        protected Multimap<S2CellId, MarkedS2Point> delegate() {
            return this.delegate;
        }

        public void add(S2Point s2Point) {
            S2CellId s2CellId = S2CellId.fromPoint(s2Point).parent(this.level);
            Collection collection = this.get(s2CellId);
            for (MarkedS2Point markedS2Point : collection) {
                if (!markedS2Point.getPoint().equals(s2Point)) continue;
                return;
            }
            this.put(s2CellId, new MarkedS2Point(s2Point));
        }

        public void query(S2Point s2Point, List<S2Point> list) {
            list.clear();
            ArrayList arrayList = Lists.newArrayList();
            S2CellId.fromPoint(s2Point).getVertexNeighbors(this.level, arrayList);
            for (S2CellId s2CellId : arrayList) {
                for (MarkedS2Point markedS2Point : this.get(s2CellId)) {
                    S2Point s2Point2;
                    if (markedS2Point.isMarked() || !(s2Point.angle(s2Point2 = markedS2Point.getPoint()) <= this.searchRadius)) continue;
                    list.add(s2Point2);
                    markedS2Point.mark();
                }
            }
        }
    }

    public strictfp static enum Options {
        DIRECTED_XOR(false, true),
        UNDIRECTED_XOR(true, true),
        UNDIRECTED_UNION(true, false),
        DIRECTED_UNION(false, false);

        private boolean undirectedEdges;
        private boolean xorEdges;
        private boolean validate;
        private S1Angle mergeDistance;

        private Options(boolean bl, boolean bl2) {
            this.undirectedEdges = bl;
            this.xorEdges = bl2;
            this.validate = false;
            this.mergeDistance = S1Angle.radians(0.0);
        }

        public boolean getUndirectedEdges() {
            return this.undirectedEdges;
        }

        public boolean getXorEdges() {
            return this.xorEdges;
        }

        public boolean getValidate() {
            return this.validate;
        }

        public S1Angle getMergeDistance() {
            return this.mergeDistance;
        }

        public void setValidate(boolean bl) {
            this.validate = bl;
        }

        public void setMergeDistance(S1Angle s1Angle) {
            this.mergeDistance = s1Angle;
        }

        void setUndirectedEdges(boolean bl) {
            this.undirectedEdges = bl;
        }

        void setXorEdges(boolean bl) {
            this.xorEdges = bl;
        }
    }
}

