/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Region;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public strictfp final class S2Polyline
implements S2Region {
    private static final Logger log = Logger.getLogger(S2Polyline.class.getCanonicalName());
    private final int numVertices;
    private final S2Point[] vertices;

    public S2Polyline(List<S2Point> list) {
        this.numVertices = list.size();
        this.vertices = list.toArray(new S2Point[this.numVertices]);
    }

    public S2Polyline(S2Polyline s2Polyline) {
        this.numVertices = s2Polyline.numVertices();
        this.vertices = (S2Point[])s2Polyline.vertices.clone();
    }

    public boolean isValid(List<S2Point> list) {
        int n;
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            if (S2.isUnitLength(list.get(n))) continue;
            log.info("Vertex " + n + " is not unit length");
            return false;
        }
        for (n = 1; n < n2; ++n) {
            if (!list.get(n - 1).equals(list.get(n)) && !list.get(n - 1).equals(S2Point.neg(list.get(n)))) continue;
            log.info("Vertices " + (n - 1) + " and " + n + " are identical or antipodal");
            return false;
        }
        return true;
    }

    public int numVertices() {
        return this.numVertices;
    }

    public S2Point vertex(int n) {
        return this.vertices[n];
    }

    public S1Angle getArclengthAngle() {
        double d = 0.0;
        for (int i = 1; i < this.numVertices(); ++i) {
            d += this.vertex(i - 1).angle(this.vertex(i));
        }
        return S1Angle.radians(d);
    }

    public S2Point interpolate(double d) {
        if (d <= 0.0) {
            return this.vertex(0);
        }
        double d2 = 0.0;
        for (int i = 1; i < this.numVertices(); ++i) {
            d2 += this.vertex(i - 1).angle(this.vertex(i));
        }
        double d3 = d * d2;
        for (int i = 1; i < this.numVertices(); ++i) {
            double d4 = this.vertex(i - 1).angle(this.vertex(i));
            if (d3 < d4) {
                double d5 = Math.sin(d3) / Math.sin(d4);
                return S2Point.add(S2Point.mul(this.vertex(i - 1), Math.cos(d3) - d5 * Math.cos(d4)), S2Point.mul(this.vertex(i), d5));
            }
            d3 -= d4;
        }
        return this.vertex(this.numVertices() - 1);
    }

    @Override
    public S2Cap getCapBound() {
        return this.getRectBound().getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2EdgeUtil.RectBounder rectBounder = new S2EdgeUtil.RectBounder();
        for (int i = 0; i < this.numVertices(); ++i) {
            rectBounder.addPoint(this.vertex(i));
        }
        return rectBounder.getBound();
    }

    @Override
    public boolean contains(S2Cell s2Cell) {
        throw new UnsupportedOperationException("'containment' is not numerically well-defined except at the polyline vertices");
    }

    @Override
    public boolean mayIntersect(S2Cell s2Cell) {
        int n;
        if (this.numVertices() == 0) {
            return false;
        }
        for (int i = 0; i < this.numVertices(); ++i) {
            if (!s2Cell.contains(this.vertex(i))) continue;
            return true;
        }
        S2Point[] s2PointArray = new S2Point[4];
        for (n = 0; n < 4; ++n) {
            s2PointArray[n] = s2Cell.getVertex(n);
        }
        for (n = 0; n < 4; ++n) {
            S2EdgeUtil.EdgeCrosser edgeCrosser = new S2EdgeUtil.EdgeCrosser(s2PointArray[n], s2PointArray[n + 1 & 3], this.vertex(0));
            for (int i = 1; i < this.numVertices(); ++i) {
                if (edgeCrosser.robustCrossing(this.vertex(i)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public int getNearestEdgeIndex(S2Point s2Point) {
        Preconditions.checkState((this.numVertices() > 0 ? 1 : 0) != 0, (Object)"Empty polyline");
        if (this.numVertices() == 1) {
            return 0;
        }
        S1Angle s1Angle = S1Angle.radians(10.0);
        int n = -1;
        for (int i = 0; i < this.numVertices() - 1; ++i) {
            S1Angle s1Angle2 = S2EdgeUtil.getDistance(s2Point, this.vertex(i), this.vertex(i + 1));
            if (!s1Angle2.lessThan(s1Angle)) continue;
            s1Angle = s1Angle2;
            n = i;
        }
        return n;
    }

    public S2Point projectToEdge(S2Point s2Point, int n) {
        Preconditions.checkState((this.numVertices() > 0 ? 1 : 0) != 0, (Object)"Empty polyline");
        Preconditions.checkState((this.numVertices() == 1 || n < this.numVertices() - 1 ? 1 : 0) != 0, (Object)"Invalid edge index");
        if (this.numVertices() == 1) {
            return this.vertex(0);
        }
        return S2EdgeUtil.getClosestPoint(s2Point, this.vertex(n), this.vertex(n + 1));
    }

    public boolean equals(Object object) {
        if (!(object instanceof S2Polyline)) {
            return false;
        }
        S2Polyline s2Polyline = (S2Polyline)object;
        if (this.numVertices != s2Polyline.numVertices) {
            return false;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i].equals(s2Polyline.vertices[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.numVertices, Arrays.deepHashCode(this.vertices)});
    }
}

