/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.base.Preconditions;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellUnion;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Projections;
import com.google.common.geometry.S2Region;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;

public strictfp final class S2RegionCoverer {
    public static final int DEFAULT_MAX_CELLS = 8;
    private static final S2Cell[] FACE_CELLS = new S2Cell[6];
    private int minLevel = 0;
    private int maxLevel = 30;
    private int levelMod = 1;
    private int maxCells = 8;
    private boolean interiorCovering;
    private int candidatesCreatedCounter;
    S2Region region = null;
    ArrayList<S2CellId> result = new ArrayList();
    private PriorityQueue<QueueEntry> candidateQueue = new PriorityQueue<QueueEntry>(10, new QueueEntriesComparator());

    public void setMinLevel(int n) {
        this.minLevel = Math.max(0, Math.min(30, n));
    }

    public void setMaxLevel(int n) {
        this.maxLevel = Math.max(0, Math.min(30, n));
    }

    public int minLevel() {
        return this.minLevel;
    }

    public int maxLevel() {
        return this.maxLevel;
    }

    public int maxCells() {
        return this.maxCells;
    }

    public void setLevelMod(int n) {
        this.levelMod = Math.max(1, Math.min(3, n));
    }

    public int levelMod() {
        return this.levelMod;
    }

    public void setMaxCells(int n) {
        this.maxCells = n;
    }

    public void getCovering(S2Region s2Region, ArrayList<S2CellId> arrayList) {
        S2CellUnion s2CellUnion = this.getCovering(s2Region);
        s2CellUnion.denormalize(this.minLevel(), this.levelMod(), arrayList);
    }

    public void getInteriorCovering(S2Region s2Region, ArrayList<S2CellId> arrayList) {
        S2CellUnion s2CellUnion = this.getInteriorCovering(s2Region);
        s2CellUnion.denormalize(this.minLevel(), this.levelMod(), arrayList);
    }

    public S2CellUnion getCovering(S2Region s2Region) {
        S2CellUnion s2CellUnion = new S2CellUnion();
        this.getCovering(s2Region, s2CellUnion);
        return s2CellUnion;
    }

    public void getCovering(S2Region s2Region, S2CellUnion s2CellUnion) {
        this.interiorCovering = false;
        this.getCoveringInternal(s2Region);
        s2CellUnion.initSwap(this.result);
    }

    public S2CellUnion getInteriorCovering(S2Region s2Region) {
        S2CellUnion s2CellUnion = new S2CellUnion();
        this.getInteriorCovering(s2Region, s2CellUnion);
        return s2CellUnion;
    }

    public void getInteriorCovering(S2Region s2Region, S2CellUnion s2CellUnion) {
        this.interiorCovering = true;
        this.getCoveringInternal(s2Region);
        s2CellUnion.initSwap(this.result);
    }

    public static void getSimpleCovering(S2Region s2Region, S2Point s2Point, int n, ArrayList<S2CellId> arrayList) {
        S2RegionCoverer.floodFill(s2Region, S2CellId.fromPoint(s2Point).parent(n), arrayList);
    }

    private Candidate newCandidate(S2Cell s2Cell) {
        if (!this.region.mayIntersect(s2Cell)) {
            return null;
        }
        boolean bl = false;
        if (s2Cell.level() >= this.minLevel) {
            if (this.interiorCovering) {
                if (this.region.contains(s2Cell)) {
                    bl = true;
                } else if (s2Cell.level() + this.levelMod > this.maxLevel) {
                    return null;
                }
            } else if (s2Cell.level() + this.levelMod > this.maxLevel || this.region.contains(s2Cell)) {
                bl = true;
            }
        }
        Candidate candidate = new Candidate();
        candidate.cell = s2Cell;
        candidate.isTerminal = bl;
        if (!bl) {
            Candidate.access$302(candidate, new Candidate[1 << this.maxChildrenShift()]);
        }
        ++this.candidatesCreatedCounter;
        return candidate;
    }

    private int maxChildrenShift() {
        return 2 * this.levelMod;
    }

    private void addCandidate(Candidate candidate) {
        if (candidate == null) {
            return;
        }
        if (candidate.isTerminal) {
            this.result.add(candidate.cell.id());
            return;
        }
        int n = candidate.cell.level() < this.minLevel ? 1 : this.levelMod;
        int n2 = this.expandChildren(candidate, candidate.cell, n);
        if (candidate.numChildren != 0) {
            if (!this.interiorCovering && n2 == 1 << this.maxChildrenShift() && candidate.cell.level() >= this.minLevel) {
                candidate.isTerminal = true;
                this.addCandidate(candidate);
            } else {
                int n3 = -(((candidate.cell.level() << this.maxChildrenShift()) + candidate.numChildren << this.maxChildrenShift()) + n2);
                this.candidateQueue.add(new QueueEntry(n3, candidate));
            }
        }
    }

    private int expandChildren(Candidate candidate, S2Cell s2Cell, int n) {
        int n2;
        --n;
        S2Cell[] s2CellArray = new S2Cell[4];
        for (n2 = 0; n2 < 4; ++n2) {
            s2CellArray[n2] = new S2Cell();
        }
        s2Cell.subdivide(s2CellArray);
        n2 = 0;
        for (int i = 0; i < 4; ++i) {
            if (n > 0) {
                if (!this.region.mayIntersect(s2CellArray[i])) continue;
                n2 += this.expandChildren(candidate, s2CellArray[i], n);
                continue;
            }
            Candidate candidate2 = this.newCandidate(s2CellArray[i]);
            if (candidate2 == null) continue;
            ((Candidate)candidate).children[((Candidate)candidate).numChildren++] = candidate2;
            if (!candidate2.isTerminal) continue;
            ++n2;
        }
        return n2;
    }

    private void getInitialCandidates() {
        if (this.maxCells >= 4) {
            S2Cap s2Cap = this.region.getCapBound();
            int n = Math.min(S2Projections.MIN_WIDTH.getMaxLevel(2.0 * s2Cap.angle().radians()), Math.min(this.maxLevel(), 29));
            if (this.levelMod() > 1 && n > this.minLevel()) {
                n -= (n - this.minLevel()) % this.levelMod();
            }
            if (n > 0) {
                ArrayList<S2CellId> arrayList = new ArrayList<S2CellId>(4);
                S2CellId s2CellId = S2CellId.fromPoint(s2Cap.axis());
                s2CellId.getVertexNeighbors(n, arrayList);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.addCandidate(this.newCandidate(new S2Cell(arrayList.get(i))));
                }
                return;
            }
        }
        for (int i = 0; i < 6; ++i) {
            this.addCandidate(this.newCandidate(FACE_CELLS[i]));
        }
    }

    private void getCoveringInternal(S2Region s2Region) {
        Preconditions.checkState((this.candidateQueue.isEmpty() && this.result.isEmpty() ? 1 : 0) != 0);
        this.region = s2Region;
        this.candidatesCreatedCounter = 0;
        this.getInitialCandidates();
        while (!(this.candidateQueue.isEmpty() || this.interiorCovering && this.result.size() >= this.maxCells)) {
            Candidate candidate = this.candidateQueue.poll().candidate;
            if (candidate.cell.level() < this.minLevel || candidate.numChildren == 1 || this.result.size() + (this.interiorCovering ? 0 : this.candidateQueue.size()) + candidate.numChildren <= this.maxCells) {
                for (int i = 0; i < candidate.numChildren; ++i) {
                    this.addCandidate(candidate.children[i]);
                }
                continue;
            }
            if (this.interiorCovering) continue;
            candidate.isTerminal = true;
            this.addCandidate(candidate);
        }
        this.candidateQueue.clear();
        this.region = null;
    }

    private static void floodFill(S2Region s2Region, S2CellId s2CellId, ArrayList<S2CellId> arrayList) {
        HashSet<S2CellId> hashSet = new HashSet<S2CellId>();
        ArrayList<S2CellId> arrayList2 = new ArrayList<S2CellId>();
        arrayList.clear();
        hashSet.add(s2CellId);
        arrayList2.add(s2CellId);
        while (!arrayList2.isEmpty()) {
            S2CellId s2CellId2 = (S2CellId)arrayList2.get(arrayList2.size() - 1);
            arrayList2.remove(arrayList2.size() - 1);
            if (!s2Region.mayIntersect(new S2Cell(s2CellId2))) continue;
            arrayList.add(s2CellId2);
            S2CellId[] s2CellIdArray = new S2CellId[4];
            s2CellId2.getEdgeNeighbors(s2CellIdArray);
            for (int i = 0; i < 4; ++i) {
                S2CellId s2CellId3 = s2CellIdArray[i];
                boolean bl = hashSet.contains(s2CellId3);
                if (hashSet.contains(s2CellId3)) continue;
                arrayList2.add(s2CellId3);
                hashSet.add(s2CellId3);
            }
        }
    }

    static {
        for (int i = 0; i < 6; ++i) {
            S2RegionCoverer.FACE_CELLS[i] = S2Cell.fromFacePosLevel(i, (byte)0, 0);
        }
    }

    strictfp static class QueueEntriesComparator
    implements Comparator<QueueEntry> {
        QueueEntriesComparator() {
        }

        @Override
        public int compare(QueueEntry queueEntry, QueueEntry queueEntry2) {
            return queueEntry.id < queueEntry2.id ? 1 : (queueEntry.id > queueEntry2.id ? -1 : 0);
        }
    }

    strictfp static class QueueEntry {
        private int id;
        private Candidate candidate;

        public QueueEntry(int n, Candidate candidate) {
            this.id = n;
            this.candidate = candidate;
        }
    }

    strictfp static class Candidate {
        private S2Cell cell;
        private boolean isTerminal;
        private int numChildren;
        private Candidate[] children;

        Candidate() {
        }

        static /* synthetic */ Candidate[] access$302(Candidate candidate, Candidate[] candidateArray) {
            candidate.children = candidateArray;
            return candidateArray;
        }
    }
}

