/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.kits;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.mparticle.kits.SkyhookIntentService;
import com.mparticle.kits.SkyhookLog;
import com.mparticle.kits.SkyhookPreferences;
import com.skyhookwireless.accelerator.AcceleratorClient;

public class SkyhookBootReceiver
extends BroadcastReceiver
implements AcceleratorClient.ConnectionCallbacks,
AcceleratorClient.OnConnectionFailedListener,
AcceleratorClient.OnRegisterForCampaignMonitoringResultListener {
    public void onReceive(Context context, Intent intent) {
        String apiKey = new SkyhookPreferences(context).getApiKey();
        if (apiKey == null || apiKey.equals("")) {
            SkyhookLog.e("not resuming monitoring after reboot");
            return;
        }
        Intent serviceIntent = new Intent(context, SkyhookIntentService.class);
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)serviceIntent, (int)0x8000000);
        SkyhookLog.i("resuming monitoring after reboot");
        AcceleratorClient accelerator = new AcceleratorClient(context, apiKey, (AcceleratorClient.ConnectionCallbacks)this, (AcceleratorClient.OnConnectionFailedListener)this);
        accelerator.registerForCampaignMonitoring(pendingIntent, (AcceleratorClient.OnRegisterForCampaignMonitoringResultListener)this);
    }

    public void onConnected() {
    }

    public void onDisconnected() {
    }

    public void onConnectionFailed(int errorCode) {
    }

    public void onRegisterForCampaignMonitoringResult(int statusCode, PendingIntent pendingIntent) {
        if (statusCode == 0) {
            SkyhookLog.i("resumed monitoring after reboot");
        } else {
            SkyhookLog.e("failed to resume monitoring after reboot: " + statusCode);
        }
    }
}

