/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.kits;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.mparticle.internal.MPUtility;
import com.mparticle.kits.KitIntegration;
import com.mparticle.kits.ReportingMessage;
import com.mparticle.kits.SkyhookIntentService;
import com.mparticle.kits.SkyhookLog;
import com.mparticle.kits.SkyhookPreferences;
import com.skyhookwireless.accelerator.AcceleratorClient;
import java.util.List;
import java.util.Map;

public class SkyhookKit
extends KitIntegration
implements KitIntegration.ActivityListener,
AcceleratorClient.ConnectionCallbacks,
AcceleratorClient.OnConnectionFailedListener,
AcceleratorClient.OnRegisterForCampaignMonitoringResultListener,
AcceleratorClient.OnStartCampaignMonitoringResultListener,
AcceleratorClient.OnStopCampaignMonitoringResultListener {
    private static final String API_KEY = "apiKey";
    private AcceleratorClient _client;
    private boolean _isInitialized;
    private boolean _isRegistered;
    private SkyhookPreferences _preferences;

    public String getName() {
        return "Skyhook";
    }

    protected List<ReportingMessage> onKitCreate(Map<String, String> settings, Context context) {
        SkyhookLog.d("onKitCreate");
        String apiKey = settings.get(API_KEY);
        this._preferences = new SkyhookPreferences(context);
        this._preferences.setApiKey(apiKey);
        this._client = new AcceleratorClient(context, apiKey, (AcceleratorClient.ConnectionCallbacks)this, (AcceleratorClient.OnConnectionFailedListener)this);
        SkyhookLog.i("Accelerator SDK v" + this._client.getVersion());
        this.initialize();
        return null;
    }

    protected void onKitDestroy() {
        SkyhookLog.d("onKitDestroy");
        this.shutdown();
        this._preferences.clearApiKey();
        SkyhookLog.d("destroyed");
    }

    public void onSettingsUpdated(Map<String, String> settings) {
        SkyhookLog.d("onSettingsUpdated");
        String newApiKey = settings.get(API_KEY);
        String oldApiKey = this._preferences.getApiKey();
        if (oldApiKey == null) {
            SkyhookLog.i("not running");
        } else if (oldApiKey.equals(newApiKey)) {
            SkyhookLog.i("the key hasn't changed");
        } else {
            SkyhookLog.i("shutting down because the key has changed");
            this.shutdown();
            this._preferences.clearApiKey();
        }
    }

    public List<ReportingMessage> setOptOut(boolean optOutStatus) {
        return null;
    }

    public void onConnected() {
        SkyhookLog.d("connected");
        this._client.registerForCampaignMonitoring(SkyhookKit.getServiceIntent(this.getContext()), (AcceleratorClient.OnRegisterForCampaignMonitoringResultListener)this);
    }

    public void onDisconnected() {
        SkyhookLog.d("disconnected");
    }

    public void onConnectionFailed(int errorCode) {
        SkyhookLog.e("connection failed: " + errorCode);
    }

    public void onRegisterForCampaignMonitoringResult(int statusCode, PendingIntent pendingIntent) {
        if (statusCode == 0) {
            this._isRegistered = true;
            this._client.startMonitoringForAllCampaigns((AcceleratorClient.OnStartCampaignMonitoringResultListener)this);
        } else {
            SkyhookLog.e("failed to register: " + statusCode);
        }
    }

    public void onStartCampaignMonitoringResult(int statusCode, String campaignName) {
        if (statusCode == 0) {
            SkyhookLog.i("monitoring started");
        } else {
            SkyhookLog.e("failed to start monitoring: " + statusCode);
        }
    }

    public void onStopCampaignMonitoringResult(int statusCode, String campaignName) {
        if (statusCode == 0) {
            SkyhookLog.i("monitoring stopped");
        } else {
            SkyhookLog.e("failed to stop monitoring: " + statusCode);
        }
    }

    public List<ReportingMessage> onActivityCreated(Activity activity, Bundle bundle) {
        return null;
    }

    public List<ReportingMessage> onActivityStarted(Activity activity) {
        return null;
    }

    public List<ReportingMessage> onActivityResumed(Activity activity) {
        this.initialize();
        return null;
    }

    public List<ReportingMessage> onActivityPaused(Activity activity) {
        return null;
    }

    public List<ReportingMessage> onActivityStopped(Activity activity) {
        return null;
    }

    public List<ReportingMessage> onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        return null;
    }

    public List<ReportingMessage> onActivityDestroyed(Activity activity) {
        return null;
    }

    private static PendingIntent getServiceIntent(Context context) {
        return PendingIntent.getService((Context)context, (int)0, (Intent)new Intent(context, SkyhookIntentService.class), (int)0x8000000);
    }

    private void initialize() {
        if (this._client == null || this._isInitialized) {
            return;
        }
        if (MPUtility.checkPermission((Context)this.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION")) {
            SkyhookLog.i("location permission granted");
            this._client.connect();
            this._isInitialized = true;
        } else {
            SkyhookLog.i("location permission is not granted yet");
        }
    }

    private void shutdown() {
        if (this._client == null || !this._client.isConnected()) {
            return;
        }
        if (this._isRegistered) {
            this._client.stopMonitoringForAllCampaigns((AcceleratorClient.OnStopCampaignMonitoringResultListener)this);
        }
        this._client.disconnect();
    }
}

