/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.DirectBuffer;
import com.almworks.sqlite4java.Internal;
import com.almworks.sqlite4java.ProgressHandler;
import com.almworks.sqlite4java.SQLParts;
import com.almworks.sqlite4java.SQLite;
import com.almworks.sqlite4java.SQLiteBackup;
import com.almworks.sqlite4java.SQLiteBlob;
import com.almworks.sqlite4java.SQLiteBusyException;
import com.almworks.sqlite4java.SQLiteColumnMetadata;
import com.almworks.sqlite4java.SQLiteController;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteInterruptedException;
import com.almworks.sqlite4java.SQLiteLongArray;
import com.almworks.sqlite4java.SQLiteProfiler;
import com.almworks.sqlite4java.SQLiteStatement;
import com.almworks.sqlite4java.SWIGTYPE_p_intarray;
import com.almworks.sqlite4java.SWIGTYPE_p_intarray_module;
import com.almworks.sqlite4java.SWIGTYPE_p_sqlite3;
import com.almworks.sqlite4java.SWIGTYPE_p_sqlite3_backup;
import com.almworks.sqlite4java.SWIGTYPE_p_sqlite3_blob;
import com.almworks.sqlite4java.SWIGTYPE_p_sqlite3_stmt;
import com.almworks.sqlite4java._SQLiteManual;
import com.almworks.sqlite4java._SQLiteSwigged;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javolution.util.stripped.FastMap;

public final class SQLiteConnection {
    public static final String DEFAULT_DB_NAME = "main";
    private static final int MAX_POOLED_DIRECT_BUFFER_SIZE = 0x100000;
    private static final int DEFAULT_STEPS_PER_CALLBACK = 1;
    private final File myFile;
    private final int myNumber = Internal.nextConnectionNumber();
    private final Object myLock = new Object();
    private volatile Thread myConfinement;
    private SWIGTYPE_p_sqlite3 myHandle;
    private boolean myDisposed;
    private final ArrayList<SQLiteStatement> myStatements = new ArrayList(100);
    private final ArrayList<SQLiteBlob> myBlobs = new ArrayList(10);
    private final ArrayList<DirectBuffer> myBuffers = new ArrayList(10);
    private int myBuffersTotalSize;
    private final FastMap<SQLParts, SWIGTYPE_p_sqlite3_stmt> myStatementCache = new FastMap();
    private final SQLiteController myCachedController = new CachedController();
    private final SQLiteController myUncachedController = new UncachedController();
    private final _SQLiteManual mySQLiteManual = new _SQLiteManual();
    private SWIGTYPE_p_intarray_module myIntArrayModule;
    private ProgressHandler myProgressHandler;
    private volatile int myStepsPerCallback = 1;
    private volatile SQLiteProfiler myProfiler;
    private final FastMap<String, SWIGTYPE_p_intarray> myLongArrays = FastMap.newInstance();
    private int myLongArrayCounter;
    private int myOpenFlags;

    public SQLiteConnection(File dbfile) {
        this.myFile = dbfile;
        Internal.logInfo(this, "instantiated [" + this.myFile + "]");
    }

    public SQLiteConnection() {
        this(null);
    }

    public File getDatabaseFile() {
        return this.myFile;
    }

    public boolean isMemoryDatabase() {
        return this.myFile == null;
    }

    public void setStepsPerCallback(int stepsPerCallback) {
        if (stepsPerCallback > 0) {
            this.myStepsPerCallback = stepsPerCallback;
        }
    }

    public int setLimit(int id, int newVal) throws SQLiteException {
        this.checkThread();
        return _SQLiteSwigged.sqlite3_limit(this.handle(), id, newVal);
    }

    public int getLimit(int id) throws SQLiteException {
        this.checkThread();
        return _SQLiteSwigged.sqlite3_limit(this.handle(), id, -1);
    }

    public SQLiteConnection open(boolean allowCreate) throws SQLiteException {
        int flags = 2;
        if (!allowCreate) {
            if (this.isMemoryDatabase()) {
                throw new SQLiteException(-99, "cannot open memory database without creation");
            }
        } else {
            flags |= 4;
        }
        this.open0(flags);
        return this;
    }

    public SQLiteConnection open() throws SQLiteException {
        return this.open(true);
    }

    public SQLiteConnection openReadonly() throws SQLiteException {
        if (this.isMemoryDatabase()) {
            throw new SQLiteException(-99, "cannot open memory database in read-only mode");
        }
        this.open0(1);
        return this;
    }

    public SQLiteConnection openV2(int flags) throws SQLiteException {
        this.open0(flags);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myHandle != null && !this.myDisposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDisposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOpenFlags() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myOpenFlags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SWIGTYPE_p_sqlite3 handle;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                return;
            }
            Thread confinement = this.myConfinement;
            if (confinement != null && confinement != Thread.currentThread()) {
                Internal.recoverableError(this, "will not dispose from a non-confining thread", true);
                return;
            }
            this.myDisposed = true;
            handle = this.myHandle;
            this.myHandle = null;
            this.myOpenFlags = 0;
        }
        if (handle == null) {
            return;
        }
        Internal.logFine(this, "disposing");
        this.finalizeStatements();
        this.finalizeBlobs();
        this.finalizeBuffers();
        this.finalizeProgressHandler(handle);
        int rc = _SQLiteSwigged.sqlite3_close(handle);
        if (rc != 0) {
            String errmsg = null;
            try {
                errmsg = _SQLiteSwigged.sqlite3_errmsg(handle);
            }
            catch (Exception e) {
                Internal.log(Level.WARNING, this, "cannot get sqlite3_errmsg", e);
            }
            Internal.logWarn(this, "close error " + rc + (errmsg == null ? "" : ": " + errmsg));
        }
        Internal.logInfo(this, "connection closed");
        this.myConfinement = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteConnection exec(String sql) throws SQLiteException {
        this.checkThread();
        SQLiteProfiler profiler = this.myProfiler;
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "exec [" + sql + "]");
        }
        SWIGTYPE_p_sqlite3 handle = this.handle();
        ProgressHandler ph = this.getProgressHandler();
        ph.reset();
        try {
            String[] error = new String[]{null};
            long from = profiler == null ? 0L : System.nanoTime();
            int rc = _SQLiteManual.sqlite3_exec(handle, sql, error);
            if (profiler != null) {
                profiler.reportExec(sql, from, System.nanoTime(), rc);
            }
            this.throwResult(rc, "exec()", error[0]);
        }
        finally {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "exec [" + sql + "]: " + ph.getSteps() + " steps");
            }
            ph.reset();
        }
        return this;
    }

    public SQLiteColumnMetadata getTableColumnMetadata(String dbName, String tableName, String columnName) throws SQLiteException {
        this.checkThread();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "calling sqlite3_table_column_metadata [" + dbName + "," + tableName + "," + columnName + "]");
        }
        return this.mySQLiteManual.sqlite3_table_column_metadata(this.handle(), dbName, tableName, columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteStatement prepare(SQLParts sql, boolean cached) throws SQLiteException {
        SWIGTYPE_p_sqlite3 handle;
        Object e;
        this.checkThread();
        SQLiteProfiler profiler = this.myProfiler;
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "prepare [" + sql + "]");
        }
        if (sql == null) {
            throw new IllegalArgumentException();
        }
        SWIGTYPE_p_sqlite3_stmt stmt = null;
        SQLParts fixedKey = null;
        Object object = this.myLock;
        synchronized (object) {
            if (cached && (e = this.myStatementCache.getEntry(sql)) != null) {
                fixedKey = ((FastMap.Entry)e).getKey();
                assert (fixedKey != null);
                assert (fixedKey.isFixed()) : sql;
                stmt = ((FastMap.Entry)e).getValue();
                if (stmt != null) {
                    ((FastMap.Entry)e).setValue(null);
                }
            }
            handle = this.handle();
        }
        if (stmt == null) {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "calling sqlite3_prepare_v2 for [" + sql + "]");
            }
            long from = profiler == null ? 0L : System.nanoTime();
            String sqlString = sql.toString();
            if (sqlString.trim().length() == 0) {
                throw new SQLiteException(-999, "empty SQL");
            }
            stmt = this.mySQLiteManual.sqlite3_prepare_v2(handle, sqlString);
            int rc = this.mySQLiteManual.getLastReturnCode();
            if (profiler != null) {
                profiler.reportPrepare(sqlString, from, System.nanoTime(), rc);
            }
            this.throwResult(rc, "prepare()", sql);
            if (stmt == null) {
                throw new SQLiteException(-99, "sqlite did not return stmt");
            }
        } else if (Internal.isFineLogging()) {
            Internal.logFine(this, "using cached stmt for [" + sql + "]");
        }
        SQLiteStatement statement = null;
        e = this.myLock;
        synchronized (e) {
            if (this.myHandle != null) {
                SQLiteController controller;
                SQLiteController sQLiteController = controller = cached ? this.myCachedController : this.myUncachedController;
                if (fixedKey == null) {
                    fixedKey = sql.getFixedParts();
                }
                statement = new SQLiteStatement(controller, stmt, fixedKey, this.myProfiler);
                this.myStatements.add(statement);
            } else {
                Internal.logWarn(this, "connection disposed while preparing statement for [" + sql + "]");
            }
        }
        if (statement == null) {
            try {
                this.throwResult(_SQLiteSwigged.sqlite3_finalize(stmt), "finalize() in prepare()");
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new SQLiteException(-97, "connection disposed");
        }
        return statement;
    }

    public SQLiteStatement prepare(String sql) throws SQLiteException {
        return this.prepare(sql, true);
    }

    public SQLiteStatement prepare(String sql, boolean cached) throws SQLiteException {
        return this.prepare(new SQLParts(sql), cached);
    }

    public SQLiteStatement prepare(SQLParts sql) throws SQLiteException {
        return this.prepare(sql, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteBlob blob(String dbname, String table, String column, long rowid, boolean writeAccess) throws SQLiteException {
        this.checkThread();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "openBlob [" + dbname + "," + table + "," + column + "," + rowid + "," + writeAccess + "]");
        }
        SWIGTYPE_p_sqlite3 handle = this.handle();
        SWIGTYPE_p_sqlite3_blob blob = this.mySQLiteManual.sqlite3_blob_open(handle, dbname, table, column, rowid, writeAccess);
        this.throwResult(this.mySQLiteManual.getLastReturnCode(), "openBlob()", null);
        if (blob == null) {
            throw new SQLiteException(-99, "sqlite did not return blob");
        }
        SQLiteBlob result = null;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myHandle != null) {
                result = new SQLiteBlob(this.myUncachedController, blob, dbname, table, column, rowid, writeAccess);
                this.myBlobs.add(result);
            } else {
                Internal.logWarn(this, "connection disposed while opening blob");
            }
        }
        if (result == null) {
            try {
                this.throwResult(_SQLiteSwigged.sqlite3_blob_close(blob), "blob_close() in prepare()");
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new SQLiteException(-97, "connection disposed");
        }
        return result;
    }

    public SQLiteBlob blob(String table, String column, long rowid, boolean writeAccess) throws SQLiteException {
        return this.blob(null, table, column, rowid, writeAccess);
    }

    public SQLiteConnection setBusyTimeout(long millis) throws SQLiteException {
        this.checkThread();
        int rc = _SQLiteSwigged.sqlite3_busy_timeout(this.handle(), (int)millis);
        this.throwResult(rc, "setBusyTimeout");
        return this;
    }

    public boolean getAutoCommit() throws SQLiteException {
        this.checkThread();
        int r = _SQLiteSwigged.sqlite3_get_autocommit(this.handle());
        return r != 0;
    }

    public long getLastInsertId() throws SQLiteException {
        this.checkThread();
        long id = _SQLiteSwigged.sqlite3_last_insert_rowid(this.handle());
        return id;
    }

    public int getChanges() throws SQLiteException {
        this.checkThread();
        return _SQLiteSwigged.sqlite3_changes(this.handle());
    }

    public int getTotalChanges() throws SQLiteException {
        this.checkThread();
        return _SQLiteSwigged.sqlite3_total_changes(this.handle());
    }

    public void interrupt() throws SQLiteException {
        _SQLiteSwigged.sqlite3_interrupt(this.handle());
    }

    public int getErrorCode() throws SQLiteException {
        this.checkThread();
        return _SQLiteSwigged.sqlite3_errcode(this.handle());
    }

    public String getErrorMessage() throws SQLiteException {
        this.checkThread();
        return _SQLiteSwigged.sqlite3_errmsg(this.handle());
    }

    public SQLiteProfiler profile() {
        SQLiteProfiler profiler = this.myProfiler;
        if (profiler == null) {
            this.myProfiler = profiler = new SQLiteProfiler();
        }
        return profiler;
    }

    public SQLiteProfiler stopProfiling() {
        SQLiteProfiler profiler = this.myProfiler;
        this.myProfiler = null;
        return profiler;
    }

    public SQLiteLongArray createArray(String name, boolean cached) throws SQLiteException {
        SWIGTYPE_p_intarray array;
        this.checkThread();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "createArray [" + name + "," + cached + "]");
        }
        if (!cached && name != null && this.myLongArrays.containsKey(name)) {
            Internal.logWarn(this, "using cached array in lieu of passed parameter, because name already in use");
            cached = true;
        }
        if (!cached) {
            return this.createArray0(name, this.myUncachedController);
        }
        if (name == null && !this.myLongArrays.isEmpty()) {
            name = (String)((FastMap.Entry)this.myLongArrays.head().getNext()).getKey();
        }
        SWIGTYPE_p_intarray sWIGTYPE_p_intarray = array = name == null ? null : this.myLongArrays.remove(name);
        if (array != null) {
            return new SQLiteLongArray(this.myCachedController, array, name);
        }
        return this.createArray0(name, this.myCachedController);
    }

    public SQLiteLongArray createArray() throws SQLiteException {
        return this.createArray(null, true);
    }

    public SQLiteBackup initializeBackup(String sourceDbName, File destinationDbFile, int flags) throws SQLiteException {
        this.checkThread();
        SQLiteConnection destination = new SQLiteConnection(destinationDbFile).openV2(flags);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "initializeBackup to " + destination);
        }
        SWIGTYPE_p_sqlite3 sourceDb = this.handle();
        SWIGTYPE_p_sqlite3 destinationDb = destination.handle();
        SWIGTYPE_p_sqlite3_backup backup = _SQLiteSwigged.sqlite3_backup_init(destinationDb, DEFAULT_DB_NAME, sourceDb, sourceDbName);
        if (backup == null) {
            try {
                int errorCode = destination.getErrorCode();
                destination.throwResult(errorCode, "backup initialization");
                throw new SQLiteException(-99, "backup failed to start but error code is 0");
            }
            catch (Throwable throwable) {
                destination.dispose();
                throw throwable;
            }
        }
        SQLiteController destinationController = destination.myUncachedController;
        return new SQLiteBackup(this.myUncachedController, destinationController, backup, this, destination);
    }

    public SQLiteBackup initializeBackup(File destinationDbFile) throws SQLiteException {
        return this.initializeBackup(DEFAULT_DB_NAME, destinationDbFile, 6);
    }

    public void setExtensionLoadingEnabled(boolean enabled) throws SQLiteException {
        this.checkThread();
        int rc = _SQLiteSwigged.sqlite3_enable_load_extension(this.handle(), enabled ? 1 : 0);
        this.throwResult(rc, "enableLoadExtension()");
        if (Internal.isFineLogging()) {
            Internal.logFine(this, enabled ? "Extension load enabled" : "Extension load disabled");
        }
    }

    public void loadExtension(File extensionFile, String entryPoint) throws SQLiteException {
        this.checkThread();
        SWIGTYPE_p_sqlite3 handle = this.handle();
        String path = extensionFile.getAbsolutePath();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "loading extension from (" + path + "," + entryPoint + ")");
        }
        String error = this.mySQLiteManual.sqlite3_load_extension(handle, path, entryPoint);
        int rc = this.mySQLiteManual.getLastReturnCode();
        this.throwResult(rc, "loadExtension()", error);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "extension (" + path + "," + entryPoint + ") loaded");
        }
    }

    public void loadExtension(File extensionFile) throws SQLiteException {
        this.loadExtension(extensionFile, null);
    }

    private SQLiteLongArray createArray0(String name, SQLiteController controller) throws SQLiteException {
        SWIGTYPE_p_sqlite3 handle = this.handle();
        if (name == null) {
            name = this.nextArrayName();
        }
        SWIGTYPE_p_intarray_module module = this.getIntArrayModule(handle);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "creating intarray [" + name + "]");
        }
        SWIGTYPE_p_intarray r = this.mySQLiteManual.sqlite3_intarray_create(module, name);
        int rc = this.mySQLiteManual.getLastReturnCode();
        if (rc != 0) {
            this.throwResult(rc, "createArray()", name + " (cannot allocate virtual table)");
        }
        if (r == null) {
            this.throwResult(-99, "createArray()", name);
        }
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "created intarray [" + name + "]");
        }
        return new SQLiteLongArray(controller, r, name);
    }

    private SWIGTYPE_p_intarray_module getIntArrayModule(SWIGTYPE_p_sqlite3 handle) throws SQLiteException {
        SWIGTYPE_p_intarray_module r = this.myIntArrayModule;
        if (r == null) {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "registering INTARRAY module");
            }
            this.myIntArrayModule = r = this.mySQLiteManual.sqlite3_intarray_register(handle);
            this.throwResult(this.mySQLiteManual.getLastReturnCode(), "getIntArrayModule()");
            if (r == null) {
                this.throwResult(-99, "getIntArrayModule()");
            }
        }
        return r;
    }

    private String nextArrayName() {
        return String.format("__IA%02X", ++this.myLongArrayCounter);
    }

    private void finalizeProgressHandler(SWIGTYPE_p_sqlite3 handle) {
        ProgressHandler handler;
        if (Thread.currentThread() == this.myConfinement && (handler = this.myProgressHandler) != null) {
            _SQLiteManual.uninstall_progress_handler(handle, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeBuffers() {
        DirectBuffer[] buffers;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myBuffers.isEmpty()) {
                return;
            }
            buffers = this.myBuffers.toArray(new DirectBuffer[this.myBuffers.size()]);
            this.myBuffers.clear();
            this.myBuffersTotalSize = 0;
        }
        if (Thread.currentThread() == this.myConfinement) {
            for (DirectBuffer buffer : buffers) {
                _SQLiteManual.wrapper_free(buffer);
            }
        } else {
            Internal.logWarn(this, "cannot free " + buffers.length + " buffers from alien thread (" + Thread.currentThread() + ")");
        }
    }

    private ProgressHandler getProgressHandler() throws SQLiteException {
        ProgressHandler handler = this.myProgressHandler;
        if (handler == null) {
            handler = this.mySQLiteManual.install_progress_handler(this.handle(), this.myStepsPerCallback);
            if (handler == null) {
                Internal.logWarn(this, "cannot install progress handler [" + this.mySQLiteManual.getLastReturnCode() + "]");
                handler = ProgressHandler.DISPOSED;
            }
            this.myProgressHandler = handler;
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeStatements() {
        boolean alienThread;
        boolean bl = alienThread = this.myConfinement != Thread.currentThread();
        if (!alienThread) {
            Internal.logFine(this, "finalizing statements");
            block9: while (true) {
                SQLiteStatement[] statements = null;
                Object object = this.myLock;
                synchronized (object) {
                    if (this.myStatements.isEmpty()) {
                        break;
                    }
                    statements = this.myStatements.toArray(new SQLiteStatement[this.myStatements.size()]);
                }
                SQLiteStatement[] arr$ = statements;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block9;
                    SQLiteStatement statement = arr$[i$];
                    this.finalizeStatement(statement);
                    ++i$;
                }
                break;
            }
            while (true) {
                SWIGTYPE_p_sqlite3_stmt stmt = null;
                SQLParts sql = null;
                Object object = this.myLock;
                synchronized (object) {
                    if (this.myStatementCache.isEmpty()) {
                        break;
                    }
                    Map.Entry<SQLParts, SWIGTYPE_p_sqlite3_stmt> e = this.myStatementCache.entrySet().iterator().next();
                    sql = e.getKey();
                    stmt = e.getValue();
                }
                this.finalizeStatement(stmt, sql);
            }
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myStatements.isEmpty() || !this.myStatementCache.isEmpty()) {
                int count = this.myStatements.size() + this.myStatementCache.size();
                if (alienThread) {
                    Internal.logWarn(this, "cannot finalize " + count + " statements from alien thread");
                } else {
                    Internal.recoverableError(this, count + " statements are not finalized", false);
                }
            }
            this.myStatements.clear();
            this.myStatementCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeBlobs() {
        boolean alienThread;
        boolean bl = alienThread = this.myConfinement != Thread.currentThread();
        if (!alienThread) {
            Internal.logFine(this, "finalizing blobs");
            block6: while (true) {
                SQLiteBlob[] blobs = null;
                Object object = this.myLock;
                synchronized (object) {
                    if (this.myBlobs.isEmpty()) {
                        break;
                    }
                    blobs = this.myBlobs.toArray(new SQLiteBlob[this.myBlobs.size()]);
                }
                SQLiteBlob[] arr$ = blobs;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block6;
                    SQLiteBlob blob = arr$[i$];
                    this.finalizeBlob(blob);
                    ++i$;
                }
                break;
            }
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myBlobs.isEmpty()) {
                int count = this.myBlobs.size();
                if (alienThread) {
                    Internal.logWarn(this, "cannot finalize " + count + " blobs from alien thread");
                } else {
                    Internal.recoverableError(this, count + " blobs are not finalized", false);
                }
            }
            this.myBlobs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeStatement(SWIGTYPE_p_sqlite3_stmt handle, SQLParts sql) {
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "finalizing cached stmt for " + sql);
        }
        this.softFinalize(handle, sql);
        Object object = this.myLock;
        synchronized (object) {
            this.forgetCachedHandle(handle, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeStatement(SQLiteStatement statement) {
        Internal.logFine(statement, "finalizing");
        SWIGTYPE_p_sqlite3_stmt handle = statement.statementHandle();
        SQLParts sql = statement.getSqlParts();
        statement.clear();
        this.softFinalize(handle, statement);
        Object object = this.myLock;
        synchronized (object) {
            this.forgetStatement(statement);
            this.forgetCachedHandle(handle, sql);
        }
    }

    private void finalizeArray(SQLiteLongArray array) {
        Internal.logFine(array, "finalizing");
        SWIGTYPE_p_intarray handle = array.arrayHandle();
        String tableName = array.getName();
        int rc = _SQLiteManual.sqlite3_intarray_destroy(handle);
        if (rc != 0) {
            Internal.logWarn(this, "error [" + rc + "] finalizing array " + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeBlob(SQLiteBlob blob) {
        Internal.logFine(blob, "finalizing");
        SWIGTYPE_p_sqlite3_blob handle = blob.blobHandle();
        blob.clear();
        this.softClose(handle, blob);
        Object object = this.myLock;
        synchronized (object) {
            this.forgetBlob(blob);
        }
    }

    private void softFinalize(SWIGTYPE_p_sqlite3_stmt handle, Object source) {
        int rc = _SQLiteSwigged.sqlite3_finalize(handle);
        if (rc != 0) {
            Internal.logWarn(this, "error [" + rc + "] finishing " + source);
        }
    }

    private void softClose(SWIGTYPE_p_sqlite3_blob handle, Object source) {
        int rc = _SQLiteSwigged.sqlite3_blob_close(handle);
        if (rc != 0) {
            Internal.logWarn(this, "error [" + rc + "] finishing " + source);
        }
    }

    private void cacheArrayHandle(SQLiteLongArray array) {
        if (Internal.isFineLogging()) {
            Internal.logFine(array, "returning handle to cache");
        }
        boolean finalize = false;
        SWIGTYPE_p_intarray handle = array.arrayHandle();
        if (handle == null) {
            Internal.logWarn(array, "no handle");
            return;
        }
        try {
            int rc = _SQLiteManual.sqlite3_intarray_unbind(handle);
            this.throwResult(rc, "intarray_unbind");
        }
        catch (SQLiteException e) {
            Internal.log(Level.WARNING, array, "exception when clearing", e);
            finalize = true;
        }
        if (finalize) {
            this.finalizeArray(array);
        } else {
            SWIGTYPE_p_intarray expunged = this.myLongArrays.put(array.getName(), handle);
            if (expunged != null) {
                Internal.logWarn(array, handle + " expunged " + expunged);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheStatementHandle(SQLiteStatement statement) {
        if (Internal.isFineLogging()) {
            Internal.logFine(statement, "returning handle to cache");
        }
        boolean finalize = false;
        SWIGTYPE_p_sqlite3_stmt handle = statement.statementHandle();
        SQLParts sql = statement.getSqlParts();
        try {
            int rc;
            if (statement.hasStepped()) {
                rc = _SQLiteSwigged.sqlite3_reset(handle);
                this.throwResult(rc, "reset");
            }
            if (statement.hasBindings()) {
                rc = _SQLiteSwigged.sqlite3_clear_bindings(handle);
                this.throwResult(rc, "clearBindings");
            }
        }
        catch (SQLiteException e) {
            Internal.log(Level.WARNING, statement, "exception when clearing", e);
            finalize = true;
        }
        Object object = this.myLock;
        synchronized (object) {
            SWIGTYPE_p_sqlite3_stmt expunged;
            if (!finalize && (expunged = this.myStatementCache.put(sql, handle)) != null) {
                if (expunged == handle) {
                    Internal.recoverableError(statement, "handle appeared in cache when inserted", true);
                } else {
                    if (Internal.isFineLogging()) {
                        Internal.logFine(statement, "second cached copy for [" + sql + "] prevails");
                    }
                    this.myStatementCache.put(sql, expunged);
                    finalize = true;
                }
            }
            this.forgetStatement(statement);
        }
        if (finalize) {
            Internal.logFine(statement, "cache don't need me, finalizing");
            this.finalizeStatement(handle, sql);
        }
    }

    private void forgetCachedHandle(SWIGTYPE_p_sqlite3_stmt handle, SQLParts sql) {
        assert (Thread.holdsLock(this.myLock));
        SWIGTYPE_p_sqlite3_stmt removedHandle = this.myStatementCache.remove(sql);
        if (removedHandle != null && removedHandle != handle) {
            this.myStatementCache.put(sql, removedHandle);
        }
    }

    private void forgetStatement(SQLiteStatement statement) {
        assert (Thread.holdsLock(this.myLock));
        boolean removed = this.myStatements.remove(statement);
        if (!removed) {
            Internal.recoverableError(statement, "alien statement", true);
        }
    }

    private void forgetBlob(SQLiteBlob blob) {
        assert (Thread.holdsLock(this.myLock));
        boolean removed = this.myBlobs.remove(blob);
        if (!removed) {
            Internal.recoverableError(blob, "alien blob", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWIGTYPE_p_sqlite3 handle() throws SQLiteException {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                throw new SQLiteException(-92, "connection is disposed");
            }
            SWIGTYPE_p_sqlite3 handle = this.myHandle;
            if (handle == null) {
                throw new SQLiteException(-97, null);
            }
            return handle;
        }
    }

    void throwResult(int resultCode, String operation) throws SQLiteException {
        this.throwResult(resultCode, operation, null);
    }

    void throwResult(int resultCode, String operation, Object additional) throws SQLiteException {
        String additionalMessage;
        if (resultCode == 0) {
            return;
        }
        SWIGTYPE_p_sqlite3 handle = this.myHandle;
        String message = this + " " + operation;
        String string = additionalMessage = additional == null ? null : String.valueOf(additional);
        if (additionalMessage != null) {
            message = message + " " + additionalMessage;
        }
        if (handle != null) {
            try {
                String errmsg = _SQLiteSwigged.sqlite3_errmsg(handle);
                if (additionalMessage == null || !additionalMessage.equals(errmsg)) {
                    message = message + " [" + errmsg + "]";
                }
            }
            catch (Exception e) {
                Internal.log(Level.WARNING, this, "cannot get sqlite3_errmsg", e);
            }
        }
        if (resultCode == 5 || resultCode == 2826) {
            throw new SQLiteBusyException(resultCode, message);
        }
        if (resultCode == 9) {
            throw new SQLiteInterruptedException(resultCode, message);
        }
        throw new SQLiteException(resultCode, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open0(int flags) throws SQLiteException {
        SWIGTYPE_p_sqlite3 handle;
        SQLite.loadLibrary();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "opening (0x" + Integer.toHexString(flags).toUpperCase(Locale.US) + ")");
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                throw new SQLiteException(-92, "cannot reopen closed connection");
            }
            if (this.myConfinement == null) {
                this.myConfinement = Thread.currentThread();
                if (Internal.isFineLogging()) {
                    Internal.logFine(this, "confined to " + this.myConfinement);
                }
            } else {
                this.checkThread();
            }
            handle = this.myHandle;
        }
        if (handle != null) {
            Internal.recoverableError(this, "already opened", true);
            return;
        }
        String dbname = this.getSqliteDbName();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "dbname [" + dbname + "]");
        }
        handle = this.mySQLiteManual.sqlite3_open_v2(dbname, flags);
        int rc = this.mySQLiteManual.getLastReturnCode();
        if (rc != 0) {
            String errorMessage;
            if (handle != null) {
                if (Internal.isFineLogging()) {
                    Internal.logFine(this, "error on open (" + rc + "), closing handle");
                }
                try {
                    _SQLiteSwigged.sqlite3_close(handle);
                }
                catch (Exception e) {
                    Internal.log(Level.FINE, this, "error on closing after failed open", e);
                }
            }
            if ((errorMessage = this.mySQLiteManual.drainLastOpenError()) == null) {
                errorMessage = "open database error code " + rc;
            }
            throw new SQLiteException(rc, errorMessage);
        }
        if (handle == null) {
            throw new SQLiteException(-99, "sqlite didn't return db handle");
        }
        this.configureConnection(handle);
        Object object2 = this.myLock;
        synchronized (object2) {
            this.myHandle = handle;
            this.myOpenFlags = flags;
        }
        Internal.logInfo(this, "opened");
    }

    private void configureConnection(SWIGTYPE_p_sqlite3 handle) {
        int rc = _SQLiteSwigged.sqlite3_extended_result_codes(handle, 1);
        if (rc != 0) {
            Internal.logWarn(this, "cannot enable extended result codes [" + rc + "]");
        }
    }

    private String getSqliteDbName() {
        return this.myFile == null ? ":memory:" : this.myFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getStatementCount() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myStatements.size();
        }
    }

    void checkThread() throws SQLiteException {
        Thread confinement = this.myConfinement;
        if (confinement == null) {
            throw new SQLiteException(-92, this + " is not confined or already disposed");
        }
        Thread thread = Thread.currentThread();
        if (thread != confinement) {
            String message = this + " confined(" + confinement + ") used (" + thread + ")";
            throw new SQLiteException(-98, message);
        }
    }

    public String toString() {
        return "DB[" + this.myNumber + "]";
    }

    protected void finalize() throws Throwable {
        super.finalize();
        SWIGTYPE_p_sqlite3 handle = this.myHandle;
        boolean disposed = this.myDisposed;
        if (handle != null || !disposed) {
            Internal.recoverableError(this, "wasn't disposed before finalizing", true);
        }
    }

    SWIGTYPE_p_sqlite3 connectionHandle() {
        return this.myHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeBuffer(DirectBuffer buffer) throws SQLiteException {
        int rc;
        boolean cached;
        this.checkThread();
        Object object = this.myLock;
        synchronized (object) {
            cached = this.myBuffers.indexOf(buffer) >= 0;
        }
        buffer.decUsed();
        if (!cached && (rc = _SQLiteManual.wrapper_free(buffer)) != 0) {
            Internal.recoverableError(this, "error deallocating buffer", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectBuffer allocateBuffer(int minimumSize) throws SQLiteException, IOException {
        int allocated;
        DirectBuffer b;
        int i;
        int size;
        this.checkThread();
        this.handle();
        for (size = 1024; size < minimumSize + 2; size <<= 1) {
        }
        int payloadSize = size - 2;
        DirectBuffer buffer = null;
        Object object = this.myLock;
        synchronized (object) {
            for (i = this.myBuffers.size() - 1; i >= 0; --i) {
                b = this.myBuffers.get(i);
                if (!b.isValid()) {
                    this.myBuffers.remove(i);
                    this.myBuffersTotalSize -= b.getCapacity();
                    continue;
                }
                if (b.getCapacity() < payloadSize) break;
                if (b.isUsed()) continue;
                buffer = b;
            }
            if (buffer != null) {
                buffer.incUsed();
                buffer.data().clear();
                return buffer;
            }
            allocated = this.myBuffersTotalSize;
        }
        assert (buffer == null);
        buffer = this.mySQLiteManual.wrapper_alloc(size);
        this.throwResult(this.mySQLiteManual.getLastReturnCode(), "allocateBuffer", minimumSize);
        if (buffer == null) {
            throw new SQLiteException(-99, "cannot allocate buffer [" + minimumSize + "]");
        }
        buffer.incUsed();
        buffer.data().clear();
        if (allocated + size < 0x100000) {
            object = this.myLock;
            synchronized (object) {
                for (i = 0; i < this.myBuffers.size() && (b = this.myBuffers.get(i)).getCapacity() <= payloadSize; ++i) {
                }
                this.myBuffers.add(i, buffer);
                this.myBuffersTotalSize += buffer.getCapacity();
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debug(String sql) {
        SQLiteStatement st = null;
        try {
            int i;
            st = this.prepare(sql);
            boolean r = st.step();
            if (!r) {
                String string = "";
                return string;
            }
            int columns = st.columnCount();
            if (columns == 0) {
                String string = "";
                return string;
            }
            int[] widths = new int[columns];
            String[] columnNames = new String[columns];
            for (int i2 = 0; i2 < columns; ++i2) {
                columnNames[i2] = String.valueOf(st.getColumnName(i2));
                widths[i2] = columnNames[i2].length();
            }
            ArrayList<String> cells = new ArrayList<String>();
            do {
                for (int i3 = 0; i3 < columns; ++i3) {
                    String v = st.columnNull(i3) ? "<null>" : String.valueOf(st.columnValue(i3));
                    cells.add(v);
                    widths[i3] = Math.max(widths[i3], v.length());
                }
            } while (st.step());
            StringBuilder buf = new StringBuilder();
            buf.append('|');
            for (i = 0; i < columns; ++i) {
                SQLiteConnection.appendW(buf, columnNames[i], widths[i], ' ');
                buf.append('|');
            }
            buf.append("\n|");
            for (i = 0; i < columns; ++i) {
                SQLiteConnection.appendW(buf, "", widths[i], '-');
                buf.append('|');
            }
            for (i = 0; i < cells.size(); ++i) {
                if (i % columns == 0) {
                    buf.append("\n|");
                }
                SQLiteConnection.appendW(buf, (String)cells.get(i), widths[i % columns], ' ');
                buf.append('|');
            }
            String string = buf.toString();
            return string;
        }
        catch (SQLiteException e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            if (st != null) {
                st.dispose();
            }
        }
    }

    private static void appendW(StringBuilder buf, String what, int width, char filler) {
        buf.append(what);
        for (int i = what.length(); i < width; ++i) {
            buf.append(filler);
        }
    }

    private class UncachedController
    extends BaseController {
        private UncachedController() {
        }

        public void dispose(SQLiteStatement statement) {
            if (this.checkDispose(statement)) {
                SQLiteConnection.this.finalizeStatement(statement);
            }
        }

        public void dispose(SQLiteLongArray array) {
            if (this.checkDispose(array)) {
                SQLiteConnection.this.finalizeArray(array);
            }
        }

        public String toString() {
            return SQLiteConnection.this.toString() + "[U]";
        }
    }

    private class CachedController
    extends BaseController {
        private CachedController() {
        }

        public void dispose(SQLiteStatement statement) {
            if (this.checkDispose(statement)) {
                SQLiteConnection.this.cacheStatementHandle(statement);
            }
        }

        public void dispose(SQLiteLongArray array) {
            if (this.checkDispose(array)) {
                SQLiteConnection.this.cacheArrayHandle(array);
            }
        }

        public String toString() {
            return SQLiteConnection.this.toString() + "[C]";
        }
    }

    private abstract class BaseController
    extends SQLiteController {
        private BaseController() {
        }

        public void validate() throws SQLiteException {
            assert (this.validateImpl());
        }

        private boolean validateImpl() throws SQLiteException {
            SQLiteConnection.this.checkThread();
            SQLiteConnection.this.handle();
            return true;
        }

        public void throwResult(int resultCode, String message, Object additionalMessage) throws SQLiteException {
            SQLiteConnection.this.throwResult(resultCode, message, additionalMessage);
        }

        public void dispose(SQLiteBlob blob) {
            if (this.checkDispose(blob)) {
                SQLiteConnection.this.finalizeBlob(blob);
            }
        }

        protected boolean checkDispose(Object object) {
            try {
                SQLiteConnection.this.checkThread();
            }
            catch (SQLiteException e) {
                Internal.recoverableError(this, "disposing " + object + " from alien thread", true);
                return false;
            }
            return true;
        }

        public _SQLiteManual getSQLiteManual() {
            return SQLiteConnection.this.mySQLiteManual;
        }

        public DirectBuffer allocateBuffer(int sizeEstimate) throws IOException, SQLiteException {
            return SQLiteConnection.this.allocateBuffer(sizeEstimate);
        }

        public void freeBuffer(DirectBuffer buffer) {
            try {
                SQLiteConnection.this.freeBuffer(buffer);
            }
            catch (SQLiteException e) {
                Internal.logWarn(SQLiteConnection.this, e.toString());
            }
        }

        public ProgressHandler getProgressHandler() throws SQLiteException {
            return SQLiteConnection.this.getProgressHandler();
        }
    }
}

