/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle;

import com.mparticle.GsonCustomConverterFactory;
import com.mparticle.JSON;
import com.mparticle.client.HttpBasicAuth;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ApiClient {
    private Map<String, Interceptor> apiAuthorizations = new LinkedHashMap<String, Interceptor>();
    private OkHttpClient.Builder okBuilder;
    private Retrofit.Builder adapterBuilder;
    private JSON json;

    public ApiClient(String apiKey, String apiSecret) {
        this.createDefaultAdapter();
        HttpBasicAuth auth = new HttpBasicAuth();
        auth.setCredentials(apiKey, apiSecret);
        this.addAuthorization("basic", auth);
    }

    public void createDefaultAdapter() {
        this.json = new JSON();
        this.okBuilder = new OkHttpClient.Builder();
        String baseUrl = "https://s2s.mparticle.com/v2";
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.adapterBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonCustomConverterFactory.create(this.json.getGson()));
    }

    public <S> S createService(Class<S> serviceClass) {
        return (S)this.adapterBuilder.client(this.okBuilder.build()).build().create(serviceClass);
    }

    public ApiClient setCredentials(String username, String password) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof HttpBasicAuth)) continue;
            HttpBasicAuth basicAuth = (HttpBasicAuth)apiAuthorization;
            basicAuth.setCredentials(username, password);
            return this;
        }
        return this;
    }

    public ApiClient addAuthorization(String authName, Interceptor authorization) {
        if (this.apiAuthorizations.containsKey(authName)) {
            throw new RuntimeException("auth name \"" + authName + "\" already in api authorizations");
        }
        this.apiAuthorizations.put(authName, authorization);
        this.okBuilder.addInterceptor(authorization);
        return this;
    }

    public Map<String, Interceptor> getApiAuthorizations() {
        return this.apiAuthorizations;
    }

    public ApiClient setApiAuthorizations(Map<String, Interceptor> apiAuthorizations) {
        this.apiAuthorizations = apiAuthorizations;
        return this;
    }

    public Retrofit.Builder getAdapterBuilder() {
        return this.adapterBuilder;
    }

    public ApiClient setAdapterBuilder(Retrofit.Builder adapterBuilder) {
        this.adapterBuilder = adapterBuilder;
        return this;
    }

    public OkHttpClient.Builder getOkBuilder() {
        return this.okBuilder;
    }

    public void addAuthsToOkBuilder(OkHttpClient.Builder okBuilder) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            okBuilder.addInterceptor(apiAuthorization);
        }
    }

    public void configureFromOkclient(OkHttpClient okClient) {
        this.okBuilder = okClient.newBuilder();
        this.addAuthsToOkBuilder(this.okBuilder);
    }
}

