/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle;

import com.mparticle.GsonCustomConverterFactory;
import com.mparticle.JSON;
import com.mparticle.Logger;
import com.mparticle.client.EventsApi;
import com.mparticle.client.HttpBasicAuth;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ApiClient {
    private Map<String, Interceptor> apiAuthorizations = new LinkedHashMap<String, Interceptor>();
    private static OkHttpClient.Builder okBuilder;
    private Retrofit.Builder adapterBuilder;
    private JSON json;
    private static Long retryAfter;

    public ApiClient(String apiKey, String apiSecret) {
        this.createDefaultAdapter();
        HttpBasicAuth auth = new HttpBasicAuth();
        auth.setCredentials(apiKey, apiSecret);
        this.addAuthorization("basic", auth);
    }

    public void createDefaultAdapter() {
        this.json = new JSON();
        okBuilder = new OkHttpClient.Builder();
        String baseUrl = "https://s2s.mparticle.com/v2";
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.adapterBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonCustomConverterFactory.create(this.json.getGson()));
    }

    public <S> S createService(Class<S> serviceClass) {
        if (serviceClass == EventsApi.class) {
            okBuilder.addInterceptor((Interceptor)new RateLimitInterceptor());
        }
        return (S)this.adapterBuilder.client(okBuilder.build()).build().create(serviceClass);
    }

    public ApiClient setCredentials(String username, String password) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof HttpBasicAuth)) continue;
            HttpBasicAuth basicAuth = (HttpBasicAuth)apiAuthorization;
            basicAuth.setCredentials(username, password);
            return this;
        }
        return this;
    }

    public ApiClient addAuthorization(String authName, Interceptor authorization) {
        if (this.apiAuthorizations.containsKey(authName)) {
            throw new RuntimeException("auth name \"" + authName + "\" already in api authorizations");
        }
        this.apiAuthorizations.put(authName, authorization);
        okBuilder.addInterceptor(authorization);
        return this;
    }

    public Map<String, Interceptor> getApiAuthorizations() {
        return this.apiAuthorizations;
    }

    public ApiClient setApiAuthorizations(Map<String, Interceptor> apiAuthorizations) {
        this.apiAuthorizations = apiAuthorizations;
        return this;
    }

    public Retrofit.Builder getAdapterBuilder() {
        return this.adapterBuilder;
    }

    public ApiClient setAdapterBuilder(Retrofit.Builder adapterBuilder) {
        this.adapterBuilder = adapterBuilder;
        return this;
    }

    public OkHttpClient.Builder getOkBuilder() {
        return okBuilder;
    }

    public void addAuthsToOkBuilder(OkHttpClient.Builder okBuilder) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            okBuilder.addInterceptor(apiAuthorization);
        }
    }

    public void configureFromOkclient(OkHttpClient okClient) {
        okBuilder = okClient.newBuilder();
        this.addAuthsToOkBuilder(okBuilder);
    }

    static {
        retryAfter = null;
    }

    static class RateLimitInterceptor
    implements Interceptor {
        RateLimitInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Logger.debug("Starting request: " + chain.request().toString());
            long currentTimeMillis = System.currentTimeMillis();
            if (retryAfter != null && currentTimeMillis < retryAfter) {
                Long retryAfterHeaderValue = (retryAfter - currentTimeMillis) / 1000L;
                Logger.debug("This endpoint is currently rate-limited, please retry after " + retryAfterHeaderValue + " seconds, returning a local 429 response");
                return new Response.Builder().request(chain.request()).addHeader("retry-after", retryAfterHeaderValue.toString()).protocol(Protocol.HTTP_2).code(429).message("").body(ResponseBody.create(null, (String)"")).build();
            }
            Response response = chain.proceed(chain.request());
            Logger.debug("Response " + response.code());
            Logger.debug(String.valueOf(response));
            if (response.code() == 429) {
                String retryAfterString = response.header("Retry-After");
                if (retryAfterString != null) {
                    retryAfterString = response.header("retry-after");
                }
                try {
                    if (retryAfterString == null) {
                        Logger.debug("No Retry-After value found");
                    } else {
                        long parsedThrottle = Long.parseLong(retryAfterString) * 1000L;
                        if (parsedThrottle > 0L) {
                            retryAfter = System.currentTimeMillis() + parsedThrottle;
                            Logger.debug("Retry-After header value: " + retryAfterString);
                            Logger.debug("Next request may not be attempted for " + retryAfterString + " seconds");
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    Logger.debug("Unable to parse retry-after header, next request will not be rate-limited.");
                }
            }
            return response;
        }
    }
}

