/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle;

public class Logger {
    private static AbstractLogHandler logHandler;

    public static void debug(String message) {
        if (Logger.getLogHandler() != null) {
            Logger.getLogHandler().log(LogLevel.DEBUG, null, message);
        }
    }

    public static void info(String message) {
        if (Logger.getLogHandler() != null) {
            Logger.getLogHandler().log(LogLevel.INFO, null, message);
        }
    }

    public static void error(String message) {
        if (Logger.getLogHandler() != null) {
            Logger.getLogHandler().log(LogLevel.ERROR, null, message);
        }
    }

    public static void error(Throwable error) {
        if (Logger.getLogHandler() != null) {
            Logger.getLogHandler().log(LogLevel.ERROR, error, error.toString());
        }
    }

    public static void setLogHandler(AbstractLogHandler logListener) {
        logHandler = logListener;
    }

    public static AbstractLogHandler getLogHandler() {
        return logHandler;
    }

    public static abstract class AbstractLogHandler {
        public void log(LogLevel priority, Throwable error, String message) {
            if (message != null) {
                switch (priority) {
                    case DEBUG: {
                        this.debug(message);
                        break;
                    }
                    case INFO: {
                        this.info(message);
                        break;
                    }
                    case ERROR: {
                        this.error(error, message);
                    }
                }
            }
        }

        public abstract void debug(String var1);

        public abstract void info(String var1);

        public abstract void error(Throwable var1, String var2);
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        ERROR;

    }
}

