/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.model;

import com.google.gson.annotations.SerializedName;
import com.mparticle.model.CommonEventData;
import com.mparticle.model.ProductAction;
import com.mparticle.model.ProductImpression;
import com.mparticle.model.PromotionAction;
import com.mparticle.model.ShoppingCart;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class CommerceEventData
extends CommonEventData {
    public static final String SERIALIZED_NAME_PRODUCT_ACTION = "product_action";
    @SerializedName(value="product_action")
    private ProductAction productAction = null;
    public static final String SERIALIZED_NAME_PROMOTION_ACTION = "promotion_action";
    @SerializedName(value="promotion_action")
    private PromotionAction promotionAction = null;
    public static final String SERIALIZED_NAME_PRODUCT_IMPRESSIONS = "product_impressions";
    @SerializedName(value="product_impressions")
    private List<ProductImpression> productImpressions = new ArrayList<ProductImpression>();
    public static final String SERIALIZED_NAME_SHOPPING_CART = "shopping_cart";
    @SerializedName(value="shopping_cart")
    private ShoppingCart shoppingCart = null;
    public static final String SERIALIZED_NAME_CURRENCY_CODE = "currency_code";
    @SerializedName(value="currency_code")
    private String currencyCode;
    public static final String SERIALIZED_NAME_SCREEN_NAME = "screen_name";
    @SerializedName(value="screen_name")
    private String screenName;
    public static final String SERIALIZED_NAME_IS_NON_INTERACTIVE = "is_non_interactive";
    @SerializedName(value="is_non_interactive")
    private Boolean isNonInteractive;
    public static final String SERIALIZED_NAME_EVENT_NAME = "event_name";
    @SerializedName(value="event_name")
    private String eventName;
    public static final String SERIALIZED_NAME_CUSTOM_EVENT_TYPE = "custom_event_type";
    @SerializedName(value="custom_event_type")
    private CustomEventTypeEnum customEventType;
    public static final String SERIALIZED_NAME_CUSTOM_FLAGS = "custom_flags";
    @SerializedName(value="custom_flags")
    private Map<String, String> customFlags = new HashMap<String, String>();

    public CommerceEventData productAction(ProductAction productAction) {
        this.productAction = productAction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProductAction getProductAction() {
        return this.productAction;
    }

    public void setProductAction(ProductAction productAction) {
        this.productAction = productAction;
    }

    public CommerceEventData promotionAction(PromotionAction promotionAction) {
        this.promotionAction = promotionAction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PromotionAction getPromotionAction() {
        return this.promotionAction;
    }

    public void setPromotionAction(PromotionAction promotionAction) {
        this.promotionAction = promotionAction;
    }

    public CommerceEventData productImpressions(List<ProductImpression> productImpressions) {
        this.productImpressions = productImpressions;
        return this;
    }

    public CommerceEventData addProductImpressionsItem(ProductImpression productImpressionsItem) {
        if (this.productImpressions == null) {
            this.productImpressions = new ArrayList<ProductImpression>();
        }
        this.productImpressions.add(productImpressionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<ProductImpression> getProductImpressions() {
        return this.productImpressions;
    }

    public void setProductImpressions(List<ProductImpression> productImpressions) {
        this.productImpressions = productImpressions;
    }

    public CommerceEventData shoppingCart(ShoppingCart shoppingCart) {
        this.shoppingCart = shoppingCart;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ShoppingCart getShoppingCart() {
        return this.shoppingCart;
    }

    public void setShoppingCart(ShoppingCart shoppingCart) {
        this.shoppingCart = shoppingCart;
    }

    public CommerceEventData currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CommerceEventData screenName(String screenName) {
        this.screenName = screenName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public CommerceEventData isNonInteractive(Boolean isNonInteractive) {
        this.isNonInteractive = isNonInteractive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getIsNonInteractive() {
        return this.isNonInteractive;
    }

    public void setIsNonInteractive(Boolean isNonInteractive) {
        this.isNonInteractive = isNonInteractive;
    }

    public CommerceEventData eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CustomEventTypeEnum getCustomEventType() {
        return this.customEventType;
    }

    public CommerceEventData customFlags(Map<String, String> customFlags) {
        this.customFlags = customFlags;
        return this;
    }

    public CommerceEventData putCustomFlagsItem(String key, String customFlagsItem) {
        if (this.customFlags == null) {
            this.customFlags = new HashMap<String, String>();
        }
        this.customFlags.put(key, customFlagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getCustomFlags() {
        return this.customFlags;
    }

    public void setCustomFlags(Map<String, String> customFlags) {
        this.customFlags = customFlags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommerceEventData commerceEventData = (CommerceEventData)o;
        return Objects.equals(this.productAction, commerceEventData.productAction) && Objects.equals(this.promotionAction, commerceEventData.promotionAction) && Objects.equals(this.productImpressions, commerceEventData.productImpressions) && Objects.equals(this.shoppingCart, commerceEventData.shoppingCart) && Objects.equals(this.currencyCode, commerceEventData.currencyCode) && Objects.equals(this.screenName, commerceEventData.screenName) && Objects.equals(this.isNonInteractive, commerceEventData.isNonInteractive) && Objects.equals(this.eventName, commerceEventData.eventName) && Objects.equals((Object)this.customEventType, (Object)commerceEventData.customEventType) && Objects.equals(this.customFlags, commerceEventData.customFlags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.productAction, this.promotionAction, this.productImpressions, this.shoppingCart, this.currencyCode, this.screenName, this.isNonInteractive, this.eventName, this.customEventType, this.customFlags});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommerceEventData {\n");
        sb.append("    productAction: ").append(this.toIndentedString(this.productAction)).append("\n");
        sb.append("    promotionAction: ").append(this.toIndentedString(this.promotionAction)).append("\n");
        sb.append("    productImpressions: ").append(this.toIndentedString(this.productImpressions)).append("\n");
        sb.append("    shoppingCart: ").append(this.toIndentedString(this.shoppingCart)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    screenName: ").append(this.toIndentedString(this.screenName)).append("\n");
        sb.append("    isNonInteractive: ").append(this.toIndentedString(this.isNonInteractive)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    customEventType: ").append(this.toIndentedString((Object)this.customEventType)).append("\n");
        sb.append("    customFlags: ").append(this.toIndentedString(this.customFlags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CustomEventTypeEnum {
        ADD_TO_CART("add_to_cart"),
        REMOVE_FROM_CART("remove_from_cart"),
        CHECKOUT("checkout"),
        CHECKOUT_OPTION("checkout_option"),
        CLICK("click"),
        VIEW_DETAIL("view_detail"),
        PURCHASE("purchase"),
        REFUND("refund"),
        PROMOTION_VIEW("promotion_view"),
        PROMOTION_CLICK("promotion_click"),
        ADD_TO_WISHLIST("add_to_wishlist"),
        REMOVE_FROM_WISHLIST("remove_from_wishlist"),
        IMPRESSION("impression");

        private String value;

        private CustomEventTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CustomEventTypeEnum fromValue(String value) {
            for (CustomEventTypeEnum b : CustomEventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

