/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.bdparsii.eval;

import ch.obermuhlner.math.big.BigDecimalMath;
import com.mpobjects.bdparsii.eval.AbstractExpression;
import com.mpobjects.bdparsii.eval.Constant;
import com.mpobjects.bdparsii.eval.Expression;
import com.mpobjects.bdparsii.eval.MathContextGuard;
import java.math.BigDecimal;
import java.math.MathContext;

public final class BinaryOperation
extends AbstractExpression {
    private static final BigDecimal POW_LOWER_LIMT = BigDecimal.valueOf(-999999999L);
    private static final BigDecimal POW_UPPER_LIMT = BigDecimal.valueOf(999999999L);
    private final Op op;
    private Expression left;
    private Expression right;
    private boolean sealed = false;

    public static BigDecimal pow(BigDecimal x, BigDecimal y, MathContext mathContext) {
        if (POW_LOWER_LIMT.compareTo(y) < 0 && POW_UPPER_LIMT.compareTo(y) > 0) {
            try {
                int intval = y.intValueExact();
                return x.pow(intval, mathContext);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return BigDecimalMath.pow((BigDecimal)x, (BigDecimal)y, (MathContext)MathContextGuard.getSafeContext(mathContext));
    }

    public BinaryOperation(MathContext mathContext, Op op, Expression left, Expression right) {
        super(mathContext);
        this.op = op;
        this.left = left;
        this.right = right;
    }

    public Op getOp() {
        return this.op;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void seal() {
        this.sealed = true;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public BigDecimal evaluate(MathContext mathContext) {
        BigDecimal a = this.left.evaluate(mathContext);
        BigDecimal b = this.right.evaluate(mathContext);
        if (a == null) {
            throw new ArithmeticException("Left argument evaluated to null");
        }
        if (b == null) {
            throw new ArithmeticException("Right argument evaluated to null");
        }
        switch (this.op) {
            case ADD: {
                return a.add(b, mathContext);
            }
            case SUBTRACT: {
                return a.subtract(b, mathContext);
            }
            case MULTIPLY: {
                return a.multiply(b, mathContext);
            }
            case DIVIDE: {
                return a.divide(b, mathContext);
            }
            case POWER: {
                return BinaryOperation.pow(a, b, mathContext);
            }
            case MODULO: {
                return a.remainder(b, mathContext);
            }
            case LT: {
                return a.compareTo(b) < 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case LT_EQ: {
                return a.compareTo(b) <= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case GT: {
                return a.compareTo(b) > 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case GT_EQ: {
                return a.compareTo(b) >= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case EQ: {
                return a.compareTo(b) == 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case NEQ: {
                return a.compareTo(b) != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case AND: {
                return a.compareTo(BigDecimal.ZERO) != 0 && b.compareTo(BigDecimal.ZERO) != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case OR: {
                return a.compareTo(BigDecimal.ZERO) != 0 || b.compareTo(BigDecimal.ZERO) != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)this.op));
    }

    @Override
    public Expression simplify(MathContext mathContext) {
        this.left = this.left.simplify(mathContext);
        this.right = this.right.simplify(mathContext);
        if (this.left.isConstant() && this.right.isConstant()) {
            return new Constant(this.evaluate());
        }
        if (this.op == Op.ADD || this.op == Op.MULTIPLY) {
            Expression childOp;
            if (this.right.isConstant()) {
                Expression tmp = this.right;
                this.right = this.left;
                this.left = tmp;
            }
            if (this.right instanceof BinaryOperation && (childOp = this.trySimplifyRightSide()) != null) {
                return childOp;
            }
        }
        return this;
    }

    private Expression trySimplifyRightSide() {
        BinaryOperation childOp = (BinaryOperation)this.right;
        if (this.op != childOp.op) {
            return null;
        }
        if (this.left.isConstant() && childOp.left.isConstant()) {
            if (this.op == Op.ADD) {
                return new BinaryOperation(this.getMathContext(), this.op, new Constant(this.left.evaluate().add(childOp.left.evaluate())), childOp.right);
            }
            if (this.op == Op.MULTIPLY) {
                return new BinaryOperation(this.getMathContext(), this.op, new Constant(this.left.evaluate().multiply(childOp.left.evaluate())), childOp.right);
            }
        }
        if (childOp.left.isConstant()) {
            return new BinaryOperation(this.getMathContext(), this.op, childOp.left, new BinaryOperation(this.getMathContext(), this.op, this.left, childOp.right));
        }
        return null;
    }

    public String toString() {
        return "(" + this.left.toString() + " " + (Object)((Object)this.op) + " " + this.right + ")";
    }

    public static enum Op {
        ADD(3),
        SUBTRACT(3),
        MULTIPLY(4),
        DIVIDE(4),
        MODULO(4),
        POWER(5),
        LT(2),
        LT_EQ(2),
        EQ(2),
        GT_EQ(2),
        GT(2),
        NEQ(2),
        AND(1),
        OR(1);

        private final int priority;

        private Op(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

