/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.bdparsii.eval;

import com.mpobjects.bdparsii.eval.AbstractExpression;
import com.mpobjects.bdparsii.eval.Constant;
import com.mpobjects.bdparsii.eval.Expression;
import com.mpobjects.bdparsii.eval.Function;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;

public final class FunctionCall
extends AbstractExpression {
    private List<Expression> parameters = new ArrayList<Expression>();
    private Function function;

    public FunctionCall(MathContext mathContext) {
        super(mathContext);
    }

    @Override
    public BigDecimal evaluate(MathContext mathContext) {
        return this.function.eval(this.parameters, mathContext);
    }

    @Override
    public Expression simplify(MathContext mathContext) {
        if (!this.function.isNaturalFunction()) {
            return this;
        }
        for (Expression expr : this.parameters) {
            if (expr.isConstant()) continue;
            return this;
        }
        return new Constant(this.evaluate(mathContext));
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public void addParameter(Expression expression) {
        this.parameters.add(expression);
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }
}

