/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.bdparsii.eval;

import ch.obermuhlner.math.big.BigDecimalMath;
import com.mpobjects.bdparsii.eval.BinaryFunction;
import com.mpobjects.bdparsii.eval.BinaryOperation;
import com.mpobjects.bdparsii.eval.Expression;
import com.mpobjects.bdparsii.eval.Function;
import com.mpobjects.bdparsii.eval.MathContextGuard;
import com.mpobjects.bdparsii.eval.UnaryFunction;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;

public class Functions {
    public static final BigDecimal ONEHUNDREDEIGHTY = BigDecimal.valueOf(180L);
    public static final Function SIN = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.sin((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function SINH = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.sinh((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function COS = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.cos((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function COSH = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.cosh((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function COT = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.cot((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function COTH = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.coth((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function TAN = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.tan((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function TANH = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.tanh((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function ABS = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return a.abs(mathContext);
        }
    };
    public static final Function ASIN = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.asin((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function ASINH = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.asinh((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function ACOS = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.acos((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function ACOSH = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.acosh((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function ACOT = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.acot((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function ACOTH = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.acoth((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function ATAN = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.atan((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function ATANH = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.atanh((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function ATAN2 = new BinaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, BigDecimal b, MathContext mathContext) {
            return BigDecimalMath.atan2((BigDecimal)a, (BigDecimal)b, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function ROUND = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return a.setScale(0, RoundingMode.HALF_UP);
        }
    };
    public static final Function FLOOR = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return a.setScale(0, RoundingMode.FLOOR);
        }
    };
    public static final Function CEIL = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return a.setScale(0, RoundingMode.CEILING);
        }
    };
    public static final Function POW = new BinaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, BigDecimal b, MathContext mathContext) {
            return BinaryOperation.pow(a, b, mathContext);
        }
    };
    public static final Function SQRT = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.sqrt((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function EXP = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.exp((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function LN = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.log((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function LOG = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.log10((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function LOG2 = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.log2((BigDecimal)a, (MathContext)MathContextGuard.getSafeContext(mathContext));
        }
    };
    public static final Function MIN = new BinaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, BigDecimal b, MathContext mathContext) {
            return a.min(b);
        }
    };
    public static final Function MAX = new BinaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, BigDecimal b, MathContext mathContext) {
            return a.max(b);
        }
    };
    public static final Function RND = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return a.multiply(BigDecimal.valueOf(Math.random()), mathContext);
        }
    };
    public static final Function SIGN = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimal.valueOf(a.signum());
        }
    };
    public static final Function DEG = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return a.multiply(ONEHUNDREDEIGHTY, mathContext).divide(BigDecimalMath.pi((MathContext)MathContextGuard.getSafeContext(mathContext)), mathContext);
        }
    };
    public static final Function RAD = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return a.divide(ONEHUNDREDEIGHTY, mathContext).multiply(BigDecimalMath.pi((MathContext)MathContextGuard.getSafeContext(mathContext)), mathContext);
        }
    };
    public static final Function EXPONENT = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimal.valueOf(BigDecimalMath.exponent((BigDecimal)a));
        }
    };
    public static final Function MANTISSA = new UnaryFunction(){

        @Override
        protected BigDecimal eval(BigDecimal a, MathContext mathContext) {
            return BigDecimalMath.mantissa((BigDecimal)a);
        }
    };
    public static final Function IF = new IfFunction();
    public static final Function SCALE = new ScaleFunction();

    private Functions() {
    }

    private static class ScaleFunction
    implements Function {
        private ScaleFunction() {
        }

        @Override
        public int getNumberOfArguments() {
            return -1;
        }

        @Override
        public BigDecimal eval(List<Expression> args, MathContext mathContext) {
            if (args.size() == 1) {
                BigDecimal val = args.get(0).evaluate(mathContext);
                if (val == null) {
                    throw new ArithmeticException("Parameter 1 evaluated to null");
                }
                return BigDecimal.valueOf(val.scale());
            }
            if (args.size() == 2) {
                BigDecimal val = args.get(0).evaluate(mathContext);
                if (val == null) {
                    throw new ArithmeticException("Parameter 1 evaluated to null");
                }
                BigDecimal scale = args.get(1).evaluate(mathContext);
                if (scale == null) {
                    throw new ArithmeticException("Parameter 2 evaluated to null");
                }
                return val.setScale(scale.intValueExact(), mathContext.getRoundingMode());
            }
            throw new ArithmeticException("Unsupported number of arguments: " + args.size());
        }

        @Override
        public boolean isNaturalFunction() {
            return true;
        }
    }

    private static class IfFunction
    implements Function {
        private IfFunction() {
        }

        @Override
        public int getNumberOfArguments() {
            return 3;
        }

        @Override
        public BigDecimal eval(List<Expression> args, MathContext mathContext) {
            BigDecimal check = args.get(0).evaluate(mathContext);
            if (check == null) {
                throw new ArithmeticException("Parameter 1 evaluated to null");
            }
            if (check.compareTo(BigDecimal.ZERO) != 0) {
                return args.get(1).evaluate(mathContext);
            }
            return args.get(2).evaluate(mathContext);
        }

        @Override
        public boolean isNaturalFunction() {
            return false;
        }
    }
}

