/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.bdparsii.eval;

import com.mpobjects.bdparsii.eval.BinaryOperation;
import com.mpobjects.bdparsii.eval.Constant;
import com.mpobjects.bdparsii.eval.Expression;
import com.mpobjects.bdparsii.eval.Function;
import com.mpobjects.bdparsii.eval.FunctionCall;
import com.mpobjects.bdparsii.eval.Functions;
import com.mpobjects.bdparsii.eval.Scope;
import com.mpobjects.bdparsii.eval.VariableReference;
import com.mpobjects.bdparsii.tokenizer.ParseError;
import com.mpobjects.bdparsii.tokenizer.ParseException;
import com.mpobjects.bdparsii.tokenizer.Position;
import com.mpobjects.bdparsii.tokenizer.Token;
import com.mpobjects.bdparsii.tokenizer.Tokenizer;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Parser {
    private final Scope scope;
    private List<ParseError> errors = new ArrayList<ParseError>();
    private Tokenizer tokenizer;
    private static Map<String, Function> functionTable = new TreeMap<String, Function>();
    private static final Expression ERROR;

    protected Parser(Reader input, Scope scope) {
        this.scope = scope;
        this.tokenizer = new Tokenizer(input);
        this.tokenizer.setProblemCollector(this.errors);
    }

    public static void registerFunction(String name, Function function) {
        functionTable.put(name, function);
    }

    public static Expression parse(String input) throws ParseException {
        return new Parser(new StringReader(input), new Scope()).parse();
    }

    public static Expression parse(Reader input) throws ParseException {
        return new Parser(input, new Scope()).parse();
    }

    public static Expression parse(String input, Scope scope) throws ParseException {
        return new Parser(new StringReader(input), scope).parse();
    }

    public static Expression parse(Reader input, Scope scope) throws ParseException {
        return new Parser(input, scope).parse();
    }

    protected Expression parse() throws ParseException {
        Expression result = this.expression().simplify(this.scope.getMathContext());
        if (((Token)this.tokenizer.current()).isNotEnd()) {
            Token token = (Token)this.tokenizer.consume();
            this.errors.add(ParseError.error(token, String.format("Unexpected token: '%s'. Expected an expression.", token.getSource())));
        }
        if (!this.errors.isEmpty()) {
            throw ParseException.create(this.errors);
        }
        return result;
    }

    protected Expression expression() {
        Expression left = this.relationalExpression();
        if (((Token)this.tokenizer.current()).isSymbol("&&")) {
            this.tokenizer.consume();
            Expression right = this.expression();
            return this.reOrder(left, right, BinaryOperation.Op.AND);
        }
        if (((Token)this.tokenizer.current()).isSymbol("||")) {
            this.tokenizer.consume();
            Expression right = this.expression();
            return this.reOrder(left, right, BinaryOperation.Op.OR);
        }
        return left;
    }

    protected Expression relationalExpression() {
        Expression left = this.term();
        if (((Token)this.tokenizer.current()).isSymbol("<")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.LT);
        }
        if (((Token)this.tokenizer.current()).isSymbol("<=")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.LT_EQ);
        }
        if (((Token)this.tokenizer.current()).isSymbol("=")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.EQ);
        }
        if (((Token)this.tokenizer.current()).isSymbol(">=")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.GT_EQ);
        }
        if (((Token)this.tokenizer.current()).isSymbol(">")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.GT);
        }
        if (((Token)this.tokenizer.current()).isSymbol("!=")) {
            this.tokenizer.consume();
            Expression right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.NEQ);
        }
        return left;
    }

    protected Expression term() {
        Expression left = this.product();
        if (((Token)this.tokenizer.current()).isSymbol("+")) {
            this.tokenizer.consume();
            Expression right = this.term();
            return this.reOrder(left, right, BinaryOperation.Op.ADD);
        }
        if (((Token)this.tokenizer.current()).isSymbol("-")) {
            this.tokenizer.consume();
            Expression right = this.term();
            return this.reOrder(left, right, BinaryOperation.Op.SUBTRACT);
        }
        if (((Token)this.tokenizer.current()).isNumber() && ((Token)this.tokenizer.current()).getContents().startsWith("-")) {
            ((Token)this.tokenizer.current()).setContent(((Token)this.tokenizer.current()).getContents().substring(1));
            Expression right = this.term();
            return this.reOrder(left, right, BinaryOperation.Op.SUBTRACT);
        }
        return left;
    }

    protected Expression product() {
        Expression left = this.power();
        if (((Token)this.tokenizer.current()).isSymbol("*")) {
            this.tokenizer.consume();
            Expression right = this.product();
            return this.reOrder(left, right, BinaryOperation.Op.MULTIPLY);
        }
        if (((Token)this.tokenizer.current()).isSymbol("/")) {
            this.tokenizer.consume();
            Expression right = this.product();
            return this.reOrder(left, right, BinaryOperation.Op.DIVIDE);
        }
        if (((Token)this.tokenizer.current()).isSymbol("%")) {
            this.tokenizer.consume();
            Expression right = this.product();
            return this.reOrder(left, right, BinaryOperation.Op.MODULO);
        }
        return left;
    }

    protected Expression reOrder(Expression left, Expression right, BinaryOperation.Op op) {
        BinaryOperation rightOp;
        if (right instanceof BinaryOperation && !(rightOp = (BinaryOperation)right).isSealed() && rightOp.getOp().getPriority() == op.getPriority()) {
            this.replaceLeft(rightOp, left, op);
            return right;
        }
        return new BinaryOperation(this.scope.getMathContext(), op, left, right);
    }

    protected void replaceLeft(BinaryOperation target, Expression newLeft, BinaryOperation.Op op) {
        BinaryOperation leftOp;
        if (target.getLeft() instanceof BinaryOperation && !(leftOp = (BinaryOperation)target.getLeft()).isSealed() && leftOp.getOp().getPriority() == op.getPriority()) {
            this.replaceLeft(leftOp, newLeft, op);
            return;
        }
        target.setLeft(new BinaryOperation(this.scope.getMathContext(), op, newLeft, target.getLeft()));
    }

    protected Expression power() {
        Expression left = this.atom();
        if (((Token)this.tokenizer.current()).isSymbol("^") || ((Token)this.tokenizer.current()).isSymbol("**")) {
            this.tokenizer.consume();
            Expression right = this.power();
            return this.reOrder(left, right, BinaryOperation.Op.POWER);
        }
        return left;
    }

    protected Expression atom() {
        if (((Token)this.tokenizer.current()).isSymbol("-")) {
            this.tokenizer.consume();
            BinaryOperation result = new BinaryOperation(this.scope.getMathContext(), BinaryOperation.Op.SUBTRACT, new Constant(BigDecimal.ZERO), this.atom());
            result.seal();
            return result;
        }
        if (((Token)this.tokenizer.current()).isSymbol("+") && ((Token)this.tokenizer.next()).isSymbol("(")) {
            this.tokenizer.consume();
        }
        if (((Token)this.tokenizer.current()).isSymbol("(")) {
            this.tokenizer.consume();
            Expression result = this.expression();
            if (result instanceof BinaryOperation) {
                ((BinaryOperation)result).seal();
            }
            this.expect(Token.TokenType.SYMBOL, ")");
            return result;
        }
        if (((Token)this.tokenizer.current()).isSymbol("|")) {
            this.tokenizer.consume();
            FunctionCall call = new FunctionCall(this.scope.getMathContext());
            call.addParameter(this.expression());
            call.setFunction(Functions.ABS);
            this.expect(Token.TokenType.SYMBOL, "|");
            return call;
        }
        if (((Token)this.tokenizer.current()).isIdentifier(new String[0])) {
            if (((Token)this.tokenizer.next()).isSymbol("(")) {
                return this.functionCall();
            }
            Token variableName = (Token)this.tokenizer.consume();
            try {
                return new VariableReference(this.scope.getVariable(variableName.getContents()));
            }
            catch (IllegalArgumentException e) {
                this.errors.add(ParseError.error(variableName, String.format("Unknown variable: '%s'", variableName.getContents())));
                return new Constant(BigDecimal.ZERO);
            }
        }
        return this.literalAtom();
    }

    private Expression literalAtom() {
        if (((Token)this.tokenizer.current()).isSymbol("+") && ((Token)this.tokenizer.next()).isNumber()) {
            this.tokenizer.consume();
        }
        if (((Token)this.tokenizer.current()).isNumber()) {
            BigDecimal value = new BigDecimal(((Token)this.tokenizer.consume()).getContents());
            if (((Token)this.tokenizer.current()).is(Token.TokenType.ID)) {
                String quantifier;
                switch (quantifier = ((Token)this.tokenizer.current()).getContents().intern()) {
                    case "n": {
                        value = value.divide(BigDecimal.valueOf(1000000000L), this.scope.getMathContext());
                        this.tokenizer.consume();
                        break;
                    }
                    case "u": {
                        value = value.divide(BigDecimal.valueOf(1000000L), this.scope.getMathContext());
                        this.tokenizer.consume();
                        break;
                    }
                    case "m": {
                        value = value.divide(BigDecimal.valueOf(1000L), this.scope.getMathContext());
                        this.tokenizer.consume();
                        break;
                    }
                    case "k": 
                    case "K": {
                        value = value.multiply(BigDecimal.valueOf(1000L), this.scope.getMathContext());
                        this.tokenizer.consume();
                        break;
                    }
                    case "M": {
                        value = value.multiply(BigDecimal.valueOf(1000000L), this.scope.getMathContext());
                        this.tokenizer.consume();
                        break;
                    }
                    case "G": {
                        value = value.multiply(BigDecimal.valueOf(1000000000L), this.scope.getMathContext());
                        this.tokenizer.consume();
                        break;
                    }
                    default: {
                        Token token = (Token)this.tokenizer.consume();
                        this.errors.add(ParseError.error(token, String.format("Unexpected token: '%s'. Expected a valid quantifier.", token.getSource())));
                    }
                }
            }
            return new Constant(value);
        }
        Token token = (Token)this.tokenizer.consume();
        this.errors.add(ParseError.error(token, String.format("Unexpected token: '%s'. Expected an expression.", token.getSource())));
        return ERROR;
    }

    protected Expression functionCall() {
        FunctionCall call = new FunctionCall(this.scope.getMathContext());
        Token funToken = (Token)this.tokenizer.consume();
        Function fun = functionTable.get(funToken.getContents());
        if (fun == null) {
            this.errors.add(ParseError.error(funToken, String.format("Unknown function: '%s'", funToken.getContents())));
        }
        call.setFunction(fun);
        this.tokenizer.consume();
        while (!((Token)this.tokenizer.current()).isSymbol(")") && ((Token)this.tokenizer.current()).isNotEnd()) {
            if (!call.getParameters().isEmpty()) {
                this.expect(Token.TokenType.SYMBOL, ",");
            }
            call.addParameter(this.expression());
        }
        this.expect(Token.TokenType.SYMBOL, ")");
        if (fun == null) {
            return ERROR;
        }
        if (call.getParameters().size() != fun.getNumberOfArguments() && fun.getNumberOfArguments() >= 0) {
            this.errors.add(ParseError.error(funToken, String.format("Number of arguments for function '%s' do not match. Expected: %d, Found: %d", funToken.getContents(), fun.getNumberOfArguments(), call.getParameters().size())));
            return ERROR;
        }
        return call;
    }

    protected void expect(Token.TokenType type, String trigger) {
        if (((Token)this.tokenizer.current()).matches(type, trigger)) {
            this.tokenizer.consume();
        } else {
            this.errors.add(ParseError.error((Position)this.tokenizer.current(), String.format("Unexpected token '%s'. Expected: '%s'", ((Token)this.tokenizer.current()).getSource(), trigger)));
        }
    }

    static {
        Parser.registerFunction("sin", Functions.SIN);
        Parser.registerFunction("cos", Functions.COS);
        Parser.registerFunction("cot", Functions.COT);
        Parser.registerFunction("tan", Functions.TAN);
        Parser.registerFunction("sinh", Functions.SINH);
        Parser.registerFunction("cosh", Functions.COSH);
        Parser.registerFunction("coth", Functions.COTH);
        Parser.registerFunction("tanh", Functions.TANH);
        Parser.registerFunction("asin", Functions.ASIN);
        Parser.registerFunction("acos", Functions.ACOS);
        Parser.registerFunction("acot", Functions.ACOT);
        Parser.registerFunction("atan", Functions.ATAN);
        Parser.registerFunction("atan2", Functions.ATAN2);
        Parser.registerFunction("asinh", Functions.ASINH);
        Parser.registerFunction("acosh", Functions.ACOSH);
        Parser.registerFunction("acoth", Functions.ACOTH);
        Parser.registerFunction("atanh", Functions.ATANH);
        Parser.registerFunction("deg", Functions.DEG);
        Parser.registerFunction("rad", Functions.RAD);
        Parser.registerFunction("abs", Functions.ABS);
        Parser.registerFunction("round", Functions.ROUND);
        Parser.registerFunction("ceil", Functions.CEIL);
        Parser.registerFunction("floor", Functions.FLOOR);
        Parser.registerFunction("exp", Functions.EXP);
        Parser.registerFunction("ln", Functions.LN);
        Parser.registerFunction("log", Functions.LOG);
        Parser.registerFunction("log2", Functions.LOG2);
        Parser.registerFunction("sqrt", Functions.SQRT);
        Parser.registerFunction("pow", Functions.POW);
        Parser.registerFunction("min", Functions.MIN);
        Parser.registerFunction("max", Functions.MAX);
        Parser.registerFunction("rnd", Functions.RND);
        Parser.registerFunction("sign", Functions.SIGN);
        Parser.registerFunction("exponent", Functions.EXPONENT);
        Parser.registerFunction("mantissa", Functions.MANTISSA);
        Parser.registerFunction("if", Functions.IF);
        Parser.registerFunction("scale", Functions.SCALE);
        ERROR = mc -> null;
    }
}

