/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.bdparsii.eval;

import ch.obermuhlner.math.big.BigDecimalMath;
import com.mpobjects.bdparsii.eval.MathContextGuard;
import com.mpobjects.bdparsii.eval.Variable;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class Scope {
    private Scope parent;
    private boolean autocreateVariables = true;
    private Map<String, Variable> context = new ConcurrentHashMap<String, Variable>();
    private MathContext mathContext = MathContext.DECIMAL64;

    public Scope() {
        this.createConstants();
    }

    public Scope withStrictLookup(boolean strictLookup) {
        this.autocreateVariables = !strictLookup;
        return this;
    }

    public Scope withParent(Scope parent) {
        this.parent = parent;
        return this;
    }

    public Variable find(String name) {
        if (this.context.containsKey(name)) {
            return this.context.get(name);
        }
        if (this.parent != null) {
            return this.parent.find(name);
        }
        return null;
    }

    public Variable getVariable(String name) {
        Variable result = this.find(name);
        if (result != null) {
            return result;
        }
        if (!this.autocreateVariables) {
            throw new IllegalArgumentException();
        }
        return this.create(name);
    }

    public Variable create(String name) {
        if (this.context.containsKey(name)) {
            return this.context.get(name);
        }
        Variable result = new Variable(name);
        this.context.put(name, result);
        return result;
    }

    public Variable remove(String name) {
        if (this.context.containsKey(name)) {
            return this.context.remove(name);
        }
        return null;
    }

    public Set<String> getLocalNames() {
        return this.context.keySet();
    }

    public Set<String> getNames() {
        if (this.parent == null) {
            return this.getLocalNames();
        }
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.parent.getNames());
        result.addAll(this.getLocalNames());
        return result;
    }

    public Collection<Variable> getLocalVariables() {
        return this.context.values();
    }

    public Collection<Variable> getVariables() {
        if (this.parent == null) {
            return this.getLocalVariables();
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        result.addAll(this.parent.getVariables());
        result.addAll(this.getLocalVariables());
        return result;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public void setMathContext(MathContext mathContext) {
        if (mathContext == null) {
            throw new IllegalArgumentException("MathContext cannot be null");
        }
        this.mathContext = mathContext;
    }

    public Scope withMathContext(MathContext mathContext) {
        this.setMathContext(mathContext);
        return this;
    }

    protected void createConstants() {
        this.create("pi").makeConstant(() -> BigDecimalMath.pi((MathContext)MathContextGuard.getSafeContext(this.mathContext)));
        this.create("euler").makeConstant(() -> BigDecimalMath.e((MathContext)MathContextGuard.getSafeContext(this.mathContext)));
    }
}

