/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.bdparsii.eval;

import java.math.BigDecimal;
import java.util.function.Supplier;

public class Variable {
    private BigDecimal value;
    private String name;
    private boolean constant;
    private Supplier<BigDecimal> initializor = () -> BigDecimal.ZERO;

    protected Variable(String name) {
        this.name = name;
    }

    public void setValue(BigDecimal value) {
        if (this.constant) {
            throw new IllegalStateException(String.format("%s is constant!", this.name));
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        this.value = value;
    }

    public void setValue(double value) {
        this.setValue(BigDecimal.valueOf(value));
    }

    public void setValue(long value) {
        this.setValue(BigDecimal.valueOf(value));
    }

    public void makeConstant(BigDecimal value) {
        this.setValue(value);
        this.constant = true;
    }

    public void makeConstant(Supplier<BigDecimal> supplier) {
        if (this.constant) {
            throw new IllegalStateException(String.format("%s is constant!", this.name));
        }
        this.value = null;
        this.initializor = supplier;
        this.constant = true;
    }

    public BigDecimal getValue() {
        if (this.value == null) {
            this.value = this.initializor.get();
        }
        return this.value;
    }

    public String toString() {
        return this.name + ": " + this.getValue();
    }

    public String getName() {
        return this.name;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public Variable withValue(BigDecimal value) {
        this.setValue(value);
        return this;
    }

    public Variable withValue(double value) {
        this.setValue(value);
        return this;
    }

    public Variable withValue(long value) {
        this.setValue(value);
        return this;
    }
}

