/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.bdparsii.tokenizer;

import com.mpobjects.bdparsii.tokenizer.Position;

public class Char
implements Position {
    private char value;
    private int line;
    private int pos;

    Char(char value, int line, int pos) {
        this.value = value;
        this.line = line;
        this.pos = pos;
    }

    public char getValue() {
        return this.value;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    public boolean isDigit() {
        return Character.isDigit(this.value);
    }

    public boolean isLetter() {
        return Character.isLetter(this.value);
    }

    public boolean isWhitepace() {
        return Character.isWhitespace(this.value) && !this.isEndOfInput();
    }

    public boolean isNewLine() {
        return this.value == '\n';
    }

    public boolean isEndOfInput() {
        return this.value == '\u0000';
    }

    public String toString() {
        if (this.isEndOfInput()) {
            return "<End Of Input>";
        }
        return String.valueOf(this.value);
    }

    public boolean is(char ... tests) {
        for (char test : tests) {
            if (test != this.value || test == '\u0000') continue;
            return true;
        }
        return false;
    }

    public String getStringValue() {
        if (this.isEndOfInput()) {
            return "";
        }
        return String.valueOf(this.value);
    }
}

