/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.smartexception;

import com.arthenica.smartexception.StackTraceElementWrapper;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Set;

public class ThrowableWrapper {
    private final String message;
    private final ThrowableWrapper cause;
    private final String className;
    private final ThrowableWrapper[] suppressed;
    private final StackTraceElementWrapper[] stackTrace;

    public ThrowableWrapper(Throwable throwable) {
        this(throwable, Collections.newSetFromMap(new IdentityHashMap()));
    }

    public ThrowableWrapper(Throwable throwable, Set<Throwable> alreadyWrapped) {
        alreadyWrapped.add(throwable);
        this.message = throwable.getMessage();
        this.cause = throwable.getCause() != null && !alreadyWrapped.contains(throwable.getCause()) ? new ThrowableWrapper(throwable.getCause(), alreadyWrapped) : null;
        this.className = throwable.getClass().getName();
        Throwable[] suppressedThrowableArray = throwable.getSuppressed();
        LinkedList<ThrowableWrapper> tmpList = new LinkedList<ThrowableWrapper>();
        int throwableSuppressedLength = suppressedThrowableArray.length;
        for (int i = 0; i < throwableSuppressedLength; ++i) {
            if (alreadyWrapped.contains(suppressedThrowableArray[i])) continue;
            tmpList.add(new ThrowableWrapper(suppressedThrowableArray[i], alreadyWrapped));
        }
        this.suppressed = tmpList.toArray(new ThrowableWrapper[0]);
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        this.stackTrace = new StackTraceElementWrapper[stackTraceElements.length];
        int stackTraceElementsLength = stackTraceElements.length;
        for (int i = 0; i < stackTraceElementsLength; ++i) {
            this.stackTrace[i] = new StackTraceElementWrapper(stackTraceElements[i]);
        }
    }

    public ThrowableWrapper(String message, ThrowableWrapper cause, String className, ThrowableWrapper[] suppressed, StackTraceElementWrapper[] stackTrace) {
        this.message = message;
        this.cause = cause;
        this.className = className;
        this.suppressed = suppressed;
        this.stackTrace = stackTrace;
    }

    public String getMessage() {
        return this.message;
    }

    public ThrowableWrapper getCause() {
        return this.cause;
    }

    public String getClassName() {
        return this.className;
    }

    public ThrowableWrapper[] getSuppressed() {
        return this.suppressed;
    }

    public StackTraceElementWrapper[] getStackTrace() {
        return this.stackTrace;
    }
}

