/*
 * Decompiled with CFR 0.152.
 */
package com.jam01.mule.extension.wiremock.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappingCollection;
import com.jam01.mule.extension.wiremock.internal.StubParameter;
import com.jam01.mule.extension.wiremock.internal.VerificationComparisonValueProvider;
import com.jam01.mule.extension.wiremock.internal.VerificationParameter;
import com.jam01.mule.extension.wiremock.internal.WireMockConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireMockOperations {
    private static final String WHEN_PARAM_GROUP = "Given scenario... when request... then respond...";
    private static final String VERIFY_PARAM_GROUP = "Verify that request...";
    private static final Logger LOGGER = LoggerFactory.getLogger(WireMockOperations.class);

    public void addStub(@Config WireMockConfiguration config, @Connection WireMock wireMock, @ParameterGroup(name="Given scenario... when request... then respond...") StubParameter param) {
        if (param.jsonMapping == null) {
            return;
        }
        try {
            StubMappingCollection stubCollection = WireMockOperations.read(param.jsonMapping, StubMappingCollection.class);
            for (StubMapping mapping : stubCollection.getMappingOrMappings()) {
                mapping.setDirty(false);
                wireMock.register(mapping);
            }
        }
        catch (JsonException e) {
            throw new IllegalArgumentException(String.format("Error loading json mapping:\n%s", e.getErrors().first().getDetail()));
        }
    }

    public void verifyRequest(@Config WireMockConfiguration config, @Connection WireMock wireMock, @ParameterGroup(name="Verify that request...") VerificationParameter param) {
        if (param.jsonMapping == null) {
            return;
        }
        CountMatchingStrategy matchingStrategy = WireMockOperations.getCountMatchingStrategy(param.comparison, param.times);
        try {
            RequestPattern requestPattern = WireMockOperations.read(param.jsonMapping, RequestPattern.class);
            wireMock.verifyThat(matchingStrategy, RequestPatternBuilder.like((RequestPattern)requestPattern));
        }
        catch (JsonException e) {
            throw new IllegalArgumentException(String.format("Error loading json mapping:\n%s", e.getErrors().first().getDetail()));
        }
    }

    public void resetRequests(@Config WireMockConfiguration config, @Connection WireMock wireMock) {
        wireMock.resetRequests();
    }

    private static <T> T read(@Nonnull Object object, Class<T> clazz) {
        try {
            if (object instanceof InputStream) {
                return (T)Json.getObjectMapper().readValue((InputStream)object, clazz);
            }
            if (object instanceof byte[]) {
                return (T)Json.getObjectMapper().readValue((byte[])object, clazz);
            }
            if (object instanceof CharSequence) {
                String trimmed = ((CharSequence)object).toString().trim();
                return (T)Json.getObjectMapper().readValue(trimmed, clazz);
            }
            throw new IllegalArgumentException(String.format("Unable to parse %s from %s object", clazz, object.getClass()));
        }
        catch (JsonProcessingException processingException) {
            throw JsonException.fromJackson((JsonProcessingException)processingException);
        }
        catch (IOException ioe) {
            return (T)Exceptions.throwUnchecked((Throwable)ioe, clazz);
        }
    }

    private static CountMatchingStrategy getCountMatchingStrategy(String comparison, Integer value) {
        switch (comparison) {
            case "AT_LEAST": {
                return new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN_OR_EQUAL, value.intValue());
            }
            case "AT_MOST": {
                return new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN_OR_EQUAL, value.intValue());
            }
            case "EQUAL_TO": {
                return new CountMatchingStrategy(CountMatchingStrategy.EQUAL_TO, value.intValue());
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized comparison value %s, valid values are %s", comparison, VerificationComparisonValueProvider.VALUES.stream().map(Value::getId).collect(Collectors.joining(", "))));
    }
}

