/*
 * Decompiled with CFR 0.152.
 */
package com.jam01.mule.extension.wiremock.internal;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.jam01.mule.extension.wiremock.internal.ConnectionParameter;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireMockProvider
implements CachedConnectionProvider<WireMock>,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(WireMockProvider.class);
    private static final String TLS_CONFIGURATION = "TLS Configuration";
    private WireMockServer mockServer;
    private WireMock mock;
    @ParameterGroup(name="Connection")
    private ConnectionParameter connectionParams;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="TLS Configuration")
    @Placement(tab="TLS")
    private TlsContextFactory tlsContext;
    @RefName
    private String configName;

    public ConnectionValidationResult validate(WireMock connection) {
        if (this.mockServer.isRunning()) {
            return ConnectionValidationResult.success();
        }
        return ConnectionValidationResult.failure((String)String.format("Server on host %s and port %s is stopped.", this.mockServer.getOptions().bindAddress(), this.mockServer.getOptions().portNumber()), (Exception)new ConnectionException("Server stopped."));
    }

    public void initialise() throws InitialisationException {
        if (this.connectionParams.getProtocol().equals((Object)HttpConstants.Protocol.HTTP) && this.tlsContext != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP. If you defined a tls:context element in your wiremock:config then you must set protocol=\"HTTPS\""), (Initialisable)this);
        }
        if (this.tlsContext != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
        }
        WireMockConfiguration options = WireMockConfiguration.options().usingFilesUnderDirectory(this.connectionParams.getResources()).bindAddress(this.connectionParams.getHost());
        if (this.connectionParams.getProtocol() == HttpConstants.Protocol.HTTPS) {
            options.dynamicPort();
            options.httpsPort(this.connectionParams.getPort());
            if (this.tlsContext != null) {
                if (this.tlsContext.isKeyStoreConfigured()) {
                    options.keystoreType(this.tlsContext.getKeyStoreConfiguration().getType()).keystorePath(this.tlsContext.getKeyStoreConfiguration().getPath()).keystorePassword(this.tlsContext.getKeyStoreConfiguration().getPassword());
                }
                if (this.tlsContext.isTrustStoreConfigured()) {
                    options.needClientAuth(true).trustStoreType(this.tlsContext.getTrustStoreConfiguration().getType()).trustStorePath(this.tlsContext.getTrustStoreConfiguration().getPath()).trustStorePassword(this.tlsContext.getTrustStoreConfiguration().getPassword());
                }
            }
        } else {
            options.port(this.connectionParams.getPort().intValue());
        }
        this.mockServer = new WireMockServer((Options)options);
        this.mock = new WireMock((Admin)this.mockServer);
    }

    public void start() throws MuleException {
        this.mockServer.start();
    }

    public WireMock connect() throws ConnectionException {
        return this.mock;
    }

    public void disconnect(WireMock connection) {
    }

    public void dispose() {
        this.mockServer.shutdownServer();
    }

    public void stop() throws MuleException {
        this.mockServer.stop();
    }
}

