/*
 * Decompiled with CFR 0.152.
 */
package com.ms3_inc.tavros;

import com.ms3_inc.tavros.RoutesGeneratedGenerator;
import com.ms3_inc.tavros.RoutesImplGenerator;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.maven.plugin.MojoExecutionException;

public class RoutesCreator {
    private String oasPathStr;
    private String baseDir;
    private String groupId;
    private static final Logger LOGGER = Logger.getLogger(RoutesCreator.class.getName());

    public RoutesCreator(String oasPathStr, String baseDir, String groupId) {
        this.oasPathStr = oasPathStr;
        this.baseDir = baseDir;
        this.groupId = groupId.replaceAll("\\.", "/").replaceAll("-", "_");
    }

    void init() throws MojoExecutionException {
        this.copySpec();
        List opInfoList = this.generateOperationInfoList();
        StringBuffer routesGeneratedCode = this.generateRoutesGeneratedCode(opInfoList);
        this.writeRoutesGenerated(routesGeneratedCode);
        StringBuffer routesImplCode = this.generateRoutesImplCode(opInfoList);
        this.writeRoutesImplementation(routesImplCode);
    }

    void copySpec() throws MojoExecutionException {
        LOGGER.info("==== Copying OpenAPI spec ====");
        LOGGER.info("API file to copy: " + this.oasPathStr);
        Path oasFile = Path.of(this.oasPathStr, new String[0]);
        String specText = null;
        try {
            specText = Files.readString(oasFile);
            String oasPath = this.baseDir + "/src/generated/api";
            String pathAndName = oasPath + "/" + oasFile.getFileName();
            new File(oasPath).mkdir();
            LOGGER.info("Made directory " + oasPath);
            BufferedWriter writer = new BufferedWriter(new FileWriter(pathAndName));
            LOGGER.info("File to write: " + pathAndName);
            writer.write(specText);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was a problem while copying the spec.");
        }
    }

    List generateOperationInfoList() {
        OpenAPI openAPI = new OpenAPIV3Parser().read(this.oasPathStr);
        LOGGER.info("==== Parse spec into operation list ====");
        Paths paths = openAPI.getPaths();
        Set pathKeys = paths.keySet();
        Vector opInfoList = new Vector();
        for (String path : pathKeys) {
            PathItem item = (PathItem)paths.get((Object)path);
            item.readOperationsMap().forEach((method, op) -> opInfoList.add(Triple.of((Object)method.toString(), (Object)path, (Object)op)));
        }
        return opInfoList;
    }

    StringBuffer generateRoutesGeneratedCode(List<Triple<String, String, Operation>> opInfoList) {
        LOGGER.log(Level.INFO, "==== Add Endpoints to RoutesGenerated Class (rGen) ====");
        RoutesGeneratedGenerator rGenCode = new RoutesGeneratedGenerator();
        Path oasFile = Path.of(this.oasPathStr, new String[0]);
        rGenCode.appendRequestValidation(oasFile.getFileName());
        rGenCode.appendStartOfRestDSL();
        for (Triple<String, String, Operation> opInfo : opInfoList) {
            String method = opInfo.getLeft().toString().toLowerCase();
            String path = opInfo.getMiddle().toString();
            Operation operation = (Operation)opInfo.getRight();
            rGenCode.appendDslMethodAndId(method, path);
            rGenCode.appendConsumes(operation);
            rGenCode.appendProduces(operation);
            rGenCode.appendProducer(method, path);
        }
        rGenCode.appendEndColon();
        return rGenCode.getGeneratedCode();
    }

    void writeRoutesGenerated(StringBuffer routesGeneratedCode) throws MojoExecutionException {
        String rGenPath = this.baseDir + "/src/generated/java/" + this.groupId + "/RoutesGenerated.java";
        File rGenFile = new File(rGenPath);
        try {
            StringBuffer rGenBuf = new StringBuffer(Files.readString(Path.of(rGenPath, new String[0])));
            String routesGenToReplace = "// REST DSL routes";
            String rGenCodeStr = rGenBuf.toString().replace(routesGenToReplace, routesGeneratedCode.toString());
            LOGGER.log(Level.INFO, "File to write: " + rGenFile.getAbsolutePath());
            BufferedWriter writer = new BufferedWriter(new FileWriter(rGenPath));
            writer.write(rGenCodeStr);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was a problem writing RoutesGenerated.");
        }
    }

    StringBuffer generateRoutesImplCode(List<Triple<String, String, Operation>> opInfoList) {
        RoutesImplGenerator routesImplCode = new RoutesImplGenerator();
        routesImplCode.appendStubComment();
        for (Triple<String, String, Operation> opInfo : opInfoList) {
            routesImplCode.appendStub(opInfo);
        }
        return routesImplCode.getGeneratedCode();
    }

    void writeRoutesImplementation(StringBuffer routesImplCode) throws MojoExecutionException {
        LOGGER.log(Level.INFO, "==== Add Endpoints to RoutesImplemented (rImp) Class ====");
        String rImpPath = this.baseDir + "/src/main/java/" + this.groupId + "/RoutesImplementation.java";
        File rImpFile = new File(rImpPath);
        try {
            StringBuffer rImpBuf = new StringBuffer(Files.readString(Path.of(rImpPath, new String[0])));
            String routesImplToReplace = "// Implementation routes";
            String rImpCodeStr = rImpBuf.toString().replace(routesImplToReplace, routesImplCode.toString());
            LOGGER.log(Level.INFO, "File to write: " + rImpFile.getAbsolutePath());
            BufferedWriter writer = new BufferedWriter(new FileWriter(rImpPath));
            writer.write(rImpCodeStr);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was a problem writing RoutesImplementation.");
        }
    }
}

