/*
 * Decompiled with CFR 0.152.
 */
package com.ms3_inc.tavros;

import com.ms3_inc.tavros.RoutesGenerator;
import io.swagger.v3.oas.models.Operation;
import java.nio.file.Path;
import java.util.ArrayList;

public class RoutesGeneratedGenerator
extends RoutesGenerator {
    protected StringBuffer appendDslMethodAndId(String method, String path) {
        this.generatedCode.append(this.indents(3)).append(".").append(method).append("(\"").append(path).append("\")\n");
        this.generatedCode.append(this.indents(4)).append(".id(\"").append(this.createOpId(method, path)).append("\")\n");
        return this.generatedCode;
    }

    protected StringBuffer appendConsumes(Operation operation) {
        ArrayList consumes = new ArrayList();
        if (operation.getRequestBody() != null) {
            operation.getRequestBody().getContent().forEach((mediaType, mediaTypeObj) -> consumes.add(mediaType));
        }
        if (consumes.size() > 0) {
            this.generatedCode.append(this.indents(4)).append(".consumes(\"").append(String.join((CharSequence)",", consumes)).append("\")\n");
        }
        return this.generatedCode;
    }

    protected StringBuffer appendProduces(Operation operation) {
        ArrayList produces = new ArrayList();
        operation.getResponses().forEach((status, resp) -> {
            if (resp.getContent() != null) {
                resp.getContent().forEach((mediaType, mediaTypeObj) -> {
                    if (!produces.contains(mediaType)) {
                        produces.add(mediaType);
                    }
                });
            }
        });
        if (produces.size() > 0) {
            this.generatedCode.append(this.indents(4)).append(".produces(\"").append(String.join((CharSequence)",", produces)).append("\")\n");
        }
        return this.generatedCode;
    }

    protected StringBuffer appendProducer(String method, String path) {
        this.generatedCode.append(this.indents(4)).append(".to(direct(\"").append(this.createOpId(method, path)).append("\").getUri())\n");
        return this.generatedCode;
    }

    protected StringBuffer appendRequestValidation(Path fileName) {
        this.generatedCode.append(this.indents(0)).append("interceptFrom()\n");
        this.generatedCode.append(this.indents(3)).append(".process(new OpenApi4jValidator(\"").append(fileName).append("\", contextPath));\n\n");
        return this.generatedCode;
    }

    protected StringBuffer appendStartOfRestDSL() {
        this.generatedCode.append(this.indents(2)).append("rest()\n");
        return this.generatedCode;
    }

    protected StringBuffer appendEndColon() {
        this.generatedCode.append(this.indents(2)).append(';');
        return this.generatedCode;
    }
}

