/*
 * Decompiled with CFR 0.152.
 */
package com.mtfelisb.flink.connectors.elasticsearch.sink;

import com.mtfelisb.flink.connectors.elasticsearch.sink.BulkRequestFactory;
import com.mtfelisb.flink.connectors.elasticsearch.sink.ElasticsearchSink;
import com.mtfelisb.flink.connectors.elasticsearch.sink.Emitter;
import com.mtfelisb.flink.connectors.elasticsearch.sink.NetworkConfigFactory;
import org.apache.flink.util.Preconditions;

public class ElasticsearchSinkBuilder<T> {
    private String host;
    private int port;
    private String username;
    private String password;
    private Long threshold;
    private Emitter<T> emitter;

    public ElasticsearchSinkBuilder<T> setHost(String host) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkState((host.length() > 0 ? 1 : 0) != 0, (Object)"Host cannot be empty");
        this.host = host;
        return this;
    }

    public ElasticsearchSinkBuilder<T> setPort(int port) {
        this.port = port;
        return this;
    }

    public ElasticsearchSinkBuilder<T> setUsername(String username) {
        Preconditions.checkNotNull((Object)username);
        this.username = username;
        return this;
    }

    public ElasticsearchSinkBuilder<T> setPassword(String password) {
        Preconditions.checkNotNull((Object)password);
        this.password = password;
        return this;
    }

    public ElasticsearchSinkBuilder<T> setThreshold(Long threshold) {
        Preconditions.checkNotNull((Object)threshold);
        Preconditions.checkState((threshold >= 0L ? 1 : 0) != 0, (Object)"Threshold should be positive");
        this.threshold = threshold;
        return this;
    }

    public ElasticsearchSinkBuilder<T> setEmitter(Emitter<T> emitter) {
        Preconditions.checkNotNull(emitter);
        this.emitter = emitter;
        return this;
    }

    public ElasticsearchSink<T> build() {
        this.validate();
        return new ElasticsearchSink<T>(new NetworkConfigFactory(this.host, this.port, this.username, this.password), this.emitter, this.threshold, new BulkRequestFactory());
    }

    public static <T> ElasticsearchSinkBuilder<T> builder() {
        return new ElasticsearchSinkBuilder<T>();
    }

    private void validate() {
        this.setEmitter(this.emitter);
        this.setHost(this.host);
        this.setPort(this.port);
        this.setThreshold(this.threshold);
    }
}

