/*
 * Decompiled with CFR 0.152.
 */
package com.mtfelisb.flink.connectors.elasticsearch.sink;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.mtfelisb.flink.connectors.elasticsearch.sink.INetworkConfigFactory;
import org.apache.flink.shaded.curator5.com.google.common.base.Preconditions;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.RestClient;

public class NetworkConfigFactory
implements INetworkConfigFactory {
    private static final Logger LOG = LogManager.getLogger(NetworkConfigFactory.class);
    private final String host;
    private final int port;
    private final String username;
    private final String password;

    public NetworkConfigFactory(String host, int port, String username, String password) {
        this.host = (String)Preconditions.checkNotNull((Object)host);
        this.port = (Integer)Preconditions.checkNotNull((Object)port);
        this.username = username;
        this.password = password;
    }

    @Override
    public ElasticsearchClient create() {
        LOG.debug("Http client host {} and port {}", (Object)this.host, (Object)this.port);
        RestClient restClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.host, this.port)}).setHttpClientConfigCallback(httpClientBuilder -> this.username != null && this.password != null ? httpClientBuilder.setDefaultCredentialsProvider(this.getCredentials()) : httpClientBuilder).build();
        return new ElasticsearchClient((ElasticsearchTransport)new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper()));
    }

    private CredentialsProvider getCredentials() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        return credentialsProvider;
    }
}

